/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.modelAction;

import com.intellij.gradle.toolingExtension.impl.telemetry.GradleOpenTelemetry;
import com.intellij.gradle.toolingExtension.modelAction.GradleModelFetchPhase;
import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import io.opentelemetry.context.Context;
import java.io.File;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.internal.gradle.DefaultBuildIdentifier;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.Build;
import org.jetbrains.plugins.gradle.model.DefaultBuild;
import org.jetbrains.plugins.gradle.model.DefaultBuildController;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;
import org.jetbrains.plugins.gradle.model.internal.TurnOffDefaultTasks;
import org.jetbrains.plugins.gradle.tooling.serialization.ModelConverter;

@ApiStatus.Internal
public class GradleModelFetchAction {
    @NotNull
    private final ProjectImportAction.AllModels myAllModels;
    @NotNull
    private final Set<ProjectImportModelProvider> myModelProviders;
    @NotNull
    private final ModelConverter myModelConverter;
    @NotNull
    private final ExecutorService myModelConverterExecutor;
    @NotNull
    private final GradleOpenTelemetry myTelemetry;
    private final boolean myIsPreviewMode;
    private final boolean myIsProjectsLoadedAction;

    public GradleModelFetchAction(@NotNull ProjectImportAction.AllModels allModels, @NotNull Set<ProjectImportModelProvider> modelProviders, @NotNull ModelConverter modelConverter, @NotNull ExecutorService modelConverterExecutor, @NotNull GradleOpenTelemetry telemetry, boolean isPreviewMode, boolean isProjectsLoadedAction) {
        if (allModels == null) {
            GradleModelFetchAction.$$$reportNull$$$0(0);
        }
        if (modelProviders == null) {
            GradleModelFetchAction.$$$reportNull$$$0(1);
        }
        if (modelConverter == null) {
            GradleModelFetchAction.$$$reportNull$$$0(2);
        }
        if (modelConverterExecutor == null) {
            GradleModelFetchAction.$$$reportNull$$$0(3);
        }
        if (telemetry == null) {
            GradleModelFetchAction.$$$reportNull$$$0(4);
        }
        this.myAllModels = allModels;
        this.myModelProviders = modelProviders;
        this.myModelConverter = modelConverter;
        this.myModelConverterExecutor = modelConverterExecutor;
        this.myTelemetry = telemetry;
        this.myIsPreviewMode = isPreviewMode;
        this.myIsProjectsLoadedAction = isProjectsLoadedAction;
    }

    public void execute(@NotNull DefaultBuildController controller) {
        if (controller == null) {
            GradleModelFetchAction.$$$reportNull$$$0(5);
        }
        GradleBuild mainGradleBuild = controller.getBuildModel();
        Set nestedBuilds = this.myTelemetry.callWithSpan("NestedBuildsResolve", span -> GradleModelFetchAction.getNestedBuilds(controller, mainGradleBuild));
        this.myTelemetry.runWithSpan("MainBuildAddModels", span -> this.addModels(controller, mainGradleBuild));
        this.myTelemetry.runWithSpan("IncludedBuildAddModels", span -> {
            for (GradleBuild includedBuild : nestedBuilds) {
                if (!this.myIsProjectsLoadedAction) {
                    this.myAllModels.addIncludedBuild(DefaultBuild.convertGradleBuild(includedBuild));
                }
                this.addModels(controller, includedBuild);
            }
        });
        GradleModelFetchAction.setupIncludedBuildsHierarchy(this.myAllModels.getIncludedBuilds(), nestedBuilds);
        if (this.myIsProjectsLoadedAction) {
            controller.getModel(TurnOffDefaultTasks.class);
        }
    }

    private static Set<GradleBuild> getNestedBuilds(@NotNull BuildController controller, @NotNull GradleBuild build) {
        BuildEnvironment environment;
        if (controller == null) {
            GradleModelFetchAction.$$$reportNull$$$0(6);
        }
        if (build == null) {
            GradleModelFetchAction.$$$reportNull$$$0(7);
        }
        if ((environment = (BuildEnvironment)controller.getModel(BuildEnvironment.class)) == null) {
            return Collections.emptySet();
        }
        GradleVersion gradleVersion = GradleVersion.version((String)environment.getGradle().getGradleVersion());
        HashSet<String> processedBuildsPaths = new HashSet<String>();
        LinkedHashSet<GradleBuild> nestedBuilds = new LinkedHashSet<GradleBuild>();
        String rootBuildPath = build.getBuildIdentifier().getRootDir().getPath();
        processedBuildsPaths.add(rootBuildPath);
        ArrayDeque<? extends GradleBuild> queue = new ArrayDeque<GradleBuild>((Collection<? extends GradleBuild>)GradleModelFetchAction.getEditableBuilds(build, gradleVersion));
        while (!queue.isEmpty()) {
            GradleBuild includedBuild = (GradleBuild)queue.remove();
            String includedBuildPath = includedBuild.getBuildIdentifier().getRootDir().getPath();
            if (!processedBuildsPaths.add(includedBuildPath)) continue;
            nestedBuilds.add(includedBuild);
            queue.addAll((Collection<? extends GradleBuild>)GradleModelFetchAction.getEditableBuilds(includedBuild, gradleVersion));
        }
        return nestedBuilds;
    }

    private static DomainObjectSet<? extends GradleBuild> getEditableBuilds(@NotNull GradleBuild build, @NotNull GradleVersion version) {
        if (build == null) {
            GradleModelFetchAction.$$$reportNull$$$0(8);
        }
        if (version == null) {
            GradleModelFetchAction.$$$reportNull$$$0(9);
        }
        if (GradleVersionUtil.isGradleAtLeast((GradleVersion)version, (String)"8.0")) {
            DomainObjectSet builds = build.getEditableBuilds();
            if (builds.isEmpty()) {
                return build.getIncludedBuilds();
            }
            return builds;
        }
        return build.getIncludedBuilds();
    }

    private static void setupIncludedBuildsHierarchy(List<Build> builds, Set<GradleBuild> gradleBuilds) {
        HashSet<Build> updatedBuilds = new HashSet<Build>();
        HashMap<File, Build> rootDirsToBuilds = new HashMap<File, Build>();
        for (Build build : builds) {
            rootDirsToBuilds.put(build.getBuildIdentifier().getRootDir(), build);
        }
        for (GradleBuild gradleBuild : gradleBuilds) {
            Build build = (Build)rootDirsToBuilds.get(gradleBuild.getBuildIdentifier().getRootDir());
            if (build == null) continue;
            for (GradleBuild includedGradleBuild : gradleBuild.getIncludedBuilds()) {
                Build buildToUpdate = (Build)rootDirsToBuilds.get(includedGradleBuild.getBuildIdentifier().getRootDir());
                if (!(buildToUpdate instanceof DefaultBuild) || !updatedBuilds.add(buildToUpdate)) continue;
                ((DefaultBuild)buildToUpdate).setParentBuildIdentifier(new DefaultBuildIdentifier(gradleBuild.getBuildIdentifier().getRootDir()));
            }
        }
    }

    private void forEachModelFetchPhase(@NotNull BiConsumer<GradleModelFetchPhase, List<ProjectImportModelProvider>> consumer) {
        if (consumer == null) {
            GradleModelFetchAction.$$$reportNull$$$0(10);
        }
        this.myModelProviders.stream().collect(Collectors.groupingBy(it -> it.getPhase())).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(it -> consumer.accept((GradleModelFetchPhase)it.getKey(), (List)it.getValue()));
    }

    private void addModels(@NotNull BuildController controller, @NotNull GradleBuild gradleBuild) {
        block4: {
            if (controller == null) {
                GradleModelFetchAction.$$$reportNull$$$0(11);
            }
            if (gradleBuild == null) {
                GradleModelFetchAction.$$$reportNull$$$0(12);
            }
            try {
                this.forEachModelFetchPhase((phase, modelProviders) -> {
                    this.myTelemetry.runWithSpan("AddProjectModels", span -> {
                        span.setAttribute("phase", phase.name());
                        for (BasicGradleProject gradleProject : gradleBuild.getProjects()) {
                            for (ProjectImportModelProvider modelProvider : modelProviders) {
                                this.addProjectModels(controller, gradleProject, modelProvider);
                            }
                        }
                    });
                    this.myTelemetry.runWithSpan("AddBuildModels", span -> {
                        span.setAttribute("phase", phase.name());
                        for (ProjectImportModelProvider modelProvider : modelProviders) {
                            this.addBuildModels(controller, gradleBuild, modelProvider);
                        }
                    });
                });
            }
            catch (Exception e) {
                if (this.myIsPreviewMode) break block4;
                throw new ExternalSystemException((Throwable)e);
            }
        }
    }

    private void addProjectModels(@NotNull BuildController controller, final @NotNull BasicGradleProject gradleProject, @NotNull ProjectImportModelProvider modelProvider) {
        if (controller == null) {
            GradleModelFetchAction.$$$reportNull$$$0(13);
        }
        if (gradleProject == null) {
            GradleModelFetchAction.$$$reportNull$$$0(14);
        }
        if (modelProvider == null) {
            GradleModelFetchAction.$$$reportNull$$$0(15);
        }
        this.myTelemetry.runWithSpan(modelProvider.getName(), span -> modelProvider.populateProjectModels(controller, (Model)gradleProject, new ProjectImportModelProvider.ProjectModelConsumer(){

            public void consume(@NotNull Object object, @NotNull Class<?> clazz) {
                if (object == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (clazz == null) {
                    1.$$$reportNull$$$0(1);
                }
                GradleModelFetchAction.this.addProjectModel((ProjectModel)gradleProject, object, clazz);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "object";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "clazz";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/gradle/toolingExtension/impl/modelAction/GradleModelFetchAction$1";
                objectArray[2] = "consume";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
    }

    private void addBuildModels(@NotNull BuildController controller, @NotNull GradleBuild gradleBuild, @NotNull ProjectImportModelProvider modelProvider) {
        if (controller == null) {
            GradleModelFetchAction.$$$reportNull$$$0(16);
        }
        if (gradleBuild == null) {
            GradleModelFetchAction.$$$reportNull$$$0(17);
        }
        if (modelProvider == null) {
            GradleModelFetchAction.$$$reportNull$$$0(18);
        }
        this.myTelemetry.runWithSpan(modelProvider.getName(), span -> modelProvider.populateBuildModels(controller, gradleBuild, new ProjectImportModelProvider.BuildModelConsumer(){

            public void consumeProjectModel(@NotNull ProjectModel projectModel, @NotNull Object object, @NotNull Class<?> clazz) {
                if (projectModel == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (object == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (clazz == null) {
                    2.$$$reportNull$$$0(2);
                }
                GradleModelFetchAction.this.addProjectModel(projectModel, object, clazz);
            }

            public void consume(@NotNull BuildModel buildModel, @NotNull Object object, @NotNull Class<?> clazz) {
                if (buildModel == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (object == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (clazz == null) {
                    2.$$$reportNull$$$0(5);
                }
                GradleModelFetchAction.this.addBuildModel(buildModel, object, clazz);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "projectModel";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "object";
                        break;
                    }
                    case 2: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "clazz";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "buildModel";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/modelAction/GradleModelFetchAction$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "consumeProjectModel";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "consume";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
    }

    private void addProjectModel(@NotNull ProjectModel projectModel, @NotNull Object object, @NotNull Class<?> clazz) {
        if (projectModel == null) {
            GradleModelFetchAction.$$$reportNull$$$0(19);
        }
        if (object == null) {
            GradleModelFetchAction.$$$reportNull$$$0(20);
        }
        if (clazz == null) {
            GradleModelFetchAction.$$$reportNull$$$0(21);
        }
        this.convertModel(object, clazz, "ProjectModelConverter", converted -> this.myAllModels.addModel(converted, clazz, projectModel));
    }

    private void addBuildModel(@NotNull BuildModel buildModel, @NotNull Object object, @NotNull Class<?> clazz) {
        if (buildModel == null) {
            GradleModelFetchAction.$$$reportNull$$$0(22);
        }
        if (object == null) {
            GradleModelFetchAction.$$$reportNull$$$0(23);
        }
        if (clazz == null) {
            GradleModelFetchAction.$$$reportNull$$$0(24);
        }
        this.convertModel(object, clazz, "BuildModelConverter", converted -> this.myAllModels.addModel(converted, clazz, buildModel));
    }

    private void convertModel(@NotNull Object object, @NotNull Class<?> clazz, @NotNull String spanName, @NotNull Consumer<Object> onConvertorEnd) {
        if (object == null) {
            GradleModelFetchAction.$$$reportNull$$$0(25);
        }
        if (clazz == null) {
            GradleModelFetchAction.$$$reportNull$$$0(26);
        }
        if (spanName == null) {
            GradleModelFetchAction.$$$reportNull$$$0(27);
        }
        if (onConvertorEnd == null) {
            GradleModelFetchAction.$$$reportNull$$$0(28);
        }
        Context.current().wrap(this.myModelConverterExecutor).execute(() -> {
            Object converted = this.myTelemetry.callWithSpan(spanName, span -> {
                span.setAttribute("model.class", clazz.getName());
                return this.myModelConverter.convert(object);
            });
            onConvertorEnd.accept(converted);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allModels";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelProviders";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelConverter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelConverterExecutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "telemetry";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "build";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleBuild";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProject";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelProvider";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectModel";
                break;
            }
            case 20: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 21: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModel";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spanName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onConvertorEnd";
                break;
            }
        }
        objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/modelAction/GradleModelFetchAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getNestedBuilds";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditableBuilds";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "forEachModelFetchPhase";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addModels";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "addProjectModels";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "addBuildModels";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "addProjectModel";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "addBuildModel";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "convertModel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

