/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.telemetry;

import com.intellij.gradle.toolingExtension.impl.telemetry.FilteringSpanDataCollector;
import com.intellij.gradle.toolingExtension.impl.telemetry.GradleTracingContext;
import com.intellij.gradle.toolingExtension.impl.telemetry.SpanDataSerializer;
import com.intellij.util.ArrayUtilRt;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.Closeable;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleOpenTelemetry {
    private static final String INSTRUMENTATION_NAME = "GradleDaemon";
    @NotNull
    private OpenTelemetry myOpenTelemetry = OpenTelemetry.noop();
    @Nullable
    private Scope myScope = null;
    @Nullable
    private FilteringSpanDataCollector mySpanDataCollector = null;

    public void start(@NotNull GradleTracingContext context) {
        if (context == null) {
            GradleOpenTelemetry.$$$reportNull$$$0(0);
        }
        this.mySpanDataCollector = new FilteringSpanDataCollector();
        this.myOpenTelemetry = OpenTelemetrySdk.builder().setTracerProvider(SdkTracerProvider.builder().addSpanProcessor((SpanProcessor)BatchSpanProcessor.builder((SpanExporter)this.mySpanDataCollector).setMaxExportBatchSize(128).build()).setResource(Resource.create((Attributes)Attributes.of((AttributeKey)AttributeKey.stringKey((String)"service.name"), (Object)INSTRUMENTATION_NAME))).build()).setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).build();
        this.myScope = GradleOpenTelemetry.injectTracingContext(this.myOpenTelemetry, context);
    }

    @NotNull
    public OpenTelemetry getTelemetry() {
        OpenTelemetry openTelemetry = this.myOpenTelemetry;
        if (openTelemetry == null) {
            GradleOpenTelemetry.$$$reportNull$$$0(1);
        }
        return openTelemetry;
    }

    @NotNull
    public Tracer getTracer() {
        Tracer tracer = this.getTelemetry().getTracer(INSTRUMENTATION_NAME);
        if (tracer == null) {
            GradleOpenTelemetry.$$$reportNull$$$0(2);
        }
        return tracer;
    }

    public <T> T callWithSpan(@NotNull String spanName, @NotNull Function<Span, T> fn) {
        if (spanName == null) {
            GradleOpenTelemetry.$$$reportNull$$$0(3);
        }
        if (fn == null) {
            GradleOpenTelemetry.$$$reportNull$$$0(4);
        }
        return this.callWithSpan(spanName, ignore -> {}, fn);
    }

    public <T> T callWithSpan(@NotNull String spanName, @NotNull Consumer<SpanBuilder> configurator, @NotNull Function<Span, T> fn) {
        if (spanName == null) {
            GradleOpenTelemetry.$$$reportNull$$$0(5);
        }
        if (configurator == null) {
            GradleOpenTelemetry.$$$reportNull$$$0(6);
        }
        if (fn == null) {
            GradleOpenTelemetry.$$$reportNull$$$0(7);
        }
        SpanBuilder spanBuilder = this.getTracer().spanBuilder(spanName);
        configurator.accept(spanBuilder);
        Span span = spanBuilder.startSpan();
        try {
            T t;
            block14: {
                Scope ignore = span.makeCurrent();
                try {
                    t = fn.apply(span);
                    if (ignore == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        span.recordException((Throwable)e);
                        span.setStatus(StatusCode.ERROR);
                        throw e;
                    }
                }
                ignore.close();
            }
            return t;
        }
        finally {
            span.end();
        }
    }

    public void runWithSpan(@NotNull String spanName, @NotNull Consumer<Span> consumer) {
        if (spanName == null) {
            GradleOpenTelemetry.$$$reportNull$$$0(8);
        }
        if (consumer == null) {
            GradleOpenTelemetry.$$$reportNull$$$0(9);
        }
        this.callWithSpan(spanName, span -> {
            consumer.accept((Span)span);
            return null;
        });
    }

    public byte[] shutdown() {
        try {
            if (this.myScope != null) {
                this.myScope.close();
            }
            if (this.myOpenTelemetry instanceof Closeable) {
                ((Closeable)this.myOpenTelemetry).close();
            }
            if (this.mySpanDataCollector != null) {
                Collection<SpanData> collectedSpans = this.mySpanDataCollector.getCollectedSpans();
                return SpanDataSerializer.serialize(collectedSpans);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ArrayUtilRt.EMPTY_BYTE_ARRAY;
    }

    @NotNull
    private static Scope injectTracingContext(@NotNull OpenTelemetry telemetry, @NotNull GradleTracingContext context) {
        if (telemetry == null) {
            GradleOpenTelemetry.$$$reportNull$$$0(10);
        }
        if (context == null) {
            GradleOpenTelemetry.$$$reportNull$$$0(11);
        }
        Scope scope = telemetry.getPropagators().getTextMapPropagator().extract(Context.current(), (Object)context, GradleTracingContext.GETTER).makeCurrent();
        if (scope == null) {
            GradleOpenTelemetry.$$$reportNull$$$0(12);
        }
        return scope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/telemetry/GradleOpenTelemetry";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spanName";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fn";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "telemetry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/telemetry/GradleOpenTelemetry";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTelemetry";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTracer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "injectTracingContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: 
            case 2: 
            case 12: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "callWithSpan";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runWithSpan";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "injectTracingContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

