/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.util;

import com.intellij.openapi.util.Pair;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;

public final class GradleModelProviderUtil {
    @NotNull
    private static <T, M> List<Pair<T, M>> buildModelsInParallel(@NotNull BuildController controller, @NotNull Iterable<T> targets, @NotNull BiFunction<? super BuildController, ? super T, ? extends M> buildAction) {
        if (controller == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(0);
        }
        if (targets == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(1);
        }
        if (buildAction == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(2);
        }
        ArrayList<BuildAction & Serializable> buildActions = new ArrayList<BuildAction & Serializable>();
        for (Object target : targets) {
            buildActions.add((BuildAction & Serializable)innerController -> {
                Object model = buildAction.apply((BuildController)innerController, (Object)target);
                if (model == null) {
                    return null;
                }
                return new Pair(target, model);
            });
        }
        List list = controller.run(buildActions);
        if (list == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static <T, M> List<Pair<T, M>> buildModelsSequentially(@NotNull BuildController controller, @NotNull Iterable<T> targets, @NotNull BiFunction<? super BuildController, ? super T, ? extends M> buildAction) {
        if (controller == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(4);
        }
        if (targets == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(5);
        }
        if (buildAction == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(6);
        }
        ArrayList<Pair<T, M>> result = new ArrayList<Pair<T, M>>();
        for (T target : targets) {
            M model = buildAction.apply((BuildController)((BuildController)controller), (BuildController)target);
            if (model == null) continue;
            result.add(new Pair(target, model));
        }
        ArrayList<Pair<T, M>> arrayList = result;
        if (arrayList == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    public static <T, M> List<Pair<T, M>> buildModels(@NotNull BuildController controller, @NotNull Iterable<T> targets, @NotNull BiFunction<? super BuildController, ? super T, ? extends M> buildAction) {
        if (controller == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(8);
        }
        if (targets == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(9);
        }
        if (buildAction == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(10);
        }
        if (Objects.equals(System.getProperty("idea.parallelModelFetch.enabled"), "true")) {
            return GradleModelProviderUtil.buildModelsInParallel(controller, targets, buildAction);
        }
        return GradleModelProviderUtil.buildModelsSequentially(controller, targets, buildAction);
    }

    @NotNull
    public static <T extends Model, M> List<Pair<T, M>> buildModels(@NotNull BuildController controller, @NotNull Iterable<T> targets, @NotNull Class<M> modelClass) {
        if (controller == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(11);
        }
        if (targets == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(12);
        }
        if (modelClass == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(13);
        }
        return GradleModelProviderUtil.buildModels(controller, targets, (? super BuildController innerController, ? super T target) -> innerController.findModel(target, modelClass));
    }

    public static <T extends Model, M> void buildModels(@NotNull BuildController controller, @NotNull Iterable<T> targets, @NotNull Class<M> modelClass, @NotNull BiConsumer<T, M> modelConsumer) {
        if (controller == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(14);
        }
        if (targets == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(15);
        }
        if (modelClass == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(16);
        }
        if (modelConsumer == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(17);
        }
        List<Pair<T, M>> models = GradleModelProviderUtil.buildModels(controller, targets, modelClass);
        for (Pair<T, M> model : models) {
            modelConsumer.accept((Model)model.first, model.second);
        }
    }

    public static <M> void buildModelsRecursively(@NotNull BuildController controller, @NotNull GradleBuild buildModel, @NotNull Class<M> modelClass, @NotNull ProjectImportModelProvider.BuildModelConsumer consumer) {
        if (controller == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(18);
        }
        if (buildModel == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(19);
        }
        if (modelClass == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(20);
        }
        if (consumer == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(21);
        }
        GradleModelProviderUtil.traverseTree(buildModel.getRootProject(), BasicGradleProject::getChildren, gradleProject -> {
            Object model = controller.findModel((Model)gradleProject, modelClass);
            if (model != null) {
                consumer.consumeProjectModel((ProjectModel)gradleProject, model, modelClass);
            }
        });
    }

    private static <T> void traverseTree(@NotNull T root, @NotNull Function<T, Iterable<? extends T>> children, @NotNull Consumer<T> action) {
        if (root == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(22);
        }
        if (children == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(23);
        }
        if (action == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(24);
        }
        ArrayDeque<T> queue = new ArrayDeque<T>();
        action.accept(root);
        queue.add(root);
        while (!queue.isEmpty()) {
            Object parent = queue.remove();
            for (T child : children.apply(parent)) {
                action.accept(child);
                queue.add(child);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildAction";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/util/GradleModelProviderUtil";
                break;
            }
            case 13: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelClass";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelConsumer";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModel";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/util/GradleModelProviderUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildModelsInParallel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildModelsSequentially";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildModelsInParallel";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildModelsSequentially";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "buildModels";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "buildModelsRecursively";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "traverseTree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

