/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.gradle.tooling.internal.gradle.DefaultBuildIdentifier;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.Build;
import org.jetbrains.plugins.gradle.model.DefaultProject;
import org.jetbrains.plugins.gradle.model.Project;

@ApiStatus.Internal
public final class DefaultBuild
implements Build,
Serializable {
    private final String myName;
    private final DefaultBuildIdentifier myBuildIdentifier;
    private final Collection<Project> myProjects = new ArrayList<Project>(0);
    private DefaultBuildIdentifier myParentBuildIdentifier = null;

    private DefaultBuild(String name, File rootDir) {
        this.myName = name;
        this.myBuildIdentifier = new DefaultBuildIdentifier(rootDir);
    }

    public String getName() {
        return this.myName;
    }

    public BuildIdentifier getBuildIdentifier() {
        return this.myBuildIdentifier;
    }

    public Collection<Project> getProjects() {
        return this.myProjects;
    }

    public BuildIdentifier getParentBuildIdentifier() {
        return this.myParentBuildIdentifier;
    }

    public void setParentBuildIdentifier(DefaultBuildIdentifier parentBuildIdentifier) {
        this.myParentBuildIdentifier = parentBuildIdentifier;
    }

    @NotNull
    public static Build convertGradleBuild(@NotNull GradleBuild gradleBuild) {
        if (gradleBuild == null) {
            DefaultBuild.$$$reportNull$$$0(0);
        }
        String name = gradleBuild.getRootProject().getName();
        File rootDir = gradleBuild.getBuildIdentifier().getRootDir();
        DefaultBuild build = new DefaultBuild(name, rootDir);
        for (BasicGradleProject gradleProject : gradleBuild.getProjects()) {
            build.myProjects.add(DefaultProject.convertGradleProject(gradleProject));
        }
        DefaultBuild defaultBuild = build;
        if (defaultBuild == null) {
            DefaultBuild.$$$reportNull$$$0(1);
        }
        return defaultBuild;
    }

    @NotNull
    public static Build convertIdeaProject(@NotNull IdeaProject ideaProject) {
        if (ideaProject == null) {
            DefaultBuild.$$$reportNull$$$0(2);
        }
        String name = ideaProject.getName();
        DomainObjectSet ideaModules = ideaProject.getChildren();
        assert (!ideaModules.isEmpty()) : "Cannot evaluate build identifier for IdeaProject";
        File rootDir = ((IdeaModule)ideaModules.getAt(0)).getGradleProject().getProjectIdentifier().getBuildIdentifier().getRootDir();
        DefaultBuild build = new DefaultBuild(name, rootDir);
        for (IdeaModule ideaModule : ideaModules) {
            build.myProjects.add(DefaultProject.convertIdeaProject(ideaModule));
        }
        DefaultBuild defaultBuild = build;
        if (defaultBuild == null) {
            DefaultBuild.$$$reportNull$$$0(3);
        }
        return defaultBuild;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleBuild";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/model/DefaultBuild";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/model/DefaultBuild";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "convertGradleBuild";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "convertIdeaProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertGradleBuild";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertIdeaProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

