/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import com.intellij.gradle.toolingExtension.impl.util.GradleIdeaPluginUtil;
import com.intellij.gradle.toolingExtension.impl.util.javaPluginUtil.JavaPluginUtil;
import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.AnnotationProcessingConfig;
import org.jetbrains.plugins.gradle.model.AnnotationProcessingModel;
import org.jetbrains.plugins.gradle.tooling.AbstractModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.internal.AnnotationProcessingConfigImpl;
import org.jetbrains.plugins.gradle.tooling.internal.AnnotationProcessingModelImpl;

public class AnnotationProcessingModelBuilder
extends AbstractModelBuilderService {
    private static final boolean isAtLeastGradle6_3 = GradleVersionUtil.isCurrentGradleAtLeast((String)"6.3");

    public Object buildAll(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context) {
        if (modelName == null) {
            AnnotationProcessingModelBuilder.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AnnotationProcessingModelBuilder.$$$reportNull$$$0(1);
        }
        if (context == null) {
            AnnotationProcessingModelBuilder.$$$reportNull$$$0(2);
        }
        if (!this.canBuild(modelName)) {
            return null;
        }
        SourceSetContainer container = JavaPluginUtil.getSourceSetContainer(project);
        if (container == null) {
            return null;
        }
        HashMap<String, AnnotationProcessingConfig> sourceSetConfigs = new HashMap<String, AnnotationProcessingConfig>();
        IdeaModule ideaModule = null;
        IdeaPlugin plugin = (IdeaPlugin)project.getPlugins().findPlugin(IdeaPlugin.class);
        if (plugin != null) {
            ideaModule = plugin.getModel().getModule();
        }
        for (SourceSet sourceSet : container) {
            Set files;
            CompileOptions options;
            FileCollection path;
            String compileTaskName = sourceSet.getCompileJavaTaskName();
            Task compileTask = (Task)project.getTasks().findByName(compileTaskName);
            if (!(compileTask instanceof JavaCompile) || (path = (options = ((JavaCompile)compileTask).getOptions()).getAnnotationProcessorPath()) == null || (files = path.getFiles()).isEmpty()) continue;
            ArrayList<String> annotationProcessorArgs = new ArrayList<String>();
            List args = options.getAllCompilerArgs();
            for (String arg : args) {
                if (!arg.startsWith("-A")) continue;
                annotationProcessorArgs.add(arg);
            }
            File generatedSourcesDirectory = AnnotationProcessingModelBuilder.getAnnotationProcessorGeneratedSourcesDirectory(options);
            String output = generatedSourcesDirectory != null ? generatedSourcesDirectory.getAbsolutePath() : null;
            sourceSetConfigs.put(sourceSet.getName(), new AnnotationProcessingConfigImpl(files, annotationProcessorArgs, output, AnnotationProcessingModelBuilder.isTestSourceSet(sourceSet, ideaModule)));
        }
        if (!sourceSetConfigs.isEmpty()) {
            return new AnnotationProcessingModelImpl(sourceSetConfigs);
        }
        return null;
    }

    @Nullable
    private static File getAnnotationProcessorGeneratedSourcesDirectory(@NotNull CompileOptions options) {
        if (options == null) {
            AnnotationProcessingModelBuilder.$$$reportNull$$$0(3);
        }
        if (isAtLeastGradle6_3) {
            return ((Directory)options.getGeneratedSourceOutputDirectory().get()).getAsFile();
        }
        return options.getAnnotationProcessorGeneratedSourcesDirectory();
    }

    private static boolean isTestSourceSet(@NotNull SourceSet sourceSet, @Nullable IdeaModule module) {
        if (sourceSet == null) {
            AnnotationProcessingModelBuilder.$$$reportNull$$$0(4);
        }
        if ("test".equals(sourceSet.getName())) {
            return true;
        }
        if (module != null) {
            Set<File> testSourceDirectories = GradleIdeaPluginUtil.getTestSourceDirectories(module);
            Set sourceDirectories = sourceSet.getAllJava().getSrcDirs();
            return testSourceDirectories.containsAll(sourceDirectories);
        }
        return false;
    }

    public boolean canBuild(String modelName) {
        return AnnotationProcessingModel.class.getName().equals(modelName);
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        if (modelName == null) {
            AnnotationProcessingModelBuilder.$$$reportNull$$$0(5);
        }
        if (project == null) {
            AnnotationProcessingModelBuilder.$$$reportNull$$$0(6);
        }
        if (context == null) {
            AnnotationProcessingModelBuilder.$$$reportNull$$$0(7);
        }
        if (exception == null) {
            AnnotationProcessingModelBuilder.$$$reportNull$$$0(8);
        }
        context.getMessageReporter().createMessage().withGroup("gradle.annotationProcessorModel.group").withKind(Message.Kind.WARNING).withTitle("Project annotation processor import failure").withText("Unable to create annotation processors model").withException(exception).reportMessage(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelName";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSet";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/tooling/builder/AnnotationProcessingModelBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildAll";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnnotationProcessorGeneratedSourcesDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestSourceSet";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "reportErrorMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

