/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.dtrace;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.DummyCallTreeBuilder;
import com.intellij.profiler.LineByLineParser;
import com.intellij.profiler.ProfilerManager;
import com.intellij.profiler.ProfilerProcessBase;
import com.intellij.profiler.UtilsKt;
import com.intellij.profiler.api.AttachCanceledException;
import com.intellij.profiler.api.AttachFailedException;
import com.intellij.profiler.api.AttachProfilerUtilsKt;
import com.intellij.profiler.api.AttachableTargetProcess;
import com.intellij.profiler.api.Attached;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.DataReady;
import com.intellij.profiler.api.NewCallTreeOnlyProfilerData;
import com.intellij.profiler.api.ParsingData;
import com.intellij.profiler.api.ProfilerDumpWriter;
import com.intellij.profiler.api.ProfilerTargetProcess;
import com.intellij.profiler.api.ReadingData;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.dtrace.DTraceProfilerProcessBase;
import com.intellij.profiler.dtrace.DTraceProfilerProcessBaseKt;
import com.intellij.profiler.dtrace.DTraceScript;
import com.intellij.profiler.dtrace.DTraceScriptKt;
import com.intellij.profiler.dtrace.FullDumpParser;
import com.intellij.profiler.sudo.SudoProcessHandler;
import com.intellij.util.concurrency.Semaphore;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b&\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001)B'\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H$J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0016\u0010\u001e\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140 H$J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020\"H\u0014J\b\u0010&\u001a\u00020\"H\u0014J\b\u0010'\u001a\u00020\"H\u0014J\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00140 2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140 H\u0014R\u0014\u0010\u000b\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006*"}, d2={"Lcom/intellij/profiler/dtrace/DTraceProfilerProcessBase;", "Lcom/intellij/profiler/ProfilerProcessBase;", "Lcom/intellij/profiler/api/AttachableTargetProcess;", "project", "Lcom/intellij/openapi/project/Project;", "targetProcess", "attachedTimestamp", "", "dtraceProcessHandler", "Lcom/intellij/profiler/sudo/SudoProcessHandler;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/api/AttachableTargetProcess;JLcom/intellij/profiler/sudo/SudoProcessHandler;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getAttachedTimestamp", "()J", "dumpParser", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/profiler/dtrace/FullDumpParser;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "profilerConfiguration", "Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "getProfilerConfiguration", "()Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "createDumpParser", "createDumpWriter", "Lcom/intellij/profiler/api/ProfilerDumpWriter;", "data", "Lcom/intellij/profiler/api/NewCallTreeOnlyProfilerData;", "createProfilerData", "builder", "Lcom/intellij/profiler/DummyCallTreeBuilder;", "dispose", "", "doStop", "", "onDTraceStopped", "onTargetProcessTerminated", "onTerminateCalled", "postProcessData", "Companion", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nDTraceProfilerProcessBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DTraceProfilerProcessBase.kt\ncom/intellij/profiler/dtrace/DTraceProfilerProcessBase\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,177:1\n11#2:178\n*S KotlinDebug\n*F\n+ 1 DTraceProfilerProcessBase.kt\ncom/intellij/profiler/dtrace/DTraceProfilerProcessBase\n*L\n175#1:178\n*E\n"})
public abstract class DTraceProfilerProcessBase
extends ProfilerProcessBase<AttachableTargetProcess> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long attachedTimestamp;
    @NotNull
    private final SudoProcessHandler dtraceProcessHandler;
    @NotNull
    private final ProfilerConfigurationState profilerConfiguration;
    @NotNull
    private final AtomicReference<FullDumpParser<BaseCallStackElement>> dumpParser;
    @NotNull
    private final Logger LOG;
    @NotNull
    private static final Logger staticLogger;

    protected DTraceProfilerProcessBase(@NotNull Project project, final @NotNull AttachableTargetProcess targetProcess, long attachedTimestamp, @NotNull SudoProcessHandler dtraceProcessHandler) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetProcess, (String)"targetProcess");
        Intrinsics.checkNotNullParameter((Object)((Object)dtraceProcessHandler), (String)"dtraceProcessHandler");
        super(project, (ProfilerTargetProcess)targetProcess);
        this.attachedTimestamp = attachedTimestamp;
        this.dtraceProcessHandler = dtraceProcessHandler;
        this.dtraceProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            @Nullable
            private BufferedWriter currentProcessRawDumpFileWriter;

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    this.getDumpReadIndicator().checkCanceled();
                    if (this.getState() == Attached.INSTANCE && ProcessOutputType.isStdout(outputType)) {
                        String string = event.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"DTrace stopped", (boolean)false, (int)2, null)) {
                            this.onDTraceStopped();
                            if (UtilsKt.keepTempProfilerFiles()) {
                                File file2 = UtilsKt.dtraceOutputFile(targetProcess.getPid());
                                this.getLOG().info("DTrace dump will be written to " + file2.getAbsolutePath());
                                this.currentProcessRawDumpFileWriter = new BufferedWriter(new FileWriter(file2));
                            }
                            dumpParser.set(this.createDumpParser());
                            this.changeStateAndNotifyAsync(ReadingData.INSTANCE);
                        }
                    }
                    if (this.getState() != ReadingData.INSTANCE) break block5;
                    FullDumpParser fullDumpParser = (FullDumpParser)dumpParser.get();
                    if (fullDumpParser != null) {
                        LineByLineParser lineByLineParser = fullDumpParser;
                        String string = event.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        LineByLineParser.consumeText$default(lineByLineParser, string, null, 2, null);
                    }
                    BufferedWriter bufferedWriter = this.currentProcessRawDumpFileWriter;
                    if (bufferedWriter != null) {
                        bufferedWriter.append(event.getText());
                    }
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                BufferedWriter bufferedWriter = this.currentProcessRawDumpFileWriter;
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                FullDumpParser fullDumpParser = (FullDumpParser)dumpParser.get();
                if (fullDumpParser == null) {
                    return;
                }
                FullDumpParser parser = fullDumpParser;
                this.getLOG().info("Dtrace process terminated with code: " + event.getExitCode());
                this.changeStateAndNotifyAsync(ParsingData.INSTANCE);
                DummyCallTreeBuilder dummyCallTreeBuilder = parser.getChartBuilders().get("CPU Samples");
                if (dummyCallTreeBuilder == null) {
                    dummyCallTreeBuilder = new DummyCallTreeBuilder();
                }
                DummyCallTreeBuilder<BaseCallStackElement> cpuAnalyzedTree = this.postProcessData(dummyCallTreeBuilder);
                NewCallTreeOnlyProfilerData data = this.createProfilerData(cpuAnalyzedTree);
                this.getDumpReadIndicator().checkCanceled();
                this.changeStateAndNotifyAsync(new DataReady(data, this.createDumpWriter(data)));
            }
        });
        this.profilerConfiguration = DTraceProfilerProcessBaseKt.getLegacyDTraceProfilerConfiguration();
        this.dumpParser = new AtomicReference<Object>(null);
        this.LOG = staticLogger;
    }

    @Override
    public long getAttachedTimestamp() {
        return this.attachedTimestamp;
    }

    @Override
    @NotNull
    public ProfilerConfigurationState getProfilerConfiguration() {
        return this.profilerConfiguration;
    }

    @NotNull
    protected abstract FullDumpParser<BaseCallStackElement> createDumpParser();

    @NotNull
    protected abstract NewCallTreeOnlyProfilerData createProfilerData(@NotNull DummyCallTreeBuilder<BaseCallStackElement> var1);

    @Nullable
    protected ProfilerDumpWriter createDumpWriter(@NotNull NewCallTreeOnlyProfilerData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return null;
    }

    protected void onDTraceStopped() {
    }

    @NotNull
    protected DummyCallTreeBuilder<BaseCallStackElement> postProcessData(@NotNull DummyCallTreeBuilder<BaseCallStackElement> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        return builder;
    }

    @Override
    @NotNull
    protected Logger getLOG() {
        return this.LOG;
    }

    @Override
    protected boolean doStop() {
        this.dtraceProcessHandler.sendSIGINT();
        return true;
    }

    @Override
    protected void onTargetProcessTerminated() {
    }

    @Override
    protected void onTerminateCalled() {
        this.dtraceProcessHandler.destroyProcess();
    }

    @Override
    public void dispose() {
        this.dtraceProcessHandler.destroyProcess();
        this.dumpParser.set(null);
        super.dispose();
    }

    public static final /* synthetic */ Logger access$getStaticLogger$cp() {
        return staticLogger;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DTraceProfilerProcessBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        staticLogger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0090\u0001\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\b\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0018\b\u0002\u0010\u0013\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u001426\u0010\u0017\u001a2\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u0002H\u00070\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/profiler/dtrace/DTraceProfilerProcessBase$Companion;", "", "()V", "staticLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "attachBase", "Lorg/jetbrains/concurrency/Promise;", "ProfilerProcess", "Lcom/intellij/profiler/dtrace/DTraceProfilerProcessBase;", "targetProcess", "Lcom/intellij/profiler/api/AttachableTargetProcess;", "backgroundOption", "Lcom/intellij/openapi/progress/PerformInBackgroundOption;", "dTraceScript", "Lcom/intellij/profiler/dtrace/DTraceScript;", "timeoutInMilliseconds", "", "project", "Lcom/intellij/openapi/project/Project;", "sudoPasswordSupplier", "Lkotlin/Function1;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "", "onDTraceAttached", "Lkotlin/Function2;", "Lcom/intellij/profiler/sudo/SudoProcessHandler;", "Lkotlin/ParameterName;", "name", "dtraceProcessHandler", "indicator", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <ProfilerProcess extends DTraceProfilerProcessBase> Promise<ProfilerProcess> attachBase(@NotNull AttachableTargetProcess targetProcess, @NotNull PerformInBackgroundOption backgroundOption, @NotNull DTraceScript dTraceScript, int timeoutInMilliseconds, @NotNull Project project, @NotNull Function1<? super ProgressIndicator, String> sudoPasswordSupplier, @NotNull Function2<? super SudoProcessHandler, ? super ProgressIndicator, ? extends ProfilerProcess> onDTraceAttached) {
            Intrinsics.checkNotNullParameter((Object)targetProcess, (String)"targetProcess");
            Intrinsics.checkNotNullParameter((Object)backgroundOption, (String)"backgroundOption");
            Intrinsics.checkNotNullParameter((Object)dTraceScript, (String)"dTraceScript");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(sudoPasswordSupplier, (String)"sudoPasswordSupplier");
            Intrinsics.checkNotNullParameter(onDTraceAttached, (String)"onDTraceAttached");
            AsyncPromise result2 = new AsyncPromise();
            String string = CommonProfilerBundleKt.commonProfilerMessage("attach.task.title", new Object[0]);
            new Task.Backgroundable(project, backgroundOption, targetProcess, sudoPasswordSupplier, dTraceScript, timeoutInMilliseconds, result2, onDTraceAttached, string){
                final /* synthetic */ AttachableTargetProcess $targetProcess;
                final /* synthetic */ Function1<ProgressIndicator, String> $sudoPasswordSupplier;
                final /* synthetic */ DTraceScript $dTraceScript;
                final /* synthetic */ int $timeoutInMilliseconds;
                final /* synthetic */ AsyncPromise<ProfilerProcess> $result;
                final /* synthetic */ Function2<SudoProcessHandler, ProgressIndicator, ProfilerProcess> $onDTraceAttached;
                {
                    this.$targetProcess = $targetProcess;
                    this.$sudoPasswordSupplier = $sudoPasswordSupplier;
                    this.$dTraceScript = $dTraceScript;
                    this.$timeoutInMilliseconds = $timeoutInMilliseconds;
                    this.$result = $result;
                    this.$onDTraceAttached = $onDTraceAttached;
                    super($project, $super_call_param$1, true, $backgroundOption);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    Object[] objectArray = new Object[]{this.$targetProcess.getFullName()};
                    indicator.setText(CommonProfilerBundleKt.commonProfilerMessage("attach.task.text", objectArray));
                    String password = (String)this.$sudoPasswordSupplier.invoke((Object)indicator);
                    if (password == null) {
                        com.intellij.profiler.dtrace.DTraceProfilerProcessBase$Companion.access$attachBase$setWrongPasswordResult(this.$result);
                        return;
                    }
                    Semaphore semaphore = new Semaphore(1);
                    AtomicBoolean terminated = new AtomicBoolean(false);
                    SudoProcessHandler handler2 = DTraceScriptKt.startDTraceProcessNew(this.$targetProcess.getPid(), this.$dTraceScript, (Function0<String>)((Function0)new Function0<String>(password){
                        final /* synthetic */ String $password;
                        {
                            this.$password = $password;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return this.$password;
                        }
                    }), (Function0<Unit>)((Function0)new Function0<Unit>(semaphore, this.$result){
                        final /* synthetic */ Semaphore $semaphore;
                        final /* synthetic */ AsyncPromise<ProfilerProcess> $result;
                        {
                            this.$semaphore = $semaphore;
                            this.$result = $result;
                            super(0);
                        }

                        public final void invoke() {
                            this.$semaphore.up();
                            com.intellij.profiler.dtrace.DTraceProfilerProcessBase$Companion.access$attachBase$setWrongPasswordResult(this.$result);
                        }
                    }), (Function1<? super Integer, Unit>)((Function1)attachBase.run.handler.3.INSTANCE));
                    ProcessAdapter adapter2 = new ProcessAdapter(terminated, this.$result, this.$onDTraceAttached, handler2, indicator, semaphore, this.$targetProcess){
                        final /* synthetic */ AtomicBoolean $terminated;
                        final /* synthetic */ AsyncPromise<ProfilerProcess> $result;
                        final /* synthetic */ Function2<SudoProcessHandler, ProgressIndicator, ProfilerProcess> $onDTraceAttached;
                        final /* synthetic */ SudoProcessHandler $handler;
                        final /* synthetic */ ProgressIndicator $indicator;
                        final /* synthetic */ Semaphore $semaphore;
                        final /* synthetic */ AttachableTargetProcess $targetProcess;
                        {
                            this.$terminated = $terminated;
                            this.$result = $result;
                            this.$onDTraceAttached = $onDTraceAttached;
                            this.$handler = $handler;
                            this.$indicator = $indicator;
                            this.$semaphore = $semaphore;
                            this.$targetProcess = $targetProcess;
                        }

                        /*
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                            if (this.$terminated.get()) {
                                return;
                            }
                            if (ProcessOutputType.isStdout(outputType)) {
                                String string = event.getText();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"DTrace attached", (boolean)false, (int)2, null)) {
                                    try {
                                        this.$result.setResult(this.$onDTraceAttached.invoke((Object)((Object)this.$handler), (Object)this.$indicator));
                                    }
                                    catch (Throwable e) {
                                        this.$result.setError(e);
                                        this.$handler.destroyProcess();
                                    }
                                    this.$semaphore.up();
                                    return;
                                }
                            }
                            if (ProcessOutputType.isStderr(outputType)) {
                                String string = event.getText();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"DTrace cannot instrument translated processes", (boolean)false, (int)2, null)) {
                                    this.$result.setError((Throwable)AttachProfilerUtilsKt.cannotInstrumentTranslatedProcess());
                                    this.$handler.destroyProcess();
                                    this.$semaphore.up();
                                    return;
                                }
                            }
                            if (!ProcessOutputType.isStderr(outputType)) return;
                            String string = event.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"dtrace: failed to grab pid", (boolean)false, (int)2, null)) return;
                            this.$result.setError((Throwable)AttachProfilerUtilsKt.attachFailedCantGrubPid(this.$targetProcess));
                            this.$handler.destroyProcess();
                            this.$semaphore.up();
                        }
                    };
                    handler2.addProcessListener((ProcessListener)adapter2);
                    handler2.startNotify();
                    long start2 = System.currentTimeMillis();
                    while (!semaphore.waitFor(100L)) {
                        boolean canceled = indicator.isCanceled();
                        if (!canceled && System.currentTimeMillis() - start2 <= (long)this.$timeoutInMilliseconds) continue;
                        terminated.set(true);
                        handler2.destroyProcess();
                        this.$result.setError((Throwable)(canceled ? (Exception)AttachCanceledException.INSTANCE : (Exception)AttachProfilerUtilsKt.attachFailedTimeout(this.$targetProcess)));
                        break;
                    }
                    handler2.removeProcessListener((ProcessListener)adapter2);
                }
            }.queue();
            return (Promise)result2;
        }

        public static /* synthetic */ Promise attachBase$default(Companion companion, AttachableTargetProcess attachableTargetProcess, PerformInBackgroundOption performInBackgroundOption, DTraceScript dTraceScript, int n, Project project, Function1 function1, Function2 function2, int n2, Object object) {
            if ((n2 & 0x20) != 0) {
                function1 = (Function1)new Function1<ProgressIndicator, String>(project){
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                        super(1);
                    }

                    @Nullable
                    public final String invoke(@Nullable ProgressIndicator it) {
                        return ProfilerManager.INSTANCE.getSudoPassword(this.$project, it);
                    }
                };
            }
            return companion.attachBase(attachableTargetProcess, performInBackgroundOption, dTraceScript, n, project, (Function1<? super ProgressIndicator, String>)function1, function2);
        }

        private static final <ProfilerProcess extends DTraceProfilerProcessBase> boolean attachBase$setWrongPasswordResult(AsyncPromise<ProfilerProcess> result2) {
            return result2.setError((Throwable)new AttachFailedException(CommonProfilerBundleKt.commonProfilerMessage("profiler.valid.password.required", new Object[0])));
        }

        public static final /* synthetic */ boolean access$attachBase$setWrongPasswordResult(AsyncPromise result2) {
            return com.intellij.profiler.dtrace.DTraceProfilerProcessBase$Companion.attachBase$setWrongPasswordResult(result2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

