/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.sudo;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.profiler.ProcessUtilKt;
import com.intellij.profiler.sudo.ExecSudoCommandKt;
import com.intellij.profiler.sudo.SendResult;
import java.io.OutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 #2\u00020\u0001:\u0001#BV\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0006\u0012#\b\u0002\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0016\u001a\u00020\bH\u0014J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u001c\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00042\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0016J\u0016\u0010 \u001a\u00020\b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\u0006H\u0002J\u0006\u0010\"\u001a\u00020\bR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R)\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lcom/intellij/profiler/sudo/SudoProcessHandler;", "Lcom/intellij/execution/process/OSProcessHandler;", "commandWithParameters", "", "", "sudoPasswordSupplier", "Lkotlin/Function0;", "onWrongSudoPassword", "", "onCantSendSudoSignal", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "signal", "(Ljava/util/List;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "consumeRest", "", "<set-?>", "wrongSudoPassword", "getWrongSudoPassword", "()Z", "doDestroyProcess", "killSudoProcessTree", "process", "Ljava/lang/Process;", "notifyIfCant", "result", "notifyTextAvailable", "text", "outputType", "Lcom/intellij/openapi/util/Key;", "runSyncIfTestOtherwiseExecute", "body", "sendSIGINT", "Companion", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nSudoProcessHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SudoProcessHandler.kt\ncom/intellij/profiler/sudo/SudoProcessHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,83:1\n11#2:84\n*S KotlinDebug\n*F\n+ 1 SudoProcessHandler.kt\ncom/intellij/profiler/sudo/SudoProcessHandler\n*L\n21#1:84\n*E\n"})
public final class SudoProcessHandler
extends OSProcessHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<String> sudoPasswordSupplier;
    @NotNull
    private final Function0<Unit> onWrongSudoPassword;
    @NotNull
    private final Function1<Integer, Unit> onCantSendSudoSignal;
    private volatile boolean wrongSudoPassword;
    private boolean consumeRest;
    @NotNull
    private static final Logger logger;

    public SudoProcessHandler(@NotNull List<String> commandWithParameters, @NotNull Function0<String> sudoPasswordSupplier, @NotNull Function0<Unit> onWrongSudoPassword, @NotNull Function1<? super Integer, Unit> onCantSendSudoSignal) {
        block0: {
            OutputStream outputStream;
            Intrinsics.checkNotNullParameter(commandWithParameters, (String)"commandWithParameters");
            Intrinsics.checkNotNullParameter(sudoPasswordSupplier, (String)"sudoPasswordSupplier");
            Intrinsics.checkNotNullParameter(onWrongSudoPassword, (String)"onWrongSudoPassword");
            Intrinsics.checkNotNullParameter(onCantSendSudoSignal, (String)"onCantSendSudoSignal");
            super(ExecSudoCommandKt.sudoCmd().withParameters(commandWithParameters));
            this.sudoPasswordSupplier = sudoPasswordSupplier;
            this.onWrongSudoPassword = onWrongSudoPassword;
            this.onCantSendSudoSignal = onCantSendSudoSignal;
            OutputStream outputStream2 = this.getProcessInput();
            if (outputStream2 == null) break block0;
            OutputStream $this$_init__u24lambda_u240 = outputStream = outputStream2;
            boolean bl = false;
            byte[] byArray = (this.sudoPasswordSupplier.invoke() + "\n").getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            $this$_init__u24lambda_u240.write(byArray);
            $this$_init__u24lambda_u240.flush();
        }
    }

    public /* synthetic */ SudoProcessHandler(List list, Function0 function0, Function0 function02, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function02 = 1.INSTANCE;
        }
        if ((n & 8) != 0) {
            function1 = 2.INSTANCE;
        }
        this(list, (Function0<String>)function0, (Function0<Unit>)function02, (Function1<? super Integer, Unit>)function1);
    }

    public final boolean getWrongSudoPassword() {
        return this.wrongSudoPassword;
    }

    public void notifyTextAvailable(@NotNull String text2, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        logger.debug("sudo text available from " + outputType + ": " + text2);
        if (this.consumeRest) {
            super.notifyTextAvailable(text2, outputType);
            return;
        }
        if (this.wrongSudoPassword) {
            return;
        }
        if (outputType == ProcessOutputTypes.SYSTEM) {
            super.notifyTextAvailable(text2, outputType);
            return;
        }
        if (ProcessOutputType.isStderr(outputType) && StringsKt.contains$default((CharSequence)text2, (CharSequence)"Sorry, try again.", (boolean)false, (int)2, null)) {
            this.wrongSudoPassword = true;
            this.destroyProcess();
            this.onWrongSudoPassword.invoke();
            return;
        }
        this.consumeRest = true;
        super.notifyTextAvailable(text2, outputType);
    }

    protected void doDestroyProcess() {
        if (this.wrongSudoPassword) {
            super.doDestroyProcess();
            return;
        }
        if (this.shouldDestroyProcessRecursively() && OSProcessHandler.processCanBeKilledByOS((Process)this.getProcess())) {
            Process process = this.getProcess();
            Intrinsics.checkNotNullExpressionValue((Object)process, (String)"getProcess(...)");
            this.killSudoProcessTree(process);
        } else {
            this.runSyncIfTestOtherwiseExecute((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ SudoProcessHandler this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    Process process = this.this$0.getProcess();
                    Intrinsics.checkNotNullExpressionValue((Object)process, (String)"getProcess(...)");
                    SudoProcessHandler.access$notifyIfCant(this.this$0, ExecSudoCommandKt.sudoSendSIGKILL(process, (String)SudoProcessHandler.access$getSudoPasswordSupplier$p(this.this$0).invoke()) == SendResult.FAILED, 9);
                }
            }));
        }
    }

    private final void killSudoProcessTree(Process process) {
        this.runSyncIfTestOtherwiseExecute((Function0<Unit>)((Function0)new Function0<Unit>(this, process){
            final /* synthetic */ SudoProcessHandler this$0;
            final /* synthetic */ Process $process;
            {
                this.this$0 = $receiver;
                this.$process = $process;
                super(0);
            }

            public final void invoke() {
                SudoProcessHandler.access$notifyIfCant(this.this$0, ProcessUtilKt.killSudoProcessTreeSync$default(this.$process, (String)SudoProcessHandler.access$getSudoPasswordSupplier$p(this.this$0).invoke(), 0, 4, null), 9);
            }
        }));
    }

    public final void sendSIGINT() {
        this.runSyncIfTestOtherwiseExecute((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ SudoProcessHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Process process = this.this$0.getProcess();
                Intrinsics.checkNotNullExpressionValue((Object)process, (String)"getProcess(...)");
                SudoProcessHandler.access$notifyIfCant(this.this$0, ProcessUtilKt.killSudoProcessTreeSync(process, (String)SudoProcessHandler.access$getSudoPasswordSupplier$p(this.this$0).invoke(), 2), 2);
            }
        }));
    }

    private final void notifyIfCant(boolean result2, int signal) {
        if (!result2) {
            this.onCantSendSudoSignal.invoke((Object)signal);
        }
    }

    private final void runSyncIfTestOtherwiseExecute(Function0<Unit> body) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            body.invoke();
        } else {
            this.executeTask(() -> SudoProcessHandler.runSyncIfTestOtherwiseExecute$lambda$1(body));
        }
    }

    private static final void runSyncIfTestOtherwiseExecute$lambda$1(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    public static final /* synthetic */ void access$notifyIfCant(SudoProcessHandler $this, boolean result2, int signal) {
        $this.notifyIfCant(result2, signal);
    }

    public static final /* synthetic */ Function0 access$getSudoPasswordSupplier$p(SudoProcessHandler $this) {
        return $this.sudoPasswordSupplier;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SudoProcessHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SudoProcessHandler.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/intellij/profiler/sudo/SudoProcessHandler$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

