/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.callusage;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.model.CallWithValue;
import com.intellij.profiler.model.diff.DiffUtilsKt;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.ui.CommonProfilerTabNameWithId;
import com.intellij.profiler.ui.MainCallTreeDataComponent;
import com.intellij.profiler.ui.MergedCalleesPanelKt;
import com.intellij.profiler.ui.ProfilerUIUtilsKt;
import com.intellij.profiler.ui.TransformCallTreeActionsKt;
import com.intellij.profiler.ui.callusage.CallUsageNodeKt;
import com.intellij.profiler.ui.callusage.CallUsageTreeCellRenderer;
import com.intellij.profiler.ui.callusage.MainCallTreeUIModel;
import com.intellij.profiler.ui.callusage.MouseAwareLabel;
import com.intellij.profiler.ui.callusage.UIVisibleCallTreeNode;
import com.intellij.profiler.ui.callusage.UsageModelActions;
import com.intellij.profiler.ui.flamechart.FlameChartColors;
import com.intellij.profiler.ui.treetable.MouseAwareTreeCellRendererPanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTreeTable;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 42\u00020\u0001:\u000245B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0014\u00a2\u0006\u0002\u0010\u001cJB\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020#H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0014J\u0010\u0010-\u001a\u00020*2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010.\u001a\u00020*2\u0006\u0010/\u001a\u0002002\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u00101\u001a\u00020*2\u0006\u0010/\u001a\u0002002\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u00102\u001a\u00020*2\u0006\u0010/\u001a\u0002002\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u00103\u001a\u00020*2\u0006\u0010/\u001a\u0002002\u0006\u0010&\u001a\u00020'H\u0002R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/profiler/ui/callusage/CallUsageTreeCellRenderer;", "Lcom/intellij/profiler/ui/treetable/MouseAwareTreeCellRendererPanel;", "treeTable", "Lcom/intellij/ui/components/JBTreeTable;", "parentComponent", "Lcom/intellij/profiler/ui/MainCallTreeDataComponent;", "(Lcom/intellij/ui/components/JBTreeTable;Lcom/intellij/profiler/ui/MainCallTreeDataComponent;)V", "INSETS", "Lcom/intellij/util/ui/JBEmptyBorder;", "Lorg/jetbrains/annotations/NotNull;", "STACKED_INSETS", "fold", "Lcom/intellij/profiler/ui/callusage/MouseAwareLabel;", "horizontalStrut", "Ljava/awt/Component;", "kotlin.jvm.PlatformType", "label", "Lcom/intellij/ui/SimpleColoredComponent;", "links", "", "Ljavax/swing/JComponent;", "[Ljavax/swing/JComponent;", "metrics", "Lcom/intellij/ui/components/JBLabel;", "optional", "recursionIcon", "unfold", "getHighlightables", "()[Ljavax/swing/JComponent;", "getTreeCellRendererComponent", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "mouseClicked", "", "event", "Ljava/awt/event/MouseEvent;", "updateComponents", "updateFoldLink", "uiData", "Lcom/intellij/profiler/ui/callusage/CallUsageTreeCellRenderer$Companion$TreeNodeUIData;", "updateMetrics", "updateRecursionIcon", "updateUnfoldLink", "Companion", "TreeNodeUIValue", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nCallUsageTreeCellRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallUsageTreeCellRenderer.kt\ncom/intellij/profiler/ui/callusage/CallUsageTreeCellRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,355:1\n1#2:356\n13309#3,2:357\n4098#3,11:359\n1855#4,2:370\n1864#4,3:372\n*S KotlinDebug\n*F\n+ 1 CallUsageTreeCellRenderer.kt\ncom/intellij/profiler/ui/callusage/CallUsageTreeCellRenderer\n*L\n117#1:357,2\n125#1:359,11\n125#1:370,2\n151#1:372,3\n*E\n"})
public final class CallUsageTreeCellRenderer
extends MouseAwareTreeCellRendererPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MainCallTreeDataComponent parentComponent;
    @NotNull
    private final JBEmptyBorder STACKED_INSETS;
    @NotNull
    private final JBEmptyBorder INSETS;
    @NotNull
    private final JBLabel metrics;
    @NotNull
    private final MouseAwareLabel unfold;
    @NotNull
    private final MouseAwareLabel fold;
    @NotNull
    private final JBLabel recursionIcon;
    private final Component horizontalStrut;
    @NotNull
    private final SimpleColoredComponent label;
    @NotNull
    private final JComponent[] optional;
    @NotNull
    private final JComponent[] links;

    /*
     * WARNING - void declaration
     */
    public CallUsageTreeCellRenderer(@NotNull JBTreeTable treeTable2, @NotNull MainCallTreeDataComponent parentComponent) {
        void $this$fold_u24lambda_u240;
        JComponent[] jComponentArray;
        Intrinsics.checkNotNullParameter((Object)treeTable2, (String)"treeTable");
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        super((JTree)treeTable2.getTree());
        this.parentComponent = parentComponent;
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty((int)3, (int)3, (int)0, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(...)");
        this.STACKED_INSETS = jBEmptyBorder;
        JBEmptyBorder jBEmptyBorder2 = JBUI.Borders.empty((int)3, (int)0, (int)0, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder2, (String)"empty(...)");
        this.INSETS = jBEmptyBorder2;
        this.metrics = new JBLabel();
        this.unfold = new MouseAwareLabel("\u2193");
        JComponent[] jComponentArray2 = jComponentArray = new MouseAwareLabel("\u2191");
        CallUsageTreeCellRenderer callUsageTreeCellRenderer = this;
        boolean bl = false;
        $this$fold_u24lambda_u240.setBorder((Border)this.INSETS);
        callUsageTreeCellRenderer.fold = jComponentArray;
        this.recursionIcon = new JBLabel(AllIcons.Gutter.RecursiveMethod);
        this.horizontalStrut = Box.createHorizontalStrut(8);
        this.label = new SimpleColoredComponent();
        jComponentArray = new JComponent[]{this.metrics, this.unfold, this.fold, this.recursionIcon};
        this.optional = jComponentArray;
        jComponentArray = new JComponent[]{this.unfold, this.fold, this.recursionIcon};
        this.links = jComponentArray;
        this.setLayout((LayoutManager)new HorizontalLayout(0, 0, 2, null));
        this.add((Component)this.metrics);
        this.add((Component)((Object)this.unfold));
        this.add((Component)((Object)this.fold));
        this.add((Component)this.recursionIcon);
        this.add(this.horizontalStrut);
        this.add((Component)this.label);
        this.metrics.setBorder((Border)JBUI.Borders.emptyRight((int)8));
        this.metrics.setHorizontalAlignment(4);
        JTree jTree = this.tree;
        Intrinsics.checkNotNullExpressionValue((Object)jTree, (String)"tree");
        int width = ProfilerUIUtilsKt.metricsStringWidth(jTree, true, this.parentComponent.isDiff()) + 8;
        if (this.metrics.getWidth() != width) {
            this.metrics.setPreferredSize(new Dimension(width, 0));
        }
    }

    @NotNull
    public CallUsageTreeCellRenderer getTreeCellRendererComponent(@NotNull JTree tree, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        this.updateComponents(selected);
        TreeModel treeModel = tree.getModel();
        MainCallTreeUIModel mainCallTreeUIModel = treeModel instanceof MainCallTreeUIModel ? (MainCallTreeUIModel)((Object)treeModel) : null;
        if (mainCallTreeUIModel == null) {
            return this;
        }
        MainCallTreeUIModel usageModel = mainCallTreeUIModel;
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.intellij.profiler.model.CallTreeNode<com.intellij.profiler.api.BaseCallStackElement>{ com.intellij.profiler.ui.callusage.CallUsageNodeKt.CallUsageNode }");
        CallTreeNode usageNode = (CallTreeNode)value;
        Companion.TreeNodeUIData treeNodeUIData = Companion.createUIData(usageModel, usageNode);
        if (treeNodeUIData == null) {
            return this;
        }
        Companion.TreeNodeUIData uiData = treeNodeUIData;
        this.updateMetrics(uiData, selected);
        this.updateUnfoldLink(uiData, row);
        this.updateFoldLink(uiData, row);
        this.updateRecursionIcon(uiData, row);
        this.horizontalStrut.setVisible(this.unfold.isVisible() || this.fold.isVisible());
        if (uiData.getVisibleNodes().size() > 1) {
            this.parentComponent.getCallStackElementRenderer().appendStackElementInRenderer((BaseCallStackElement)CollectionsKt.first(uiData.getVisibleNodes()), this.label, tree, selected);
            this.label.append(" \u2192 ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            this.parentComponent.getCallStackElementRenderer().appendStackElementInRenderer((BaseCallStackElement)CollectionsKt.last(uiData.getVisibleNodes()), this.label, tree, selected);
        } else {
            this.parentComponent.getCallStackElementRenderer().appendStackElementInRenderer((BaseCallStackElement)CollectionsKt.first(uiData.getVisibleNodes()), this.label, tree, selected);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateComponents(boolean selected) {
        void $this$forEach$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Color color2;
        JComponent[] element$iv;
        JComponent[] $this$forEach$iv2 = this.optional;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv2.length;
        for (int i = 0; i < n; ++i) {
            JComponent[] it = element$iv = $this$forEach$iv2[i];
            boolean bl = false;
            it.setVisible(false);
        }
        this.label.clear();
        this.setBackground(RenderingUtil.getBackground((JTree)this.tree, (boolean)selected));
        this.setToolTipText(null);
        Color color3 = RenderingUtil.getForeground((JTree)this.tree, (boolean)selected);
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"getForeground(...)");
        Color foreground = color3;
        if (selected) {
            color2 = foreground;
        } else {
            Color color4 = JBUI.CurrentTheme.Link.Foreground.ENABLED;
            color2 = color4;
            Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"ENABLED");
        }
        Color hoverground = color2;
        Object $this$filterIsInstance$iv = this.links;
        boolean $i$f$filterIsInstance = false;
        element$iv = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof MouseAwareLabel)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv2 : $this$forEach$iv) {
            MouseAwareLabel it = (MouseAwareLabel)((Object)element$iv2);
            boolean bl = false;
            it.setHoverground(hoverground);
            it.setForeground(hoverground);
        }
        this.metrics.setForeground(foreground);
        this.label.setForeground(foreground);
    }

    private final void updateMetrics(Companion.TreeNodeUIData uiData, boolean selected) {
        TreeNodeUIValue uiValue2 = uiData.getUiValue();
        if (uiValue2 instanceof TreeNodeUIValue.Regular) {
            double frac = ((TreeNodeUIValue.Regular)uiValue2).getToggledViewFraction().getFractionValue();
            if (!selected) {
                this.metrics.setForeground(FlameChartColors.INSTANCE.getFireColor$intellij_profiler_common(frac));
            }
            this.metrics.setVisible(true);
            this.metrics.setText(ProfilerUIUtilsKt.fractionToString$default(frac, 0.0, false, false, 14, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateUnfoldLink(Companion.TreeNodeUIData uiData, int row) {
        List<BaseCallStackElement> foldedNodes = uiData.getVisibleNodes();
        if (foldedNodes.size() <= 1) {
            return;
        }
        this.unfold.setVisible(true);
        if (this.getHighlightedRow() == row && this.getHighlightedComponent() == this.unfold) {
            this.unfold.entered(null);
            HtmlBuilder builder = new HtmlBuilder();
            builder.append((HtmlChunk)HtmlChunk.div((String)"margin-bottom: 12px; font-weight: bold").child(HtmlChunk.text((String)CommonProfilerBundleKt.profilerMessage("settings.tooltips.showFilteredCalls", new Object[0]))));
            Iterable $this$forEachIndexed$iv = foldedNodes;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void it;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                BaseCallStackElement baseCallStackElement = (BaseCallStackElement)item$iv;
                int i = n;
                boolean bl = false;
                String node2 = XmlStringUtil.escapeString((String)this.parentComponent.getCallStackElementRenderer().getText((BaseCallStackElement)it));
                builder.append((HtmlChunk)HtmlChunk.div((String)("padding-left: " + i * 4 + "px; white-space: nowrap")).child(HtmlChunk.text((String)node2)));
            }
            this.setToolTipText(builder.wrapWithHtmlBody().toString());
        } else {
            this.unfold.exited(null);
        }
    }

    private final void updateFoldLink(Companion.TreeNodeUIData uiData, int row) {
        if (((CommonProfilerUiOptions)CallUsageNodeKt.getSettings().getState()).getCallTreeState().getFilterCalls() && uiData.getCanBeFolded()) {
            this.fold.setVisible(true);
            if (this.getHighlightedRow() == row && this.getHighlightedComponent() == this.fold) {
                this.fold.entered(null);
                this.setToolTipText(CommonProfilerBundleKt.profilerMessage("settings.tooltips.hideFilteredCalls", new Object[0]));
            } else {
                this.fold.exited(null);
            }
        }
    }

    private final void updateRecursionIcon(Companion.TreeNodeUIData uiData, int row) {
        if (uiData.getRecursionCount() > 0) {
            this.recursionIcon.setVisible(true);
            this.recursionIcon.setBorder(this.unfold.isVisible() || this.fold.isVisible() ? (Border)this.STACKED_INSETS : (Border)this.INSETS);
            if (this.getHighlightedRow() == row && this.getHighlightedComponent() == this.recursionIcon) {
                this.setToolTipText(MergedCalleesPanelKt.collapseRecursionCallsActionText(uiData.getRecursionCount()));
            }
        }
    }

    @Override
    protected void mouseClicked(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getButton() != 1) {
            return;
        }
        TreePath path = this.tree.getPathForRow(this.getHighlightedRow());
        if (this.getHighlightedComponent() == this.unfold) {
            JTree jTree = this.tree;
            Intrinsics.checkNotNullExpressionValue((Object)jTree, (String)"tree");
            Intrinsics.checkNotNull((Object)path);
            UsageModelActions.INSTANCE.unfold(jTree, path);
        } else if (this.getHighlightedComponent() == this.fold) {
            JTree jTree = this.tree;
            Intrinsics.checkNotNullExpressionValue((Object)jTree, (String)"tree");
            Intrinsics.checkNotNull((Object)path);
            UsageModelActions.INSTANCE.fold(jTree, path);
        } else if (this.getHighlightedComponent() == this.recursionIcon) {
            ProfilerUsageTriggerCollector.logSnapshotInteraction$default(ProfilerUsageTriggerCollector.INSTANCE, this.parentComponent.getProject(), ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.CT_RECURSION_COLLAPSE, CommonProfilerTabNameWithId.CALL_TREE, null, 8, null);
            TreeModel treeModel = this.tree.getModel();
            MainCallTreeUIModel mainCallTreeUIModel = treeModel instanceof MainCallTreeUIModel ? (MainCallTreeUIModel)((Object)treeModel) : null;
            if (mainCallTreeUIModel == null) {
                return;
            }
            MainCallTreeUIModel uiModel = mainCallTreeUIModel;
            Object object = path.getLastPathComponent();
            if (object == null) {
                return;
            }
            Object it = object;
            boolean bl = false;
            CallTreeNode node2 = (CallTreeNode)it;
            TransformCallTreeActionsKt.addFocusOnSubTreeTab(this.parentComponent, uiModel.getUIVisibleNodeView(node2).getMaybeWrappedVisibleTreeNode(), true);
        }
    }

    @Override
    @NotNull
    protected JComponent[] getHighlightables() {
        return this.links;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0010\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\t0\bj\u0002`\n\u00a8\u0006\f"}, d2={"Lcom/intellij/profiler/ui/callusage/CallUsageTreeCellRenderer$Companion;", "", "()V", "createUIData", "Lcom/intellij/profiler/ui/callusage/CallUsageTreeCellRenderer$Companion$TreeNodeUIData;", "treeModel", "Lcom/intellij/profiler/ui/callusage/MainCallTreeUIModel;", "delegatedTreeNode", "Lcom/intellij/profiler/model/CallTreeNode;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Lcom/intellij/profiler/ui/callusage/CallUsageNode;", "TreeNodeUIData", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nCallUsageTreeCellRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallUsageTreeCellRenderer.kt\ncom/intellij/profiler/ui/callusage/CallUsageTreeCellRenderer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,355:1\n1603#2,9:356\n1855#2:365\n1856#2:367\n1612#2:368\n1#3:366\n*S KotlinDebug\n*F\n+ 1 CallUsageTreeCellRenderer.kt\ncom/intellij/profiler/ui/callusage/CallUsageTreeCellRenderer$Companion\n*L\n227#1:356,9\n227#1:365\n227#1:367\n227#1:368\n227#1:366\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final TreeNodeUIData createUIData(@NotNull MainCallTreeUIModel treeModel, @NotNull CallTreeNode<? extends BaseCallStackElement> delegatedTreeNode) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)((Object)treeModel), (String)"treeModel");
            Intrinsics.checkNotNullParameter(delegatedTreeNode, (String)"delegatedTreeNode");
            List<CallTreeNode<BaseCallStackElement>> maybeFoldedVisibleNodes = treeModel.getListOfNodesFoldedToRightNode(delegatedTreeNode);
            int recursionCount = maybeFoldedVisibleNodes.size() > 1 ? 0 : treeModel.recursionCount(delegatedTreeNode);
            boolean canBeFolded = treeModel.canBeFolded(delegatedTreeNode);
            UIVisibleCallTreeNode<BaseCallStackElement> uiNodeView = treeModel.getUIVisibleNodeView((CallTreeNode)CollectionsKt.first(maybeFoldedVisibleNodes));
            if (uiNodeView.getCall() == null) {
                return null;
            }
            TreeNodeUIValue uiValue2 = (TreeNodeUIValue)DiffUtilsKt.produceDiffDependentValue$default(delegatedTreeNode, (Function1)new Function1<CallTreeNode<? extends BaseCallStackElement>, TreeNodeUIValue>(uiNodeView, treeModel){
                final /* synthetic */ UIVisibleCallTreeNode<BaseCallStackElement> $uiNodeView;
                final /* synthetic */ MainCallTreeUIModel $treeModel;
                {
                    this.$uiNodeView = $uiNodeView;
                    this.$treeModel = $treeModel;
                    super(1);
                }

                @NotNull
                public final TreeNodeUIValue invoke(@NotNull CallTreeNode<? extends BaseCallStackElement> $this$produceDiffDependentValue) {
                    Intrinsics.checkNotNullParameter($this$produceDiffDependentValue, (String)"$this$produceDiffDependentValue");
                    return new TreeNodeUIValue.Regular(this.$uiNodeView.getValue(), this.$uiNodeView.getFractionOfParentCallDouble(), this.$uiNodeView.getFractionOfAllCallsDouble(), this.$treeModel.treeNodeToggledViewFraction(this.$uiNodeView));
                }
            }, createUIData.uiValue.2.INSTANCE, null, 4, null);
            Iterable $this$mapNotNull$iv = maybeFoldedVisibleNodes;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                BaseCallStackElement it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                CallTreeNode it = (CallTreeNode)element$iv$iv;
                boolean bl2 = false;
                CallWithValue callWithValue = (CallWithValue)it.getData();
                if ((callWithValue != null ? (BaseCallStackElement)callWithValue.getCall() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List nodes2 = (List)destination$iv$iv;
            return new TreeNodeUIData(uiValue2, nodes2, canBeFolded, recursionCount);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\nH\u00c6\u0003J7\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/intellij/profiler/ui/callusage/CallUsageTreeCellRenderer$Companion$TreeNodeUIData;", "", "uiValue", "Lcom/intellij/profiler/ui/callusage/CallUsageTreeCellRenderer$TreeNodeUIValue;", "visibleNodes", "", "Lcom/intellij/profiler/api/BaseCallStackElement;", "canBeFolded", "", "recursionCount", "", "(Lcom/intellij/profiler/ui/callusage/CallUsageTreeCellRenderer$TreeNodeUIValue;Ljava/util/List;ZI)V", "getCanBeFolded", "()Z", "getRecursionCount", "()I", "getUiValue", "()Lcom/intellij/profiler/ui/callusage/CallUsageTreeCellRenderer$TreeNodeUIValue;", "getVisibleNodes", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "", "intellij.profiler.common"})
        public static final class TreeNodeUIData {
            @NotNull
            private final TreeNodeUIValue uiValue;
            @NotNull
            private final List<BaseCallStackElement> visibleNodes;
            private final boolean canBeFolded;
            private final int recursionCount;

            public TreeNodeUIData(@NotNull TreeNodeUIValue uiValue2, @NotNull List<? extends BaseCallStackElement> visibleNodes, boolean canBeFolded, int recursionCount) {
                Intrinsics.checkNotNullParameter((Object)uiValue2, (String)"uiValue");
                Intrinsics.checkNotNullParameter(visibleNodes, (String)"visibleNodes");
                this.uiValue = uiValue2;
                this.visibleNodes = visibleNodes;
                this.canBeFolded = canBeFolded;
                this.recursionCount = recursionCount;
            }

            @NotNull
            public final TreeNodeUIValue getUiValue() {
                return this.uiValue;
            }

            @NotNull
            public final List<BaseCallStackElement> getVisibleNodes() {
                return this.visibleNodes;
            }

            public final boolean getCanBeFolded() {
                return this.canBeFolded;
            }

            public final int getRecursionCount() {
                return this.recursionCount;
            }

            @NotNull
            public final TreeNodeUIValue component1() {
                return this.uiValue;
            }

            @NotNull
            public final List<BaseCallStackElement> component2() {
                return this.visibleNodes;
            }

            public final boolean component3() {
                return this.canBeFolded;
            }

            public final int component4() {
                return this.recursionCount;
            }

            @NotNull
            public final TreeNodeUIData copy(@NotNull TreeNodeUIValue uiValue2, @NotNull List<? extends BaseCallStackElement> visibleNodes, boolean canBeFolded, int recursionCount) {
                Intrinsics.checkNotNullParameter((Object)uiValue2, (String)"uiValue");
                Intrinsics.checkNotNullParameter(visibleNodes, (String)"visibleNodes");
                return new TreeNodeUIData(uiValue2, visibleNodes, canBeFolded, recursionCount);
            }

            public static /* synthetic */ TreeNodeUIData copy$default(TreeNodeUIData treeNodeUIData, TreeNodeUIValue treeNodeUIValue, List list, boolean bl, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    treeNodeUIValue = treeNodeUIData.uiValue;
                }
                if ((n2 & 2) != 0) {
                    list = treeNodeUIData.visibleNodes;
                }
                if ((n2 & 4) != 0) {
                    bl = treeNodeUIData.canBeFolded;
                }
                if ((n2 & 8) != 0) {
                    n = treeNodeUIData.recursionCount;
                }
                return treeNodeUIData.copy(treeNodeUIValue, list, bl, n);
            }

            @NotNull
            public String toString() {
                return "TreeNodeUIData(uiValue=" + this.uiValue + ", visibleNodes=" + this.visibleNodes + ", canBeFolded=" + this.canBeFolded + ", recursionCount=" + this.recursionCount + ")";
            }

            public int hashCode() {
                int result2 = this.uiValue.hashCode();
                result2 = result2 * 31 + ((Object)this.visibleNodes).hashCode();
                result2 = result2 * 31 + Boolean.hashCode(this.canBeFolded);
                result2 = result2 * 31 + Integer.hashCode(this.recursionCount);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TreeNodeUIData)) {
                    return false;
                }
                TreeNodeUIData treeNodeUIData = (TreeNodeUIData)other;
                if (!Intrinsics.areEqual((Object)this.uiValue, (Object)treeNodeUIData.uiValue)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.visibleNodes, treeNodeUIData.visibleNodes)) {
                    return false;
                }
                if (this.canBeFolded != treeNodeUIData.canBeFolded) {
                    return false;
                }
                return this.recursionCount == treeNodeUIData.recursionCount;
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/profiler/ui/callusage/CallUsageTreeCellRenderer$TreeNodeUIValue;", "", "Diff", "Regular", "Lcom/intellij/profiler/ui/callusage/CallUsageTreeCellRenderer$TreeNodeUIValue$Diff;", "Lcom/intellij/profiler/ui/callusage/CallUsageTreeCellRenderer$TreeNodeUIValue$Regular;", "intellij.profiler.common"})
    public static interface TreeNodeUIValue {

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/ui/callusage/CallUsageTreeCellRenderer$TreeNodeUIValue$Diff;", "Lcom/intellij/profiler/ui/callusage/CallUsageTreeCellRenderer$TreeNodeUIValue;", "oldValue", "", "newValue", "(JJ)V", "getNewValue", "()J", "getOldValue", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.profiler.common"})
        public static final class Diff
        implements TreeNodeUIValue {
            private final long oldValue;
            private final long newValue;

            public Diff(long oldValue, long newValue) {
                this.oldValue = oldValue;
                this.newValue = newValue;
            }

            public final long getOldValue() {
                return this.oldValue;
            }

            public final long getNewValue() {
                return this.newValue;
            }

            public final long component1() {
                return this.oldValue;
            }

            public final long component2() {
                return this.newValue;
            }

            @NotNull
            public final Diff copy(long oldValue, long newValue) {
                return new Diff(oldValue, newValue);
            }

            public static /* synthetic */ Diff copy$default(Diff diff, long l, long l2, int n, Object object) {
                if ((n & 1) != 0) {
                    l = diff.oldValue;
                }
                if ((n & 2) != 0) {
                    l2 = diff.newValue;
                }
                return diff.copy(l, l2);
            }

            @NotNull
            public String toString() {
                return "Diff(oldValue=" + this.oldValue + ", newValue=" + this.newValue + ")";
            }

            public int hashCode() {
                int result2 = Long.hashCode(this.oldValue);
                result2 = result2 * 31 + Long.hashCode(this.newValue);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Diff)) {
                    return false;
                }
                Diff diff = (Diff)other;
                if (this.oldValue != diff.oldValue) {
                    return false;
                }
                return this.newValue == diff.newValue;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0016\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcom/intellij/profiler/ui/callusage/CallUsageTreeCellRenderer$TreeNodeUIValue$Regular;", "Lcom/intellij/profiler/ui/callusage/CallUsageTreeCellRenderer$TreeNodeUIValue;", "value", "", "fractionOfParentCall", "", "fractionOfAllCalls", "toggledViewFraction", "Lcom/intellij/profiler/ui/callusage/MainCallTreeUIModel$TreeNodeToggledViewFraction;", "(JDDLcom/intellij/profiler/ui/callusage/MainCallTreeUIModel$TreeNodeToggledViewFraction;)V", "getFractionOfAllCalls", "()D", "getFractionOfParentCall", "getToggledViewFraction", "()Lcom/intellij/profiler/ui/callusage/MainCallTreeUIModel$TreeNodeToggledViewFraction;", "getValue", "()J", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.profiler.common"})
        public static final class Regular
        implements TreeNodeUIValue {
            private final long value;
            @TestOnly
            private final double fractionOfParentCall;
            @TestOnly
            private final double fractionOfAllCalls;
            @NotNull
            private final MainCallTreeUIModel.TreeNodeToggledViewFraction toggledViewFraction;

            public Regular(long value, double fractionOfParentCall, double fractionOfAllCalls, @NotNull MainCallTreeUIModel.TreeNodeToggledViewFraction toggledViewFraction) {
                Intrinsics.checkNotNullParameter((Object)toggledViewFraction, (String)"toggledViewFraction");
                this.value = value;
                this.fractionOfParentCall = fractionOfParentCall;
                this.fractionOfAllCalls = fractionOfAllCalls;
                this.toggledViewFraction = toggledViewFraction;
            }

            public final long getValue() {
                return this.value;
            }

            public final double getFractionOfParentCall() {
                return this.fractionOfParentCall;
            }

            public final double getFractionOfAllCalls() {
                return this.fractionOfAllCalls;
            }

            @NotNull
            public final MainCallTreeUIModel.TreeNodeToggledViewFraction getToggledViewFraction() {
                return this.toggledViewFraction;
            }

            public final long component1() {
                return this.value;
            }

            public final double component2() {
                return this.fractionOfParentCall;
            }

            public final double component3() {
                return this.fractionOfAllCalls;
            }

            @NotNull
            public final MainCallTreeUIModel.TreeNodeToggledViewFraction component4() {
                return this.toggledViewFraction;
            }

            @NotNull
            public final Regular copy(long value, double fractionOfParentCall, double fractionOfAllCalls, @NotNull MainCallTreeUIModel.TreeNodeToggledViewFraction toggledViewFraction) {
                Intrinsics.checkNotNullParameter((Object)toggledViewFraction, (String)"toggledViewFraction");
                return new Regular(value, fractionOfParentCall, fractionOfAllCalls, toggledViewFraction);
            }

            public static /* synthetic */ Regular copy$default(Regular regular, long l, double d, double d2, MainCallTreeUIModel.TreeNodeToggledViewFraction treeNodeToggledViewFraction, int n, Object object) {
                if ((n & 1) != 0) {
                    l = regular.value;
                }
                if ((n & 2) != 0) {
                    d = regular.fractionOfParentCall;
                }
                if ((n & 4) != 0) {
                    d2 = regular.fractionOfAllCalls;
                }
                if ((n & 8) != 0) {
                    treeNodeToggledViewFraction = regular.toggledViewFraction;
                }
                return regular.copy(l, d, d2, treeNodeToggledViewFraction);
            }

            @NotNull
            public String toString() {
                return "Regular(value=" + this.value + ", fractionOfParentCall=" + this.fractionOfParentCall + ", fractionOfAllCalls=" + this.fractionOfAllCalls + ", toggledViewFraction=" + this.toggledViewFraction + ")";
            }

            public int hashCode() {
                int result2 = Long.hashCode(this.value);
                result2 = result2 * 31 + Double.hashCode(this.fractionOfParentCall);
                result2 = result2 * 31 + Double.hashCode(this.fractionOfAllCalls);
                result2 = result2 * 31 + this.toggledViewFraction.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Regular)) {
                    return false;
                }
                Regular regular = (Regular)other;
                if (this.value != regular.value) {
                    return false;
                }
                if (Double.compare(this.fractionOfParentCall, regular.fractionOfParentCall) != 0) {
                    return false;
                }
                if (Double.compare(this.fractionOfAllCalls, regular.fractionOfAllCalls) != 0) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.toggledViewFraction, (Object)regular.toggledViewFraction);
            }
        }
    }
}

