/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.tools.Tools;

public class ContractionSpellingRule
extends AbstractSimpleReplaceRule {
    public static final String CONTRACTION_SPELLING_RULE = "EN_CONTRACTION_SPELLING";
    private static final Map<String, List<String>> wrongWords = ContractionSpellingRule.loadFromPath("/en/contractions.txt");
    private static final Locale EN_LOCALE = new Locale("en");

    @Override
    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public ContractionSpellingRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong("We <marker>havent</marker> earned anything."), Example.fixed("We <marker>haven't</marker> earned anything."));
        this.setUrl(Tools.getUrl("https://languagetool.org/insights/post/grammar-contractions/"));
        super.setCheckLemmas(false);
    }

    @Override
    public final String getId() {
        return CONTRACTION_SPELLING_RULE;
    }

    @Override
    public String getDescription() {
        return "Spelling of English contractions";
    }

    @Override
    public String getShort() {
        return "Spelling mistake";
    }

    @Override
    public String getMessage(String tokenStr, List<String> replacements) {
        return "Possible spelling mistake found.";
    }

    @Override
    public boolean isCaseSensitive() {
        return true;
    }

    @Override
    public Locale getLocale() {
        return EN_LOCALE;
    }
}

