/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrStringConcatenationImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\f\u0010\u0015\u001a\u00020\u0013*\u00020\u0016H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/FlattenStringConcatenationLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "constToString", "", "const", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "normalizeUnsignedValue", "", "visitExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "tryToFold", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "Companion", "ir.backend.common"})
public final class FlattenStringConcatenationLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private static final Set<FqName> PARENT_NAMES;

    public FlattenStringConcatenationLowering(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrExpression visitExpression(@NotNull IrExpression expression) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (FlattenStringConcatenationLowering.Companion.isStringConcatenationExpression(expression) || expression instanceof IrCall && FlattenStringConcatenationLowering.Companion.isSpecialToStringCall((IrCall)expression)) {
            IrExpression $this$visitExpression_u24lambda_u240 = expression;
            boolean bl = false;
            irExpression = this.tryToFold(new IrStringConcatenationImpl($this$visitExpression_u24lambda_u240.getStartOffset(), $this$visitExpression_u24lambda_u240.getEndOffset(), $this$visitExpression_u24lambda_u240.getType(), FlattenStringConcatenationLowering.Companion.collectStringConcatenationArguments($this$visitExpression_u24lambda_u240)));
        } else {
            irExpression = expression;
        }
        IrExpression transformedExpression = irExpression;
        IrElementTransformerVoidKt.transformChildrenVoid(transformedExpression, this);
        return transformedExpression;
    }

    private final IrExpression tryToFold(IrStringConcatenation $this$tryToFold) {
        List folded = new ArrayList();
        for (IrExpression next : $this$tryToFold.getArguments()) {
            IrExpression last = (IrExpression)CollectionsKt.lastOrNull((List)folded);
            if (!(next instanceof IrConst)) {
                ((Collection)folded).add(next);
                continue;
            }
            if (!(last instanceof IrConst)) {
                ((Collection)folded).add(IrConstImpl.Companion.string(next.getStartOffset(), next.getEndOffset(), this.context.getIrBuiltIns().getStringType(), this.constToString((IrConst)next)));
                continue;
            }
            folded.set(folded.size() - 1, IrConstImpl.Companion.string(Math.min(last.getStartOffset(), next.getStartOffset()), Math.max(last.getEndOffset(), next.getEndOffset()), this.context.getIrBuiltIns().getStringType(), this.constToString((IrConst)last) + this.constToString((IrConst)next)));
        }
        Object object = CollectionsKt.singleOrNull((List)folded);
        IrConst irConst = object instanceof IrConst ? (IrConst)object : null;
        return irConst != null ? (IrExpression)irConst : (IrExpression)new IrStringConcatenationImpl($this$tryToFold.getStartOffset(), $this$tryToFold.getEndOffset(), $this$tryToFold.getType(), folded);
    }

    private final String constToString(IrConst<?> irConst) {
        return String.valueOf(this.normalizeUnsignedValue(irConst));
    }

    private final Object normalizeUnsignedValue(IrConst<?> irConst) {
        if (IrTypeUtilsKt.isUnsigned(irConst.getType())) {
            IrConstKind<?> kind = irConst.getKind();
            if (kind instanceof IrConstKind.Byte) {
                return UByte.box-impl((byte)UByte.constructor-impl((byte)((Number)((IrConstKind.Byte)kind).valueOf(irConst)).byteValue()));
            }
            if (kind instanceof IrConstKind.Short) {
                return UShort.box-impl((short)UShort.constructor-impl((short)((Number)((IrConstKind.Short)kind).valueOf(irConst)).shortValue()));
            }
            if (kind instanceof IrConstKind.Int) {
                return UInt.box-impl((int)UInt.constructor-impl((int)((Number)((IrConstKind.Int)kind).valueOf(irConst)).intValue()));
            }
            if (kind instanceof IrConstKind.Long) {
                return ULong.box-impl((long)ULong.constructor-impl((long)((Number)((IrConstKind.Long)kind).valueOf(irConst)).longValue()));
            }
        }
        return irConst.getValue();
    }

    static {
        Object[] objectArray = new FqName[2];
        objectArray[0] = StandardNames.BUILT_INS_PACKAGE_FQ_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)StandardNames.FqNames.string.toSafe(), (String)"toSafe(...)");
        PARENT_NAMES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0012H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\tR\u0018\u0010\n\u001a\u00020\u0007*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0018\u0010\r\u001a\u00020\u0007*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\fR\u0015\u0010\u000e\u001a\u00020\u0007*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\tR\u0018\u0010\u000f\u001a\u00020\u0007*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/FlattenStringConcatenationLowering$Companion;", "", "()V", "PARENT_NAMES", "", "Lorg/jetbrains/kotlin/name/FqName;", "isNullableToString", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Z", "isSpecialToStringCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Z", "isStringPlusCall", "isToString", "isToStringCall", "collectStringConcatenationArguments", "", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "isStringConcatenationExpression", "ir.backend.common"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isStringPlusCall(IrCall $this$isStringPlusCall) {
            IrValueParameter receiverParameter;
            IrSimpleFunction function2 = (IrSimpleFunction)$this$isStringPlusCall.getSymbol().getOwner();
            IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
            if (irValueParameter == null) {
                irValueParameter = function2.getExtensionReceiverParameter();
            }
            if ((receiverParameter = irValueParameter) == null) return false;
            if (!IrTypePredicatesKt.isStringClassType(receiverParameter.getType())) return false;
            if (!IrTypePredicatesKt.isStringClassType(function2.getReturnType())) return false;
            if (function2.getValueParameters().size() != 1) return false;
            if (!Intrinsics.areEqual((Object)function2.getName(), (Object)OperatorNameConventions.PLUS)) return false;
            FqName fqName = IrUtilsKt.getFqNameWhenAvailable(function2);
            if (!CollectionsKt.contains((Iterable)PARENT_NAMES, (Object)(fqName != null ? fqName.parent() : null))) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isToString(@NotNull IrSimpleFunction $this$isToString) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)$this$isToString, (String)"<this>");
            if (!Intrinsics.areEqual((Object)$this$isToString.getName(), (Object)OperatorNameConventions.TO_STRING)) return false;
            if (!((Collection)$this$isToString.getValueParameters()).isEmpty()) {
                return false;
            }
            boolean bl2 = false;
            if (bl2) return false;
            if (!IrTypePredicatesKt.isString($this$isToString.getReturnType())) {
                return false;
            }
            if ($this$isToString.getDispatchReceiverParameter() == null) return false;
            if ($this$isToString.getExtensionReceiverParameter() != null) return false;
            IrAnnotationContainer irAnnotationContainer = $this$isToString.getDispatchReceiverParameter();
            if (irAnnotationContainer != null && (irAnnotationContainer = irAnnotationContainer.getType()) != null) {
                if (IrTypePredicatesKt.isAny((IrType)irAnnotationContainer)) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            if (((Collection)$this$isToString.getOverriddenSymbols()).isEmpty()) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isNullableToString(IrSimpleFunction $this$isNullableToString) {
            if (!Intrinsics.areEqual((Object)$this$isNullableToString.getName(), (Object)OperatorNameConventions.TO_STRING)) return false;
            if (!((Collection)$this$isNullableToString.getValueParameters()).isEmpty()) {
                return false;
            }
            boolean bl = false;
            if (bl) return false;
            if (!IrTypePredicatesKt.isString($this$isNullableToString.getReturnType())) {
                return false;
            }
            if ($this$isNullableToString.getDispatchReceiverParameter() != null) return false;
            IrValueParameter irValueParameter = $this$isNullableToString.getExtensionReceiverParameter();
            IrAnnotationContainer irAnnotationContainer = irValueParameter;
            if (irValueParameter == null) return false;
            IrType irType = irAnnotationContainer.getType();
            irAnnotationContainer = irType;
            if (irType == null) return false;
            if (!IrTypePredicatesKt.isNullableAny((IrType)irAnnotationContainer)) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            FqName fqName = IrUtilsKt.getFqNameWhenAvailable($this$isNullableToString);
            if (!Intrinsics.areEqual((Object)(fqName != null ? fqName.parent() : null), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME)) return false;
            return true;
        }

        private final boolean isToStringCall(IrCall $this$isToStringCall) {
            if ($this$isToStringCall.getSuperQualifierSymbol() != null) {
                return false;
            }
            IrSimpleFunction function2 = (IrSimpleFunction)$this$isToStringCall.getSymbol().getOwner();
            return this.isToString(function2) || this.isNullableToString(function2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isSpecialToStringCall(IrCall $this$isSpecialToStringCall) {
            if (!this.isToStringCall($this$isSpecialToStringCall)) return false;
            IrExpression irExpression = $this$isSpecialToStringCall.getDispatchReceiver();
            Object object = irExpression;
            if (irExpression == null) return true;
            IrType irType = ((IrExpression)object).getType();
            object = irType;
            if (irType == null) return true;
            if (IrTypePredicatesKt.isPrimitiveType$default((IrType)object, false, 1, null)) return true;
            return false;
        }

        private final boolean isStringConcatenationExpression(IrExpression expression) {
            return expression instanceof IrStringConcatenation || expression instanceof IrCall && this.isStringPlusCall((IrCall)expression);
        }

        private final List<IrExpression> collectStringConcatenationArguments(IrExpression expression) {
            List arguments2 = new ArrayList();
            IrVisitorsKt.acceptChildrenVoid(expression, new IrElementVisitorVoid(arguments2){
                final /* synthetic */ List<IrExpression> $arguments;
                {
                    this.$arguments = $arguments;
                }

                public void visitElement(IrElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    IrVisitorsKt.acceptChildrenVoid(element, this);
                }

                public void visitCall(IrCall expression) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    if (org.jetbrains.kotlin.backend.common.lower.FlattenStringConcatenationLowering$Companion.access$isStringConcatenationExpression(FlattenStringConcatenationLowering.Companion, expression) || org.jetbrains.kotlin.backend.common.lower.FlattenStringConcatenationLowering$Companion.access$isToStringCall(FlattenStringConcatenationLowering.Companion, expression)) {
                        IrVisitorsKt.acceptChildrenVoid(expression, this);
                    } else {
                        this.$arguments.add(expression);
                    }
                }

                public void visitStringConcatenation(IrStringConcatenation expression) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    IrVisitorsKt.acceptChildrenVoid(expression, this);
                }

                public void visitExpression(IrExpression expression) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    this.$arguments.add(expression);
                }

                public void visitElement(IrElement element, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
                }

                public void visitCall(IrCall expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitCall(this, expression, data);
                }

                public void visitStringConcatenation(IrStringConcatenation expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression, data);
                }

                public void visitExpression(IrExpression expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression, data);
                }

                public void visitAnonymousInitializer(IrAnonymousInitializer declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
                }

                public void visitAnonymousInitializer(IrAnonymousInitializer declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
                }

                public void visitBlock(IrBlock expression) {
                    IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression);
                }

                public void visitBlock(IrBlock expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression, data);
                }

                public void visitBlockBody(IrBlockBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
                }

                public void visitBlockBody(IrBlockBody body2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
                }

                public void visitBody(IrBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
                }

                public void visitBody(IrBody body2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
                }

                public void visitBranch(IrBranch branch) {
                    IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
                }

                public void visitBranch(IrBranch branch, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
                }

                public void visitBreak(IrBreak jump) {
                    IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
                }

                public void visitBreak(IrBreak jump, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
                }

                public void visitBreakContinue(IrBreakContinue jump) {
                    IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
                }

                public void visitBreakContinue(IrBreakContinue jump, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
                }

                public void visitCallableReference(IrCallableReference<?> expression) {
                    IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression);
                }

                public void visitCallableReference(IrCallableReference<?> expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression, data);
                }

                public void visitCatch(IrCatch aCatch) {
                    IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
                }

                public void visitCatch(IrCatch aCatch, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
                }

                public void visitClass(IrClass declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration);
                }

                public void visitClass(IrClass declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data);
                }

                public void visitClassReference(IrClassReference expression) {
                    IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression);
                }

                public void visitClassReference(IrClassReference expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression, data);
                }

                public void visitComposite(IrComposite expression) {
                    IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression);
                }

                public void visitComposite(IrComposite expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression, data);
                }

                public void visitConst(IrConst<?> expression) {
                    IrElementVisitorVoid.DefaultImpls.visitConst(this, expression);
                }

                public void visitConst(IrConst<?> expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConst(this, expression, data);
                }

                public void visitConstantArray(IrConstantArray expression) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression);
                }

                public void visitConstantArray(IrConstantArray expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression, data);
                }

                public void visitConstantObject(IrConstantObject expression) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression);
                }

                public void visitConstantObject(IrConstantObject expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression, data);
                }

                public void visitConstantPrimitive(IrConstantPrimitive expression) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression);
                }

                public void visitConstantPrimitive(IrConstantPrimitive expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression, data);
                }

                public void visitConstantValue(IrConstantValue expression) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression);
                }

                public void visitConstantValue(IrConstantValue expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression, data);
                }

                public void visitConstructor(IrConstructor declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
                }

                public void visitConstructor(IrConstructor declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data);
                }

                public void visitConstructorCall(IrConstructorCall expression) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression);
                }

                public void visitConstructorCall(IrConstructorCall expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression, data);
                }

                public void visitContainerExpression(IrContainerExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression);
                }

                public void visitContainerExpression(IrContainerExpression expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression, data);
                }

                public void visitContinue(IrContinue jump) {
                    IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
                }

                public void visitContinue(IrContinue jump, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
                }

                public void visitDeclaration(IrDeclarationBase declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
                }

                public void visitDeclaration(IrDeclarationBase declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data);
                }

                public void visitDeclarationReference(IrDeclarationReference expression) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression);
                }

                public void visitDeclarationReference(IrDeclarationReference expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression, data);
                }

                public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression) {
                    IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression);
                }

                public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression, data);
                }

                public void visitDoWhileLoop(IrDoWhileLoop loop2) {
                    IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
                }

                public void visitDoWhileLoop(IrDoWhileLoop loop2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
                }

                public void visitDynamicExpression(IrDynamicExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression);
                }

                public void visitDynamicExpression(IrDynamicExpression expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression, data);
                }

                public void visitDynamicMemberExpression(IrDynamicMemberExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression);
                }

                public void visitDynamicMemberExpression(IrDynamicMemberExpression expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression, data);
                }

                public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression);
                }

                public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression, data);
                }

                public void visitElseBranch(IrElseBranch branch) {
                    IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
                }

                public void visitElseBranch(IrElseBranch branch, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
                }

                public void visitEnumConstructorCall(IrEnumConstructorCall expression) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression);
                }

                public void visitEnumConstructorCall(IrEnumConstructorCall expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression, data);
                }

                public void visitEnumEntry(IrEnumEntry declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
                }

                public void visitEnumEntry(IrEnumEntry declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data);
                }

                public void visitErrorCallExpression(IrErrorCallExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression);
                }

                public void visitErrorCallExpression(IrErrorCallExpression expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression, data);
                }

                public void visitErrorDeclaration(IrErrorDeclaration declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
                }

                public void visitErrorDeclaration(IrErrorDeclaration declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data);
                }

                public void visitErrorExpression(IrErrorExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression);
                }

                public void visitErrorExpression(IrErrorExpression expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression, data);
                }

                public void visitExpressionBody(IrExpressionBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
                }

                public void visitExpressionBody(IrExpressionBody body2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
                }

                public void visitExternalPackageFragment(IrExternalPackageFragment declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
                }

                public void visitExternalPackageFragment(IrExternalPackageFragment declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
                }

                public void visitField(IrField declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
                }

                public void visitField(IrField declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data);
                }

                public void visitFieldAccess(IrFieldAccessExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression);
                }

                public void visitFieldAccess(IrFieldAccessExpression expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression, data);
                }

                public void visitFile(IrFile declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
                }

                public void visitFile(IrFile declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data);
                }

                public void visitFunction(IrFunction declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
                }

                public void visitFunction(IrFunction declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data);
                }

                public void visitFunctionAccess(IrFunctionAccessExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression);
                }

                public void visitFunctionAccess(IrFunctionAccessExpression expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression, data);
                }

                public void visitFunctionExpression(IrFunctionExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression);
                }

                public void visitFunctionExpression(IrFunctionExpression expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression, data);
                }

                public void visitFunctionReference(IrFunctionReference expression) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression);
                }

                public void visitFunctionReference(IrFunctionReference expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression, data);
                }

                public void visitGetClass(IrGetClass expression) {
                    IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression);
                }

                public void visitGetClass(IrGetClass expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression, data);
                }

                public void visitGetEnumValue(IrGetEnumValue expression) {
                    IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression);
                }

                public void visitGetEnumValue(IrGetEnumValue expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression, data);
                }

                public void visitGetField(IrGetField expression) {
                    IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression);
                }

                public void visitGetField(IrGetField expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression, data);
                }

                public void visitGetObjectValue(IrGetObjectValue expression) {
                    IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression);
                }

                public void visitGetObjectValue(IrGetObjectValue expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression, data);
                }

                public void visitGetValue(IrGetValue expression) {
                    IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression);
                }

                public void visitGetValue(IrGetValue expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression, data);
                }

                public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock) {
                    IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock);
                }

                public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data);
                }

                public void visitInstanceInitializerCall(IrInstanceInitializerCall expression) {
                    IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression);
                }

                public void visitInstanceInitializerCall(IrInstanceInitializerCall expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression, data);
                }

                public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
                }

                public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
                }

                public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression);
                }

                public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression, data);
                }

                public void visitLoop(IrLoop loop2) {
                    IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
                }

                public void visitLoop(IrLoop loop2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
                }

                public void visitMemberAccess(IrMemberAccessExpression<?> expression) {
                    IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression);
                }

                public void visitMemberAccess(IrMemberAccessExpression<?> expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression, data);
                }

                public void visitModuleFragment(IrModuleFragment declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
                }

                public void visitModuleFragment(IrModuleFragment declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data);
                }

                public void visitPackageFragment(IrPackageFragment declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
                }

                public void visitPackageFragment(IrPackageFragment declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data);
                }

                public void visitProperty(IrProperty declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
                }

                public void visitProperty(IrProperty declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data);
                }

                public void visitPropertyReference(IrPropertyReference expression) {
                    IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression);
                }

                public void visitPropertyReference(IrPropertyReference expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression, data);
                }

                public void visitRawFunctionReference(IrRawFunctionReference expression) {
                    IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression);
                }

                public void visitRawFunctionReference(IrRawFunctionReference expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression, data);
                }

                public void visitReturn(IrReturn expression) {
                    IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression);
                }

                public void visitReturn(IrReturn expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression, data);
                }

                public void visitReturnableBlock(IrReturnableBlock expression) {
                    IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression);
                }

                public void visitReturnableBlock(IrReturnableBlock expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression, data);
                }

                public void visitScript(IrScript declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration);
                }

                public void visitScript(IrScript declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration, data);
                }

                public void visitSetField(IrSetField expression) {
                    IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression);
                }

                public void visitSetField(IrSetField expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression, data);
                }

                public void visitSetValue(IrSetValue expression) {
                    IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression);
                }

                public void visitSetValue(IrSetValue expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression, data);
                }

                public void visitSimpleFunction(IrSimpleFunction declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
                }

                public void visitSimpleFunction(IrSimpleFunction declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data);
                }

                public void visitSingletonReference(IrGetSingletonValue expression) {
                    IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression);
                }

                public void visitSingletonReference(IrGetSingletonValue expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression, data);
                }

                public void visitSpreadElement(IrSpreadElement spread) {
                    IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
                }

                public void visitSpreadElement(IrSpreadElement spread, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
                }

                public void visitSuspendableExpression(IrSuspendableExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression);
                }

                public void visitSuspendableExpression(IrSuspendableExpression expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression, data);
                }

                public void visitSuspensionPoint(IrSuspensionPoint expression) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression);
                }

                public void visitSuspensionPoint(IrSuspensionPoint expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression, data);
                }

                public void visitSyntheticBody(IrSyntheticBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
                }

                public void visitSyntheticBody(IrSyntheticBody body2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
                }

                public void visitThrow(IrThrow expression) {
                    IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression);
                }

                public void visitThrow(IrThrow expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression, data);
                }

                public void visitTry(IrTry aTry) {
                    IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
                }

                public void visitTry(IrTry aTry, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
                }

                public void visitTypeAlias(IrTypeAlias declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
                }

                public void visitTypeAlias(IrTypeAlias declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data);
                }

                public void visitTypeOperator(IrTypeOperatorCall expression) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression);
                }

                public void visitTypeOperator(IrTypeOperatorCall expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression, data);
                }

                public void visitTypeParameter(IrTypeParameter declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
                }

                public void visitTypeParameter(IrTypeParameter declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data);
                }

                public void visitValueAccess(IrValueAccessExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression);
                }

                public void visitValueAccess(IrValueAccessExpression expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression, data);
                }

                public void visitValueParameter(IrValueParameter declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
                }

                public void visitValueParameter(IrValueParameter declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data);
                }

                public void visitVararg(IrVararg expression) {
                    IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression);
                }

                public void visitVararg(IrVararg expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression, data);
                }

                public void visitVariable(IrVariable declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
                }

                public void visitVariable(IrVariable declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data);
                }

                public void visitWhen(IrWhen expression) {
                    IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression);
                }

                public void visitWhen(IrWhen expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression, data);
                }

                public void visitWhileLoop(IrWhileLoop loop2) {
                    IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
                }

                public void visitWhileLoop(IrWhileLoop loop2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
                }
            });
            return arguments2;
        }

        public static final /* synthetic */ boolean access$isToStringCall(Companion $this, IrCall $receiver) {
            return $this.isToStringCall($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

