/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\tH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/PropertiesLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "()V", "withLocalDeclarations", "", "getWithLocalDeclarations", "()Z", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "ir.backend.common"})
public final class PropertiesLowering
implements DeclarationTransformer {
    @Override
    public boolean getWithLocalDeclarations() {
        return true;
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrDeclaration irDeclaration = declaration;
        if (irDeclaration instanceof IrSimpleFunction) {
            Object object = ((IrSimpleFunction)declaration).getCorrespondingPropertySymbol();
            if (object != null && (object = (IrProperty)object.getOwner()) != null) {
                Object property = object;
                boolean bl = false;
                if (!IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)property)) {
                    return CollectionsKt.listOf((Object)declaration);
                }
            }
        } else if (irDeclaration instanceof IrField) {
            Object object = ((IrField)declaration).getCorrespondingPropertySymbol();
            if (object != null && (object = (IrProperty)object.getOwner()) != null) {
                Object property = object;
                boolean bl = false;
                if (!IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)property)) {
                    return CollectionsKt.listOf((Object)declaration);
                }
            }
        } else if (irDeclaration instanceof IrProperty && !IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)declaration)) {
            return CollectionsKt.emptyList();
        }
        return null;
    }
}

