/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.phaser;

import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.IrValidator;
import org.jetbrains.kotlin.backend.common.IrValidatorConfig;
import org.jetbrains.kotlin.backend.common.IrValidatorKt;
import org.jetbrains.kotlin.backend.common.phaser.ActionState;
import org.jetbrains.kotlin.backend.common.phaser.BeforeOrAfter;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhaseKt;
import org.jetbrains.kotlin.backend.common.phaser.DumperVerifierKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a \u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004\u001at\u0010\u0014\u001a*\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u00020\u00050\u0001j\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u0016`\u0006\"\u0004\b\u0000\u0010\u0015\"\u0004\b\u0001\u0010\u00162\u0006\u0010\u0017\u001a\u00020\r20\u0010\u0018\u001a,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u0016\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0001j\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u0016`\u0019\u001al\u0010\u001a\u001a*\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u00020\u00050\u0001j\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u0016`\u0006\"\u0004\b\u0000\u0010\u0015\"\u0004\b\u0001\u0010\u001620\u0010\u0018\u001a,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u0016\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0001j\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u0016`\u0019\u001aj\u0010\u001b\u001a*\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u00020\u00050\u0001j\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u0016`\u0006\"\u0004\b\u0000\u0010\u0015\"\u0004\b\u0001\u0010\u00162.\u0010\u0018\u001a*\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u00020\u00050\u0001j\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u0016`\u0006\u001aT\u0010\u001c\u001a*\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u00020\u00050\u0001j\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u0016`\u0006\"\u0004\b\u0000\u0010\u0015\"\u0004\b\u0001\u0010\u00162\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u00020\u00050\u001e\u001a \u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u00032\b\b\u0002\u0010!\u001a\u00020\"\u001a\f\u0010#\u001a\u00020\"*\u00020\u0002H\u0002\u001a\f\u0010$\u001a\u00020\"*\u00020\u0002H\u0002\"=\u0010\u0000\u001a.\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00050\u0001j\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0004`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"9\u0010\t\u001a*\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\u0001j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0018\u0010\f\u001a\u00020\r*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f*J\u0010%\u001a\u0004\b\u0000\u0010\u0015\u001a\u0004\b\u0001\u0010\u0016\"\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u0016\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00012\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u0016\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0001\u00a8\u0006&"}, d2={"defaultDumper", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/backend/common/phaser/ActionState;", "Lorg/jetbrains/kotlin/ir/IrElement;", "", "", "Lorg/jetbrains/kotlin/backend/common/phaser/Action;", "getDefaultDumper", "()Lkotlin/jvm/functions/Function3;", "validationAction", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "getValidationAction", "elementName", "", "getElementName", "(Lorg/jetbrains/kotlin/ir/IrElement;)Ljava/lang/String;", "dumpIrElement", "actionState", "data", "context", "dumpToFile", "Data", "Context", "fileExtension", "dumper", "Lorg/jetbrains/kotlin/backend/common/phaser/Dumper;", "dumpToStdout", "makeDumpAction", "makeVerifyAction", "verifier", "Lkotlin/Function2;", "validationCallback", "fragment", "checkProperties", "", "isDumpNeeded", "isValidationNeeded", "Dumper", "ir.backend.common"})
public final class DumperVerifierKt {
    @NotNull
    private static final Function3<ActionState, IrElement, Object, Unit> defaultDumper = DumperVerifierKt.makeDumpAction(CompilerPhaseKt.plus(DumperVerifierKt.dumpToStdout(defaultDumper.1.INSTANCE), DumperVerifierKt.dumpToFile("ir", defaultDumper.2.INSTANCE)));
    @NotNull
    private static final Function3<ActionState, IrElement, CommonBackendContext, Unit> validationAction = DumperVerifierKt.makeVerifyAction(validationAction.1.INSTANCE);

    private static final String getElementName(IrElement $this$elementName) {
        String string;
        IrElement irElement = $this$elementName;
        if (irElement instanceof IrModuleFragment) {
            String string2 = ((IrModuleFragment)$this$elementName).getName().asString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        } else {
            string = irElement instanceof IrFile ? IrDeclarationsKt.getName((IrFile)$this$elementName) : $this$elementName.toString();
        }
        return string;
    }

    private static final boolean isDumpNeeded(ActionState $this$isDumpNeeded) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$isDumpNeeded.getBeforeOrAfter().ordinal()]) {
            case 1: {
                bl = $this$isDumpNeeded.getConfig().shouldDumpStateBefore($this$isDumpNeeded.getPhase());
                break;
            }
            case 2: {
                bl = $this$isDumpNeeded.getConfig().shouldDumpStateAfter($this$isDumpNeeded.getPhase());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private static final boolean isValidationNeeded(ActionState $this$isValidationNeeded) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$isValidationNeeded.getBeforeOrAfter().ordinal()]) {
            case 1: {
                bl = $this$isValidationNeeded.getConfig().shouldValidateStateBefore($this$isValidationNeeded.getPhase());
                break;
            }
            case 2: {
                bl = $this$isValidationNeeded.getConfig().shouldValidateStateAfter($this$isValidationNeeded.getPhase());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @NotNull
    public static final <Data, Context> Function3<ActionState, Data, Context, Unit> makeDumpAction(@NotNull Function3<? super ActionState, ? super Data, ? super Context, Unit> dumper) {
        Intrinsics.checkNotNullParameter(dumper, (String)"dumper");
        return new Function3<ActionState, Data, Context, Unit>(dumper){
            final /* synthetic */ Function3<ActionState, Data, Context, Unit> $dumper;
            {
                this.$dumper = $dumper;
                super(3);
            }

            public final void invoke(ActionState phaseState, Data data, Context context2) {
                Intrinsics.checkNotNullParameter((Object)phaseState, (String)"phaseState");
                if (DumperVerifierKt.access$isDumpNeeded(phaseState)) {
                    this.$dumper.invoke((Object)phaseState, data, context2);
                }
            }
        };
    }

    @NotNull
    public static final <Data, Context> Function3<ActionState, Data, Context, Unit> makeVerifyAction(@NotNull Function2<? super Context, ? super Data, Unit> verifier) {
        Intrinsics.checkNotNullParameter(verifier, (String)"verifier");
        return new Function3<ActionState, Data, Context, Unit>(verifier){
            final /* synthetic */ Function2<Context, Data, Unit> $verifier;
            {
                this.$verifier = $verifier;
                super(3);
            }

            public final void invoke(ActionState phaseState, Data data, Context context2) {
                Intrinsics.checkNotNullParameter((Object)phaseState, (String)"phaseState");
                if (DumperVerifierKt.access$isValidationNeeded(phaseState)) {
                    this.$verifier.invoke(context2, data);
                }
            }
        };
    }

    @NotNull
    public static final String dumpIrElement(@NotNull ActionState actionState, @NotNull IrElement data, @Nullable Object context2) {
        Intrinsics.checkNotNullParameter((Object)actionState, (String)"actionState");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String beforeOrAfterStr = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)actionState.getBeforeOrAfter().name());
        Ref.ObjectRef dumpText = new Ref.ObjectRef();
        dumpText.element = "";
        String elementName = null;
        String dumpStrategy = System.getProperty("org.jetbrains.kotlin.compiler.ir.dump.strategy");
        Function1 dump2 = Intrinsics.areEqual((Object)dumpStrategy, (Object)"KotlinLike") ? (Function1)dumpIrElement.dump.1.INSTANCE : (Function1)dumpIrElement.dump.2.INSTANCE;
        String dumpOnlyFqName = actionState.getConfig().getDumpOnlyFqName();
        if (dumpOnlyFqName != null) {
            elementName = dumpOnlyFqName;
            IrVisitorsKt.acceptVoid(data, new IrElementVisitorVoid(dumpOnlyFqName, (Ref.ObjectRef<String>)dumpText, (Function1<? super IrElement, String>)dump2){
                final /* synthetic */ String $dumpOnlyFqName;
                final /* synthetic */ Ref.ObjectRef<String> $dumpText;
                final /* synthetic */ Function1<IrElement, String> $dump;
                {
                    this.$dumpOnlyFqName = $dumpOnlyFqName;
                    this.$dumpText = $dumpText;
                    this.$dump = $dump;
                }

                public void visitElement(IrElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    IrVisitorsKt.acceptChildrenVoid(element, this);
                }

                public void visitDeclaration(IrDeclarationBase declaration) {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    if (declaration instanceof IrDeclarationWithName && Intrinsics.areEqual((Object)new FqName(this.$dumpOnlyFqName), (Object)IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((Object)declaration)))) {
                        this.$dumpText.element = (String)this.$dumpText.element + (String)this.$dump.invoke((Object)declaration);
                    } else {
                        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
                    }
                }

                public void visitElement(IrElement element, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
                }

                public void visitDeclaration(IrDeclarationBase declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data);
                }

                public void visitAnonymousInitializer(IrAnonymousInitializer declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
                }

                public void visitAnonymousInitializer(IrAnonymousInitializer declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
                }

                public void visitBlock(IrBlock expression) {
                    IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression);
                }

                public void visitBlock(IrBlock expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression, data);
                }

                public void visitBlockBody(IrBlockBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
                }

                public void visitBlockBody(IrBlockBody body2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
                }

                public void visitBody(IrBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
                }

                public void visitBody(IrBody body2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
                }

                public void visitBranch(IrBranch branch) {
                    IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
                }

                public void visitBranch(IrBranch branch, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
                }

                public void visitBreak(IrBreak jump) {
                    IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
                }

                public void visitBreak(IrBreak jump, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
                }

                public void visitBreakContinue(IrBreakContinue jump) {
                    IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
                }

                public void visitBreakContinue(IrBreakContinue jump, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
                }

                public void visitCall(IrCall expression) {
                    IrElementVisitorVoid.DefaultImpls.visitCall(this, expression);
                }

                public void visitCall(IrCall expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitCall(this, expression, data);
                }

                public void visitCallableReference(IrCallableReference<?> expression) {
                    IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression);
                }

                public void visitCallableReference(IrCallableReference<?> expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression, data);
                }

                public void visitCatch(IrCatch aCatch) {
                    IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
                }

                public void visitCatch(IrCatch aCatch, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
                }

                public void visitClass(IrClass declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration);
                }

                public void visitClass(IrClass declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data);
                }

                public void visitClassReference(IrClassReference expression) {
                    IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression);
                }

                public void visitClassReference(IrClassReference expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression, data);
                }

                public void visitComposite(IrComposite expression) {
                    IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression);
                }

                public void visitComposite(IrComposite expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression, data);
                }

                public void visitConst(IrConst<?> expression) {
                    IrElementVisitorVoid.DefaultImpls.visitConst(this, expression);
                }

                public void visitConst(IrConst<?> expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConst(this, expression, data);
                }

                public void visitConstantArray(IrConstantArray expression) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression);
                }

                public void visitConstantArray(IrConstantArray expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression, data);
                }

                public void visitConstantObject(IrConstantObject expression) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression);
                }

                public void visitConstantObject(IrConstantObject expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression, data);
                }

                public void visitConstantPrimitive(IrConstantPrimitive expression) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression);
                }

                public void visitConstantPrimitive(IrConstantPrimitive expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression, data);
                }

                public void visitConstantValue(IrConstantValue expression) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression);
                }

                public void visitConstantValue(IrConstantValue expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression, data);
                }

                public void visitConstructor(IrConstructor declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
                }

                public void visitConstructor(IrConstructor declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data);
                }

                public void visitConstructorCall(IrConstructorCall expression) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression);
                }

                public void visitConstructorCall(IrConstructorCall expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression, data);
                }

                public void visitContainerExpression(IrContainerExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression);
                }

                public void visitContainerExpression(IrContainerExpression expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression, data);
                }

                public void visitContinue(IrContinue jump) {
                    IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
                }

                public void visitContinue(IrContinue jump, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
                }

                public void visitDeclarationReference(IrDeclarationReference expression) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression);
                }

                public void visitDeclarationReference(IrDeclarationReference expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression, data);
                }

                public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression) {
                    IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression);
                }

                public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression, data);
                }

                public void visitDoWhileLoop(IrDoWhileLoop loop2) {
                    IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
                }

                public void visitDoWhileLoop(IrDoWhileLoop loop2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
                }

                public void visitDynamicExpression(IrDynamicExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression);
                }

                public void visitDynamicExpression(IrDynamicExpression expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression, data);
                }

                public void visitDynamicMemberExpression(IrDynamicMemberExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression);
                }

                public void visitDynamicMemberExpression(IrDynamicMemberExpression expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression, data);
                }

                public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression);
                }

                public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression, data);
                }

                public void visitElseBranch(IrElseBranch branch) {
                    IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
                }

                public void visitElseBranch(IrElseBranch branch, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
                }

                public void visitEnumConstructorCall(IrEnumConstructorCall expression) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression);
                }

                public void visitEnumConstructorCall(IrEnumConstructorCall expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression, data);
                }

                public void visitEnumEntry(IrEnumEntry declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
                }

                public void visitEnumEntry(IrEnumEntry declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data);
                }

                public void visitErrorCallExpression(IrErrorCallExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression);
                }

                public void visitErrorCallExpression(IrErrorCallExpression expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression, data);
                }

                public void visitErrorDeclaration(IrErrorDeclaration declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
                }

                public void visitErrorDeclaration(IrErrorDeclaration declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data);
                }

                public void visitErrorExpression(IrErrorExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression);
                }

                public void visitErrorExpression(IrErrorExpression expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression, data);
                }

                public void visitExpression(IrExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression);
                }

                public void visitExpression(IrExpression expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression, data);
                }

                public void visitExpressionBody(IrExpressionBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
                }

                public void visitExpressionBody(IrExpressionBody body2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
                }

                public void visitExternalPackageFragment(IrExternalPackageFragment declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
                }

                public void visitExternalPackageFragment(IrExternalPackageFragment declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
                }

                public void visitField(IrField declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
                }

                public void visitField(IrField declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data);
                }

                public void visitFieldAccess(IrFieldAccessExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression);
                }

                public void visitFieldAccess(IrFieldAccessExpression expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression, data);
                }

                public void visitFile(IrFile declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
                }

                public void visitFile(IrFile declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data);
                }

                public void visitFunction(IrFunction declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
                }

                public void visitFunction(IrFunction declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data);
                }

                public void visitFunctionAccess(IrFunctionAccessExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression);
                }

                public void visitFunctionAccess(IrFunctionAccessExpression expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression, data);
                }

                public void visitFunctionExpression(IrFunctionExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression);
                }

                public void visitFunctionExpression(IrFunctionExpression expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression, data);
                }

                public void visitFunctionReference(IrFunctionReference expression) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression);
                }

                public void visitFunctionReference(IrFunctionReference expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression, data);
                }

                public void visitGetClass(IrGetClass expression) {
                    IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression);
                }

                public void visitGetClass(IrGetClass expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression, data);
                }

                public void visitGetEnumValue(IrGetEnumValue expression) {
                    IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression);
                }

                public void visitGetEnumValue(IrGetEnumValue expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression, data);
                }

                public void visitGetField(IrGetField expression) {
                    IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression);
                }

                public void visitGetField(IrGetField expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression, data);
                }

                public void visitGetObjectValue(IrGetObjectValue expression) {
                    IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression);
                }

                public void visitGetObjectValue(IrGetObjectValue expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression, data);
                }

                public void visitGetValue(IrGetValue expression) {
                    IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression);
                }

                public void visitGetValue(IrGetValue expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression, data);
                }

                public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock) {
                    IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock);
                }

                public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data);
                }

                public void visitInstanceInitializerCall(IrInstanceInitializerCall expression) {
                    IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression);
                }

                public void visitInstanceInitializerCall(IrInstanceInitializerCall expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression, data);
                }

                public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
                }

                public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
                }

                public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression);
                }

                public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression, data);
                }

                public void visitLoop(IrLoop loop2) {
                    IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
                }

                public void visitLoop(IrLoop loop2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
                }

                public void visitMemberAccess(IrMemberAccessExpression<?> expression) {
                    IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression);
                }

                public void visitMemberAccess(IrMemberAccessExpression<?> expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression, data);
                }

                public void visitModuleFragment(IrModuleFragment declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
                }

                public void visitModuleFragment(IrModuleFragment declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data);
                }

                public void visitPackageFragment(IrPackageFragment declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
                }

                public void visitPackageFragment(IrPackageFragment declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data);
                }

                public void visitProperty(IrProperty declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
                }

                public void visitProperty(IrProperty declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data);
                }

                public void visitPropertyReference(IrPropertyReference expression) {
                    IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression);
                }

                public void visitPropertyReference(IrPropertyReference expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression, data);
                }

                public void visitRawFunctionReference(IrRawFunctionReference expression) {
                    IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression);
                }

                public void visitRawFunctionReference(IrRawFunctionReference expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression, data);
                }

                public void visitReturn(IrReturn expression) {
                    IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression);
                }

                public void visitReturn(IrReturn expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression, data);
                }

                public void visitReturnableBlock(IrReturnableBlock expression) {
                    IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression);
                }

                public void visitReturnableBlock(IrReturnableBlock expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression, data);
                }

                public void visitScript(IrScript declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration);
                }

                public void visitScript(IrScript declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration, data);
                }

                public void visitSetField(IrSetField expression) {
                    IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression);
                }

                public void visitSetField(IrSetField expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression, data);
                }

                public void visitSetValue(IrSetValue expression) {
                    IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression);
                }

                public void visitSetValue(IrSetValue expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression, data);
                }

                public void visitSimpleFunction(IrSimpleFunction declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
                }

                public void visitSimpleFunction(IrSimpleFunction declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data);
                }

                public void visitSingletonReference(IrGetSingletonValue expression) {
                    IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression);
                }

                public void visitSingletonReference(IrGetSingletonValue expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression, data);
                }

                public void visitSpreadElement(IrSpreadElement spread) {
                    IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
                }

                public void visitSpreadElement(IrSpreadElement spread, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
                }

                public void visitStringConcatenation(IrStringConcatenation expression) {
                    IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression);
                }

                public void visitStringConcatenation(IrStringConcatenation expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression, data);
                }

                public void visitSuspendableExpression(IrSuspendableExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression);
                }

                public void visitSuspendableExpression(IrSuspendableExpression expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression, data);
                }

                public void visitSuspensionPoint(IrSuspensionPoint expression) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression);
                }

                public void visitSuspensionPoint(IrSuspensionPoint expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression, data);
                }

                public void visitSyntheticBody(IrSyntheticBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
                }

                public void visitSyntheticBody(IrSyntheticBody body2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
                }

                public void visitThrow(IrThrow expression) {
                    IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression);
                }

                public void visitThrow(IrThrow expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression, data);
                }

                public void visitTry(IrTry aTry) {
                    IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
                }

                public void visitTry(IrTry aTry, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
                }

                public void visitTypeAlias(IrTypeAlias declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
                }

                public void visitTypeAlias(IrTypeAlias declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data);
                }

                public void visitTypeOperator(IrTypeOperatorCall expression) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression);
                }

                public void visitTypeOperator(IrTypeOperatorCall expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression, data);
                }

                public void visitTypeParameter(IrTypeParameter declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
                }

                public void visitTypeParameter(IrTypeParameter declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data);
                }

                public void visitValueAccess(IrValueAccessExpression expression) {
                    IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression);
                }

                public void visitValueAccess(IrValueAccessExpression expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression, data);
                }

                public void visitValueParameter(IrValueParameter declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
                }

                public void visitValueParameter(IrValueParameter declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data);
                }

                public void visitVararg(IrVararg expression) {
                    IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression);
                }

                public void visitVararg(IrVararg expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression, data);
                }

                public void visitVariable(IrVariable declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
                }

                public void visitVariable(IrVariable declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data);
                }

                public void visitWhen(IrWhen expression) {
                    IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression);
                }

                public void visitWhen(IrWhen expression, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression, data);
                }

                public void visitWhileLoop(IrWhileLoop loop2) {
                    IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
                }

                public void visitWhileLoop(IrWhileLoop loop2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
                }
            });
        } else {
            elementName = DumperVerifierKt.getElementName(data);
            dumpText.element = dump2.invoke((Object)data);
        }
        String title = "// --- IR for " + elementName + ' ' + beforeOrAfterStr + ' ' + actionState.getPhase().getDescription() + '\n';
        return title + (String)dumpText.element;
    }

    @NotNull
    public static final <Data, Context> Function3<ActionState, Data, Context, Unit> dumpToFile(@NotNull String fileExtension, @NotNull Function3<? super ActionState, ? super Data, ? super Context, String> dumper) {
        Intrinsics.checkNotNullParameter((Object)fileExtension, (String)"fileExtension");
        Intrinsics.checkNotNullParameter(dumper, (String)"dumper");
        return new Function3<ActionState, Data, Context, Unit>(dumper, fileExtension){
            final /* synthetic */ Function3<ActionState, Data, Context, String> $dumper;
            final /* synthetic */ String $fileExtension;
            {
                this.$dumper = $dumper;
                this.$fileExtension = $fileExtension;
                super(3);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(ActionState actionState, Data data, Context context2) {
                String string;
                File directoryFile;
                Object object;
                StringBuilder stringBuilder;
                String dumpContent;
                String directoryPath;
                block7: {
                    block6: {
                        void it;
                        Intrinsics.checkNotNullParameter((Object)actionState, (String)"actionState");
                        String string2 = actionState.getConfig().getDumpToDirectory();
                        if (string2 == null) {
                            return;
                        }
                        directoryPath = string2;
                        String string3 = (String)this.$dumper.invoke((Object)actionState, data, context2);
                        if (string3 == null) {
                            return;
                        }
                        dumpContent = string3;
                        stringBuilder = new StringBuilder().append(directoryPath);
                        object = data instanceof IrModuleFragment ? (IrModuleFragment)data : null;
                        if (object == null) break block6;
                        IrModuleFragment irModuleFragment = object;
                        StringBuilder stringBuilder2 = stringBuilder;
                        boolean bl = false;
                        StringBuilder stringBuilder3 = new StringBuilder().append('/');
                        String string4 = it.getName().asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"asString(...)");
                        String string5 = stringBuilder3.append(StringsKt.removeSurrounding((String)string4, (CharSequence)"<", (CharSequence)">")).toString();
                        stringBuilder = stringBuilder2;
                        object = string5;
                        if (string5 != null) break block7;
                    }
                    object = "";
                }
                if (!(directoryFile = new File(string = stringBuilder.append((String)object).toString())).isDirectory() && !directoryFile.mkdirs()) {
                    throw new IllegalStateException(("Can't create directory for IR dumps at " + directoryPath).toString());
                }
                String string6 = "%02d";
                Object[] objectArray = new Object[]{actionState.getPhaseCount()};
                String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(...)");
                String phaseIdFormatted = string7;
                String dumpStrategy = System.getProperty("org.jetbrains.kotlin.compiler.ir.dump.strategy");
                String extPrefix = Intrinsics.areEqual((Object)dumpStrategy, (Object)"KotlinLike") ? "kt." : "";
                String fileName = phaseIdFormatted + '_' + (Object)((Object)actionState.getBeforeOrAfter()) + '.' + actionState.getPhase().getName() + '.' + extPrefix + this.$fileExtension;
                FilesKt.writeText$default((File)new File(directoryFile, fileName), (String)dumpContent, null, (int)2, null);
            }
        };
    }

    @NotNull
    public static final <Data, Context> Function3<ActionState, Data, Context, Unit> dumpToStdout(@NotNull Function3<? super ActionState, ? super Data, ? super Context, String> dumper) {
        Intrinsics.checkNotNullParameter(dumper, (String)"dumper");
        return new Function3<ActionState, Data, Context, Unit>(dumper){
            final /* synthetic */ Function3<ActionState, Data, Context, String> $dumper;
            {
                this.$dumper = $dumper;
                super(3);
            }

            public final void invoke(ActionState actionState, Data data, Context context2) {
                Intrinsics.checkNotNullParameter((Object)actionState, (String)"actionState");
                if (actionState.getConfig().getDumpToDirectory() != null) {
                    return;
                }
                String string = (String)this.$dumper.invoke((Object)actionState, data, context2);
                if (string == null) {
                    return;
                }
                String dumpContent = string;
                System.out.println((Object)"\n\n----------------------------------------------");
                System.out.println((Object)dumpContent);
                System.out.println();
            }
        };
    }

    @NotNull
    public static final Function3<ActionState, IrElement, Object, Unit> getDefaultDumper() {
        return defaultDumper;
    }

    public static final void validationCallback(@NotNull CommonBackendContext context2, @NotNull IrElement fragment, boolean checkProperties) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        IrValidatorConfig validatorConfig = new IrValidatorConfig(true, true, false, false, checkProperties, false, 32, null);
        fragment.accept(new IrValidator(context2, validatorConfig), null);
        IrValidatorKt.checkDeclarationParents(fragment);
    }

    public static /* synthetic */ void validationCallback$default(CommonBackendContext commonBackendContext, IrElement irElement, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        DumperVerifierKt.validationCallback(commonBackendContext, irElement, bl);
    }

    @NotNull
    public static final Function3<ActionState, IrElement, CommonBackendContext, Unit> getValidationAction() {
        return validationAction;
    }

    public static final /* synthetic */ boolean access$isDumpNeeded(ActionState $receiver) {
        return DumperVerifierKt.isDumpNeeded($receiver);
    }

    public static final /* synthetic */ boolean access$isValidationNeeded(ActionState $receiver) {
        return DumperVerifierKt.isValidationNeeded($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BeforeOrAfter.values().length];
            try {
                nArray[BeforeOrAfter.BEFORE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeforeOrAfter.AFTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

