/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.GlobalDeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureFactory;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000fJ)\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001f\u00a2\u0006\u0002\u0010 J\u0016\u0010!\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J$\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001fJ\u001e\u0010$\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u000eH\u0014J\u0014\u0010'\u001a\u00020\u0016*\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0014\u0010\u0005\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR0\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "", "globalTable", "Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "(Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;)V", "globalDeclarationTable", "getGlobalDeclarationTable", "()Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "signaturer", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureFactory;", "getSignaturer", "()Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureFactory;", "table", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lkotlin/collections/HashMap;", "getTable", "()Ljava/util/HashMap;", "allocateIndexedSignature", "declaration", "compatibleMode", "", "assumeDeclarationSignature", "", "signature", "inFile", "R", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "block", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "isExportedDeclaration", "privateDeclarationSignature", "builder", "signatureByDeclaration", "recordInSignatureClashDetector", "tryComputeBackendSpecificSignature", "isLocalDeclaration", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nDeclarationTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationTable.kt\norg/jetbrains/kotlin/backend/common/serialization/DeclarationTable\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n372#2,7:95\n372#2,7:102\n1#3:109\n*S KotlinDebug\n*F\n+ 1 DeclarationTable.kt\norg/jetbrains/kotlin/backend/common/serialization/DeclarationTable\n*L\n68#1:95,7\n73#1:102,7\n*E\n"})
public class DeclarationTable {
    @NotNull
    private final HashMap<IrDeclaration, IdSignature> table;
    @NotNull
    private final GlobalDeclarationTable globalDeclarationTable;
    @NotNull
    private final IdSignatureFactory signaturer;

    public DeclarationTable(@NotNull GlobalDeclarationTable globalTable) {
        Intrinsics.checkNotNullParameter((Object)globalTable, (String)"globalTable");
        this.table = new HashMap();
        this.globalDeclarationTable = globalTable;
        this.signaturer = new IdSignatureFactory(globalTable.getPublicIdSignatureComputer(), this);
    }

    @NotNull
    protected final HashMap<IrDeclaration, IdSignature> getTable() {
        return this.table;
    }

    @NotNull
    protected GlobalDeclarationTable getGlobalDeclarationTable() {
        return this.globalDeclarationTable;
    }

    @NotNull
    public IdSignatureFactory getSignaturer() {
        return this.signaturer;
    }

    public final <R> R inFile(@Nullable IrFile file, @NotNull Function0<? extends R> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        IrFile irFile = file;
        return this.getSignaturer().inFile(irFile != null ? irFile.getSymbol() : null, block);
    }

    private final boolean isLocalDeclaration(IrDeclaration $this$isLocalDeclaration, boolean compatibleMode) {
        return !this.isExportedDeclaration($this$isLocalDeclaration, compatibleMode);
    }

    public final boolean isExportedDeclaration(@NotNull IrDeclaration declaration, boolean compatibleMode) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return this.getGlobalDeclarationTable().isExportedDeclaration(declaration, compatibleMode);
    }

    @Nullable
    protected IdSignature tryComputeBackendSpecificSignature(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return null;
    }

    private final IdSignature allocateIndexedSignature(IrDeclaration declaration, boolean compatibleMode) {
        Object object;
        Map $this$getOrPut$iv = this.table;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(declaration);
        if (value$iv == null) {
            boolean bl = false;
            IdSignature answer$iv = this.getSignaturer().composeFileLocalIdSignature(declaration, compatibleMode);
            $this$getOrPut$iv.put(declaration, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (IdSignature)object;
    }

    @NotNull
    public final IdSignature privateDeclarationSignature(@NotNull IrDeclaration declaration, boolean compatibleMode, @NotNull Function0<? extends IdSignature> builder2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter(builder2, (String)"builder");
        boolean bl = this.isLocalDeclaration(declaration, compatibleMode);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Map $this$getOrPut$iv = this.table;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(declaration);
        if (value$iv == null) {
            boolean bl2 = false;
            IdSignature answer$iv = (IdSignature)builder2.invoke();
            $this$getOrPut$iv.put(declaration, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (IdSignature)object;
    }

    @NotNull
    public final IdSignature signatureByDeclaration(@NotNull IrDeclaration declaration, boolean compatibleMode, boolean recordInSignatureClashDetector) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IdSignature idSignature = this.tryComputeBackendSpecificSignature(declaration);
        if (idSignature != null) {
            IdSignature it = idSignature;
            boolean bl = false;
            return it;
        }
        return this.isLocalDeclaration(declaration, compatibleMode) ? this.allocateIndexedSignature(declaration, compatibleMode) : this.getGlobalDeclarationTable().computeSignatureByDeclaration(declaration, compatibleMode, recordInSignatureClashDetector);
    }

    public final void assumeDeclarationSignature(@NotNull IrDeclaration declaration, @NotNull IdSignature signature) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        boolean bl2 = bl = this.table.get(declaration) == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Declaration table already has signature for " + RenderIrElementKt.render$default(declaration, null, 1, null);
            throw new AssertionError((Object)string);
        }
        this.table.put(declaration, signature);
    }
}

