/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function7;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtIoFileSourceFile;
import org.jetbrains.kotlin.KtPsiSourceFile;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.KtVirtualFileSourceFile;
import org.jetbrains.kotlin.backend.common.serialization.CompatibilityMode;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleSerializer;
import org.jetbrains.kotlin.backend.common.serialization.KotlinFileSerializedData;
import org.jetbrains.kotlin.backend.common.serialization.SerializeModuleIntoKlibKt;
import org.jetbrains.kotlin.backend.common.serialization.SerializerOutput;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataSerializerKt;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibSingleFileMetadataSerializer;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.KtDiagnosticReporterWithImplicitIrBasedContext;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.SerializedIrFile;
import org.jetbrains.kotlin.library.SerializedIrModule;
import org.jetbrains.kotlin.library.SerializedMetadata;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0094\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u00f3\u0002\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\u0004\b\u0001\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00102\u00aa\u0001\u0010\u0013\u001a\u00a5\u0001\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001c\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00060\u001d\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001e\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b( \u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(!\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0\u00142\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u00040$2 \b\u0002\u0010%\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020'0&2\u001c\b\u0002\u0010(\u001a\u0016\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020'\u0018\u00010)2\u0014\b\u0002\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020'0,\u001a\f\u0010.\u001a\u0004\u0018\u00010**\u00020/\u00a8\u00060"}, d2={"serializeModuleIntoKlib", "Lorg/jetbrains/kotlin/backend/common/serialization/SerializerOutput;", "Dependency", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "SourceFile", "moduleName", "", "irModuleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "diagnosticReporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "compatibilityMode", "Lorg/jetbrains/kotlin/backend/common/serialization/CompatibilityMode;", "cleanFiles", "", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinFileSerializedData;", "dependencies", "createModuleSerializer", "Lkotlin/Function7;", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "Lkotlin/ParameterName;", "name", "irDiagnosticReporter", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "irBuiltins", "", "normalizeAbsolutePaths", "", "sourceBaseDirs", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "shouldCheckSignaturesOnUniqueness", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleSerializer;", "metadataSerializer", "Lorg/jetbrains/kotlin/backend/common/serialization/metadata/KlibSingleFileMetadataSerializer;", "runKlibCheckers", "Lkotlin/Function3;", "", "processCompiledFileData", "Lkotlin/Function2;", "Ljava/io/File;", "processKlibHeader", "Lkotlin/Function1;", "", "toIoFileOrNull", "Lorg/jetbrains/kotlin/KtSourceFile;", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nserializeModuleIntoKlib.kt\nKotlin\n*S Kotlin\n*F\n+ 1 serializeModuleIntoKlib.kt\norg/jetbrains/kotlin/backend/common/serialization/SerializeModuleIntoKlibKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,204:1\n1#2:205\n1#2:244\n1547#3:206\n1618#3,3:207\n1475#3:210\n1500#3,3:211\n1503#3,3:221\n1043#3:227\n1547#3:228\n1618#3,3:229\n1043#3:233\n1601#3,9:234\n1853#3:243\n1854#3:245\n1610#3:246\n372#4,7:214\n125#5:224\n152#5,2:225\n154#5:232\n*S KotlinDebug\n*F\n+ 1 serializeModuleIntoKlib.kt\norg/jetbrains/kotlin/backend/common/serialization/SerializeModuleIntoKlibKt\n*L\n199#1:244\n177#1:206\n177#1:207,3\n184#1:210\n184#1:211,3\n184#1:221,3\n186#1:227\n186#1:228\n186#1:229,3\n188#1:233\n199#1:234,9\n199#1:243\n199#1:245\n199#1:246\n184#1:214,7\n185#1:224\n185#1:225,2\n185#1:232\n*E\n"})
public final class SerializeModuleIntoKlibKt {
    @Nullable
    public static final File toIoFileOrNull(@NotNull KtSourceFile $this$toIoFileOrNull) {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$toIoFileOrNull, (String)"<this>");
        KtSourceFile ktSourceFile = $this$toIoFileOrNull;
        if (ktSourceFile instanceof KtIoFileSourceFile) {
            file = ((KtIoFileSourceFile)$this$toIoFileOrNull).getFile();
        } else if (ktSourceFile instanceof KtVirtualFileSourceFile) {
            file = VfsUtilCore.virtualToIoFile((VirtualFile)((KtVirtualFileSourceFile)$this$toIoFileOrNull).getVirtualFile());
        } else if (ktSourceFile instanceof KtPsiSourceFile) {
            file = VfsUtilCore.virtualToIoFile((VirtualFile)((KtPsiSourceFile)$this$toIoFileOrNull).getPsiFile().getVirtualFile());
        } else {
            String string = $this$toIoFileOrNull.getPath();
            if (string != null) {
                String p0 = string;
                boolean bl = false;
                file = new File(p0);
            } else {
                file = null;
            }
        }
        return file;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <Dependency extends KotlinLibrary, SourceFile> SerializerOutput<Dependency> serializeModuleIntoKlib(@NotNull String moduleName, @Nullable IrModuleFragment irModuleFragment, @NotNull CompilerConfiguration configuration, @NotNull DiagnosticReporter diagnosticReporter, @NotNull CompatibilityMode compatibilityMode, @NotNull List<KotlinFileSerializedData> cleanFiles, @NotNull List<? extends Dependency> dependencies, @NotNull Function7<? super IrDiagnosticReporter, ? super IrBuiltIns, ? super CompatibilityMode, ? super Boolean, ? super Collection<String>, ? super LanguageVersionSettings, ? super Boolean, ? extends IrModuleSerializer<?>> createModuleSerializer, @NotNull KlibSingleFileMetadataSerializer<SourceFile> metadataSerializer, @NotNull Function3<? super IrModuleFragment, ? super IrDiagnosticReporter, ? super CompilerConfiguration, Unit> runKlibCheckers, @Nullable Function2<? super File, ? super KotlinFileSerializedData, Unit> processCompiledFileData, @NotNull Function1<? super byte[], Unit> processKlibHeader) {
        SerializedIrModule serializedIrModule;
        SerializedMetadata serializedMetadata;
        void $this$sortedBy$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object answer$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Collection<String> collection;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        List list2;
        Collection serializedIr;
        Collection collection2;
        Collection collection3;
        Collection collection4;
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)diagnosticReporter, (String)"diagnosticReporter");
        Intrinsics.checkNotNullParameter((Object)compatibilityMode, (String)"compatibilityMode");
        Intrinsics.checkNotNullParameter(cleanFiles, (String)"cleanFiles");
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter(createModuleSerializer, (String)"createModuleSerializer");
        Intrinsics.checkNotNullParameter(metadataSerializer, (String)"metadataSerializer");
        Intrinsics.checkNotNullParameter(runKlibCheckers, (String)"runKlibCheckers");
        Intrinsics.checkNotNullParameter(processKlibHeader, (String)"processKlibHeader");
        if (irModuleFragment != null) {
            boolean bl;
            boolean bl2 = bl = metadataSerializer.getNumberOfSourceFiles() == irModuleFragment.getFiles().size();
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-SerializeModuleIntoKlibKt$serializeModuleIntoKlib$42 = false;
                String $i$a$-assert-SerializeModuleIntoKlibKt$serializeModuleIntoKlib$42 = "The number of source files (" + metadataSerializer.getNumberOfSourceFiles() + ") does not match the number of IrFiles (" + irModuleFragment.getFiles().size() + ')';
                throw new AssertionError((Object)$i$a$-assert-SerializeModuleIntoKlibKt$serializeModuleIntoKlib$42);
            }
        }
        if ((collection4 = (Collection)configuration.get(CommonConfigurationKeys.KLIB_RELATIVE_PATH_BASES)) == null) {
            collection4 = CollectionsKt.emptyList();
        }
        Collection sourceBaseDirs = collection4;
        boolean normalizeAbsolutePath = configuration.getBoolean(CommonConfigurationKeys.KLIB_NORMALIZE_ABSOLUTE_PATH);
        Boolean bl = (Boolean)configuration.get(CommonConfigurationKeys.PRODUCE_KLIB_SIGNATURES_CLASH_CHECKS);
        if (bl == null) {
            bl = true;
        }
        boolean signatureClashChecks = bl;
        IrModuleFragment irModuleFragment2 = irModuleFragment;
        if (irModuleFragment2 != null) {
            IrModuleFragment it = irModuleFragment2;
            boolean list2 = false;
            KtDiagnosticReporterWithImplicitIrBasedContext irDiagnosticReporter = new KtDiagnosticReporterWithImplicitIrBasedContext(diagnosticReporter, CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)configuration));
            runKlibCheckers.invoke((Object)it, (Object)irDiagnosticReporter, (Object)configuration);
            collection3 = ((IrModuleSerializer)createModuleSerializer.invoke((Object)irDiagnosticReporter, (Object)it.getIrBuiltins(), (Object)compatibilityMode, (Object)normalizeAbsolutePath, (Object)sourceBaseDirs, (Object)CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)configuration), (Object)signatureClashChecks)).serializedIrModule(it);
        } else {
            collection3 = null;
        }
        List serializedFiles = (collection2 = (serializedIr = collection3)) != null && (collection2 = collection2.getFiles()) != null ? CollectionsKt.toList((Iterable)collection2) : null;
        Iterable $this$serializeModuleIntoKlib_u24lambda_u242 = list2 = CollectionsKt.createListBuilder();
        boolean bl3 = false;
        $this$serializeModuleIntoKlib_u24lambda_u242.addAll(cleanFiles);
        metadataSerializer.forEachFile((Function4)new Function4<Integer, SourceFile, KtSourceFile, FqName, Unit>(serializedFiles, metadataSerializer, processCompiledFileData, (List<KotlinFileSerializedData>)$this$serializeModuleIntoKlib_u24lambda_u242){
            final /* synthetic */ List<SerializedIrFile> $serializedFiles;
            final /* synthetic */ KlibSingleFileMetadataSerializer<SourceFile> $metadataSerializer;
            final /* synthetic */ Function2<File, KotlinFileSerializedData, Unit> $processCompiledFileData;
            final /* synthetic */ List<KotlinFileSerializedData> $this_buildList;
            {
                this.$serializedFiles = $serializedFiles;
                this.$metadataSerializer = $metadataSerializer;
                this.$processCompiledFileData = $processCompiledFileData;
                this.$this_buildList = $receiver;
                super(4);
            }

            public final void invoke(int i, SourceFile sourceFile, KtSourceFile ktSourceFile, FqName packageFqName) {
                KotlinFileSerializedData compiledKotlinFile;
                KotlinFileSerializedData kotlinFileSerializedData;
                SerializedIrFile serializedIrFile;
                Intrinsics.checkNotNullParameter((Object)ktSourceFile, (String)"ktSourceFile");
                Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
                SerializedIrFile serializedIrFile2 = this.$serializedFiles;
                if (serializedIrFile2 != null && (serializedIrFile2 = serializedIrFile2.get(i)) != null) {
                    SerializedIrFile serializedIrFile3;
                    SerializedIrFile it = serializedIrFile3 = serializedIrFile2;
                    boolean bl = false;
                    boolean bl2 = Intrinsics.areEqual((Object)ktSourceFile.getPath(), (Object)it.getPath());
                    if (_Assertions.ENABLED && !bl2) {
                        boolean bl3 = false;
                        String string = StringsKt.trimMargin$default((String)("The Kt and Ir files are put in different order\n                    Kt: " + ktSourceFile.getPath() + "\n                    Ir: " + it.getPath() + "\n                    "), null, (int)1, null);
                        throw new AssertionError((Object)string);
                    }
                    serializedIrFile = serializedIrFile3;
                } else {
                    serializedIrFile = null;
                }
                SerializedIrFile binaryFile = serializedIrFile;
                ProtoBuf.PackageFragment protoBuf = this.$metadataSerializer.serializeSingleFileMetadata(sourceFile);
                byte[] metadata = protoBuf.toByteArray();
                if (binaryFile == null) {
                    Intrinsics.checkNotNull((Object)metadata);
                    String string = ktSourceFile.getPath();
                    String string2 = packageFqName.asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                    kotlinFileSerializedData = new KotlinFileSerializedData(metadata, string, string2);
                } else {
                    Intrinsics.checkNotNull((Object)metadata);
                    kotlinFileSerializedData = compiledKotlinFile = new KotlinFileSerializedData(metadata, binaryFile);
                }
                if (this.$processCompiledFileData != null) {
                    File file = SerializeModuleIntoKlibKt.toIoFileOrNull(ktSourceFile);
                    if (file == null) {
                        throw new IllegalStateException(("No file found for source " + ktSourceFile.getPath()).toString());
                    }
                    File ioFile = file;
                    this.$processCompiledFileData.invoke((Object)ioFile, (Object)compiledKotlinFile);
                }
                this.$this_buildList.add(compiledKotlinFile);
            }
        });
        List compiledKotlinFiles2 = CollectionsKt.build((List)list2);
        $this$serializeModuleIntoKlib_u24lambda_u242 = compiledKotlinFiles2;
        String string = moduleName;
        Object object = CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)configuration);
        boolean $i$f$map22 = false;
        void var21_28 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            KotlinFileSerializedData kotlinFileSerializedData = (KotlinFileSerializedData)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(it.getFqName());
        }
        collection = (List)destination$iv$iv;
        byte[] header = KlibMetadataSerializerKt.serializeKlibHeader((LanguageVersionSettings)object, string, (List<String>)CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)collection)), (List<String>)CollectionsKt.emptyList()).toByteArray();
        Intrinsics.checkNotNull((Object)header);
        processKlibHeader.invoke((Object)header);
        Iterable $i$f$map22 = compiledKotlinFiles2;
        boolean $i$f$groupBy = false;
        destination$iv$iv = $this$groupBy$iv;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            KotlinFileSerializedData it = (KotlinFileSerializedData)element$iv$iv;
            boolean bl5 = false;
            String key$iv$iv = it.getFqName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl6 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv2;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo2 = false;
        item$iv$iv2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (item$iv$iv2.hasNext()) {
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            Map.Entry item$iv$iv3;
            Map.Entry list$iv$iv = item$iv$iv3 = (Map.Entry)item$iv$iv2.next();
            object = destination$iv$iv2;
            boolean bl7 = false;
            String fqn = (String)list$iv$iv.getKey();
            List data = (List)list$iv$iv.getValue();
            Iterable $this$sortedBy$iv2 = data;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    KotlinFileSerializedData it = (KotlinFileSerializedData)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getPath());
                    it = (KotlinFileSerializedData)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getPath())));
                }
            });
            answer$iv$iv$iv = fqn;
            boolean $i$f$map3 = false;
            void var34_57 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv4 : $this$mapTo$iv$iv3) {
                void it;
                KotlinFileSerializedData kotlinFileSerializedData = (KotlinFileSerializedData)item$iv$iv4;
                Collection collection5 = destination$iv$iv3;
                boolean bl8 = false;
                collection5.add(it.getMetadata());
            }
            object.add(TuplesKt.to((Object)answer$iv$iv$iv, (Object)((List)destination$iv$iv3)));
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$sortedBy = false;
        Pair pair = CollectionsKt.unzip((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getFirst()));
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getFirst()))));
            }
        }));
        List fragmentNames = (List)pair.component1();
        List fragmentParts = (List)pair.component2();
        Object object3 = serializedMetadata = new SerializedMetadata(header, fragmentParts, fragmentNames);
        if (serializedIr == null) {
            serializedIrModule = null;
        } else {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            destination$iv$iv2 = compiledKotlinFiles2;
            collection = object3;
            boolean $i$f$mapNotNull = false;
            item$iv$iv2 = $this$mapNotNull$iv;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                SerializedIrFile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl9 = false;
                KotlinFileSerializedData it = (KotlinFileSerializedData)element$iv$iv;
                boolean bl10 = false;
                if (it.getIrData() == null) continue;
                boolean bl11 = false;
                destination$iv$iv4.add(it$iv$iv);
            }
            object3 = collection;
            Collection collection6 = (List)destination$iv$iv4;
            serializedIrModule = new SerializedIrModule(collection6);
        }
        List<? extends Dependency> list3 = dependencies;
        byte[] byArray = null;
        SerializedIrModule serializedIrModule2 = serializedIrModule;
        SerializedMetadata serializedMetadata2 = object3;
        return new SerializerOutput<Dependency>(serializedMetadata2, serializedIrModule2, byArray, list3);
    }

    public static /* synthetic */ SerializerOutput serializeModuleIntoKlib$default(String string, IrModuleFragment irModuleFragment, CompilerConfiguration compilerConfiguration, DiagnosticReporter diagnosticReporter, CompatibilityMode compatibilityMode, List list, List list2, Function7 function7, KlibSingleFileMetadataSerializer klibSingleFileMetadataSerializer, Function3 function3, Function2 function2, Function1 function1, int n, Object object) {
        if ((n & 0x200) != 0) {
            function3 = serializeModuleIntoKlib.1.INSTANCE;
        }
        if ((n & 0x400) != 0) {
            function2 = null;
        }
        if ((n & 0x800) != 0) {
            function1 = serializeModuleIntoKlib.2.INSTANCE;
        }
        return SerializeModuleIntoKlibKt.serializeModuleIntoKlib(string, irModuleFragment, compilerConfiguration, diagnosticReporter, compatibilityMode, list, list2, function7, klibSingleFileMetadataSerializer, (Function3<? super IrModuleFragment, ? super IrDiagnosticReporter, ? super CompilerConfiguration, Unit>)function3, (Function2<? super File, ? super KotlinFileSerializedData, Unit>)function2, (Function1<? super byte[], Unit>)function1);
    }
}

