/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.checkers.expressions;

import com.google.gwt.dev.js.parserExceptions.AbortParsingException;
import com.google.gwt.dev.js.rhino.CodePosition;
import com.google.gwt.dev.js.rhino.ErrorReporter;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibDiagnosticContext;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibDiagnosticContextKt;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibErrors;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibExpressionChecker;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsRootScope;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.parser.ParserUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/checkers/expressions/JsKlibJsCodeCallChecker;", "Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibExpressionChecker;", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibCallChecker;", "()V", "jsCodeFqName", "Lorg/jetbrains/kotlin/name/FqName;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibDiagnosticContext;", "reporter", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "JsErrorReporter", "ir.serialization.js"})
public final class JsKlibJsCodeCallChecker
implements JsKlibExpressionChecker<IrCall> {
    @NotNull
    public static final JsKlibJsCodeCallChecker INSTANCE = new JsKlibJsCodeCallChecker();
    @NotNull
    private static final FqName jsCodeFqName = JsStandardClassIds.Callables.JsCode.asSingleFqName();

    private JsKlibJsCodeCallChecker() {
    }

    @Override
    public void check(@NotNull IrCall expression, @NotNull JsKlibDiagnosticContext context2, @NotNull IrDiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)context2.getCompilerConfiguration()).getLanguageVersion().getUsesK2()) {
            return;
        }
        if (!Intrinsics.areEqual((Object)IrUtilsKt.getFqNameWhenAvailable(expression.getSymbol().getOwner()), (Object)jsCodeFqName)) {
            return;
        }
        IrExpression jsCodeExpr = expression.getValueArgument(0);
        if (!(jsCodeExpr instanceof IrConst) || !Intrinsics.areEqual(((IrConst)jsCodeExpr).getKind(), (Object)IrConstKind.String.INSTANCE)) {
            IrExpression irExpression = jsCodeExpr;
            if (irExpression == null) {
                irExpression = expression;
            }
            JsKlibDiagnosticContextKt.at(reporter, irExpression, context2).report(JsKlibErrors.INSTANCE.getJSCODE_CAN_NOT_VERIFY_JAVASCRIPT());
            return;
        }
        String jsCodeStr = (String)IrConstKind.String.INSTANCE.valueOf((IrConst)jsCodeExpr);
        try {
            Object fileName;
            JsErrorReporter jsErrorReporter;
            List statements;
            Collection collection;
            JsFunctionScope parserScope = new JsFunctionScope((JsScope)new JsRootScope(new JsProgram()), "<js fun>");
            Object object = context2.getContainingFile();
            if (object == null || (object = ((IrFile)object).getFileEntry()) == null || (object = object.getName()) == null) {
                object = "<unknown file>";
            }
            if ((collection = (Collection)(statements = ParserUtilsKt.parseExpressionOrStatement((String)jsCodeStr, (ErrorReporter)(jsErrorReporter = new JsErrorReporter(jsCodeExpr, context2, reporter)), (JsScope)((JsScope)parserScope), (CodePosition)new CodePosition(0, 0), (String)(fileName = object)))) == null || collection.isEmpty()) {
                JsKlibDiagnosticContextKt.at(reporter, jsCodeExpr, context2).report(JsKlibErrors.INSTANCE.getJSCODE_NO_JAVASCRIPT_PRODUCED());
            }
        }
        catch (AbortParsingException abortParsingException) {
            // empty catch block
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J \u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/checkers/expressions/JsKlibJsCodeCallChecker$JsErrorReporter;", "Lcom/google/gwt/dev/js/rhino/ErrorReporter;", "codeExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibDiagnosticContext;", "reporter", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibDiagnosticContext;Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;)V", "getCodeExpression", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibDiagnosticContext;", "getReporter", "()Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "error", "", "message", "", "startPosition", "Lcom/google/gwt/dev/js/rhino/CodePosition;", "endPosition", "warning", "ir.serialization.js"})
    private static final class JsErrorReporter
    implements ErrorReporter {
        @NotNull
        private final IrExpression codeExpression;
        @NotNull
        private final JsKlibDiagnosticContext context;
        @NotNull
        private final IrDiagnosticReporter reporter;

        public JsErrorReporter(@NotNull IrExpression codeExpression, @NotNull JsKlibDiagnosticContext context2, @NotNull IrDiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)codeExpression, (String)"codeExpression");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            this.codeExpression = codeExpression;
            this.context = context2;
            this.reporter = reporter;
        }

        @NotNull
        public final IrExpression getCodeExpression() {
            return this.codeExpression;
        }

        @NotNull
        public final JsKlibDiagnosticContext getContext() {
            return this.context;
        }

        @NotNull
        public final IrDiagnosticReporter getReporter() {
            return this.reporter;
        }

        public void warning(@NotNull String message, @NotNull CodePosition startPosition, @NotNull CodePosition endPosition) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)startPosition, (String)"startPosition");
            Intrinsics.checkNotNullParameter((Object)endPosition, (String)"endPosition");
            JsKlibDiagnosticContextKt.at(this.reporter, this.codeExpression, this.context).report(JsKlibErrors.INSTANCE.getJSCODE_WARNING(), (Object)message);
        }

        public void error(@NotNull String message, @NotNull CodePosition startPosition, @NotNull CodePosition endPosition) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)startPosition, (String)"startPosition");
            Intrinsics.checkNotNullParameter((Object)endPosition, (String)"endPosition");
            JsKlibDiagnosticContextKt.at(this.reporter, this.codeExpression, this.context).report(JsKlibErrors.INSTANCE.getJSCODE_ERROR(), (Object)message);
            throw new AbortParsingException();
        }
    }
}

