/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.expressions.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\tH\u0016J\b\u0010#\u001a\u00020\u0003H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u001a\u0010\f\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\"\u0010\u0019\u001a\u0010\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u000b0\u000b0\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\"\u0010\u001e\u001a\u0010\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\t0\t0\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001d\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstantObjectImpl;", "Lorg/jetbrains/kotlin/ir/expressions/IrConstantObject;", "startOffset", "", "endOffset", "constructor", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "initValueArguments", "", "Lorg/jetbrains/kotlin/ir/expressions/IrConstantValue;", "initTypeArguments", "Lorg/jetbrains/kotlin/ir/types/IrType;", "type", "(IILorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "getConstructor", "()Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "setConstructor", "(Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;)V", "getEndOffset", "()I", "getStartOffset", "getType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "setType", "(Lorg/jetbrains/kotlin/ir/types/IrType;)V", "typeArguments", "Lorg/jetbrains/kotlin/utils/SmartList;", "kotlin.jvm.PlatformType", "getTypeArguments", "()Lorg/jetbrains/kotlin/utils/SmartList;", "valueArguments", "getValueArguments", "contentEquals", "", "other", "contentHashCode", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nIrConstantObjectImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrConstantObjectImpl.kt\norg/jetbrains/kotlin/ir/expressions/impl/IrConstantObjectImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1724#2,3:93\n1724#2,3:96\n*S KotlinDebug\n*F\n+ 1 IrConstantObjectImpl.kt\norg/jetbrains/kotlin/ir/expressions/impl/IrConstantObjectImpl\n*L\n54#1:93,3\n55#1:96,3\n*E\n"})
public final class IrConstantObjectImpl
extends IrConstantObject {
    private final int startOffset;
    private final int endOffset;
    @NotNull
    private IrConstructorSymbol constructor;
    @NotNull
    private IrType type;
    @NotNull
    private final SmartList<IrConstantValue> valueArguments;
    @NotNull
    private final SmartList<IrType> typeArguments;

    public IrConstantObjectImpl(int startOffset, int endOffset, @NotNull IrConstructorSymbol constructor, @NotNull List<? extends IrConstantValue> initValueArguments, @NotNull List<? extends IrType> initTypeArguments, @NotNull IrType type2) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        Intrinsics.checkNotNullParameter(initValueArguments, (String)"initValueArguments");
        Intrinsics.checkNotNullParameter(initTypeArguments, (String)"initTypeArguments");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.constructor = constructor;
        this.type = type2;
        this.valueArguments = new SmartList((Collection)initValueArguments);
        this.typeArguments = new SmartList((Collection)initTypeArguments);
    }

    public /* synthetic */ IrConstantObjectImpl(int n, int n2, IrConstructorSymbol irConstructorSymbol, List list, List list2, IrType irType, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x20) != 0) {
            irType = IrUtilsKt.getConstructedClassType((IrConstructor)irConstructorSymbol.getOwner());
        }
        this(n, n2, irConstructorSymbol, list, list2, irType);
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    @NotNull
    public IrConstructorSymbol getConstructor() {
        return this.constructor;
    }

    @Override
    public void setConstructor(@NotNull IrConstructorSymbol irConstructorSymbol) {
        Intrinsics.checkNotNullParameter((Object)irConstructorSymbol, (String)"<set-?>");
        this.constructor = irConstructorSymbol;
    }

    @Override
    @NotNull
    public IrType getType() {
        return this.type;
    }

    @Override
    public void setType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"<set-?>");
        this.type = irType;
    }

    @NotNull
    public SmartList<IrConstantValue> getValueArguments() {
        return this.valueArguments;
    }

    @NotNull
    public SmartList<IrType> getTypeArguments() {
        return this.typeArguments;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean contentEquals(@NotNull IrConstantValue other) {
        int index;
        int element$iv;
        Iterator iterator;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof IrConstantObject)) return false;
        if (!Intrinsics.areEqual((Object)other.getType(), (Object)this.getType())) return false;
        if (!Intrinsics.areEqual((Object)((IrConstantObject)other).getConstructor(), (Object)this.getConstructor())) return false;
        if (this.getValueArguments().size() != ((IrConstantObject)other).getValueArguments().size()) return false;
        if (this.getTypeArguments().size() != ((IrConstantObject)other).getTypeArguments().size()) return false;
        Iterable $this$all$iv = (Iterable)CollectionsKt.getIndices((Collection)((Collection)this.getValueArguments()));
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            iterator = $this$all$iv.iterator();
            while (iterator.hasNext()) {
                index = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl2 = false;
                if (((IrConstantValue)this.getValueArguments().get(index)).contentEquals(((IrConstantObject)other).getValueArguments().get(index))) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        $this$all$iv = (Iterable)CollectionsKt.getIndices((Collection)((Collection)this.getTypeArguments()));
        $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            index = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl3 = false;
        } while (Intrinsics.areEqual((Object)this.getTypeArguments().get(index), (Object)((IrConstantObject)other).getTypeArguments().get(index)));
        return false;
    }

    @Override
    public int contentHashCode() {
        int res = this.getType().hashCode() * 31 + this.getConstructor().hashCode();
        for (Object value : this.getValueArguments()) {
            res = res * 31 + ((IrConstantValue)value).contentHashCode();
        }
        for (Object value : this.getTypeArguments()) {
            res = res * 31 + ((IrType)value).hashCode();
        }
        return res;
    }
}

