/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.linkage.IrProvider;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.DeclarationStubGenerator;
import org.jetbrains.kotlin.ir.util.SymbolTable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/util/ExternalDependenciesGenerator;", "", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "irProviders", "", "Lorg/jetbrains/kotlin/ir/linkage/IrProvider;", "(Lorg/jetbrains/kotlin/ir/util/SymbolTable;Ljava/util/List;)V", "generateUnboundSymbolsAsDependencies", "", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nExternalDependenciesGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalDependenciesGenerator.kt\norg/jetbrains/kotlin/ir/util/ExternalDependenciesGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n798#2,11:47\n1#3:58\n*S KotlinDebug\n*F\n+ 1 ExternalDependenciesGenerator.kt\norg/jetbrains/kotlin/ir/util/ExternalDependenciesGenerator\n*L\n29#1:47,11\n*E\n"})
public final class ExternalDependenciesGenerator {
    @NotNull
    private final SymbolTable symbolTable;
    @NotNull
    private final List<IrProvider> irProviders;

    public ExternalDependenciesGenerator(@NotNull SymbolTable symbolTable, @NotNull List<? extends IrProvider> irProviders) {
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter(irProviders, (String)"irProviders");
        this.symbolTable = symbolTable;
        this.irProviders = irProviders;
    }

    /*
     * WARNING - void declaration
     */
    public final void generateUnboundSymbolsAsDependencies() {
        Set<IrSymbol> prevUnbound;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.irProviders;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof DeclarationStubGenerator)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        DeclarationStubGenerator declarationStubGenerator = (DeclarationStubGenerator)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
        if (declarationStubGenerator != null) {
            DeclarationStubGenerator $this$generateUnboundSymbolsAsDependencies_u24lambda_u240 = declarationStubGenerator;
            boolean bl = false;
            $this$generateUnboundSymbolsAsDependencies_u24lambda_u240.setUnboundSymbolGeneration(true);
        }
        Set<IrSymbol> unbound = SetsKt.emptySet();
        do {
            prevUnbound = unbound;
            unbound = this.symbolTable.getDescriptorExtension().getAllUnboundSymbols();
            block2: for (IrSymbol symbol2 : unbound) {
                if (symbol2.isBound()) continue;
                for (IrProvider provider : (Iterable)this.irProviders) {
                    boolean bl = false;
                    IrDeclaration irDeclaration = provider.getDeclaration(symbol2);
                    if (irDeclaration == null) continue;
                    continue block2;
                }
            }
        } while (!Intrinsics.areEqual(unbound, prevUnbound));
    }
}

