/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaDocElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ParentAwareTokenSet;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBasicJavadocTypedHandler
extends TypedHandlerDelegate {
    private static final char START_TAG_SYMBOL = '<';
    private static final char CLOSE_TAG_SYMBOL = '>';
    private static final char SLASH = '/';
    private static final String COMMENT_PREFIX = "!--";

    protected AbstractBasicJavadocTypedHandler() {
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            AbstractBasicJavadocTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            AbstractBasicJavadocTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            AbstractBasicJavadocTypedHandler.$$$reportNull$$$0(2);
        }
        if (this.isJavaFile(file) && !this.insertClosingTagIfNecessary(c, project, editor, file)) {
            AbstractBasicJavadocTypedHandler.adjustStartTagIndent(c, editor, file);
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            AbstractBasicJavadocTypedHandler.$$$reportNull$$$0(3);
        }
        return result;
    }

    public abstract boolean isJavaFile(@Nullable PsiFile var1);

    private static void adjustStartTagIndent(char c, @NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement prev;
        int offset;
        PsiElement currElement;
        if (editor == null) {
            AbstractBasicJavadocTypedHandler.$$$reportNull$$$0(4);
        }
        if (file == null) {
            AbstractBasicJavadocTypedHandler.$$$reportNull$$$0(5);
        }
        if (c == '@' && (currElement = file.findElementAt(offset = editor.getCaretModel().getOffset())) instanceof PsiWhiteSpace && (prev = currElement.getPrevSibling()) != null && prev.getNode().getElementType() == JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS) {
            editor.getDocument().replaceString(currElement.getTextRange().getStartOffset(), offset - 1, (CharSequence)" ");
        }
    }

    private boolean insertClosingTagIfNecessary(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            AbstractBasicJavadocTypedHandler.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            AbstractBasicJavadocTypedHandler.$$$reportNull$$$0(7);
        }
        if (file == null) {
            AbstractBasicJavadocTypedHandler.$$$reportNull$$$0(8);
        }
        if (c != '>' || !CodeInsightSettings.getInstance().JAVADOC_GENERATE_CLOSING_TAG) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (!AbstractBasicJavadocTypedHandler.isAppropriatePlace(editor, file)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        String tagName = AbstractBasicJavadocTypedHandler.getTagName(document.getText(), offset);
        if (tagName == null || this.isSingleHtmlTag(tagName) || tagName.startsWith(COMMENT_PREFIX)) {
            return false;
        }
        document.insertString(offset, (CharSequence)(String.valueOf('<') + "/" + tagName + ">"));
        return true;
    }

    public abstract boolean isSingleHtmlTag(@NotNull String var1);

    @Nullable
    public static String getTagName(@NotNull CharSequence text, int afterTagOffset) {
        if (text == null) {
            AbstractBasicJavadocTypedHandler.$$$reportNull$$$0(9);
        }
        if (afterTagOffset > text.length()) {
            return null;
        }
        int endOffset = afterTagOffset - 1;
        if (endOffset > 0 && text.charAt(endOffset - 1) == '/') {
            return null;
        }
        for (int i = endOffset - 1; i >= 0; --i) {
            char c = text.charAt(i);
            switch (c) {
                case '\n': {
                    return null;
                }
                case '>': {
                    return null;
                }
                case '<': {
                    if (text.charAt(i + 1) == '/') {
                        return null;
                    }
                    return text.subSequence(i + 1, endOffset).toString();
                }
                case '\t': 
                case ' ': {
                    endOffset = i;
                }
            }
        }
        return null;
    }

    private static boolean isAppropriatePlace(Editor editor, PsiFile file) {
        PsiElement element;
        FileViewProvider provider = file.getViewProvider();
        int offset = editor.getCaretModel().getOffset();
        PsiElement elementAtCaret = offset < editor.getDocument().getTextLength() ? provider.findElementAt(offset) : provider.findElementAt(editor.getDocument().getTextLength() - 1);
        for (element = elementAtCaret; element instanceof PsiWhiteSpace || element != null && CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)element.getText()); element = element.getPrevSibling()) {
        }
        if (element == null) {
            return false;
        }
        ASTNode astNode = BasicJavaAstTreeUtil.toNode(element);
        if (BasicJavaAstTreeUtil.is(astNode, BasicJavaDocElementType.BASIC_DOC_PARAMETER_REF)) {
            astNode = astNode.getTreeParent();
        }
        if (BasicJavaAstTreeUtil.is(astNode, BasicJavaDocElementType.BASIC_DOC_TAG, BasicJavaDocElementType.BASIC_DOC_SNIPPET_TAG, BasicJavaDocElementType.BASIC_DOC_INLINE_TAG) && "param".equals(BasicJavaAstTreeUtil.getTagName(astNode)) && AbstractBasicJavadocTypedHandler.isTypeParamBracketClosedAfterParamTag(astNode, offset)) {
            return false;
        }
        if (BasicJavaAstTreeUtil.is(astNode, BasicJavaDocElementType.BASIC_DOC_INLINE_TAG, BasicJavaDocElementType.BASIC_DOC_SNIPPET_TAG) || BasicJavaAstTreeUtil.getParentOfType(astNode, ParentAwareTokenSet.create((IElementType[])new IElementType[]{BasicJavaDocElementType.BASIC_DOC_INLINE_TAG, BasicJavaDocElementType.BASIC_DOC_SNIPPET_TAG})) != null) {
            return false;
        }
        ASTNode node = element.getNode();
        return node != null && (JavaDocTokenType.ALL_JAVADOC_TOKENS.contains(node.getElementType()) || BasicJavaDocElementType.BASIC_ALL_JAVADOC_ELEMENTS.contains(node.getElementType()));
    }

    private static boolean isTypeParamBracketClosedAfterParamTag(ASTNode tag, int bracketOffset) {
        ASTNode paramToDocument = AbstractBasicJavadocTypedHandler.getDocumentingParameter(tag);
        if (paramToDocument == null) {
            return false;
        }
        TextRange paramRange = paramToDocument.getTextRange();
        return paramRange.getEndOffset() == bracketOffset;
    }

    @Nullable
    private static ASTNode getDocumentingParameter(@NotNull ASTNode tag) {
        if (tag == null) {
            AbstractBasicJavadocTypedHandler.$$$reportNull$$$0(10);
        }
        for (ASTNode element = tag.getFirstChildNode(); element != null; element = element.getTreeNext()) {
            if (!BasicJavaAstTreeUtil.is(element, BasicJavaDocElementType.BASIC_DOC_PARAMETER_REF)) continue;
            return element;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/AbstractBasicJavadocTypedHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/AbstractBasicJavadocTypedHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "adjustStartTagIndent";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "insertClosingTagIfNecessary";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTagName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentingParameter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

