/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.impl.PsiBuilderAdapter;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.java.lexer.BasicJavaLexer;
import com.intellij.lang.java.lexer.JavaDocLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.TokenList;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.ParsingDiagnostics;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaDocElementType;
import com.intellij.psi.impl.source.WhiteSpaceAndCommentSetHolder;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.indexing.IndexingDataKeys;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@ApiStatus.Experimental
public final class BasicJavaParserUtil {
    private static final Key<LanguageLevel> LANG_LEVEL_KEY = Key.create((String)"JavaParserUtil.LanguageLevel");
    private static final Key<Boolean> DEEP_PARSE_BLOCKS_IN_STATEMENTS = Key.create((String)"JavaParserUtil.ParserExtender");

    private BasicJavaParserUtil() {
    }

    public static void setLanguageLevel(PsiBuilder builder, LanguageLevel level) {
        builder.putUserData(LANG_LEVEL_KEY, (Object)level);
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(PsiBuilder builder) {
        LanguageLevel level = (LanguageLevel)((Object)builder.getUserData(LANG_LEVEL_KEY));
        assert (level != null) : builder;
        LanguageLevel languageLevel = level;
        if (languageLevel == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(0);
        }
        return languageLevel;
    }

    public static void setParseStatementCodeBlocksDeep(PsiBuilder builder, boolean deep) {
        builder.putUserData(DEEP_PARSE_BLOCKS_IN_STATEMENTS, (Object)deep);
    }

    public static boolean isParseStatementCodeBlocksDeep(PsiBuilder builder) {
        return Boolean.TRUE.equals(builder.getUserData(DEEP_PARSE_BLOCKS_IN_STATEMENTS));
    }

    public static void done(PsiBuilder.Marker marker, IElementType type, WhiteSpaceAndCommentSetHolder commentSetHolder) {
        marker.done(type);
        WhitespacesAndCommentsBinder left = commentSetHolder.getPrecedingCommentSet().contains(type) ? commentSetHolder.getPrecedingCommentBinder() : null;
        WhitespacesAndCommentsBinder right = commentSetHolder.getTrailingCommentSet().contains(type) ? commentSetHolder.getTrailingCommentBinder() : null;
        marker.setCustomEdgeTokenBinders(left, right);
    }

    @Nullable
    public static IElementType exprType(@Nullable PsiBuilder.Marker marker) {
        return marker != null ? ((LighterASTNode)marker).getTokenType() : null;
    }

    public static void error(PsiBuilder builder, @NotNull @NlsContexts.ParsingError String message) {
        if (message == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(1);
        }
        builder.mark().error(message);
    }

    public static void error(PsiBuilder builder, @NotNull @NlsContexts.ParsingError String message, @Nullable PsiBuilder.Marker before) {
        if (message == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(2);
        }
        if (before == null) {
            BasicJavaParserUtil.error(builder, message);
        } else {
            before.precede().errorBefore(message, before);
        }
    }

    public static boolean expectOrError(PsiBuilder builder, TokenSet expected, @PropertyKey(resourceBundle="messages.JavaPsiBundle") @PropertyKey(resourceBundle="messages.JavaPsiBundle") String key) {
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (TokenSet)expected)) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message(key, new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean expectOrError(PsiBuilder builder, IElementType expected, @PropertyKey(resourceBundle="messages.JavaPsiBundle") @PropertyKey(resourceBundle="messages.JavaPsiBundle") String key) {
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)expected)) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message(key, new Object[0]));
            return false;
        }
        return true;
    }

    public static void emptyElement(PsiBuilder builder, IElementType type) {
        builder.mark().done(type);
    }

    public static void emptyElement(PsiBuilder.Marker before, IElementType type) {
        before.precede().doneBefore(type, before);
    }

    public static void semicolon(PsiBuilder builder) {
        BasicJavaParserUtil.expectOrError(builder, JavaTokenType.SEMICOLON, "expected.semicolon");
    }

    public static PsiBuilder braceMatchingBuilder(PsiBuilder builder) {
        PsiBuilder.Marker pos = builder.mark();
        int braceCount = 1;
        while (!builder.eof()) {
            IElementType tokenType = builder.getTokenType();
            if (tokenType == JavaTokenType.LBRACE) {
                ++braceCount;
            } else if (tokenType == JavaTokenType.RBRACE) {
                --braceCount;
            }
            if (braceCount == 0) break;
            builder.advanceLexer();
        }
        int stopAt = builder.getCurrentOffset();
        pos.rollbackTo();
        return BasicJavaParserUtil.stoppingBuilder(builder, stopAt);
    }

    public static PsiBuilder stoppingBuilder(PsiBuilder builder, final int stopAt) {
        return new PsiBuilderAdapter(builder){

            public IElementType getTokenType() {
                return this.getCurrentOffset() < stopAt ? super.getTokenType() : null;
            }

            public boolean eof() {
                return this.getCurrentOffset() >= stopAt || super.eof();
            }
        };
    }

    public static PsiBuilder stoppingBuilder(final PsiBuilder builder, final Predicate<? super Pair<IElementType, String>> condition) {
        return new PsiBuilderAdapter(builder){

            public IElementType getTokenType() {
                Pair input = Pair.create((Object)builder.getTokenType(), (Object)builder.getTokenText());
                return condition.test(input) ? null : super.getTokenType();
            }

            public boolean eof() {
                Pair input = Pair.create((Object)builder.getTokenType(), (Object)builder.getTokenText());
                return condition.test(input) || super.eof();
            }
        };
    }

    @Nullable
    public static ASTNode parseFragment(ASTNode chameleon, ParserWrapper wrapper, Function<LanguageLevel, JavaDocLexer> javaDocLexer, Function<LanguageLevel, BasicJavaLexer> javaLexer) {
        return BasicJavaParserUtil.parseFragment(chameleon, wrapper, true, LanguageLevel.HIGHEST, javaDocLexer, javaLexer);
    }

    @Nullable
    public static ASTNode parseFragment(ASTNode chameleon, ParserWrapper wrapper, boolean eatAll, LanguageLevel level, Function<LanguageLevel, JavaDocLexer> javaDocLexer, Function<LanguageLevel, BasicJavaLexer> javaLexer) {
        PsiElement psi;
        PsiElement psiElement = psi = chameleon.getTreeParent() != null ? chameleon.getTreeParent().getPsi() : chameleon.getPsi();
        assert (psi != null) : chameleon;
        Project project = psi.getProject();
        PsiBuilderFactory factory = PsiBuilderFactory.getInstance();
        Lexer lexer = BasicJavaAstTreeUtil.is(chameleon, BasicJavaDocElementType.BASIC_DOC_COMMENT) ? (Lexer)javaDocLexer.apply(level) : (Lexer)javaLexer.apply(level);
        PsiBuilder builder = factory.createBuilder(project, chameleon, lexer, chameleon.getElementType().getLanguage(), chameleon.getChars());
        BasicJavaParserUtil.setLanguageLevel(builder, level);
        long startTime = System.nanoTime();
        PsiBuilder.Marker root = builder.mark();
        wrapper.parse(builder);
        if (!builder.eof()) {
            if (!eatAll) {
                throw new AssertionError((Object)("Unexpected token: '" + builder.getTokenText() + "'"));
            }
            PsiBuilder.Marker extras = builder.mark();
            while (!builder.eof()) {
                builder.advanceLexer();
            }
            extras.error(JavaPsiBundle.message("unexpected.tokens", new Object[0]));
        }
        root.done(chameleon.getElementType());
        ASTNode result = builder.getTreeBuilt().getFirstChildNode();
        ParsingDiagnostics.registerParse((PsiBuilder)builder, (Language)chameleon.getElementType().getLanguage(), (long)(System.nanoTime() - startTime));
        return result;
    }

    @NotNull
    public static PsiBuilder createBuilder(@NotNull ASTNode chameleon, @NotNull Function<PsiElement, LanguageLevel> languageLevelFunction, @NotNull Function<LanguageLevel, BasicJavaLexer> lexerFunction, @NotNull Function<PsiFile, TokenList> psiAsLexer) {
        CharSequence text;
        if (chameleon == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(3);
        }
        if (languageLevelFunction == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(4);
        }
        if (lexerFunction == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(5);
        }
        if (psiAsLexer == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(6);
        }
        PsiElement psi = chameleon.getPsi();
        assert (psi != null) : chameleon;
        Project project = psi.getProject();
        CharSequence indexedText = (CharSequence)psi.getUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY);
        if (TreeUtil.isCollapsedChameleon((ASTNode)chameleon)) {
            text = chameleon.getChars();
        } else {
            text = indexedText;
            if (text == null) {
                text = chameleon.getChars();
            }
        }
        LanguageLevel level = languageLevelFunction.apply(psi);
        Lexer lexer = psi instanceof PsiFile && indexedText != null ? psiAsLexer.apply((PsiFile)psi).asLexer() : (Lexer)lexerFunction.apply(level);
        Language language = psi.getLanguage();
        if (!language.isKindOf((Language)JavaLanguage.INSTANCE)) {
            language = JavaLanguage.INSTANCE;
        }
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, lexer, language, text);
        BasicJavaParserUtil.setLanguageLevel(builder, level);
        PsiBuilder psiBuilder = builder;
        if (psiBuilder == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(7);
        }
        return psiBuilder;
    }

    @NotNull
    public static PsiBuilder createBuilder(@NotNull LighterLazyParseableNode chameleon, @NotNull Function<PsiElement, LanguageLevel> languageLevelFunction, @NotNull Function<LanguageLevel, BasicJavaLexer> lexerFunction) {
        if (chameleon == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(8);
        }
        if (languageLevelFunction == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(9);
        }
        if (lexerFunction == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(10);
        }
        PsiFile psi = chameleon.getContainingFile();
        assert (psi != null) : chameleon;
        Project project = psi.getProject();
        PsiBuilderFactory factory = PsiBuilderFactory.getInstance();
        LanguageLevel level = languageLevelFunction.apply((PsiElement)psi);
        Lexer lexer = (Lexer)lexerFunction.apply(level);
        PsiBuilder builder = factory.createBuilder(project, chameleon, lexer, chameleon.getTokenType().getLanguage(), chameleon.getText());
        BasicJavaParserUtil.setLanguageLevel(builder, level);
        PsiBuilder psiBuilder = builder;
        if (psiBuilder == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(11);
        }
        return psiBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/parser/BasicJavaParserUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chameleon";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevelFunction";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexerFunction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAsLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/parser/BasicJavaParserUtil";
                break;
            }
            case 7: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface ParserWrapper {
        public void parse(PsiBuilder var1);
    }
}

