/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.runtime.repository.impl;

import com.intellij.platform.runtime.repository.IncludedRuntimeModule;
import com.intellij.platform.runtime.repository.ModuleImportance;
import com.intellij.platform.runtime.repository.ProductMode;
import com.intellij.platform.runtime.repository.RuntimeModuleDescriptor;
import com.intellij.platform.runtime.repository.RuntimeModuleGroup;
import com.intellij.platform.runtime.repository.RuntimeModuleId;
import com.intellij.platform.runtime.repository.RuntimeModuleRepository;
import com.intellij.platform.runtime.repository.impl.IncludedRuntimeModuleImpl;
import com.intellij.platform.runtime.repository.impl.ProductModeMatcher;
import com.intellij.platform.runtime.repository.serialization.RawIncludedRuntimeModule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class MainRuntimeModuleGroup
implements RuntimeModuleGroup {
    @NotNull
    private final List<RawIncludedRuntimeModule> myRawRootModules;
    private final ProductMode myProductMode;
    private final RuntimeModuleRepository myRepository;
    private volatile List<IncludedRuntimeModule> myIncludedModules;

    public MainRuntimeModuleGroup(@NotNull List<RawIncludedRuntimeModule> rawRootModules, @NotNull ProductMode currentMode, @NotNull RuntimeModuleRepository repository) {
        if (rawRootModules == null) {
            MainRuntimeModuleGroup.$$$reportNull$$$0(0);
        }
        if (currentMode == null) {
            MainRuntimeModuleGroup.$$$reportNull$$$0(1);
        }
        if (repository == null) {
            MainRuntimeModuleGroup.$$$reportNull$$$0(2);
        }
        this.myRawRootModules = rawRootModules;
        this.myProductMode = currentMode;
        this.myRepository = repository;
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull RuntimeModuleId> getOptionalModuleIds() {
        Set<RuntimeModuleId> set = this.myRawRootModules.stream().filter(it -> it.getImportance().equals((Object)ModuleImportance.OPTIONAL)).map(RawIncludedRuntimeModule::getModuleId).collect(Collectors.toSet());
        if (set == null) {
            MainRuntimeModuleGroup.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull IncludedRuntimeModule> getIncludedModules() {
        if (this.myIncludedModules == null) {
            this.myIncludedModules = this.computeIncludedModules();
        }
        List<IncludedRuntimeModule> list = this.myIncludedModules;
        if (list == null) {
            MainRuntimeModuleGroup.$$$reportNull$$$0(4);
        }
        return list;
    }

    private List<IncludedRuntimeModule> computeIncludedModules() {
        ArrayList<IncludedRuntimeModule> rootIncludedModules = new ArrayList<IncludedRuntimeModule>();
        HashSet<RuntimeModuleDescriptor> rootModules = new HashSet<RuntimeModuleDescriptor>();
        ProductModeMatcher matcher = new ProductModeMatcher(this.myProductMode);
        for (RawIncludedRuntimeModule rawRootModule : this.myRawRootModules) {
            IncludedRuntimeModule included = rawRootModule.resolve(this.myRepository);
            if (included == null || !matcher.matches(included.getModuleDescriptor())) continue;
            rootIncludedModules.add(included);
            rootModules.add(included.getModuleDescriptor());
        }
        ArrayList<IncludedRuntimeModule> result = new ArrayList<IncludedRuntimeModule>(rootIncludedModules);
        HashSet<RuntimeModuleDescriptor> visited = new HashSet<RuntimeModuleDescriptor>();
        for (IncludedRuntimeModule rootModule : rootIncludedModules) {
            MainRuntimeModuleGroup.collectDependencies(rootModule.getModuleDescriptor(), rootModules, visited, result);
        }
        return result;
    }

    private static void collectDependencies(RuntimeModuleDescriptor descriptor, Set<RuntimeModuleDescriptor> rootModules, Set<RuntimeModuleDescriptor> visited, List<IncludedRuntimeModule> result) {
        for (RuntimeModuleDescriptor dependency : descriptor.getDependencies()) {
            if (!visited.add(dependency)) continue;
            if (!rootModules.contains(dependency)) {
                result.add(new IncludedRuntimeModuleImpl(dependency, ModuleImportance.SERVICE));
            }
            MainRuntimeModuleGroup.collectDependencies(dependency, rootModules, visited, result);
        }
    }

    public String toString() {
        return "MainRuntimeModuleGroup{rootModules=" + this.myRawRootModules + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawRootModules";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentMode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/runtime/repository/impl/MainRuntimeModuleGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/runtime/repository/impl/MainRuntimeModuleGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionalModuleIds";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

