/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.runtime.repository.serialization;

import com.intellij.platform.runtime.repository.MalformedRepositoryException;
import com.intellij.platform.runtime.repository.ProductMode;
import com.intellij.platform.runtime.repository.ProductModules;
import com.intellij.platform.runtime.repository.RuntimeModuleRepository;
import com.intellij.platform.runtime.repository.serialization.RawRuntimeModuleDescriptor;
import com.intellij.platform.runtime.repository.serialization.RawRuntimeModuleRepositoryData;
import com.intellij.platform.runtime.repository.serialization.impl.JarFileSerializer;
import com.intellij.platform.runtime.repository.serialization.impl.ProductModulesXmlLoader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RuntimeModuleRepositorySerialization {
    private RuntimeModuleRepositorySerialization() {
    }

    public static void saveToJar(@NotNull Collection<RawRuntimeModuleDescriptor> descriptors, @Nullable String bootstrapModuleName, @NotNull Path jarPath, int generatorVersion) throws IOException {
        if (descriptors == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(0);
        }
        if (jarPath == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(1);
        }
        RuntimeModuleRepositorySerialization.saveToJar(descriptors, bootstrapModuleName, jarPath, null, generatorVersion);
    }

    public static void saveToJar(@NotNull Collection<RawRuntimeModuleDescriptor> descriptors, @Nullable String bootstrapModuleName, @NotNull Path jarPath, @Nullable String mainPluginModuleId, int generatorVersion) throws IOException {
        if (descriptors == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(2);
        }
        if (jarPath == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(3);
        }
        try {
            JarFileSerializer.saveToJar(descriptors, bootstrapModuleName, jarPath, mainPluginModuleId, generatorVersion);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @NotNull
    public static RawRuntimeModuleRepositoryData loadFromJar(@NotNull Path jarPath) throws MalformedRepositoryException {
        RawRuntimeModuleRepositoryData rawRuntimeModuleRepositoryData;
        if (jarPath == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(4);
        }
        try {
            rawRuntimeModuleRepositoryData = JarFileSerializer.loadFromJar(jarPath);
        }
        catch (IOException | XMLStreamException e) {
            throw new MalformedRepositoryException("Failed to load repository from " + jarPath, e);
        }
        if (rawRuntimeModuleRepositoryData == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(5);
        }
        return rawRuntimeModuleRepositoryData;
    }

    @NotNull
    public static ProductModules loadProductModules(@NotNull Path xmlFile, @NotNull ProductMode currentMode, @NotNull RuntimeModuleRepository repository) {
        if (xmlFile == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(6);
        }
        if (currentMode == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(7);
        }
        if (repository == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(8);
        }
        try {
            return RuntimeModuleRepositorySerialization.loadProductModules(Files.newInputStream(xmlFile, new OpenOption[0]), xmlFile.toString(), currentMode, repository);
        }
        catch (IOException e) {
            throw new MalformedRepositoryException("Failed to load module group from " + xmlFile, e);
        }
    }

    @NotNull
    public static ProductModules loadProductModules(@NotNull InputStream inputStream, @NotNull String filePath, @NotNull ProductMode currentMode, @NotNull RuntimeModuleRepository repository) {
        ProductModules productModules;
        if (inputStream == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(9);
        }
        if (filePath == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(10);
        }
        if (currentMode == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(11);
        }
        if (repository == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(12);
        }
        try {
            productModules = ProductModulesXmlLoader.parseModuleXml(inputStream, filePath, currentMode, repository);
        }
        catch (XMLStreamException e) {
            throw new MalformedRepositoryException("Failed to load module group from " + filePath, e);
        }
        if (productModules == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(13);
        }
        return productModules;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarPath";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/runtime/repository/serialization/RuntimeModuleRepositorySerialization";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentMode";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/runtime/repository/serialization/RuntimeModuleRepositorySerialization";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFromJar";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "loadProductModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "saveToJar";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadFromJar";
                break;
            }
            case 5: 
            case 13: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadProductModules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

