/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parcelize.serializers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.parcelize.serializers.Method;
import org.jetbrains.kotlin.parcelize.serializers.ParcelSerializer;
import org.jetbrains.kotlin.parcelize.serializers.ParcelSerializersKt;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0010\u0018\u0000 \u00122\u00020\u0001:\u0004\u0010\u0011\u0012\u0013B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/parcelize/serializers/PrimitiveTypeParcelSerializer;", "Lorg/jetbrains/kotlin/parcelize/serializers/ParcelSerializer;", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Lorg/jetbrains/org/objectweb/asm/Type;)V", "getAsmType", "()Lorg/jetbrains/org/objectweb/asm/Type;", "readMethod", "Lorg/jetbrains/kotlin/parcelize/serializers/Method;", "", "writeMethod", "readValue", "", "v", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "writeValue", "BooleanParcelSerializer", "CharParcelSerializer", "Companion", "ShortParcelSerializer", "parcelize.k1"})
@SourceDebugExtension(value={"SMAP\nParcelSerializers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParcelSerializers.kt\norg/jetbrains/kotlin/parcelize/serializers/PrimitiveTypeParcelSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,838:1\n1547#2:839\n1618#2,3:840\n*S KotlinDebug\n*F\n+ 1 ParcelSerializers.kt\norg/jetbrains/kotlin/parcelize/serializers/PrimitiveTypeParcelSerializer\n*L\n712#1:839\n712#1:840,3\n*E\n"})
public class PrimitiveTypeParcelSerializer
implements ParcelSerializer {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Type asmType;
    @NotNull
    private final Method<String> writeMethod;
    @NotNull
    private final Method<String> readMethod;
    @NotNull
    private static final Map<Type, Method<String>> WRITE_METHOD_NAMES;
    @NotNull
    private static final Map<Type, Method<String>> READ_METHOD_NAMES;
    @NotNull
    private static final Map<Type, PrimitiveTypeParcelSerializer> INSTANCES;

    private PrimitiveTypeParcelSerializer(Type asmType) {
        this.asmType = asmType;
        Method<String> method = WRITE_METHOD_NAMES.get(this.asmType);
        if (method == null) {
            throw new IllegalStateException(("Write method not found for " + this.asmType).toString());
        }
        this.writeMethod = method;
        Method<String> method2 = READ_METHOD_NAMES.get(this.asmType);
        if (method2 == null) {
            throw new IllegalStateException(("Read method not found for " + this.asmType).toString());
        }
        this.readMethod = method2;
    }

    @Override
    @NotNull
    public final Type getAsmType() {
        return this.asmType;
    }

    @Override
    public void writeValue(@NotNull InstructionAdapter v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        v.invokevirtual(ParcelSerializersKt.getPARCEL_TYPE().getInternalName(), this.writeMethod.getName(), this.writeMethod.getSignature(), false);
    }

    @Override
    public void readValue(@NotNull InstructionAdapter v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        v.invokevirtual(ParcelSerializersKt.getPARCEL_TYPE().getInternalName(), this.readMethod.getName(), this.readMethod.getSignature(), false);
    }

    public /* synthetic */ PrimitiveTypeParcelSerializer(Type asmType, DefaultConstructorMarker $constructor_marker) {
        this(asmType);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Type.BOOLEAN_TYPE, new Method<String>("writeInt", "(I)V")), TuplesKt.to((Object)Type.CHAR_TYPE, new Method<String>("writeInt", "(I)V")), TuplesKt.to((Object)Type.BYTE_TYPE, new Method<String>("writeByte", "(B)V")), TuplesKt.to((Object)Type.SHORT_TYPE, new Method<String>("writeInt", "(I)V")), TuplesKt.to((Object)Type.INT_TYPE, new Method<String>("writeInt", "(I)V")), TuplesKt.to((Object)Type.FLOAT_TYPE, new Method<String>("writeFloat", "(F)V")), TuplesKt.to((Object)Type.LONG_TYPE, new Method<String>("writeLong", "(J)V")), TuplesKt.to((Object)Type.DOUBLE_TYPE, new Method<String>("writeDouble", "(D)V"))};
        WRITE_METHOD_NAMES = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)Type.BOOLEAN_TYPE, new Method<String>("readInt", "()I")), TuplesKt.to((Object)Type.CHAR_TYPE, new Method<String>("readInt", "()I")), TuplesKt.to((Object)Type.BYTE_TYPE, new Method<String>("readByte", "()B")), TuplesKt.to((Object)Type.SHORT_TYPE, new Method<String>("readInt", "()I")), TuplesKt.to((Object)Type.INT_TYPE, new Method<String>("readInt", "()I")), TuplesKt.to((Object)Type.FLOAT_TYPE, new Method<String>("readFloat", "()F")), TuplesKt.to((Object)Type.LONG_TYPE, new Method<String>("readLong", "()J")), TuplesKt.to((Object)Type.DOUBLE_TYPE, new Method<String>("readDouble", "()D"))};
        READ_METHOD_NAMES = MapsKt.mapOf((Pair[])pairArray);
        Iterable $this$map$iv = READ_METHOD_NAMES.keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PrimitiveTypeParcelSerializer primitiveTypeParcelSerializer;
            void it;
            Type type = (Type)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var9_9 = it;
            if (Intrinsics.areEqual((Object)var9_9, (Object)Type.CHAR_TYPE)) {
                primitiveTypeParcelSerializer = CharParcelSerializer.INSTANCE;
            } else if (Intrinsics.areEqual((Object)var9_9, (Object)Type.SHORT_TYPE)) {
                primitiveTypeParcelSerializer = ShortParcelSerializer.INSTANCE;
            } else if (Intrinsics.areEqual((Object)var9_9, (Object)Type.BOOLEAN_TYPE)) {
                primitiveTypeParcelSerializer = BooleanParcelSerializer.INSTANCE;
            } else {
                Intrinsics.checkNotNull((Object)it);
                primitiveTypeParcelSerializer = new PrimitiveTypeParcelSerializer((Type)it);
            }
            collection.add(TuplesKt.to((Object)it, (Object)primitiveTypeParcelSerializer));
        }
        INSTANCES = MapsKt.toMap((Iterable)((List)var3_3));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/parcelize/serializers/PrimitiveTypeParcelSerializer$BooleanParcelSerializer;", "Lorg/jetbrains/kotlin/parcelize/serializers/PrimitiveTypeParcelSerializer;", "()V", "readValue", "", "v", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "parcelize.k1"})
    public static final class BooleanParcelSerializer
    extends PrimitiveTypeParcelSerializer {
        @NotNull
        public static final BooleanParcelSerializer INSTANCE = new BooleanParcelSerializer();

        private BooleanParcelSerializer() {
            Type type = Type.BOOLEAN_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"BOOLEAN_TYPE");
            super(type, null);
        }

        @Override
        public void readValue(@NotNull InstructionAdapter v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            super.readValue(v);
            Label falseLabel = new Label();
            Label conditionIsOver = new Label();
            v.ifeq(falseLabel);
            v.iconst(1);
            v.goTo(conditionIsOver);
            v.visitLabel(falseLabel);
            v.iconst(0);
            v.visitLabel(conditionIsOver);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/parcelize/serializers/PrimitiveTypeParcelSerializer$CharParcelSerializer;", "Lorg/jetbrains/kotlin/parcelize/serializers/PrimitiveTypeParcelSerializer;", "()V", "readValue", "", "v", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "writeValue", "parcelize.k1"})
    public static final class CharParcelSerializer
    extends PrimitiveTypeParcelSerializer {
        @NotNull
        public static final CharParcelSerializer INSTANCE = new CharParcelSerializer();

        private CharParcelSerializer() {
            Type type = Type.CHAR_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"CHAR_TYPE");
            super(type, null);
        }

        @Override
        public void writeValue(@NotNull InstructionAdapter v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            v.cast(Type.CHAR_TYPE, Type.INT_TYPE);
            super.writeValue(v);
        }

        @Override
        public void readValue(@NotNull InstructionAdapter v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            super.readValue(v);
            v.cast(Type.INT_TYPE, Type.CHAR_TYPE);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0005R\"\u0010\u0003\u001a\u0016\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u001c\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000b\u001a\u001c\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/parcelize/serializers/PrimitiveTypeParcelSerializer$Companion;", "", "()V", "INSTANCES", "", "Lorg/jetbrains/org/objectweb/asm/Type;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/parcelize/serializers/PrimitiveTypeParcelSerializer;", "READ_METHOD_NAMES", "Lorg/jetbrains/kotlin/parcelize/serializers/Method;", "", "WRITE_METHOD_NAMES", "getInstance", "type", "parcelize.k1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PrimitiveTypeParcelSerializer getInstance(@NotNull Type type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            PrimitiveTypeParcelSerializer primitiveTypeParcelSerializer = (PrimitiveTypeParcelSerializer)INSTANCES.get(type);
            if (primitiveTypeParcelSerializer == null) {
                throw new IllegalStateException(("Unsupported type " + type.getDescriptor()).toString());
            }
            return primitiveTypeParcelSerializer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/parcelize/serializers/PrimitiveTypeParcelSerializer$ShortParcelSerializer;", "Lorg/jetbrains/kotlin/parcelize/serializers/PrimitiveTypeParcelSerializer;", "()V", "readValue", "", "v", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "writeValue", "parcelize.k1"})
    public static final class ShortParcelSerializer
    extends PrimitiveTypeParcelSerializer {
        @NotNull
        public static final ShortParcelSerializer INSTANCE = new ShortParcelSerializer();

        private ShortParcelSerializer() {
            Type type = Type.SHORT_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"SHORT_TYPE");
            super(type, null);
        }

        @Override
        public void writeValue(@NotNull InstructionAdapter v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            v.cast(Type.SHORT_TYPE, Type.INT_TYPE);
            super.writeValue(v);
        }

        @Override
        public void readValue(@NotNull InstructionAdapter v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            super.readValue(v);
            v.cast(Type.INT_TYPE, Type.SHORT_TYPE);
        }
    }
}

