/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.internal.daemon;

import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.gradle.api.internal.file.DefaultFileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.api.internal.file.collections.DefaultDirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.tasks.DefaultTaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.api.tasks.util.internal.PatternSets;
import org.gradle.api.tasks.util.internal.PatternSpecFactory;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.Factory;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.configuration.BuildLayoutResult;
import org.gradle.launcher.daemon.client.DaemonClientFactory;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

public abstract class DaemonAction {
    private final String myServiceDirectoryPath;

    public DaemonAction(String serviceDirectoryPath) {
        this.myServiceDirectoryPath = serviceDirectoryPath;
    }

    protected ServiceRegistry getDaemonServices(DaemonClientFactory daemonClientFactory) {
        BuildLayoutParameters layout = new BuildLayoutParameters();
        if (this.myServiceDirectoryPath != null && !this.myServiceDirectoryPath.isEmpty()) {
            layout.setGradleUserHomeDir(new File(this.myServiceDirectoryPath));
        }
        DaemonParameters daemonParameters = DaemonAction.getDaemonParameters(layout);
        return daemonClientFactory.createBuildClientServices(new OutputEventListener(){

            public void onOutput(OutputEvent event) {
            }
        }, daemonParameters, (InputStream)new ByteArrayInputStream(new byte[0]));
    }

    @NotNull
    protected static DaemonParameters getDaemonParameters(BuildLayoutParameters layout) {
        if (GradleVersionUtil.isCurrentGradleAtLeast((String)"6.6")) {
            DaemonParameters daemonParameters = DaemonAction.daemonParameters6Dot6(layout);
            if (daemonParameters == null) {
                DaemonAction.$$$reportNull$$$0(0);
            }
            return daemonParameters;
        }
        if (GradleVersionUtil.isCurrentGradleAtLeast((String)"6.4")) {
            DaemonParameters daemonParameters = DaemonAction.daemonParameters6Dot4(layout);
            if (daemonParameters == null) {
                DaemonAction.$$$reportNull$$$0(1);
            }
            return daemonParameters;
        }
        if (GradleVersionUtil.isCurrentGradleAtLeast((String)"6.3")) {
            DaemonParameters daemonParameters = DaemonAction.daemonParameters6Dot3(layout);
            if (daemonParameters == null) {
                DaemonAction.$$$reportNull$$$0(2);
            }
            return daemonParameters;
        }
        if (GradleVersionUtil.isCurrentGradleAtLeast((String)"6.0")) {
            DaemonParameters daemonParameters = DaemonAction.daemonParameters6Dot0(layout);
            if (daemonParameters == null) {
                DaemonAction.$$$reportNull$$$0(3);
            }
            return daemonParameters;
        }
        if (GradleVersionUtil.isCurrentGradleAtLeast((String)"5.3")) {
            DaemonParameters daemonParameters = DaemonAction.daemonParameters5Dot3(layout);
            if (daemonParameters == null) {
                DaemonAction.$$$reportNull$$$0(4);
            }
            return daemonParameters;
        }
        DaemonParameters daemonParameters = DaemonAction.daemonParametersPre5Dot3(layout);
        if (daemonParameters == null) {
            DaemonAction.$$$reportNull$$$0(5);
        }
        return daemonParameters;
    }

    private static DaemonParameters daemonParameters6Dot6(BuildLayoutParameters layout) {
        try {
            ClassLoader classLoader = DaemonAction.class.getClassLoader();
            Class<?> resultClass = classLoader.loadClass("org.gradle.launcher.cli.converter.BuildLayoutConverter$Result");
            Constructor<?> resultConstructor = resultClass.getConstructor(layout.getClass());
            resultConstructor.setAccessible(true);
            BuildLayoutResult buildLayoutResult = (BuildLayoutResult)resultConstructor.newInstance(layout);
            resultConstructor.setAccessible(false);
            Factory patternSetFactory = PatternSets.getPatternSetFactory((PatternSpecFactory)PatternSpecFactory.INSTANCE);
            IdentityFileResolver identityFileResolver = (IdentityFileResolver)IdentityFileResolver.class.getConstructor(new Class[0]).newInstance(new Object[0]);
            DefaultFileCollectionFactory collectionFactory = DaemonAction.createCollectionFactory6Dot3(identityFileResolver, (Factory<PatternSet>)patternSetFactory);
            return (DaemonParameters)DaemonParameters.class.getConstructor(BuildLayoutResult.class, FileCollectionFactory.class).newInstance(buildLayoutResult, collectionFactory);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot create DaemonParameters by reflection, gradle version " + GradleVersion.current(), e);
        }
    }

    private static DaemonParameters daemonParameters6Dot4(BuildLayoutParameters layout) {
        try {
            Factory patternSetFactory = PatternSets.getPatternSetFactory((PatternSpecFactory)PatternSpecFactory.INSTANCE);
            IdentityFileResolver identityFileResolver = (IdentityFileResolver)IdentityFileResolver.class.getConstructor(new Class[0]).newInstance(new Object[0]);
            DefaultFileCollectionFactory collectionFactory = DaemonAction.createCollectionFactory6Dot3(identityFileResolver, (Factory<PatternSet>)patternSetFactory);
            return (DaemonParameters)DaemonParameters.class.getConstructor(BuildLayoutParameters.class, FileCollectionFactory.class).newInstance(layout, collectionFactory);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot create DaemonParameters by reflection, gradle version " + GradleVersion.current(), e);
        }
    }

    private static DaemonParameters daemonParameters6Dot3(BuildLayoutParameters layout) {
        try {
            Factory patternSetFactory = PatternSets.getPatternSetFactory((PatternSpecFactory)PatternSpecFactory.INSTANCE);
            IdentityFileResolver identityFileResolver = (IdentityFileResolver)IdentityFileResolver.class.getConstructor(Factory.class).newInstance(patternSetFactory);
            DefaultFileCollectionFactory collectionFactory = DaemonAction.createCollectionFactory6Dot3(identityFileResolver, (Factory<PatternSet>)patternSetFactory);
            return (DaemonParameters)DaemonParameters.class.getConstructor(BuildLayoutParameters.class, FileCollectionFactory.class).newInstance(layout, collectionFactory);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot create DaemonParameters by reflection, gradle version " + GradleVersion.current(), e);
        }
    }

    private static DefaultFileCollectionFactory createCollectionFactory6Dot3(IdentityFileResolver fileResolver, Factory<PatternSet> patternFactory) throws ClassNotFoundException, NoSuchFieldException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        ClassLoader classLoader = DaemonAction.class.getClassLoader();
        Class<?> propertyHostClass = classLoader.loadClass("org.gradle.api.internal.provider.PropertyHost");
        Object propertyHostNoOp = propertyHostClass.getField("NO_OP").get(null);
        Constructor collectionFactoryConstructor = DefaultFileCollectionFactory.class.getConstructor(PathToFileResolver.class, TaskDependencyFactory.class, DirectoryFileTreeFactory.class, Factory.class, propertyHostClass, FileSystem.class);
        return (DefaultFileCollectionFactory)collectionFactoryConstructor.newInstance(fileResolver, DefaultTaskDependencyFactory.withNoAssociatedProject(), new DefaultDirectoryFileTreeFactory(), patternFactory, propertyHostNoOp, null);
    }

    private static DaemonParameters daemonParameters6Dot0(BuildLayoutParameters layout) {
        try {
            Factory patternSetFactory = PatternSets.getPatternSetFactory((PatternSpecFactory)PatternSpecFactory.INSTANCE);
            IdentityFileResolver identityFileResolver = (IdentityFileResolver)IdentityFileResolver.class.getConstructor(Factory.class).newInstance(patternSetFactory);
            Constructor collectionFactoryConstructor = DefaultFileCollectionFactory.class.getConstructor(PathToFileResolver.class, TaskDependencyFactory.class, DirectoryFileTreeFactory.class, Factory.class);
            DefaultFileCollectionFactory factory = (DefaultFileCollectionFactory)collectionFactoryConstructor.newInstance(identityFileResolver, DefaultTaskDependencyFactory.withNoAssociatedProject(), new DefaultDirectoryFileTreeFactory(), patternSetFactory);
            return (DaemonParameters)DaemonParameters.class.getConstructor(BuildLayoutParameters.class, FileCollectionFactory.class).newInstance(layout, factory);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot create DaemonParameters by reflection, gradle version " + GradleVersion.current(), e);
        }
    }

    private static DaemonParameters daemonParameters5Dot3(BuildLayoutParameters layout) {
        try {
            return (DaemonParameters)DaemonParameters.class.getConstructor(BuildLayoutParameters.class, FileCollectionFactory.class).newInstance(layout, DefaultFileCollectionFactory.class.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot create DaemonParameters by reflection, gradle version " + GradleVersion.current(), e);
        }
    }

    private static DaemonParameters daemonParametersPre5Dot3(BuildLayoutParameters layout) {
        try {
            return (DaemonParameters)DaemonParameters.class.getConstructor(BuildLayoutParameters.class).newInstance(layout);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot create DaemonParameters by reflection, gradle version " + GradleVersion.current(), e);
        }
    }

    @NotNull
    protected static <T> T createCommand(Class<T> commandClass, Object id, byte[] token) {
        Object obj;
        try {
            obj = commandClass.getConstructors()[0].newInstance(id, token);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (obj == null) {
            DaemonAction.$$$reportNull$$$0(6);
        }
        return (T)obj;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/gradle/internal/daemon/DaemonAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDaemonParameters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommand";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

