/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.internal.daemon;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.table.TableView;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleConnectorService;
import org.jetbrains.plugins.gradle.internal.daemon.DaemonState;
import org.jetbrains.plugins.gradle.internal.daemon.GradleDaemonServices;
import org.jetbrains.plugins.gradle.statistics.GradleActionsUsagesCollector;
import org.jetbrains.plugins.gradle.util.GradleBundle;

public class DaemonsUi
implements Disposable {
    private final Project myProject;
    private final TableView<DaemonState> myTable;
    private final ListTableModel<DaemonState> myTableModel;
    private final RefreshAction myRefreshAction;
    private final StopAllAction myStopAllAction;
    private final StopWhenIdleAllAction myStopWhenIdleAllAction;
    private final StopSelectedAction myStopSelectedAction;
    private final JTextArea myDescriptionLabel;
    private final JBLoadingPanel myContent;
    private MyDialogWrapper myDialog;
    private boolean myShowStopped;

    public DaemonsUi(Project project) {
        this.myProject = project;
        this.myRefreshAction = new RefreshAction();
        this.myStopWhenIdleAllAction = new StopWhenIdleAllAction();
        this.myStopAllAction = new StopAllAction();
        this.myStopSelectedAction = new StopSelectedAction();
        this.myContent = new JBLoadingPanel((LayoutManager)new BorderLayout(10, 4), (Disposable)this.myProject);
        this.myTable = new TableView(this.createListModel());
        this.myTableModel = this.myTable.getListTableModel();
        this.myDescriptionLabel = new JTextArea(6, 50);
        this.myDescriptionLabel.setWrapStyleWord(true);
        this.myDescriptionLabel.setLineWrap(true);
        this.myDescriptionLabel.setEditable(false);
        JScrollPane label = ScrollPaneFactory.createScrollPane((Component)this.myDescriptionLabel);
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.add((Component)label, "Center");
        JBCheckBox showStoppedCb = new JBCheckBox(GradleBundle.message("gradle.daemons.show.stopped", new Object[0]));
        showStoppedCb.addActionListener(e -> {
            if (this.myShowStopped != showStoppedCb.isSelected()) {
                this.myShowStopped = showStoppedCb.isSelected();
                this.updateDaemonsList();
            }
        });
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)showStoppedCb);
        descriptionPanel.add((Component)showStoppedCb, "South");
        descriptionPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)GradleBundle.message("gradle.daemons.description.title", new Object[0]), (boolean)false));
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e.getValueIsAdjusting()) {
                    return;
                }
                DaemonState daemonState = (DaemonState)DaemonsUi.this.myTable.getSelectedObject();
                if (daemonState != null) {
                    String desc = daemonState.getDescription();
                    DaemonsUi.this.myDescriptionLabel.setText(desc);
                    DaemonsUi.this.myDescriptionLabel.setCaretPosition(0);
                } else {
                    DaemonsUi.this.myDescriptionLabel.setText(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/gradle/internal/daemon/DaemonsUi$1", "valueChanged"));
            }
        });
        this.myContent.add((Component)ScrollPaneFactory.createScrollPane(this.myTable), (Object)"Center");
        this.myContent.add((Component)descriptionPanel, (Object)"South");
    }

    public void dispose() {
    }

    public void show() {
        this.myDialog = new MyDialogWrapper();
        this.myDialog.show();
        this.updateDaemonsList();
    }

    private void updateDaemonsList() {
        Runnable updateDaemons = () -> {
            Set<String> gradleUserHomes = GradleConnectorService.getKnownGradleUserHomes(this.myProject);
            List daemonStateList = ContainerUtil.filter(GradleDaemonServices.getDaemonsStatus(gradleUserHomes), state -> this.myShowStopped || state.getToken() != null);
            ApplicationManager.getApplication().invokeLater(() -> {
                this.myTableModel.setItems(daemonStateList);
                this.myContent.stopLoading();
                this.invalidateActions();
            });
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.myContent.startLoading();
            ApplicationManager.getApplication().executeOnPooledThread(updateDaemons);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                this.myContent.startLoading();
                ApplicationManager.getApplication().executeOnPooledThread(updateDaemons);
            });
        }
    }

    private void invalidateActions() {
        if (this.myDialog != null) {
            this.myDialog.invalidateActions();
        }
    }

    protected ListTableModel<DaemonState> createListModel() {
        TableColumn pidColumn = new TableColumn(GradleBundle.message("column.name.daemon.PID", new Object[0]), 80){

            @Nullable
            public String valueOf(DaemonState daemonState) {
                return String.valueOf(daemonState.getPid());
            }

            @Nullable
            public Comparator<DaemonState> getComparator() {
                return Comparator.comparing(DaemonState::getPid);
            }
        };
        TableColumn statusColumn = new TableColumn(GradleBundle.message("column.name.daemon.status", new Object[0]), 100){

            @Nullable
            public String valueOf(DaemonState daemonState) {
                return daemonState.getStatus();
            }

            @Nullable
            public Comparator<DaemonState> getComparator() {
                return Comparator.comparing(DaemonState::getStatus);
            }
        };
        TableColumn timeColumn = new TableColumn(GradleBundle.message("column.name.daemon.timestamp", new Object[0]), 150){

            @NotNull
            public String valueOf(DaemonState daemonState) {
                String string2 = DateFormatUtil.formatPrettyDateTime((long)daemonState.getTimestamp());
                if (string2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                return string2;
            }

            @Nullable
            public Comparator<DaemonState> getComparator() {
                return Comparator.comparing(DaemonState::getTimestamp);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/internal/daemon/DaemonsUi$4", "valueOf"));
            }
        };
        TableColumn infoColumn = new TableColumn(GradleBundle.message("column.name.daemon.info", new Object[0]), -1){

            @NotNull
            public String valueOf(DaemonState daemonState) {
                String string2 = daemonState.getVersion() != null ? daemonState.getVersion() : StringUtil.capitalize((String)daemonState.getReason());
                if (string2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                return string2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/internal/daemon/DaemonsUi$5", "valueOf"));
            }
        };
        ColumnInfo[] columnInfos = new ColumnInfo[]{pidColumn, statusColumn, infoColumn, timeColumn};
        return new ListTableModel(columnInfos, new ArrayList(), 3, SortOrder.DESCENDING);
    }

    private class RefreshAction
    extends AbstractAction {
        RefreshAction() {
            super(GradleBundle.message("gradle.daemons.refresh", new Object[0]), AllIcons.Actions.Refresh);
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            if (e == null) {
                RefreshAction.$$$reportNull$$$0(0);
            }
            GradleActionsUsagesCollector.trigger(DaemonsUi.this.myProject, GradleActionsUsagesCollector.REFRESH_DAEMONS);
            DaemonsUi.this.updateDaemonsList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/gradle/internal/daemon/DaemonsUi$RefreshAction", "actionPerformed"));
        }
    }

    private class StopWhenIdleAllAction
    extends AbstractAction {
        StopWhenIdleAllAction() {
            super(GradleBundle.message("gradle.daemons.stopWhenIdle.all", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public boolean isEnabled() {
            return ContainerUtil.exists((Iterable)DaemonsUi.this.myTableModel.getItems(), state -> state.getToken() != null && !"Stopped".equals(state.getStatus()));
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            if (e == null) {
                StopWhenIdleAllAction.$$$reportNull$$$0(0);
            }
            GradleActionsUsagesCollector.trigger(DaemonsUi.this.myProject, GradleActionsUsagesCollector.GRACEFUL_STOP_ALL_DAEMONS);
            ApplicationManager.getApplication().invokeLater(() -> {
                GradleDaemonServices.gracefulStopDaemons(GradleConnectorService.getKnownGradleUserHomes(DaemonsUi.this.myProject));
                DaemonsUi.this.updateDaemonsList();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/gradle/internal/daemon/DaemonsUi$StopWhenIdleAllAction", "actionPerformed"));
        }
    }

    private class StopAllAction
    extends AbstractAction {
        StopAllAction() {
            super(GradleBundle.message("gradle.daemons.stop.all", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public boolean isEnabled() {
            return ContainerUtil.exists((Iterable)DaemonsUi.this.myTableModel.getItems(), state -> state.getToken() != null && !"Stopped".equals(state.getStatus()));
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            if (e == null) {
                StopAllAction.$$$reportNull$$$0(0);
            }
            GradleActionsUsagesCollector.trigger(DaemonsUi.this.myProject, GradleActionsUsagesCollector.STOP_ALL_DAEMONS);
            ApplicationManager.getApplication().invokeLater(() -> {
                GradleDaemonServices.stopDaemons(GradleConnectorService.getKnownGradleUserHomes(DaemonsUi.this.myProject));
                DaemonsUi.this.updateDaemonsList();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/gradle/internal/daemon/DaemonsUi$StopAllAction", "actionPerformed"));
        }
    }

    private class StopSelectedAction
    extends AbstractAction {
        StopSelectedAction() {
            super(GradleBundle.message("gradle.daemons.stop.selected", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public boolean isEnabled() {
            Collection selection = DaemonsUi.this.myTable.getSelection();
            return !selection.isEmpty() && ContainerUtil.exists((Iterable)selection, state -> state.getToken() != null && !"Stopped".equals(state.getStatus()));
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            if (e == null) {
                StopSelectedAction.$$$reportNull$$$0(0);
            }
            GradleActionsUsagesCollector.trigger(DaemonsUi.this.myProject, GradleActionsUsagesCollector.STOP_SELECTED_DAEMONS);
            List selectedObjects = DaemonsUi.this.myTable.getSelectedObjects();
            ApplicationManager.getApplication().invokeLater(() -> {
                GradleDaemonServices.stopDaemons(GradleConnectorService.getKnownGradleUserHomes(DaemonsUi.this.myProject), selectedObjects);
                DaemonsUi.this.updateDaemonsList();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/gradle/internal/daemon/DaemonsUi$StopSelectedAction", "actionPerformed"));
        }
    }

    private class MyDialogWrapper
    extends DialogWrapper {
        private AbstractAction myCloseAction;

        MyDialogWrapper() {
            super(true);
            this.setTitle(GradleBundle.message("gradle.daemons.gradle.daemons", new Object[0]));
            this.setModal(false);
            this.init();
            DaemonsUi.this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(@NotNull ListSelectionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    MyDialogWrapper.this.invalidateActions();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/gradle/internal/daemon/DaemonsUi$MyDialogWrapper$1", "valueChanged"));
                }
            });
        }

        @Nullable
        protected JComponent createNorthPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            JLabel infoLabel = new JLabel(XmlStringUtil.wrapInHtml((CharSequence)GradleBundle.message("daemons.started.by.are.displayed", ApplicationNamesInfo.getInstance().getFullProductName())));
            infoLabel.setIcon(UIUtil.getInformationIcon());
            panel.add((Component)infoLabel, "Center");
            return panel;
        }

        protected JComponent createCenterPanel() {
            return DaemonsUi.this.myContent;
        }

        protected void dispose() {
            super.dispose();
            DaemonsUi.this.myDialog = null;
            Disposer.dispose((Disposable)DaemonsUi.this);
        }

        protected String getDimensionServiceKey() {
            return "GradleDaemons";
        }

        public JComponent getPreferredFocusedComponent() {
            return DaemonsUi.this.myTable;
        }

        protected Action @NotNull [] createActions() {
            Action[] actionArray = new Action[]{DaemonsUi.this.myStopWhenIdleAllAction, DaemonsUi.this.myStopAllAction, DaemonsUi.this.myStopSelectedAction, this.myCloseAction};
            if (actionArray == null) {
                MyDialogWrapper.$$$reportNull$$$0(0);
            }
            return actionArray;
        }

        protected Action @NotNull [] createLeftSideActions() {
            Action[] actionArray = new Action[]{DaemonsUi.this.myRefreshAction};
            if (actionArray == null) {
                MyDialogWrapper.$$$reportNull$$$0(1);
            }
            return actionArray;
        }

        protected void createDefaultActions() {
            super.createDefaultActions();
            this.myCloseAction = new AbstractAction(GradleBundle.message("gradle.daemons.close", new Object[0])){

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    MyDialogWrapper.this.doOKAction();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/gradle/internal/daemon/DaemonsUi$MyDialogWrapper$2", "actionPerformed"));
                }
            };
            this.myCloseAction.putValue("DefaultAction", true);
        }

        public void invalidateActions() {
            DaemonsUi.this.myStopSelectedAction.setEnabled(DaemonsUi.this.myStopSelectedAction.isEnabled());
            DaemonsUi.this.myStopAllAction.setEnabled(DaemonsUi.this.myStopAllAction.isEnabled());
            DaemonsUi.this.myStopWhenIdleAllAction.setEnabled(DaemonsUi.this.myStopWhenIdleAllAction.isEnabled());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/plugins/gradle/internal/daemon/DaemonsUi$MyDialogWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLeftSideActions";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static abstract class TableColumn
    extends ColumnInfo<DaemonState, String> {
        private final int myWidth;
        private DefaultTableCellRenderer myRenderer;

        TableColumn(@NlsContexts.ColumnName String name2, int width) {
            super(name2);
            this.myWidth = width;
        }

        public int getWidth(JTable table) {
            return this.myWidth;
        }

        public TableCellRenderer getRenderer(DaemonState element) {
            if (this.myRenderer == null) {
                this.myRenderer = new DefaultTableCellRenderer();
            }
            if (element != null) {
                this.myRenderer.setText((String)this.valueOf(element));
            }
            return this.myRenderer;
        }
    }
}

