/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.issue.ConfigurableBuildIssue;
import com.intellij.util.PlatformUtils;
import com.intellij.util.lang.JavaVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleSettingsQuickFix;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleVersionQuickFix;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/gradle/issue/ConfigurableGradleBuildIssue;", "Lcom/intellij/build/issue/ConfigurableBuildIssue;", "()V", "addGradleJvmQuickFix", "", "projectPath", "", "javaVersion", "Lcom/intellij/util/lang/JavaVersion;", "addGradleVersionQuickFix", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "intellij.gradle.common"})
public abstract class ConfigurableGradleBuildIssue
extends ConfigurableBuildIssue {
    public final void addGradleVersionQuickFix(@NotNull String projectPath, @NotNull GradleVersion gradleVersion2) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)gradleVersion2, (String)"gradleVersion");
        GradleVersionQuickFix quickFix = new GradleVersionQuickFix(projectPath, gradleVersion2, true);
        String hyperlinkReference = this.addQuickFix(quickFix);
        Object[] objectArray = new Object[]{hyperlinkReference, gradleVersion2.getVersion()};
        String string2 = GradleBundle.message("gradle.build.quick.fix.gradle.version", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.addQuickFixPrompt(string2);
    }

    public final void addGradleJvmQuickFix(@NotNull String projectPath, @NotNull JavaVersion javaVersion) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)javaVersion, (String)"javaVersion");
        if (Intrinsics.areEqual((Object)"AndroidStudio", (Object)PlatformUtils.getPlatformPrefix())) {
            return;
        }
        GradleSettingsQuickFix quickFix = new GradleSettingsQuickFix(projectPath, true, GradleSettingsQuickFix.GradleJvmChangeDetector.INSTANCE, GradleBundle.message("gradle.settings.text.jvm.path", new Object[0]));
        String hyperlinkReference = this.addQuickFix(quickFix);
        Object[] objectArray = new Object[]{hyperlinkReference, javaVersion};
        String string2 = GradleBundle.message("gradle.build.quick.fix.gradle.jvm", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.addQuickFixPrompt(string2);
    }
}

