/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.externalSystem.issue.quickfix.ReimportQuickFix;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.UnresolvedDependencyIssue;
import org.jetbrains.plugins.gradle.issue.UnresolvedDependencyIssueKt;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001:\u0001\u001eB5\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0012\u001a\u00020\u0003H\u00c2\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c2\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J?\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnresolvedDependencySyncIssue;", "Lorg/jetbrains/plugins/gradle/issue/UnresolvedDependencyIssue;", "dependencyName", "", "failureMessage", "projectPath", "isOfflineMode", "", "dependencyOwner", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;)V", "description", "getDescription", "()Ljava/lang/String;", "quickFixes", "", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "getQuickFixes", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "toString", "DisableOfflineAndReimport", "intellij.gradle.common"})
@ApiStatus.Experimental
public final class UnresolvedDependencySyncIssue
extends UnresolvedDependencyIssue {
    @NotNull
    private final String dependencyName;
    @Nullable
    private final String failureMessage;
    @NotNull
    private final String projectPath;
    private final boolean isOfflineMode;
    @Nullable
    private final String dependencyOwner;
    @NotNull
    private final List<BuildIssueQuickFix> quickFixes;
    @NotNull
    private final String description;

    @JvmOverloads
    public UnresolvedDependencySyncIssue(@NotNull String dependencyName, @Nullable String failureMessage, @NotNull String projectPath, boolean isOfflineMode, @Nullable String dependencyOwner) {
        Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        super(dependencyName, dependencyOwner);
        this.dependencyName = dependencyName;
        this.failureMessage = failureMessage;
        this.projectPath = projectPath;
        this.isOfflineMode = isOfflineMode;
        this.dependencyOwner = dependencyOwner;
        this.quickFixes = this.isOfflineMode ? CollectionsKt.listOf((Object)new DisableOfflineAndReimport(this.projectPath)) : CollectionsKt.emptyList();
        this.description = this.buildDescription(this.failureMessage, this.isOfflineMode, "Disable offline mode and reload the project");
    }

    public /* synthetic */ UnresolvedDependencySyncIssue(String string2, String string3, String string4, boolean bl, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string5 = null;
        }
        this(string2, string3, string4, bl, string5);
    }

    @NotNull
    public List<BuildIssueQuickFix> getQuickFixes() {
        return this.quickFixes;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    private final String component1() {
        return this.dependencyName;
    }

    private final String component2() {
        return this.failureMessage;
    }

    private final String component3() {
        return this.projectPath;
    }

    private final boolean component4() {
        return this.isOfflineMode;
    }

    private final String component5() {
        return this.dependencyOwner;
    }

    @NotNull
    public final UnresolvedDependencySyncIssue copy(@NotNull String dependencyName, @Nullable String failureMessage, @NotNull String projectPath, boolean isOfflineMode, @Nullable String dependencyOwner) {
        Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        return new UnresolvedDependencySyncIssue(dependencyName, failureMessage, projectPath, isOfflineMode, dependencyOwner);
    }

    public static /* synthetic */ UnresolvedDependencySyncIssue copy$default(UnresolvedDependencySyncIssue unresolvedDependencySyncIssue, String string2, String string3, String string4, boolean bl, String string5, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = unresolvedDependencySyncIssue.dependencyName;
        }
        if ((n & 2) != 0) {
            string3 = unresolvedDependencySyncIssue.failureMessage;
        }
        if ((n & 4) != 0) {
            string4 = unresolvedDependencySyncIssue.projectPath;
        }
        if ((n & 8) != 0) {
            bl = unresolvedDependencySyncIssue.isOfflineMode;
        }
        if ((n & 0x10) != 0) {
            string5 = unresolvedDependencySyncIssue.dependencyOwner;
        }
        return unresolvedDependencySyncIssue.copy(string2, string3, string4, bl, string5);
    }

    @NotNull
    public String toString() {
        return "UnresolvedDependencySyncIssue(dependencyName=" + this.dependencyName + ", failureMessage=" + this.failureMessage + ", projectPath=" + this.projectPath + ", isOfflineMode=" + this.isOfflineMode + ", dependencyOwner=" + this.dependencyOwner + ")";
    }

    public int hashCode() {
        int result = this.dependencyName.hashCode();
        result = result * 31 + (this.failureMessage == null ? 0 : this.failureMessage.hashCode());
        result = result * 31 + this.projectPath.hashCode();
        result = result * 31 + Boolean.hashCode(this.isOfflineMode);
        result = result * 31 + (this.dependencyOwner == null ? 0 : this.dependencyOwner.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UnresolvedDependencySyncIssue)) {
            return false;
        }
        UnresolvedDependencySyncIssue unresolvedDependencySyncIssue = (UnresolvedDependencySyncIssue)other;
        if (!Intrinsics.areEqual((Object)this.dependencyName, (Object)unresolvedDependencySyncIssue.dependencyName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.failureMessage, (Object)unresolvedDependencySyncIssue.failureMessage)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.projectPath, (Object)unresolvedDependencySyncIssue.projectPath)) {
            return false;
        }
        if (this.isOfflineMode != unresolvedDependencySyncIssue.isOfflineMode) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.dependencyOwner, (Object)unresolvedDependencySyncIssue.dependencyOwner);
    }

    @JvmOverloads
    public UnresolvedDependencySyncIssue(@NotNull String dependencyName, @Nullable String failureMessage, @NotNull String projectPath, boolean isOfflineMode) {
        Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        this(dependencyName, failureMessage, projectPath, isOfflineMode, null, 16, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnresolvedDependencySyncIssue$DisableOfflineAndReimport;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "projectPath", "", "(Lorg/jetbrains/plugins/gradle/issue/UnresolvedDependencySyncIssue;Ljava/lang/String;)V", "id", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.gradle.common"})
    public final class DisableOfflineAndReimport
    implements BuildIssueQuickFix {
        @NotNull
        private final String projectPath;
        @NotNull
        private final String id;

        public DisableOfflineAndReimport(String projectPath) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            this.projectPath = projectPath;
            this.id = "disable_offline_mode";
        }

        @NotNull
        public String getId() {
            return this.id;
        }

        @NotNull
        public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            GradleSettings.getInstance(project).setOfflineWork(false);
            CompletableFuture completableFuture = UnresolvedDependencyIssueKt.access$tryRerun(dataContext);
            if (completableFuture == null) {
                ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
                Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"SYSTEM_ID");
                completableFuture = ReimportQuickFix.Companion.requestImport(project, this.projectPath, projectSystemId);
            }
            return completableFuture;
        }
    }
}

