/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.ConfigurableGradleBuildIssue;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnsupportedGradleVersionIssue;", "Lorg/jetbrains/plugins/gradle/issue/ConfigurableGradleBuildIssue;", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "projectPath", "", "(Lorg/gradle/util/GradleVersion;Ljava/lang/String;)V", "intellij.gradle.common"})
final class UnsupportedGradleVersionIssue
extends ConfigurableGradleBuildIssue {
    public UnsupportedGradleVersionIssue(@Nullable GradleVersion gradleVersion2, @NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        GradleVersion oldestSupportedGradleVersion = GradleJvmSupportMatrix.Companion.getOldestSupportedGradleVersionByIdea();
        GradleVersion recommendedGradleVersion = GradleJvmSupportMatrix.Companion.getRecommendedGradleVersionByIdea();
        String string2 = GradleBundle.message("gradle.build.issue.gradle.unsupported.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.setTitle(string2);
        if (gradleVersion2 == null) {
            String string3 = GradleBundle.message("gradle.build.issue.gradle.unsupported.unknown.description", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            this.addDescription(string3);
            Object[] objectArray = new Object[]{recommendedGradleVersion.getVersion()};
            String string4 = GradleBundle.message("gradle.build.issue.gradle.recommended.description", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            this.addDescription(string4);
            this.addGradleVersionQuickFix(projectPath, recommendedGradleVersion);
        } else {
            Object[] objectArray = new Object[]{gradleVersion2.getVersion()};
            String string5 = GradleBundle.message("gradle.build.issue.gradle.unsupported.description", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
            this.addDescription(string5);
            objectArray = new Object[]{recommendedGradleVersion.getVersion()};
            String string6 = GradleBundle.message("gradle.build.issue.gradle.recommended.description", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
            this.addDescription(string6);
            this.addGradleVersionQuickFix(projectPath, recommendedGradleVersion);
            if (oldestSupportedGradleVersion.compareTo(recommendedGradleVersion) < 0) {
                objectArray = new Object[]{oldestSupportedGradleVersion.getVersion()};
                String string7 = GradleBundle.message("gradle.build.issue.gradle.supported.description", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
                this.addDescription(string7);
                this.addGradleVersionQuickFix(projectPath, oldestSupportedGradleVersion);
            }
        }
    }
}

