/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.issue.BuildIssue;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.issue.UnsupportedGradleVersionIssue;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnsupportedGradleVersionIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "getGradleVersion", "Lorg/gradle/util/GradleVersion;", "isGradleUnsupportedByIdea", "", "isGradleUnsupportedByToolingApi", "rootCause", "", "isModelBuilderApiUnsupported", "isOldGradleClasspathInfererIssue", "Companion", "intellij.gradle.common"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nUnsupportedGradleVersionIssueChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsupportedGradleVersionIssueChecker.kt\norg/jetbrains/plugins/gradle/issue/UnsupportedGradleVersionIssueChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public final class UnsupportedGradleVersionIssueChecker
implements GradleIssueChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String UNSUPPORTED_MODEL_BUILDER_API_EXCEPTION_TEXT = "does not support the ModelBuilder API. Support for this is available in Gradle 1.2 and all later versions.";
    @NotNull
    private static final String UNSUPPORTED_VERSION_EXCEPTION_MESSAGE_PREFIX = "org.gradle.tooling.UnsupportedVersionException: Support for builds using Gradle versions older than ";

    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        GradleVersion gradleVersion2 = this.getGradleVersion(issueData);
        if (this.isGradleUnsupportedByIdea(issueData)) {
            return (BuildIssue)new UnsupportedGradleVersionIssue(gradleVersion2, issueData.getProjectPath());
        }
        Intrinsics.checkNotNull((Object)rootCause);
        if (this.isOldGradleClasspathInfererIssue(rootCause)) {
            return (BuildIssue)new UnsupportedGradleVersionIssue(gradleVersion2, issueData.getProjectPath());
        }
        if (this.isModelBuilderApiUnsupported(rootCause)) {
            return (BuildIssue)new UnsupportedGradleVersionIssue(gradleVersion2, issueData.getProjectPath());
        }
        if (this.isGradleUnsupportedByToolingApi(rootCause)) {
            return (BuildIssue)new UnsupportedGradleVersionIssue(gradleVersion2, issueData.getProjectPath());
        }
        return null;
    }

    private final GradleVersion getGradleVersion(GradleIssueData issueData) {
        if (issueData.getBuildEnvironment() != null) {
            return GradleVersion.version((String)issueData.getBuildEnvironment().getGradle().getGradleVersion());
        }
        if (issueData.getError() instanceof GradleExecutionHelper.UnsupportedGradleVersionByIdeaException) {
            return ((GradleExecutionHelper.UnsupportedGradleVersionByIdeaException)issueData.getError()).getGradleVersion();
        }
        return null;
    }

    private final boolean isGradleUnsupportedByIdea(GradleIssueData issueData) {
        return issueData.getError() instanceof GradleExecutionHelper.UnsupportedGradleVersionByIdeaException;
    }

    private final boolean isOldGradleClasspathInfererIssue(Throwable rootCause) {
        Object object;
        block3: {
            String string2 = rootCause.getMessage();
            if (string2 == null) {
                return false;
            }
            String message = string2;
            if (!StringsKt.startsWith$default((String)message, (String)"Cannot determine classpath for resource", (boolean)false, (int)2, null)) {
                return false;
            }
            StackTraceElement[] stackTraceElementArray = rootCause.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            for (Object object2 : (Object[])stackTraceElementArray) {
                StackTraceElement it = (StackTraceElement)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getClassName(), (Object)"org.gradle.tooling.internal.provider.ClasspathInferer")) continue;
                object = object2;
                break block3;
            }
            object = null;
        }
        return object != null;
    }

    private final boolean isModelBuilderApiUnsupported(Throwable rootCause) {
        return StringsKt.endsWith$default((String)rootCause.toString(), (String)UNSUPPORTED_MODEL_BUILDER_API_EXCEPTION_TEXT, (boolean)false, (int)2, null);
    }

    private final boolean isGradleUnsupportedByToolingApi(Throwable rootCause) {
        return StringsKt.startsWith$default((String)rootCause.toString(), (String)UNSUPPORTED_VERSION_EXCEPTION_MESSAGE_PREFIX, (boolean)false, (int)2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnsupportedGradleVersionIssueChecker$Companion;", "", "()V", "UNSUPPORTED_MODEL_BUILDER_API_EXCEPTION_TEXT", "", "UNSUPPORTED_VERSION_EXCEPTION_MESSAGE_PREFIX", "intellij.gradle.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

