/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue.quickfix;

import com.intellij.build.SyncViewManager;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.ide.actions.ShowLogAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.issue.quickfix.ReimportQuickFix;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.io.PathKt;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.util.GradleVersion;
import org.gradle.wrapper.WrapperConfiguration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleVersionQuickFix;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleWrapperSettingsOpenQuickFix;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u001c\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\f\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/gradle/issue/quickfix/GradleVersionQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "projectPath", "", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "requestImport", "", "(Ljava/lang/String;Lorg/gradle/util/GradleVersion;Z)V", "id", "getId", "()Ljava/lang/String;", "getWrapperConfiguration", "Lorg/gradle/wrapper/WrapperConfiguration;", "wrapperPropertiesPath", "Ljava/nio/file/Path;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "runWrapperTask", "", "updateOrCreateWrapper", "Companion", "intellij.gradle.common"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nGradleVersionQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleVersionQuickFix.kt\norg/jetbrains/plugins/gradle/issue/quickfix/GradleVersionQuickFix\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,158:1\n11#2:159\n*S KotlinDebug\n*F\n+ 1 GradleVersionQuickFix.kt\norg/jetbrains/plugins/gradle/issue/quickfix/GradleVersionQuickFix\n*L\n155#1:159\n*E\n"})
public final class GradleVersionQuickFix
implements BuildIssueQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String projectPath;
    @NotNull
    private final GradleVersion gradleVersion;
    private final boolean requestImport;
    @NotNull
    private final String id;
    @NotNull
    private static final Logger LOG;

    public GradleVersionQuickFix(@NotNull String projectPath, @NotNull GradleVersion gradleVersion2, boolean requestImport) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)gradleVersion2, (String)"gradleVersion");
        this.projectPath = projectPath;
        this.gradleVersion = gradleVersion2;
        this.requestImport = requestImport;
        this.id = "fix_gradle_version_in_wrapper";
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.updateOrCreateWrapper().exceptionally(new Function(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public final Void apply(Throwable it) {
                NotificationData notificationData;
                GradleVersionQuickFix.access$getLOG$cp().warn(it);
                String title = GradleBundle.message("gradle.version.quick.fix.error", new Object[0]);
                Object[] objectArray = new Object[]{ShowLogAction.getActionName()};
                String message = GradleBundle.message("gradle.version.quick.fix.error.description", objectArray);
                NotificationData $this$apply_u24lambda_u241 = notificationData = new NotificationData(title, message, NotificationCategory.WARNING, NotificationSource.PROJECT_SYNC);
                boolean bl = false;
                $this$apply_u24lambda_u241.setBalloonNotification(true);
                $this$apply_u24lambda_u241.setBalloonGroup(NotificationGroupManager.getInstance().getNotificationGroup("Gradle Wrapper Update"));
                $this$apply_u24lambda_u241.setListener("#open_log", runQuickFix.1::apply$lambda$1$lambda$0);
                NotificationData notification = notificationData;
                ExternalSystemNotificationManager.getInstance((Project)this.$project).showNotification(GradleConstants.SYSTEM_ID, notification);
                Intrinsics.checkNotNull((Object)it);
                throw it;
            }

            private static final void apply$lambda$1$lambda$0(Notification notification, HyperlinkEvent hyperlinkEvent) {
                Intrinsics.checkNotNullParameter((Object)notification, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)hyperlinkEvent, (String)"<anonymous parameter 1>");
                ShowLogAction.showLog();
            }
        })).thenApply(arg_0 -> GradleVersionQuickFix.runQuickFix$lambda$0(project, this, arg_0))).thenComposeAsync(arg_0 -> GradleVersionQuickFix.runQuickFix$lambda$1((Function1)new Function1<Unit, CompletionStage>(this, project){
            final /* synthetic */ GradleVersionQuickFix this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(1);
            }

            public final CompletionStage invoke(Unit it) {
                return GradleVersionQuickFix.access$runWrapperTask(this.this$0, this.$project);
            }
        }, arg_0))).thenApply(arg_0 -> GradleVersionQuickFix.runQuickFix$lambda$2(new Function1(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ GradleVersionQuickFix this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Void it) {
                GradleWrapperSettingsOpenQuickFix.Companion.showWrapperPropertiesFile(this.$project, GradleVersionQuickFix.access$getProjectPath$p(this.this$0), GradleVersionQuickFix.access$getGradleVersion$p(this.this$0).getVersion());
            }
        }, arg_0))).thenComposeAsync(arg_0 -> GradleVersionQuickFix.runQuickFix$lambda$3((Function1)new Function1<Unit, CompletionStage>(this, project){
            final /* synthetic */ GradleVersionQuickFix this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(1);
            }

            public final CompletionStage invoke(Unit it) {
                if (GradleVersionQuickFix.access$getRequestImport$p(this.this$0)) {
                    TimeoutUtil.sleep((long)500L);
                    String string2 = GradleVersionQuickFix.access$getProjectPath$p(this.this$0);
                    ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
                    Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"SYSTEM_ID");
                    return ReimportQuickFix.Companion.requestImport(this.$project, string2, projectSystemId);
                }
                return CompletableFuture.completedFuture(null);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenComposeAsync(...)");
        return completionStage;
    }

    private final CompletableFuture<?> updateOrCreateWrapper() {
        CompletableFuture<Unit> completableFuture = CompletableFuture.supplyAsync(() -> GradleVersionQuickFix.updateOrCreateWrapper$lambda$4(this));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    private final CompletableFuture runWrapperTask(Project project) {
        UserDataHolderBase userData = new UserDataHolderBase();
        String initScript2 = "gradle.projectsEvaluated { g ->\n  def wrapper = g.rootProject.tasks.wrapper\n  if (wrapper == null) return \n  wrapper.gradleVersion = '" + this.gradleVersion.getVersion() + "'\n}\n";
        userData.putUserData(GradleTaskManager.INIT_SCRIPT_KEY, (Object)initScript2);
        userData.putUserData(ExternalSystemRunConfiguration.PROGRESS_LISTENER_KEY, SyncViewManager.class);
        String gradleVmOptions = GradleSettings.getInstance(project).getGradleVmOptions();
        ExternalSystemTaskExecutionSettings settings2 = new ExternalSystemTaskExecutionSettings();
        settings2.setExecutionName(GradleBundle.message("grable.execution.name.upgrade.wrapper", new Object[0]));
        settings2.setExternalProjectPath(this.projectPath);
        settings2.setTaskNames(CollectionsKt.listOf((Object)"wrapper"));
        settings2.setVmOptions(gradleVmOptions);
        settings2.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
        CompletableFuture future = new CompletableFuture();
        ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)settings2, (String)"Run", (Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (TaskCallback)new TaskCallback(future){
            final /* synthetic */ CompletableFuture $future;
            {
                this.$future = $future;
            }

            public void onSuccess() {
                this.$future.complete(null);
            }

            public void onFailure() {
                this.$future.completeExceptionally(new RuntimeException("Wrapper task failed"));
            }
        }, (ProgressExecutionMode)ProgressExecutionMode.NO_PROGRESS_ASYNC, (boolean)false, (UserDataHolderBase)userData);
        return future;
    }

    private final WrapperConfiguration getWrapperConfiguration(Path wrapperPropertiesPath) {
        WrapperConfiguration wrapperConfiguration2;
        if (wrapperPropertiesPath == null) {
            wrapperConfiguration2 = new WrapperConfiguration();
        } else {
            wrapperConfiguration2 = GradleUtil.readWrapperConfiguration(wrapperPropertiesPath);
            if (wrapperConfiguration2 == null) {
                wrapperConfiguration2 = new WrapperConfiguration();
            }
        }
        return wrapperConfiguration2;
    }

    private static final Unit runQuickFix$lambda$0(Project $project, GradleVersionQuickFix this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ExternalProjectSettings externalProjectSettings = GradleSettings.getInstance($project).getLinkedProjectSettings(this$0.projectPath);
        Intrinsics.checkNotNull((Object)externalProjectSettings);
        ((GradleProjectSettings)externalProjectSettings).setDistributionType(DistributionType.DEFAULT_WRAPPED);
        return Unit.INSTANCE;
    }

    private static final CompletionStage runQuickFix$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final Unit runQuickFix$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0);
    }

    private static final CompletionStage runQuickFix$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final Unit updateOrCreateWrapper$lambda$4(GradleVersionQuickFix this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Path wrapperPropertiesPath = GradleUtil.findDefaultWrapperPropertiesFile(this$0.projectPath);
        WrapperConfiguration wrapperConfiguration2 = this$0.getWrapperConfiguration(wrapperPropertiesPath);
        String distributionUrl = "https://services.gradle.org/distributions/gradle-" + this$0.gradleVersion.getVersion() + "-bin.zip";
        wrapperConfiguration2.setDistribution(new URI(distributionUrl));
        if (wrapperPropertiesPath == null) {
            String[] stringArray = new String[]{"gradle", "wrapper", "gradle-wrapper.properties"};
            wrapperPropertiesPath = Paths.get(this$0.projectPath, stringArray);
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(PathKt.createParentDirectories((Path)wrapperPropertiesPath), Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
        }
        Path path = wrapperPropertiesPath;
        Intrinsics.checkNotNull((Object)path);
        GradleUtil.writeWrapperConfiguration(path, wrapperConfiguration2);
        LocalFileSystem.getInstance().refreshNioFiles((Iterable)CollectionsKt.listOf((Object)wrapperPropertiesPath));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ CompletableFuture access$runWrapperTask(GradleVersionQuickFix $this, Project project) {
        return $this.runWrapperTask(project);
    }

    public static final /* synthetic */ String access$getProjectPath$p(GradleVersionQuickFix $this) {
        return $this.projectPath;
    }

    public static final /* synthetic */ GradleVersion access$getGradleVersion$p(GradleVersionQuickFix $this) {
        return $this.gradleVersion;
    }

    public static final /* synthetic */ boolean access$getRequestImport$p(GradleVersionQuickFix $this) {
        return $this.requestImport;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GradleVersionQuickFix.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/gradle/issue/quickfix/GradleVersionQuickFix$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gradle.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

