/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.execution.target.value.TargetValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.util.GradleVersion;
import org.gradle.wrapper.PathAssembler;
import org.gradle.wrapper.WrapperConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.target.GradleTargetUtil;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.execution.BuildLayoutParameters;
import org.jetbrains.plugins.gradle.service.execution.GradleUserHomeUtil;
import org.jetbrains.plugins.gradle.service.execution.LocalBuildLayoutParameters;
import org.jetbrains.plugins.gradle.service.execution.LocalGradleExecutionAware;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u0000 %2\u00020\u0001:\u0001%B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001a\u001a\n \u001b*\u0004\u0018\u00010\u00050\u0005H\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010\u001d\u001a\u00020\u0005H\u0002J\u000f\u0010\u001e\u001a\t\u0018\u00010\u001f\u00a2\u0006\u0002\b H\u0014J\r\u0010!\u001a\u00070\"\u00a2\u0006\u0002\b#H\u0002J\n\u0010$\u001a\u0004\u0018\u00010\u0011H\u0002R#\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\f\u001a\u0004\b\u000e\u0010\nR\u001d\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\f\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\f\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/LocalBuildLayoutParameters;", "Lorg/jetbrains/plugins/gradle/service/execution/BuildLayoutParameters;", "project", "Lcom/intellij/openapi/project/Project;", "projectPath", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "gradleHome", "Lcom/intellij/execution/target/value/TargetValue;", "getGradleHome", "()Lcom/intellij/execution/target/value/TargetValue;", "gradleHome$delegate", "Lkotlin/Lazy;", "gradleUserHome", "getGradleUserHome", "gradleUserHome$delegate", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "getGradleVersion", "()Lorg/gradle/util/GradleVersion;", "gradleVersion$delegate", "wrapperConfiguration", "Lorg/gradle/wrapper/WrapperConfiguration;", "getWrapperConfiguration", "()Lorg/gradle/wrapper/WrapperConfiguration;", "wrapperConfiguration$delegate", "defaultGradleUserHome", "kotlin.jvm.PlatformType", "findGradleHome", "findGradleUserHomeDir", "getGradleProjectSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "Lorg/jetbrains/annotations/Nullable;", "getGradleSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleSettings;", "Lorg/jetbrains/annotations/NotNull;", "guessGradleVersion", "Companion", "intellij.gradle.common"})
@SourceDebugExtension(value={"SMAP\nLocalBuildLayoutParameters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalBuildLayoutParameters.kt\norg/jetbrains/plugins/gradle/service/execution/LocalBuildLayoutParameters\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,104:1\n1#2:105\n11#3:106\n*S KotlinDebug\n*F\n+ 1 LocalBuildLayoutParameters.kt\norg/jetbrains/plugins/gradle/service/execution/LocalBuildLayoutParameters\n*L\n102#1:106\n*E\n"})
public class LocalBuildLayoutParameters
implements BuildLayoutParameters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private final String projectPath;
    @NotNull
    private final Lazy gradleHome$delegate;
    @NotNull
    private final Lazy gradleVersion$delegate;
    @NotNull
    private final Lazy gradleUserHome$delegate;
    @NotNull
    private final Lazy wrapperConfiguration$delegate;
    @NotNull
    private static final Logger log;

    public LocalBuildLayoutParameters(@NotNull Project project, @Nullable String projectPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.projectPath = projectPath;
        this.gradleHome$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TargetValue<String>>(this){
            final /* synthetic */ LocalBuildLayoutParameters this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final TargetValue<String> invoke() {
                TargetValue targetValue;
                String string2 = LocalBuildLayoutParameters.access$findGradleHome(this.this$0);
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    targetValue = TargetValue.fixed((Object)it);
                } else {
                    targetValue = null;
                }
                return targetValue;
            }
        }));
        this.gradleVersion$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GradleVersion>(this){
            final /* synthetic */ LocalBuildLayoutParameters this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final GradleVersion invoke() {
                return LocalBuildLayoutParameters.access$guessGradleVersion(this.this$0);
            }
        }));
        this.gradleUserHome$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TargetValue<String>>(this){
            final /* synthetic */ LocalBuildLayoutParameters this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final TargetValue<String> invoke() {
                return TargetValue.fixed((Object)LocalBuildLayoutParameters.access$findGradleUserHomeDir(this.this$0));
            }
        }));
        this.wrapperConfiguration$delegate = LazyKt.lazy((Function0)((Function0)new Function0<WrapperConfiguration>(this){
            final /* synthetic */ LocalBuildLayoutParameters this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final WrapperConfiguration invoke() {
                Object object = this.this$0.getGradleProjectSettings();
                if (object == null || (object = object.getDistributionType()) == null) {
                    return null;
                }
                GradleProjectSettings distributionType = object;
                return switch (wrapperConfiguration.WhenMappings.$EnumSwitchMapping$0[((Enum)((Object)distributionType)).ordinal()]) {
                    case 1 -> GradleUtil.getWrapperConfiguration(LocalBuildLayoutParameters.access$getProjectPath$p(this.this$0));
                    case 2 -> {
                        WrapperConfiguration var2_2;
                        WrapperConfiguration $this$invoke_u24lambda_u240 = var2_2 = new WrapperConfiguration();
                        boolean $i$a$-apply-LocalBuildLayoutParameters$wrapperConfiguration$2$1 = false;
                        $this$invoke_u24lambda_u240.setDistribution(GradleUtil.getWrapperDistributionUri(GradleVersion.current()));
                        yield var2_2;
                    }
                    default -> null;
                };
            }
        }));
    }

    @Override
    @Nullable
    public TargetValue<String> getGradleHome() {
        Lazy lazy = this.gradleHome$delegate;
        return (TargetValue)lazy.getValue();
    }

    @Override
    @Nullable
    public GradleVersion getGradleVersion() {
        Lazy lazy = this.gradleVersion$delegate;
        return (GradleVersion)lazy.getValue();
    }

    @Override
    @NotNull
    public TargetValue<String> getGradleUserHome() {
        Lazy lazy = this.gradleUserHome$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (TargetValue)object;
    }

    @Nullable
    protected GradleProjectSettings getGradleProjectSettings() {
        GradleProjectSettings gradleProjectSettings;
        String string2 = this.projectPath;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            gradleProjectSettings = (GradleProjectSettings)this.getGradleSettings().getLinkedProjectSettings(it);
        } else {
            gradleProjectSettings = null;
        }
        return gradleProjectSettings;
    }

    private final GradleSettings getGradleSettings() {
        GradleSettings gradleSettings = GradleSettings.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"getInstance(...)");
        return gradleSettings;
    }

    private final WrapperConfiguration getWrapperConfiguration() {
        Lazy lazy = this.wrapperConfiguration$delegate;
        return (WrapperConfiguration)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String findGradleHome() {
        GradleProjectSettings gradleProjectSettings = this.getGradleProjectSettings();
        Object object = gradleProjectSettings;
        if (object == null || (object = object.getDistributionType()) == null) {
            File file = GradleInstallationManager.getInstance().getAutodetectedGradleHome(this.project);
            return file != null ? file.getPath() : null;
        }
        Object distributionType = object;
        if (distributionType == DistributionType.LOCAL) {
            return gradleProjectSettings.getGradleHome();
        }
        if (distributionType == DistributionType.WRAPPED) {
            return GradleLocalSettings.getInstance(this.project).getGradleHome(this.projectPath);
        }
        if (this.getWrapperConfiguration() == null) {
            return null;
        }
        String string2 = GradleTargetUtil.maybeGetLocalValue(this.getGradleUserHome());
        if (string2 == null) {
            return null;
        }
        String localGradleUserHome = string2;
        PathAssembler.LocalDistribution localDistribution = new PathAssembler(new File(localGradleUserHome), new File(gradleProjectSettings.getExternalProjectPath())).getDistribution(this.getWrapperConfiguration());
        File file = localDistribution.getDistributionDir();
        if (file == null) {
            return null;
        }
        File distributionDir = file;
        if (!distributionDir.exists()) {
            return null;
        }
        try {
            List list2;
            AutoCloseable autoCloseable = Files.list(distributionDir.toPath());
            Throwable throwable = null;
            try {
                Stream it = (Stream)autoCloseable;
                boolean bl = false;
                list2 = ((Stream)it.filter(arg_0 -> LocalBuildLayoutParameters.findGradleHome$lambda$2$lambda$1(findGradleHome.dirs.1.1.INSTANCE, arg_0)).unordered()).limit(2L).toList();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            List dirs2 = list2;
            if (dirs2.size() == 1) {
                Intrinsics.checkNotNull(dirs2);
                return CollectionsKt.first(dirs2).toString();
            }
        }
        catch (Exception e) {
            log.debug("Can not find Gradle installation inside " + distributionDir.getPath(), (Throwable)e);
        }
        return null;
    }

    private final GradleVersion guessGradleVersion() {
        Object object = this.getGradleProjectSettings();
        if (object == null || (object = object.getDistributionType()) == null) {
            return null;
        }
        GradleProjectSettings distributionType = object;
        switch (WhenMappings.$EnumSwitchMapping$0[((Enum)((Object)distributionType)).ordinal()]) {
            case 1: {
                return GradleVersion.current();
            }
            case 2: {
                GradleVersion gradleVersion2;
                TargetValue<String> targetValue = this.getGradleHome();
                String string2 = GradleInstallationManager.getGradleVersion(targetValue != null ? GradleTargetUtil.maybeGetLocalValue(targetValue) : null);
                if (string2 != null) {
                    String $this$guessGradleVersion_u24lambda_u243 = string2;
                    boolean bl = false;
                    gradleVersion2 = GradleInstallationManager.getGradleVersionSafe($this$guessGradleVersion_u24lambda_u243);
                } else {
                    gradleVersion2 = null;
                }
                return gradleVersion2;
            }
            case 3: {
                GradleVersion gradleVersion3;
                TargetValue<String> targetValue = this.getGradleHome();
                String string3 = GradleInstallationManager.getGradleVersion(targetValue != null ? GradleTargetUtil.maybeGetLocalValue(targetValue) : null);
                if (string3 != null) {
                    String $this$guessGradleVersion_u24lambda_u244 = string3;
                    boolean bl = false;
                    v6 = GradleInstallationManager.getGradleVersionSafe($this$guessGradleVersion_u24lambda_u244);
                } else {
                    v6 = gradleVersion3 = null;
                }
                if (gradleVersion3 == null) {
                    String path;
                    Object object2 = this.getWrapperConfiguration();
                    String string4 = object2 != null && (object2 = object2.getDistribution()) != null ? ((URI)object2).getRawPath() : (path = null);
                    if (path == null) break;
                    return GradleInstallationManager.parseDistributionVersion(path);
                }
                return gradleVersion3;
            }
            case 4: {
                return null;
            }
        }
        return null;
    }

    private final String findGradleUserHomeDir() {
        if (this.projectPath == null) {
            String string2 = this.defaultGradleUserHome();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"defaultGradleUserHome(...)");
            return string2;
        }
        String string3 = this.getGradleSettings().getServiceDirectoryPath();
        if (string3 == null) {
            String string4 = this.defaultGradleUserHome();
            string3 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"defaultGradleUserHome(...)");
        }
        return string3;
    }

    private final String defaultGradleUserHome() {
        return GradleUserHomeUtil.gradleUserHomeDir().getPath();
    }

    private static final boolean findGradleHome$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$findGradleHome(LocalBuildLayoutParameters $this) {
        return $this.findGradleHome();
    }

    public static final /* synthetic */ GradleVersion access$guessGradleVersion(LocalBuildLayoutParameters $this) {
        return $this.guessGradleVersion();
    }

    public static final /* synthetic */ String access$findGradleUserHomeDir(LocalBuildLayoutParameters $this) {
        return $this.findGradleUserHomeDir();
    }

    public static final /* synthetic */ String access$getProjectPath$p(LocalBuildLayoutParameters $this) {
        return $this.projectPath;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LocalGradleExecutionAware.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/LocalBuildLayoutParameters$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gradle.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DistributionType.values().length];
            try {
                nArray[DistributionType.BUNDLED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DistributionType.LOCAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DistributionType.DEFAULT_WRAPPED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DistributionType.WRAPPED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

