/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemExecutionAware;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.Build;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.model.data.CompositeBuildData;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.DefaultProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ToolingModelsProviderImpl;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleModuleDataKt;

public final class GradleBuildSrcProjectsResolver {
    public static final String BUILD_SRC_MODULE_PROPERTY = "buildSrcModule";
    @NotNull
    private final GradleProjectResolver myProjectResolver;
    @NotNull
    private final DefaultProjectResolverContext myResolverContext;
    @Nullable
    private final File myGradleUserHome;
    @Nullable
    private final GradleExecutionSettings myMainBuildExecutionSettings;
    @NotNull
    private final ExternalSystemTaskNotificationListener myListener;
    @NotNull
    private final ExternalSystemTaskId mySyncTaskId;
    @NotNull
    private final GradleProjectResolverExtension myResolverChain;

    public GradleBuildSrcProjectsResolver(@NotNull GradleProjectResolver projectResolver, @NotNull DefaultProjectResolverContext resolverContext, @Nullable File gradleUserHome2, @Nullable GradleExecutionSettings mainBuildSettings, @NotNull ExternalSystemTaskNotificationListener listener2, @NotNull ExternalSystemTaskId syncTaskId, @NotNull GradleProjectResolverExtension projectResolverChain) {
        if (projectResolver == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(0);
        }
        if (resolverContext == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(1);
        }
        if (listener2 == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(2);
        }
        if (syncTaskId == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(3);
        }
        if (projectResolverChain == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(4);
        }
        this.myProjectResolver = projectResolver;
        this.myResolverContext = resolverContext;
        this.myGradleUserHome = gradleUserHome2;
        this.myMainBuildExecutionSettings = mainBuildSettings;
        this.myListener = listener2;
        this.mySyncTaskId = syncTaskId;
        this.myResolverChain = projectResolverChain;
    }

    public void discoverAndAppendTo(@NotNull DataNode<ProjectData> mainBuildProjectDataNode) {
        if (mainBuildProjectDataNode == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(5);
        }
        String gradleHome2 = this.myGradleUserHome == null ? null : this.myGradleUserHome.getPath();
        Index index = GradleBuildSrcProjectsResolver.prepareIndexes(mainBuildProjectDataNode);
        SmartList jvmOptions = new SmartList();
        BuildEnvironment mainBuildEnvironment = this.myResolverContext.getModels().getBuildEnvironment();
        if (mainBuildEnvironment != null) {
            jvmOptions.addAll(mainBuildEnvironment.getJava().getJvmArguments());
        }
        if (this.myMainBuildExecutionSettings != null) {
            jvmOptions.addAll(this.myMainBuildExecutionSettings.getJvmArguments());
        }
        Stream<Build> builds = new ToolingModelsProviderImpl(this.myResolverContext.getModels()).builds();
        builds.forEach(arg_0 -> this.lambda$discoverAndAppendTo$0(gradleHome2, (List)jvmOptions, index, mainBuildProjectDataNode, arg_0));
    }

    @NotNull
    public static Index prepareIndexes(@NotNull DataNode<ProjectData> mainBuildProjectDataNode) {
        if (mainBuildProjectDataNode == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(6);
        }
        ProjectData mainBuildProjectData = (ProjectData)mainBuildProjectDataNode.getData();
        String projectPath = mainBuildProjectData.getLinkedExternalProjectPath();
        HashMap<String, String> includedBuildsPaths = new HashMap<String, String>();
        HashMap<String, String> buildNames = new HashMap<String, String>();
        buildNames.put(projectPath, mainBuildProjectData.getExternalName());
        CompositeBuildData compositeBuildData = GradleBuildSrcProjectsResolver.getCompositeBuildData(mainBuildProjectDataNode);
        if (compositeBuildData != null) {
            for (BuildParticipant buildParticipant : compositeBuildData.getCompositeParticipants()) {
                String buildParticipantRootPath = buildParticipant.getRootPath();
                buildNames.put(buildParticipantRootPath, buildParticipant.getRootProjectName());
                for (String path : buildParticipant.getProjects()) {
                    includedBuildsPaths.put(path, buildParticipantRootPath);
                }
            }
        }
        MultiMap buildClasspathNodesMap = new MultiMap();
        HashMap<String, DataNode<ModuleData>> includedModulesPaths = new HashMap<String, DataNode<ModuleData>>();
        for (DataNode moduleDataNode : ExternalSystemApiUtil.findAll(mainBuildProjectDataNode, (Key)ProjectKeys.MODULE)) {
            String path;
            path = ((ModuleData)moduleDataNode.getData()).getLinkedExternalProjectPath();
            includedModulesPaths.put(path, (DataNode<ModuleData>)moduleDataNode);
            DataNode scriptClasspathDataNode = ExternalSystemApiUtil.find((DataNode)moduleDataNode, BuildScriptClasspathData.KEY);
            if (scriptClasspathDataNode == null) continue;
            String rootPath = (String)includedBuildsPaths.get(path);
            buildClasspathNodesMap.putValue((Object)Paths.get(rootPath != null ? rootPath : projectPath, new String[0]), (Object)scriptClasspathDataNode);
        }
        return new Index(buildNames, compositeBuildData, (MultiMap<Path, DataNode<BuildScriptClasspathData>>)buildClasspathNodesMap, includedModulesPaths);
    }

    private static void reuseTargetEnvironmentConfigurationProvider(@NotNull GradleExecutionSettings buildSrcProjectSettings, @NotNull GradleExecutionSettings mainBuildExecutionSettings) {
        if (buildSrcProjectSettings == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(7);
        }
        if (mainBuildExecutionSettings == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(8);
        }
        TargetEnvironmentConfigurationProvider targetEnvironmentConfigurationProvider = ExternalSystemExecutionAware.Companion.getEnvironmentConfigurationProvider((ExternalSystemExecutionSettings)mainBuildExecutionSettings);
        ExternalSystemExecutionAware.Companion.setEnvironmentConfigurationProvider((ExternalSystemExecutionSettings)buildSrcProjectSettings, targetEnvironmentConfigurationProvider);
    }

    private void includeRootBuildIncludedBuildsIfNeeded(@NotNull GradleExecutionSettings buildSrcProjectSettings, @Nullable CompositeBuildData compositeBuildData, @NotNull String mainBuildPath) {
        if (buildSrcProjectSettings == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(9);
        }
        if (mainBuildPath == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(10);
        }
        if (compositeBuildData == null) {
            return;
        }
        String projectGradleVersion = this.myResolverContext.getProjectGradleVersion();
        if (projectGradleVersion == null) {
            return;
        }
        if (GradleVersionUtil.isGradleOlderThan((String)projectGradleVersion, (String)"6.7")) {
            return;
        }
        for (BuildParticipant buildParticipant : GradleBuildSrcProjectsResolver.excludeTransitiveParentsOf(mainBuildPath, compositeBuildData.getCompositeParticipants())) {
            buildSrcProjectSettings.withArguments(new String[]{"--include-build", buildParticipant.getRootPath()});
        }
    }

    @NotNull
    private static Collection<BuildParticipant> excludeTransitiveParentsOf(@NotNull String path, @NotNull List<BuildParticipant> participants) {
        if (path == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(11);
        }
        if (participants == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(12);
        }
        LinkedHashMap<String, BuildParticipant> rootPathParticipantMap = new LinkedHashMap<String, BuildParticipant>();
        for (BuildParticipant participant : participants) {
            rootPathParticipantMap.put(participant.getRootPath(), participant);
        }
        String currentPath = path;
        while (currentPath != null) {
            BuildParticipant removed = (BuildParticipant)rootPathParticipantMap.remove(currentPath);
            currentPath = removed != null ? removed.getParentRootPath() : null;
        }
        Collection<BuildParticipant> collection = rootPathParticipantMap.values();
        if (collection == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @Nullable
    private static CompositeBuildData getCompositeBuildData(@NotNull DataNode<ProjectData> mainBuildProjectDataNode) {
        DataNode compositeBuildDataNode;
        if (mainBuildProjectDataNode == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(14);
        }
        return (compositeBuildDataNode = ExternalSystemApiUtil.find(mainBuildProjectDataNode, CompositeBuildData.KEY)) != null ? (CompositeBuildData)compositeBuildDataNode.getData() : null;
    }

    private void handleBuildSrcProject(@NotNull DataNode<ProjectData> resultProjectDataNode, @Nullable String buildName, @NotNull Collection<DataNode<BuildScriptClasspathData>> buildClasspathNodes, @NotNull Map<String, DataNode<ModuleData>> includedModulesPaths, @NotNull DefaultProjectResolverContext buildSrcResolverCtx, @NotNull Function<ProjectConnection, DataNode<ProjectData>> projectConnectionDataNodeFunction) {
        String projectPath;
        File projectPathFile;
        if (resultProjectDataNode == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(15);
        }
        if (buildClasspathNodes == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(16);
        }
        if (includedModulesPaths == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(17);
        }
        if (buildSrcResolverCtx == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(18);
        }
        if (projectConnectionDataNodeFunction == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(19);
        }
        if (!(projectPathFile = new File(projectPath = buildSrcResolverCtx.getProjectPath())).isDirectory()) {
            return;
        }
        if (includedModulesPaths.containsKey(projectPath)) {
            return;
        }
        if (ArrayUtil.isEmpty((Object[])projectPathFile.list((dir, name2) -> !name2.equals(".gradle") && !name2.equals("build")))) {
            return;
        }
        if (buildSrcResolverCtx.isPreviewMode()) {
            ModuleData buildSrcModuleData = new ModuleData(":buildSrc", GradleConstants.SYSTEM_ID, GradleProjectResolverUtil.getDefaultModuleTypeId(), "buildSrc", projectPath, projectPath);
            GradleModuleDataKt.setBuildSrcModule(buildSrcModuleData);
            resultProjectDataNode.createChild(ProjectKeys.MODULE, (Object)buildSrcModuleData);
            return;
        }
        DataNode<ProjectData> buildSrcProjectDataNode = this.myProjectResolver.getHelper().execute(projectPath, buildSrcResolverCtx.getSettings(), this.mySyncTaskId, this.myListener, null, projectConnectionDataNodeFunction);
        if (buildSrcProjectDataNode == null) {
            return;
        }
        for (DataNode libraryDataNode : ExternalSystemApiUtil.getChildren(buildSrcProjectDataNode, (Key)ProjectKeys.LIBRARY)) {
            GradleProjectResolverUtil.linkProjectLibrary(resultProjectDataNode, (LibraryData)libraryDataNode.getData());
        }
        HashMap<String, DataNode<? extends ModuleData>> buildSrcModules = new HashMap<String, DataNode<? extends ModuleData>>();
        boolean modulePerSourceSet = buildSrcResolverCtx.isResolveModulePerSourceSet();
        DataNode buildSrcModuleNode = null;
        for (DataNode moduleNode : ExternalSystemApiUtil.getChildren(buildSrcProjectDataNode, (Key)ProjectKeys.MODULE)) {
            DataNode<ModuleData> includedModule;
            ModuleData moduleData = (ModuleData)moduleNode.getData();
            buildSrcModules.put(moduleData.getId(), (DataNode<? extends ModuleData>)moduleNode);
            boolean isBuildSrcModule = "buildSrc".equals(moduleData.getExternalName());
            if (isBuildSrcModule && !modulePerSourceSet) {
                buildSrcModuleNode = moduleNode;
            }
            if (modulePerSourceSet) {
                for (DataNode sourceSetNode : ExternalSystemApiUtil.getChildren((DataNode)moduleNode, GradleSourceSetData.KEY)) {
                    buildSrcModules.put(((GradleSourceSetData)((Object)sourceSetNode.getData())).getId(), (DataNode<? extends ModuleData>)sourceSetNode);
                    if (!isBuildSrcModule || buildSrcModuleNode != null || !((GradleSourceSetData)((Object)sourceSetNode.getData())).getExternalName().endsWith(":main")) continue;
                    buildSrcModuleNode = sourceSetNode;
                }
            }
            if ((includedModule = includedModulesPaths.get(moduleData.getLinkedExternalProjectPath())) != null) continue;
            GradleModuleDataKt.setBuildSrcModule(moduleData);
            resultProjectDataNode.addChild(moduleNode);
            String[] moduleGroup = GradleBuildSrcProjectsResolver.getModuleGroup(resultProjectDataNode, buildName, buildSrcResolverCtx, moduleData);
            if (moduleGroup != null) {
                moduleData.setIdeModuleGroup(moduleGroup);
            }
            for (DataNode sourceSetNode : ExternalSystemApiUtil.getChildren((DataNode)moduleNode, GradleSourceSetData.KEY)) {
                if (moduleGroup != null) {
                    ((GradleSourceSetData)((Object)sourceSetNode.getData())).setIdeModuleGroup(moduleGroup);
                }
                ExternalSystemApiUtil.getChildren((DataNode)sourceSetNode, (Key)ProjectKeys.MODULE_DEPENDENCY).forEach(node -> GradleBuildSrcProjectsResolver.maybeUpdateNonBuildSrcModuleDependencies(includedModulesPaths, (ModuleDependencyData)node.getData()));
            }
        }
        if (buildSrcModuleNode != null) {
            GradleBuildSrcProjectsResolver.addBuildSrcToBuildScriptClasspathData(buildClasspathNodes, buildSrcModules, buildSrcModuleNode);
        }
    }

    public static void addBuildSrcToBuildScriptClasspathData(@NotNull Collection<DataNode<BuildScriptClasspathData>> buildClasspathNodes, @NotNull Map<String, DataNode<? extends ModuleData>> buildSrcModules, @NotNull DataNode<? extends ModuleData> buildSrcModuleNode) {
        if (buildClasspathNodes == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(20);
        }
        if (buildSrcModules == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(21);
        }
        if (buildSrcModuleNode == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(22);
        }
        HashSet<String> buildSrcRuntimeSourcesPaths = new HashSet<String>();
        HashSet buildSrcRuntimeClassesPaths = new HashSet();
        GradleBuildSrcProjectsResolver.addSourcePaths(buildSrcRuntimeSourcesPaths, buildSrcModuleNode);
        for (DataNode child : buildSrcModuleNode.getChildren()) {
            LibraryDependencyData dependencyData;
            ModuleDependencyData moduleDependencyData;
            Object childData = child.getData();
            if (childData instanceof ModuleDependencyData && (moduleDependencyData = (ModuleDependencyData)childData).getScope().isForProductionRuntime()) {
                DataNode<? extends ModuleData> depModuleNode = buildSrcModules.get(((ModuleData)moduleDependencyData.getTarget()).getId());
                if (depModuleNode == null) continue;
                GradleBuildSrcProjectsResolver.addSourcePaths(buildSrcRuntimeSourcesPaths, depModuleNode);
                continue;
            }
            if (!(childData instanceof LibraryDependencyData) || (dependencyData = (LibraryDependencyData)childData).getExternalName().startsWith("gradle-api-")) continue;
            LibraryData libraryData = (LibraryData)dependencyData.getTarget();
            buildSrcRuntimeSourcesPaths.addAll(libraryData.getPaths(LibraryPathType.SOURCE));
            buildSrcRuntimeClassesPaths.addAll(libraryData.getPaths(LibraryPathType.BINARY));
        }
        if (!buildSrcRuntimeSourcesPaths.isEmpty() || !buildSrcRuntimeClassesPaths.isEmpty()) {
            buildClasspathNodes.forEach(classpathNode -> {
                BuildScriptClasspathData copyFrom = (BuildScriptClasspathData)((Object)((Object)classpathNode.getData()));
                ArrayList<BuildScriptClasspathData.ClasspathEntry> classpathEntries = new ArrayList<BuildScriptClasspathData.ClasspathEntry>(copyFrom.getClasspathEntries().size() + 1);
                classpathEntries.addAll(copyFrom.getClasspathEntries());
                classpathEntries.add(BuildScriptClasspathData.ClasspathEntry.create(new HashSet<String>(buildSrcRuntimeClassesPaths), new HashSet<String>(buildSrcRuntimeSourcesPaths), Collections.emptySet()));
                BuildScriptClasspathData buildScriptClasspathData = new BuildScriptClasspathData(GradleConstants.SYSTEM_ID, classpathEntries);
                buildScriptClasspathData.setGradleHomeDir(copyFrom.getGradleHomeDir());
                DataNode parent = classpathNode.getParent();
                assert (parent != null);
                parent.createChild(BuildScriptClasspathData.KEY, (Object)buildScriptClasspathData);
                classpathNode.clear(true);
            });
        }
    }

    private static void maybeUpdateNonBuildSrcModuleDependencies(@NotNull Map<String, DataNode<ModuleData>> includedModulesPaths, @NotNull ModuleDependencyData moduleDependencyData) {
        String targetModuleName;
        DataNode nonBuildSrcModule;
        ModuleData target;
        DataNode<ModuleData> moduleDataResolvedForMainBuild;
        if (includedModulesPaths == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(23);
        }
        if (moduleDependencyData == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(24);
        }
        if ((moduleDataResolvedForMainBuild = includedModulesPaths.get((target = (ModuleData)moduleDependencyData.getTarget()).getLinkedExternalProjectPath())) != null && target instanceof GradleSourceSetData && (nonBuildSrcModule = ExternalSystemApiUtil.find(moduleDataResolvedForMainBuild, GradleSourceSetData.KEY, arg_0 -> GradleBuildSrcProjectsResolver.lambda$maybeUpdateNonBuildSrcModuleDependencies$4(targetModuleName = target.getModuleName(), arg_0))) != null) {
            moduleDependencyData.setTarget((AbstractExternalEntityData)((ModuleData)nonBuildSrcModule.getData()));
        }
    }

    private static String @Nullable [] getModuleGroup(@NotNull DataNode<ProjectData> resultProjectDataNode, @Nullable String buildName, @NotNull DefaultProjectResolverContext buildSrcResolverCtx, ModuleData moduleData) {
        if (resultProjectDataNode == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(25);
        }
        if (buildSrcResolverCtx == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(26);
        }
        if (!buildSrcResolverCtx.isUseQualifiedModuleNames() && moduleData.getIdeModuleGroup() != null) {
            String buildNamePrefix = StringUtil.isNotEmpty((String)buildName) ? buildName : ((ProjectData)resultProjectDataNode.getData()).getInternalName();
            return (String[])ArrayUtil.prepend((Object)buildNamePrefix, (Object[])moduleData.getIdeModuleGroup());
        }
        return null;
    }

    private static void addSourcePaths(Set<String> paths, DataNode<? extends ModuleData> moduleNode) {
        ExternalSystemApiUtil.getChildren(moduleNode, (Key)ProjectKeys.CONTENT_ROOT).stream().flatMap(contentNode -> ((ContentRootData)contentNode.getData()).getPaths(ExternalSystemSourceType.SOURCE).stream()).map(ContentRootData.SourceRoot::getPath).forEach(paths::add);
    }

    @NotNull
    private static String getBuildSrcGroup(String buildPath, String buildName) {
        if (StringUtil.isEmpty((String)buildName)) {
            String string2 = new File(buildPath).getName();
            if (string2 == null) {
                GradleBuildSrcProjectsResolver.$$$reportNull$$$0(27);
            }
            return string2;
        }
        String string3 = buildName;
        if (string3 == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(28);
        }
        return string3;
    }

    private static /* synthetic */ boolean lambda$maybeUpdateNonBuildSrcModuleDependencies$4(String targetModuleName, DataNode node) {
        return targetModuleName.equals(((GradleSourceSetData)((Object)node.getData())).getModuleName());
    }

    private /* synthetic */ void lambda$discoverAndAppendTo$0(String gradleHome2, List jvmOptions, Index index, DataNode mainBuildProjectDataNode, Build build) {
        GradleExecutionSettings buildSrcProjectSettings;
        String buildPath = FileUtil.toSystemIndependentName((String)build.getBuildIdentifier().getRootDir().getPath());
        if (gradleHome2 != null) {
            if (this.myMainBuildExecutionSettings != null) {
                buildSrcProjectSettings = new GradleExecutionSettings(gradleHome2, this.myMainBuildExecutionSettings.getServiceDirectory(), DistributionType.LOCAL, this.myMainBuildExecutionSettings.isOfflineWork());
                buildSrcProjectSettings.setIdeProjectPath(this.myMainBuildExecutionSettings.getIdeProjectPath());
                buildSrcProjectSettings.setJavaHome(this.myMainBuildExecutionSettings.getJavaHome());
                buildSrcProjectSettings.setResolveModulePerSourceSet(this.myMainBuildExecutionSettings.isResolveModulePerSourceSet());
                buildSrcProjectSettings.setUseQualifiedModuleNames(this.myMainBuildExecutionSettings.isUseQualifiedModuleNames());
                buildSrcProjectSettings.setRemoteProcessIdleTtlInMs(this.myMainBuildExecutionSettings.getRemoteProcessIdleTtlInMs());
                buildSrcProjectSettings.setVerboseProcessing(this.myMainBuildExecutionSettings.isVerboseProcessing());
                buildSrcProjectSettings.setWrapperPropertyFile(this.myMainBuildExecutionSettings.getWrapperPropertyFile());
                buildSrcProjectSettings.setDownloadSources(this.myMainBuildExecutionSettings.isDownloadSources());
                buildSrcProjectSettings.setParallelModelFetch(this.myMainBuildExecutionSettings.isParallelModelFetch());
                buildSrcProjectSettings.setDelegatedBuild(this.myMainBuildExecutionSettings.isDelegatedBuild());
                buildSrcProjectSettings.withArguments(this.myMainBuildExecutionSettings.getArguments()).withEnvironmentVariables(this.myMainBuildExecutionSettings.getEnv()).passParentEnvs(this.myMainBuildExecutionSettings.isPassParentEnvs()).withVmOptions((Collection)jvmOptions);
                GradleBuildSrcProjectsResolver.reuseTargetEnvironmentConfigurationProvider(buildSrcProjectSettings, this.myMainBuildExecutionSettings);
            } else {
                buildSrcProjectSettings = new GradleExecutionSettings(gradleHome2, null, DistributionType.LOCAL, false);
            }
            this.includeRootBuildIncludedBuildsIfNeeded(buildSrcProjectSettings, index.compositeBuildData(), buildPath);
        } else {
            buildSrcProjectSettings = this.myMainBuildExecutionSettings;
        }
        String buildSrcProjectPath = buildPath + "/buildSrc";
        DefaultProjectResolverContext buildSrcResolverCtx = new DefaultProjectResolverContext(this.mySyncTaskId, buildSrcProjectPath, buildSrcProjectSettings, this.myListener, this.myResolverContext.getPolicy(), false);
        this.myResolverContext.copyUserDataTo(buildSrcResolverCtx);
        String buildName = index.buildNames().get(buildPath);
        String buildSrcGroup = GradleBuildSrcProjectsResolver.getBuildSrcGroup(buildPath, buildName);
        buildSrcResolverCtx.setBuildSrcGroup(buildSrcGroup);
        this.handleBuildSrcProject((DataNode<ProjectData>)mainBuildProjectDataNode, buildName, index.buildClasspathNodesMap().getModifiable((Object)Paths.get(buildPath, new String[0])), index.includedModulesPaths(), buildSrcResolverCtx, this.myProjectResolver.getProjectDataFunction(buildSrcResolverCtx, this.myResolverChain, true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectResolver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncTaskId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectResolverChain";
                break;
            }
            case 5: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainBuildProjectDataNode";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildSrcProjectSettings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainBuildExecutionSettings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainBuildPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "participants";
                break;
            }
            case 13: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleBuildSrcProjectsResolver";
                break;
            }
            case 15: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultProjectDataNode";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildClasspathNodes";
                break;
            }
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includedModulesPaths";
                break;
            }
            case 18: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildSrcResolverCtx";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectConnectionDataNodeFunction";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildSrcModules";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildSrcModuleNode";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDependencyData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleBuildSrcProjectsResolver";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeTransitiveParentsOf";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildSrcGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "discoverAndAppendTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "prepareIndexes";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reuseTargetEnvironmentConfigurationProvider";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "includeRootBuildIncludedBuildsIfNeeded";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "excludeTransitiveParentsOf";
                break;
            }
            case 13: 
            case 27: 
            case 28: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCompositeBuildData";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "handleBuildSrcProject";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addBuildSrcToBuildScriptClasspathData";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "maybeUpdateNonBuildSrcModuleDependencies";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getModuleGroup";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 13, 27, 28 -> new IllegalStateException(string2);
        };
    }

    public record Index(Map<String, String> buildNames, CompositeBuildData compositeBuildData, MultiMap<Path, DataNode<BuildScriptClasspathData>> buildClasspathNodesMap, Map<String, DataNode<ModuleData>> includedModulesPaths) {
    }
}

