/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.gradle.toolingExtension.impl.telemetry.GradleTracingContext;
import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.diagnostic.ExternalSystemSyncDiagnostic;
import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemOperationDescriptor;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemSyncActionsCollector;
import com.intellij.openapi.externalSystem.statistics.Phase;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemDebugEnvironment;
import com.intellij.openapi.externalSystem.util.ExternalSystemTelemetryUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.gradle.api.ProjectConfigurationException;
import org.gradle.tooling.BuildActionFailureException;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.Build;
import org.jetbrains.plugins.gradle.model.DefaultExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProjectPreview;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.GradleBuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ModelsHolder;
import org.jetbrains.plugins.gradle.model.Project;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.model.data.CompositeBuildData;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.remote.impl.GradleLibraryNamesMixer;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.ArtifactMappingService;
import org.jetbrains.plugins.gradle.service.project.BaseProjectImportErrorHandler;
import org.jetbrains.plugins.gradle.service.project.BaseResolverExtension;
import org.jetbrains.plugins.gradle.service.project.DefaultProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.GradleBuildSrcProjectsResolver;
import org.jetbrains.plugins.gradle.service.project.GradleImportCustomizer;
import org.jetbrains.plugins.gradle.service.project.GradlePartialResolverPolicy;
import org.jetbrains.plugins.gradle.service.project.GradlePreviewCustomizer;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.LibraryDataNodeSubstitutor;
import org.jetbrains.plugins.gradle.service.project.ModifiableGradleProjectModelImpl;
import org.jetbrains.plugins.gradle.service.project.ModuleMappingInfo;
import org.jetbrains.plugins.gradle.service.project.ProjectModelContributor;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.ToolingModelsProviderImpl;
import org.jetbrains.plugins.gradle.settings.GradleBuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.telemetry.GradleOpenTelemetryTraceExporter;

public class GradleProjectResolver
implements ExternalSystemProjectResolver<GradleExecutionSettings> {
    private static final Logger LOG = Logger.getInstance(GradleProjectResolver.class);
    private static final ExternalSystemSyncDiagnostic syncMetrics = ExternalSystemSyncDiagnostic.getInstance();
    @NotNull
    private final GradleExecutionHelper myHelper;
    private final GradleLibraryNamesMixer myLibraryNamesMixer;
    private final MultiMap<ExternalSystemTaskId, CancellationTokenSource> myCancellationMap;
    public static final Key<Map<String, Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>>> RESOLVED_SOURCE_SETS = Key.create((String)"resolvedSourceSets");
    public static final Key<Map<String, Pair<String, ExternalSystemSourceType>>> MODULES_OUTPUTS = Key.create((String)"moduleOutputsMap");
    public static final Key<MultiMap<ExternalSystemSourceType, String>> GRADLE_OUTPUTS = Key.create((String)"gradleOutputs");
    private static final Key<File> GRADLE_HOME_DIR = Key.create((String)"gradleHomeDir");

    public GradleProjectResolver() {
        this(new GradleExecutionHelper());
    }

    public GradleProjectResolver(@NotNull GradleExecutionHelper helper) {
        if (helper == null) {
            GradleProjectResolver.$$$reportNull$$$0(0);
        }
        this.myLibraryNamesMixer = new GradleLibraryNamesMixer();
        this.myCancellationMap = MultiMap.createConcurrent();
        this.myHelper = helper;
    }

    @Nullable
    public DataNode<ProjectData> resolveProjectInfo(@NotNull ExternalSystemTaskId syncTaskId, @NotNull String projectPath, boolean isPreviewMode, @Nullable GradleExecutionSettings settings2, @Nullable ProjectResolverPolicy resolverPolicy, @NotNull ExternalSystemTaskNotificationListener listener2) throws ExternalSystemException, IllegalArgumentException, IllegalStateException {
        if (syncTaskId == null) {
            GradleProjectResolver.$$$reportNull$$$0(1);
        }
        if (projectPath == null) {
            GradleProjectResolver.$$$reportNull$$$0(2);
        }
        if (listener2 == null) {
            GradleProjectResolver.$$$reportNull$$$0(3);
        }
        GradlePartialResolverPolicy gradleResolverPolicy = null;
        if (resolverPolicy != null) {
            if (resolverPolicy instanceof GradlePartialResolverPolicy) {
                gradleResolverPolicy = (GradlePartialResolverPolicy)resolverPolicy;
            } else {
                throw new ExternalSystemException("Unsupported project resolver policy: " + resolverPolicy.getClass().getName());
            }
        }
        if (isPreviewMode) {
            return GradlePreviewCustomizer.Companion.getCustomizer(projectPath, syncTaskId).resolvePreviewProjectInfo(projectPath, syncTaskId, settings2);
        }
        DefaultProjectResolverContext resolverContext = new DefaultProjectResolverContext(syncTaskId, projectPath, settings2, listener2, gradleResolverPolicy, false);
        CancellationTokenSource cancellationTokenSource = resolverContext.getCancellationTokenSource();
        this.myCancellationMap.putValue((Object)resolverContext.getExternalSystemTaskId(), (Object)cancellationTokenSource);
        long activityId = resolverContext.getExternalSystemTaskId().getId();
        ExternalSystemSyncActionsCollector.logSyncStarted((com.intellij.openapi.project.Project)resolverContext.getExternalSystemTaskId().findProject(), (long)activityId);
        syncMetrics.getOrStartSpan("gradle.sync.duration");
        Span gradleExecutionSpan = ExternalSystemTelemetryUtil.getTracer((ProjectSystemId)GradleConstants.SYSTEM_ID).spanBuilder("GradleExecution").startSpan();
        try {
            DataNode<ProjectData> dataNode;
            block18: {
                Scope ignore = gradleExecutionSpan.makeCurrent();
                try {
                    if (settings2 != null) {
                        this.myHelper.ensureInstalledWrapper(syncTaskId, projectPath, settings2, listener2, cancellationTokenSource.token());
                    }
                    Predicate<GradleProjectResolverExtension> extensionsFilter = gradleResolverPolicy != null ? gradleResolverPolicy.getExtensionsFilter() : null;
                    GradleProjectResolverExtension projectResolverChain = GradleProjectResolver.createProjectResolverChain(resolverContext, extensionsFilter);
                    DataNode<ProjectData> projectDataNode = this.myHelper.execute(projectPath, settings2, syncTaskId, listener2, cancellationTokenSource, this.getProjectDataFunction(resolverContext, projectResolverChain, false));
                    if (GradleVersionUtil.isGradleOlderThan((String)resolverContext.getProjectGradleVersion(), (String)"8.0")) {
                        File gradleUserHome2 = (File)resolverContext.getUserData(GRADLE_HOME_DIR);
                        new GradleBuildSrcProjectsResolver(this, resolverContext, gradleUserHome2, settings2, listener2, syncTaskId, projectResolverChain).discoverAndAppendTo(projectDataNode);
                    }
                    dataNode = projectDataNode;
                    if (ignore == null) break block18;
                }
                catch (Throwable throwable) {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignore.close();
            }
            return dataNode;
        }
        finally {
            this.myCancellationMap.remove((Object)resolverContext.getExternalSystemTaskId(), (Object)cancellationTokenSource);
            gradleExecutionSpan.end();
        }
    }

    @NotNull
    Function<ProjectConnection, DataNode<ProjectData>> getProjectDataFunction(DefaultProjectResolverContext resolverContext, GradleProjectResolverExtension projectResolverChain, boolean isBuildSrcProject) {
        return new ProjectConnectionDataNodeFunction(resolverContext, projectResolverChain, isBuildSrcProject);
    }

    @NotNull
    GradleExecutionHelper getHelper() {
        GradleExecutionHelper gradleExecutionHelper = this.myHelper;
        if (gradleExecutionHelper == null) {
            GradleProjectResolver.$$$reportNull$$$0(4);
        }
        return gradleExecutionHelper;
    }

    public boolean cancelTask(@NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (id == null) {
            GradleProjectResolver.$$$reportNull$$$0(5);
        }
        if (listener2 == null) {
            GradleProjectResolver.$$$reportNull$$$0(6);
        }
        for (CancellationTokenSource cancellationTokenSource : this.myCancellationMap.get((Object)id)) {
            cancellationTokenSource.cancel();
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private DataNode<ProjectData> doResolveProjectInfo(@NotNull DefaultProjectResolverContext resolverCtx, @NotNull GradleProjectResolverExtension projectResolverChain, boolean isBuildSrcProject) throws IllegalArgumentException, IllegalStateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private DataNode<ProjectData> convertData(@NotNull ProjectImportAction.AllModels allModels, @NotNull GradleExecutionSettings executionSettings, @NotNull DefaultProjectResolverContext resolverCtx, @Nullable GradleVersion gradleVersion2, @NotNull GradleProjectResolverExtension tracedResolverChain, boolean isBuildSrcProject, boolean useCustomSerialization) {
        IdeaModule ideaModule;
        DataNode moduleDataNode;
        if (allModels == null) {
            GradleProjectResolver.$$$reportNull$$$0(10);
        }
        if (executionSettings == null) {
            GradleProjectResolver.$$$reportNull$$$0(11);
        }
        if (resolverCtx == null) {
            GradleProjectResolver.$$$reportNull$$$0(12);
        }
        if (tracedResolverChain == null) {
            GradleProjectResolver.$$$reportNull$$$0(13);
        }
        long activityId = resolverCtx.getExternalSystemTaskId().getId();
        syncMetrics.getOrStartSpan(Phase.PROJECT_RESOLVERS.name(), "gradle.sync.duration");
        ExternalSystemSyncActionsCollector.logPhaseStarted(null, (long)activityId, (Phase)Phase.PROJECT_RESOLVERS);
        GradleProjectResolver.extractExternalProjectModels(allModels, resolverCtx, useCustomSerialization);
        String projectName = allModels.getMainBuild().getName();
        ModifiableGradleProjectModelImpl modifiableGradleProjectModel = new ModifiableGradleProjectModelImpl(projectName, resolverCtx.getProjectPath());
        ToolingModelsProviderImpl modelsProvider = new ToolingModelsProviderImpl(allModels);
        ProjectModelContributor.EP_NAME.forEachExtensionSafe(extension -> {
            resolverCtx.checkCancelled();
            long starResolveTime = System.currentTimeMillis();
            String modelContributorName = extension.getClass().getSimpleName();
            ExternalSystemTelemetryUtil.runWithSpan((ProjectSystemId)GradleConstants.SYSTEM_ID, (String)"ExternalSystemProjectModelContributor", span -> {
                span.setAttribute("contributor.name", modelContributorName);
                extension.accept(modifiableGradleProjectModel, modelsProvider, resolverCtx);
            });
            long resolveTimeInMs = System.currentTimeMillis() - starResolveTime;
            LOG.debug(String.format("Project model contributed by `" + modelContributorName + "` in %d ms", resolveTimeInMs));
        });
        DataNode<ProjectData> projectDataNode = modifiableGradleProjectModel.buildDataNodeGraph();
        ExternalSystemOperationDescriptor externalSystemOperationDescriptor = new ExternalSystemOperationDescriptor(activityId);
        DataNode descriptorDataNode = new DataNode(ExternalSystemOperationDescriptor.OPERATION_DESCRIPTOR_KEY, (Object)externalSystemOperationDescriptor, projectDataNode);
        projectDataNode.addChild(descriptorDataNode);
        DomainObjectSet gradleModules = Collections.emptySet();
        IdeaProject ideaProject = (IdeaProject)allModels.getModel(IdeaProject.class);
        if (ideaProject != null) {
            tracedResolverChain.populateProjectExtraModels(ideaProject, projectDataNode);
            gradleModules = ideaProject.getModules();
            if (gradleModules == null || gradleModules.isEmpty()) {
                throw new IllegalStateException("No modules found for the target project: " + ideaProject);
            }
        }
        Collection<IdeaModule> includedModules = GradleProjectResolver.exposeCompositeBuild(allModels, resolverCtx, projectDataNode);
        HashMap<String, Pair<DataNode<ModuleData>, IdeaModule>> moduleMap = new HashMap<String, Pair<DataNode<ModuleData>, IdeaModule>>();
        HashMap sourceSetsMap = new HashMap();
        projectDataNode.putUserData(RESOLVED_SOURCE_SETS, sourceSetsMap);
        Map moduleOutputsMap = CollectionFactory.createFilePathMap();
        projectDataNode.putUserData(MODULES_OUTPUTS, (Object)moduleOutputsMap);
        ArtifactMappingService artifactsMap = resolverCtx.getArtifactsMap();
        for (Object gradleModule : ContainerUtil.concat((Iterable)gradleModules, includedModules)) {
            String moduleName;
            if (gradleModule == null) continue;
            resolverCtx.checkCancelled();
            if (ExternalSystemDebugEnvironment.DEBUG_ORPHAN_MODULES_PROCESSING) {
                LOG.info(String.format("Importing module data: %s", gradleModule));
            }
            if ((moduleName = gradleModule.getName()) == null) {
                throw new IllegalStateException("Module with undefined name detected: " + (IdeaModule)gradleModule);
            }
            moduleDataNode = tracedResolverChain.createModule((IdeaModule)gradleModule, projectDataNode);
            if (moduleDataNode == null) continue;
            String mainModuleId = GradleProjectResolverUtil.getModuleId(resolverCtx, (IdeaModule)gradleModule);
            if (moduleMap.containsKey(mainModuleId)) {
                throw new IllegalStateException("Attempt to add module with already existing id [" + mainModuleId + "]\n new module: " + (IdeaModule)gradleModule + "\n existing module: " + ((Pair)moduleMap.get((Object)mainModuleId)).second);
            }
            moduleMap.put(mainModuleId, (Pair<DataNode<ModuleData>, IdeaModule>)Pair.create((Object)moduleDataNode, (Object)gradleModule));
        }
        executionSettings.getExecutionWorkspace().setModuleIdIndex(moduleMap);
        File gradleHomeDir = null;
        for (Pair pair : moduleMap.values()) {
            GradleBuildScriptClasspathModel buildScriptClasspathModel;
            moduleDataNode = (DataNode)pair.first;
            ideaModule = (IdeaModule)pair.second;
            if (gradleHomeDir == null && (buildScriptClasspathModel = resolverCtx.getExtraProject(ideaModule, GradleBuildScriptClasspathModel.class)) != null) {
                gradleHomeDir = buildScriptClasspathModel.getGradleHomeDir();
            }
            tracedResolverChain.populateModuleContentRoots(ideaModule, (DataNode<ModuleData>)moduleDataNode);
            tracedResolverChain.populateModuleCompileOutputSettings(ideaModule, (DataNode<ModuleData>)moduleDataNode);
            if (!isBuildSrcProject) {
                tracedResolverChain.populateModuleTasks(ideaModule, (DataNode<ModuleData>)moduleDataNode, projectDataNode);
            }
            SmartList modules = new SmartList();
            modules.add(moduleDataNode);
            modules.addAll(ExternalSystemApiUtil.findAll((DataNode)moduleDataNode, GradleSourceSetData.KEY));
            ExternalSystemSourceType[] sourceTypes = new ExternalSystemSourceType[]{ExternalSystemSourceType.SOURCE, ExternalSystemSourceType.RESOURCE, ExternalSystemSourceType.TEST, ExternalSystemSourceType.TEST_RESOURCE};
            for (DataNode module : modules) {
                ModuleData moduleData = (ModuleData)module.getData();
                for (ExternalSystemSourceType sourceType : sourceTypes) {
                    String path = moduleData.getCompileOutputPath(sourceType);
                    if (path == null) continue;
                    moduleOutputsMap.put(path, Pair.create((Object)moduleData.getId(), (Object)sourceType));
                }
                if (!(moduleData instanceof GradleSourceSetData)) continue;
                for (File artifactFile2 : moduleData.getArtifacts()) {
                    artifactsMap.storeModuleId(ExternalSystemApiUtil.toCanonicalPath((String)artifactFile2.getPath()), moduleData.getId());
                }
            }
            ExternalProject externalProject = resolverCtx.getExtraProject(ideaModule, ExternalProject.class);
            if (externalProject == null) continue;
            externalProject.getSourceSetModel().getAdditionalArtifacts().forEach(artifactFile -> {
                String path = ExternalSystemApiUtil.toCanonicalPath((String)artifactFile.getPath());
                ModuleMappingInfo mapping = artifactsMap.getModuleMapping(path);
                if (mapping != null && "base-gradle".equals(mapping.getOwnerId())) {
                    artifactsMap.markArtifactPath(path, true);
                }
            });
        }
        if (gradleHomeDir == null && executionSettings.getGradleHome() != null) {
            gradleHomeDir = new File(executionSettings.getGradleHome());
        }
        resolverCtx.putUserData(GRADLE_HOME_DIR, gradleHomeDir);
        for (Pair pair : moduleMap.values()) {
            moduleDataNode = (DataNode)pair.first;
            ideaModule = (IdeaModule)pair.second;
            tracedResolverChain.populateModuleDependencies(ideaModule, (DataNode<ModuleData>)moduleDataNode, projectDataNode);
            tracedResolverChain.populateModuleExtraModels(ideaModule, (DataNode<ModuleData>)moduleDataNode);
        }
        GradleProjectResolver.mergeSourceSetContentRoots(moduleMap, resolverCtx);
        if (resolverCtx.isResolveModulePerSourceSet()) {
            GradleProjectResolver.mergeLibraryAndModuleDependencyData(resolverCtx, projectDataNode, resolverCtx.getGradleUserHome(), gradleHomeDir, gradleVersion2);
        }
        GradleProjectResolver.processBuildSrcModules(resolverCtx, projectDataNode);
        for (GradleProjectResolverExtension resolver = tracedResolverChain; resolver != null; resolver = resolver.getNext()) {
            resolver.resolveFinished(projectDataNode);
        }
        projectDataNode.putUserData(RESOLVED_SOURCE_SETS, null);
        projectDataNode.putUserData(MODULES_OUTPUTS, null);
        Collection libraries = ExternalSystemApiUtil.getChildren(projectDataNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.LIBRARY);
        this.myLibraryNamesMixer.mixNames(libraries);
        DataNode<ProjectData> dataNode = projectDataNode;
        if (dataNode == null) {
            GradleProjectResolver.$$$reportNull$$$0(14);
        }
        return dataNode;
    }

    private static void processBuildSrcModules(DefaultProjectResolverContext ctx, DataNode<ProjectData> projectDataNode) {
        DataNode compositeNode = ExternalSystemApiUtil.find(projectDataNode, CompositeBuildData.KEY);
        if (compositeNode == null) {
            return;
        }
        GradleBuildSrcProjectsResolver.Index index = GradleBuildSrcProjectsResolver.prepareIndexes(projectDataNode);
        CompositeBuildData compositeBuildData = (CompositeBuildData)compositeNode.getData();
        for (BuildParticipant participant : compositeBuildData.getCompositeParticipants()) {
            if (!participant.getRootProjectName().endsWith("buildSrc")) continue;
            Set<String> buildSrcProjectPaths = participant.getProjects();
            @NotNull Collection buildClasspathNodes = index.buildClasspathNodesMap().get((Object)Path.of(participant.getRootPath(), new String[0]).getParent());
            @NotNull HashMap<String, DataNode<? extends ModuleData>> buildSrcModules = new HashMap<String, DataNode<? extends ModuleData>>();
            AtomicReference buildSrcModuleNode = new AtomicReference();
            ExternalSystemApiUtil.findAll(projectDataNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.MODULE).stream().filter(node -> buildSrcProjectPaths.contains(((ModuleData)node.getData()).getLinkedExternalProjectPath())).forEach(node -> {
                buildSrcModules.put(((ModuleData)node.getData()).getId(), (DataNode<? extends ModuleData>)node);
                ExternalSystemApiUtil.findAll((DataNode)node, GradleSourceSetData.KEY).forEach(sourceSetNode -> buildSrcModules.put(((GradleSourceSetData)((Object)((Object)((Object)sourceSetNode.getData())))).getId(), (DataNode<? extends ModuleData>)sourceSetNode));
                if (participant.getRootPath().equals(((ModuleData)node.getData()).getLinkedExternalProjectPath())) {
                    if (ctx.isResolveModulePerSourceSet()) {
                        buildSrcModuleNode.set(ExternalSystemApiUtil.findChild((DataNode)node, GradleSourceSetData.KEY, sourceSetNode -> ((GradleSourceSetData)((Object)((Object)((Object)sourceSetNode.getData())))).getExternalName().endsWith(":main")));
                    } else {
                        buildSrcModuleNode.set(node);
                    }
                }
            });
            GradleBuildSrcProjectsResolver.addBuildSrcToBuildScriptClasspathData(buildClasspathNodes, buildSrcModules, (DataNode<? extends ModuleData>)((DataNode)buildSrcModuleNode.get()));
        }
    }

    private static void configureExecutionArgumentsAndVmOptions(@NotNull GradleExecutionSettings executionSettings, @NotNull DefaultProjectResolverContext resolverCtx, @Nullable GradleVersion gradleVersion2, boolean isBuildSrcProject) {
        if (executionSettings == null) {
            GradleProjectResolver.$$$reportNull$$$0(15);
        }
        if (resolverCtx == null) {
            GradleProjectResolver.$$$reportNull$$$0(16);
        }
        executionSettings.withArgument("-Didea.gradle.download.sources=" + executionSettings.isDownloadSources());
        executionSettings.withArgument("-Didea.sync.active=true");
        if (resolverCtx.isResolveModulePerSourceSet()) {
            executionSettings.withArgument("-Didea.resolveSourceSetDependencies=true");
        }
        GradleVersion usedGradleVersion = Objects.requireNonNullElseGet(gradleVersion2, GradleVersion::current);
        if (executionSettings.isParallelModelFetch() && GradleVersionUtil.isGradleAtLeast((GradleVersion)usedGradleVersion, (String)"7.4")) {
            executionSettings.withArgument("-Didea.parallelModelFetch.enabled=true");
        }
        if (!isBuildSrcProject) {
            for (GradleBuildParticipant buildParticipant : executionSettings.getExecutionWorkspace().getBuildParticipants()) {
                executionSettings.withArguments(new String[]{"--include-build", buildParticipant.getProjectPath()});
            }
        }
        GradleImportCustomizer importCustomizer = GradleImportCustomizer.get();
        GradleProjectResolverUtil.createProjectResolvers(resolverCtx).forEachOrdered(extension -> {
            if (importCustomizer == null || importCustomizer.useExtraJvmArgs()) {
                ParametersList parametersList = new ParametersList();
                for (Pair<String, String> jvmArg : extension.getExtraJvmArgs()) {
                    parametersList.addProperty((String)jvmArg.first, (String)jvmArg.second);
                }
                executionSettings.withVmOptions(parametersList.getParameters());
            }
            executionSettings.withArguments(extension.getExtraCommandLineArgs());
        });
    }

    @NotNull
    private static Collection<IdeaModule> exposeCompositeBuild(ProjectImportAction.AllModels allModels, DefaultProjectResolverContext resolverCtx, DataNode<ProjectData> projectDataNode) {
        if (resolverCtx.getSettings() != null && !resolverCtx.getSettings().getExecutionWorkspace().getBuildParticipants().isEmpty()) {
            List<IdeaModule> list2 = Collections.emptyList();
            if (list2 == null) {
                GradleProjectResolver.$$$reportNull$$$0(17);
            }
            return list2;
        }
        SmartList gradleIncludedModules = new SmartList();
        List includedBuilds = allModels.getIncludedBuilds();
        if (!includedBuilds.isEmpty()) {
            ProjectData projectData = (ProjectData)projectDataNode.getData();
            CompositeBuildData compositeBuildData = new CompositeBuildData(projectData.getLinkedExternalProjectPath());
            for (Build build : includedBuilds) {
                if (build.getProjects().isEmpty()) continue;
                IdeaProject ideaProject = (IdeaProject)allModels.getModel((BuildModel)build, IdeaProject.class);
                if (ideaProject != null) {
                    gradleIncludedModules.addAll(ideaProject.getModules());
                }
                String rootProjectName = build.getName();
                BuildParticipant buildParticipant = new BuildParticipant();
                String projectPath = ExternalSystemApiUtil.toCanonicalPath((String)build.getBuildIdentifier().getRootDir().getPath());
                String parentPath = build.getParentBuildIdentifier() != null ? ExternalSystemApiUtil.toCanonicalPath((String)build.getParentBuildIdentifier().getRootDir().getPath()) : null;
                buildParticipant.setRootProjectName(rootProjectName);
                buildParticipant.setRootPath(projectPath);
                buildParticipant.setParentRootPath(parentPath);
                if (ideaProject != null) {
                    for (IdeaModule module : ideaProject.getModules()) {
                        String modulePath = ExternalSystemApiUtil.toCanonicalPath((String)module.getGradleProject().getProjectDirectory().getPath());
                        buildParticipant.getProjects().add(modulePath);
                    }
                }
                compositeBuildData.getCompositeParticipants().add(buildParticipant);
            }
            projectDataNode.createChild(CompositeBuildData.KEY, (Object)compositeBuildData);
        }
        SmartList smartList = gradleIncludedModules;
        if (smartList == null) {
            GradleProjectResolver.$$$reportNull$$$0(18);
        }
        return smartList;
    }

    private static void mergeLibraryAndModuleDependencyData(@NotNull ProjectResolverContext context, @NotNull DataNode<ProjectData> projectDataNode, @NotNull File gradleUserHomeDir, @Nullable File gradleHomeDir, @Nullable GradleVersion gradleVersion2) {
        if (context == null) {
            GradleProjectResolver.$$$reportNull$$$0(19);
        }
        if (projectDataNode == null) {
            GradleProjectResolver.$$$reportNull$$$0(20);
        }
        if (gradleUserHomeDir == null) {
            GradleProjectResolver.$$$reportNull$$$0(21);
        }
        Map sourceSetMap = (Map)projectDataNode.getUserData(RESOLVED_SOURCE_SETS);
        assert (sourceSetMap != null);
        Map moduleOutputsMap = (Map)projectDataNode.getUserData(MODULES_OUTPUTS);
        assert (moduleOutputsMap != null);
        ArtifactMappingService artifactsMap = context.getArtifactsMap();
        assert (artifactsMap != null);
        Collection libraryDependencies = ExternalSystemApiUtil.findAllRecursively(projectDataNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.LIBRARY_DEPENDENCY);
        LibraryDataNodeSubstitutor librarySubstitutor = new LibraryDataNodeSubstitutor(context, gradleUserHomeDir, gradleHomeDir, gradleVersion2, sourceSetMap, moduleOutputsMap, artifactsMap);
        for (DataNode libraryDependencyDataNode : libraryDependencies) {
            librarySubstitutor.run((DataNode<LibraryDependencyData>)libraryDependencyDataNode);
        }
    }

    private static void extractExternalProjectModels(@NotNull ProjectImportAction.AllModels models, @NotNull ProjectResolverContext resolverCtx, boolean useCustomSerialization) {
        if (models == null) {
            GradleProjectResolver.$$$reportNull$$$0(22);
        }
        if (resolverCtx == null) {
            GradleProjectResolver.$$$reportNull$$$0(23);
        }
        resolverCtx.setModels(models);
        Class modelClazz = resolverCtx.isPreviewMode() ? ExternalProjectPreview.class : ExternalProject.class;
        ExternalProject externalRootProject = (ExternalProject)models.getModel(modelClazz);
        if (externalRootProject == null) {
            return;
        }
        DefaultExternalProject wrappedExternalRootProject = useCustomSerialization ? (DefaultExternalProject)externalRootProject : new DefaultExternalProject(externalRootProject);
        models.addModel((Object)wrappedExternalRootProject, ExternalProject.class);
        Map<String, DefaultExternalProject> externalProjectsMap = GradleProjectResolver.createExternalProjectsMap(wrappedExternalRootProject);
        Collection projects2 = models.getMainBuild().getProjects();
        for (Project project : projects2) {
            ExternalProject externalProject = (ExternalProject)externalProjectsMap.get(project.getProjectIdentifier().getProjectPath());
            if (externalProject == null) continue;
            models.addModel((Object)externalProject, ExternalProject.class, (ProjectModel)project);
        }
        for (Build includedBuild : models.getIncludedBuilds()) {
            ExternalProject externalIncludedRootProject = (ExternalProject)models.getModel((BuildModel)includedBuild, modelClazz);
            if (externalIncludedRootProject == null) continue;
            DefaultExternalProject wrappedExternalIncludedRootProject = useCustomSerialization ? (DefaultExternalProject)externalIncludedRootProject : new DefaultExternalProject(externalIncludedRootProject);
            wrappedExternalRootProject.getChildProjects().put(wrappedExternalIncludedRootProject.getName(), wrappedExternalIncludedRootProject);
            Map<String, DefaultExternalProject> externalIncludedProjectsMap = GradleProjectResolver.createExternalProjectsMap(wrappedExternalIncludedRootProject);
            for (ProjectModel project : includedBuild.getProjects()) {
                ExternalProject externalProject = (ExternalProject)externalIncludedProjectsMap.get(project.getProjectIdentifier().getProjectPath());
                if (externalProject == null) continue;
                models.addModel((Object)externalProject, ExternalProject.class, project);
            }
        }
    }

    @NotNull
    private static Map<String, DefaultExternalProject> createExternalProjectsMap(@Nullable DefaultExternalProject rootExternalProject) {
        DefaultExternalProject externalProject;
        HashMap<String, DefaultExternalProject> externalProjectMap = new HashMap<String, DefaultExternalProject>();
        if (rootExternalProject == null) {
            HashMap<String, DefaultExternalProject> hashMap = externalProjectMap;
            if (hashMap == null) {
                GradleProjectResolver.$$$reportNull$$$0(24);
            }
            return hashMap;
        }
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        queue.add(rootExternalProject);
        while ((externalProject = (DefaultExternalProject)queue.pollFirst()) != null) {
            queue.addAll(externalProject.getChildProjects().values());
            externalProjectMap.put(externalProject.getQName(), externalProject);
        }
        HashMap<String, DefaultExternalProject> hashMap = externalProjectMap;
        if (hashMap == null) {
            GradleProjectResolver.$$$reportNull$$$0(25);
        }
        return hashMap;
    }

    private static void mergeSourceSetContentRoots(@NotNull Map<String, Pair<DataNode<ModuleData>, IdeaModule>> moduleMap, @NotNull ProjectResolverContext resolverCtx) {
        DataNode moduleNode;
        if (moduleMap == null) {
            GradleProjectResolver.$$$reportNull$$$0(26);
        }
        if (resolverCtx == null) {
            GradleProjectResolver.$$$reportNull$$$0(27);
        }
        HashMap<String, Counter> weightMap = new HashMap<String, Counter>();
        for (Pair<DataNode<ModuleData>, IdeaModule> pair : moduleMap.values()) {
            moduleNode = (DataNode)pair.first;
            for (DataNode contentRootNode : ExternalSystemApiUtil.findAll((DataNode)moduleNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.CONTENT_ROOT)) {
                for (File file = new File(((ContentRootData)contentRootNode.getData()).getRootPath()); file != null; file = file.getParentFile()) {
                    weightMap.computeIfAbsent(file.getPath(), __ -> new Counter()).increment();
                }
            }
            for (DataNode sourceSetNode : ExternalSystemApiUtil.findAll((DataNode)moduleNode, GradleSourceSetData.KEY)) {
                HashSet<String> set = new HashSet<String>();
                for (DataNode contentRootNode : ExternalSystemApiUtil.findAll((DataNode)sourceSetNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.CONTENT_ROOT)) {
                    for (File file = new File(((ContentRootData)contentRootNode.getData()).getRootPath()); file != null; file = file.getParentFile()) {
                        set.add(file.getPath());
                    }
                }
                for (String path : set) {
                    weightMap.computeIfAbsent(path, __ -> new Counter()).increment();
                }
            }
        }
        for (Pair<DataNode<ModuleData>, IdeaModule> pair : moduleMap.values()) {
            moduleNode = (DataNode)pair.first;
            ExternalProject externalProject = resolverCtx.getExtraProject((IdeaModule)pair.second, ExternalProject.class);
            if (externalProject == null) continue;
            GradleProjectResolver.mergeModuleContentRoots(weightMap, externalProject, (DataNode<? extends ModuleData>)moduleNode);
            for (DataNode sourceSetNode : ExternalSystemApiUtil.findAll((DataNode)moduleNode, GradleSourceSetData.KEY)) {
                GradleProjectResolver.mergeModuleContentRoots(weightMap, externalProject, (DataNode<? extends ModuleData>)sourceSetNode);
            }
        }
    }

    private static void mergeModuleContentRoots(@NotNull Map<String, Counter> weightMap, @NotNull ExternalProject externalProject, @NotNull DataNode<? extends ModuleData> moduleNode) {
        if (weightMap == null) {
            GradleProjectResolver.$$$reportNull$$$0(28);
        }
        if (externalProject == null) {
            GradleProjectResolver.$$$reportNull$$$0(29);
        }
        if (moduleNode == null) {
            GradleProjectResolver.$$$reportNull$$$0(30);
        }
        File buildDir = externalProject.getBuildDir();
        MultiMap sourceSetRoots = MultiMap.create();
        Collection contentRootNodes = ExternalSystemApiUtil.findAll(moduleNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.CONTENT_ROOT);
        if (contentRootNodes.size() <= 1) {
            return;
        }
        for (DataNode contentRootNode : contentRootNodes) {
            File root = new File(((ContentRootData)contentRootNode.getData()).getRootPath());
            if (FileUtil.isAncestor((File)buildDir, (File)root, (boolean)true)) continue;
            while (weightMap.containsKey(root.getParent()) && weightMap.get((Object)root.getParent()).count <= 1) {
                root = root.getParentFile();
            }
            ContentRootData mergedContentRoot = null;
            String rootPath = ExternalSystemApiUtil.toCanonicalPath((String)root.getPath());
            HashSet paths = new HashSet(sourceSetRoots.keySet());
            for (String path : paths) {
                if (FileUtil.isAncestor((String)rootPath, (String)path, (boolean)true)) {
                    Collection values = sourceSetRoots.remove((Object)path);
                    if (values != null) {
                        sourceSetRoots.putValues((Object)rootPath, values);
                    }
                } else if (FileUtil.isAncestor((String)path, (String)rootPath, (boolean)false)) {
                    Collection contentRoots = sourceSetRoots.get((Object)path);
                    for (ContentRootData rootData : contentRoots) {
                        if (!StringUtil.equals((CharSequence)rootData.getRootPath(), (CharSequence)path)) continue;
                        mergedContentRoot = rootData;
                        break;
                    }
                    if (mergedContentRoot != null) break;
                    mergedContentRoot = (ContentRootData)contentRoots.iterator().next();
                    break;
                }
                if (sourceSetRoots.size() != 1) continue;
                break;
            }
            if (mergedContentRoot == null) {
                mergedContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, root.getPath());
                sourceSetRoots.putValue((Object)mergedContentRoot.getRootPath(), (Object)mergedContentRoot);
            }
            for (ExternalSystemSourceType externalSystemSourceType : ExternalSystemSourceType.values()) {
                ContentRootData rootData;
                rootData = ((ContentRootData)contentRootNode.getData()).getPaths(externalSystemSourceType).iterator();
                while (rootData.hasNext()) {
                    ContentRootData.SourceRoot sourceRoot = (ContentRootData.SourceRoot)rootData.next();
                    mergedContentRoot.storePath(externalSystemSourceType, sourceRoot.getPath(), sourceRoot.getPackagePrefix());
                }
            }
            contentRootNode.clear(true);
        }
        for (Map.Entry entry : sourceSetRoots.entrySet()) {
            String rootPath = (String)entry.getKey();
            ContentRootData ideContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, rootPath);
            for (ContentRootData rootData : (Collection)entry.getValue()) {
                for (ExternalSystemSourceType externalSystemSourceType : ExternalSystemSourceType.values()) {
                    Collection roots = rootData.getPaths(externalSystemSourceType);
                    for (ContentRootData.SourceRoot sourceRoot : roots) {
                        ideContentRoot.storePath(externalSystemSourceType, sourceRoot.getPath(), sourceRoot.getPackagePrefix());
                    }
                }
            }
            moduleNode.createChild(ProjectKeys.CONTENT_ROOT, (Object)ideContentRoot);
        }
    }

    private static Throwable extractCause(Throwable e) {
        if (e instanceof BuildActionFailureException) {
            return GradleProjectResolver.extractCause(e.getCause());
        }
        Class<?> exceptionClass = e.getClass();
        if (exceptionClass.getName().equals(ProjectConfigurationException.class.getName())) {
            try {
                List causes = (List)exceptionClass.getMethod("getCauses", new Class[0]).invoke((Object)e, new Object[0]);
                return (Throwable)causes.get(0);
            }
            catch (Throwable ignore) {
                return e;
            }
        }
        return e;
    }

    @ApiStatus.Experimental
    public static GradleProjectResolverExtension createProjectResolverChain() {
        return GradleProjectResolver.createProjectResolverChain(null, null);
    }

    @NotNull
    private static GradleProjectResolverExtension createProjectResolverChain(@Nullable DefaultProjectResolverContext resolverContext, @Nullable Predicate<? super GradleProjectResolverExtension> extensionsFilter) {
        GradleProjectResolverExtension firstResolver;
        Stream<Object> extensions = GradleProjectResolverUtil.createProjectResolvers(resolverContext);
        if (extensionsFilter != null) {
            extensions = extensions.filter(extensionsFilter.or(BaseResolverExtension.class::isInstance));
        }
        ArrayDeque deque = new ArrayDeque();
        extensions.forEachOrdered(extension -> {
            GradleProjectResolverExtension previous = (GradleProjectResolverExtension)deque.peekLast();
            if (previous != null) {
                previous.setNext((GradleProjectResolverExtension)extension);
                if (previous.getNext() != extension) {
                    throw new AssertionError((Object)("Illegal next resolver got, current resolver class is " + previous.getClass().getName()));
                }
            }
            deque.add(extension);
        });
        GradleProjectResolverExtension resolverExtension = firstResolver = (GradleProjectResolverExtension)deque.peekFirst();
        assert (resolverExtension != null);
        while (resolverExtension.getNext() != null) {
            resolverExtension = resolverExtension.getNext();
        }
        if (!(resolverExtension instanceof BaseResolverExtension)) {
            throw new AssertionError((Object)("Illegal last resolver got of class " + resolverExtension.getClass().getName()));
        }
        AbstractProjectResolverExtension chainWrapper = new AbstractProjectResolverExtension(){

            @Override
            @NotNull
            public ExternalSystemException getUserFriendlyError(@Nullable BuildEnvironment buildEnvironment, @NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
                if (error == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (projectPath == null) {
                    1.$$$reportNull$$$0(1);
                }
                ExternalSystemException friendlyError = super.getUserFriendlyError(buildEnvironment, error, projectPath, buildFilePath);
                ExternalSystemException externalSystemException = new BaseProjectImportErrorHandler().checkErrorsWithoutQuickFixes(buildEnvironment, error, projectPath, buildFilePath, friendlyError);
                if (externalSystemException == null) {
                    1.$$$reportNull$$$0(2);
                }
                return externalSystemException;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "error";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "projectPath";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUserFriendlyError";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getUserFriendlyError";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 2 -> new IllegalStateException(string2);
                };
            }
        };
        chainWrapper.setNext(firstResolver);
        AbstractProjectResolverExtension abstractProjectResolverExtension = chainWrapper;
        if (abstractProjectResolverExtension == null) {
            GradleProjectResolver.$$$reportNull$$$0(31);
        }
        return abstractProjectResolverExtension;
    }

    @NotNull
    private static GradleTracingContext getActionTelemetryContext(@NotNull Span span) {
        if (span == null) {
            GradleProjectResolver.$$$reportNull$$$0(32);
        }
        GradleTracingContext context = new GradleTracingContext();
        GlobalOpenTelemetry.get().getPropagators().getTextMapPropagator().inject(Context.current().with((ImplicitContextKeyed)span), (Object)context, GradleTracingContext.SETTER);
        GradleTracingContext gradleTracingContext = context;
        if (gradleTracingContext == null) {
            GradleProjectResolver.$$$reportNull$$$0(33);
        }
        return gradleTracingContext;
    }

    private static void exportRecordedTraces(@NotNull ProjectImportAction.AllModels allModels) {
        byte[] traces;
        if (allModels == null) {
            GradleProjectResolver.$$$reportNull$$$0(34);
        }
        if ((traces = allModels.getOpenTelemetryTrace()).length == 0) {
            return;
        }
        URI telemetryHost = GradleProjectResolver.getOpenTelemetryAddress();
        if (telemetryHost == null) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> GradleOpenTelemetryTraceExporter.export(telemetryHost, traces));
    }

    @Nullable
    private static URI getOpenTelemetryAddress() {
        String property2 = System.getProperty("idea.diagnostic.opentelemetry.otlp");
        if (property2 == null) {
            return null;
        }
        if (property2.endsWith("/")) {
            return URI.create(property2 + "v1/traces");
        }
        return URI.create(property2 + "/v1/traces");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$doResolveProjectInfo$2(GradleProjectResolverExtension projectResolverChain, CountDownLatch buildFinishWaiter, GradleConnectionException exception) {
        try {
            for (GradleProjectResolverExtension resolver = projectResolverChain; resolver != null; resolver = resolver.getNext()) {
                resolver.buildFinished(exception);
            }
        }
        finally {
            buildFinishWaiter.countDown();
        }
    }

    private static /* synthetic */ void lambda$doResolveProjectInfo$1(GradleProjectResolverExtension projectResolverChain, ModelsHolder models) {
        for (GradleProjectResolverExtension resolver = projectResolverChain; resolver != null; resolver = resolver.getNext()) {
            resolver.projectsLoaded((ModelsHolder<BuildModel, ProjectModel>)models);
        }
    }

    private static /* synthetic */ GradleVersion lambda$doResolveProjectInfo$0(BuildEnvironment it) {
        return GradleVersion.version((String)it.getGradle().getGradleVersion());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 9, 14, 17, 18, 24, 25, 31, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncTaskId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 7: 
            case 12: 
            case 16: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverCtx";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectResolverChain";
                break;
            }
            case 10: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allModels";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionSettings";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracedResolverChain";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDataNode";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleUserHomeDir";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleMap";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weightMap";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProject";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNode";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "span";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelper";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveProjectInfo";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "convertData";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "exposeCompositeBuild";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createExternalProjectsMap";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectResolverChain";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTelemetryContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjectInfo";
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 31: 
            case 33: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "cancelTask";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doResolveProjectInfo";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "convertData";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "configureExecutionArgumentsAndVmOptions";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "mergeLibraryAndModuleDependencyData";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "extractExternalProjectModels";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "mergeSourceSetContentRoots";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "mergeModuleContentRoots";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getActionTelemetryContext";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "exportRecordedTraces";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 9, 14, 17, 18, 24, 25, 31, 33 -> new IllegalStateException(string2);
        };
    }

    private final class ProjectConnectionDataNodeFunction
    implements Function<ProjectConnection, DataNode<ProjectData>> {
        @NotNull
        private final GradleProjectResolverExtension myProjectResolverChain;
        private final boolean myIsBuildSrcProject;
        private final DefaultProjectResolverContext myResolverContext;

        private ProjectConnectionDataNodeFunction(@NotNull DefaultProjectResolverContext resolverContext, GradleProjectResolverExtension projectResolverChain, boolean isBuildSrcProject) {
            if (resolverContext == null) {
                ProjectConnectionDataNodeFunction.$$$reportNull$$$0(0);
            }
            if (projectResolverChain == null) {
                ProjectConnectionDataNodeFunction.$$$reportNull$$$0(1);
            }
            this.myResolverContext = resolverContext;
            this.myProjectResolverChain = projectResolverChain;
            this.myIsBuildSrcProject = isBuildSrcProject;
        }

        public DataNode<ProjectData> fun(ProjectConnection connection) {
            ExternalSystemTaskId taskId = this.myResolverContext.getExternalSystemTaskId();
            long activityId = taskId.getId();
            try {
                GradleProjectResolver.this.myCancellationMap.putValue((Object)taskId, (Object)this.myResolverContext.getCancellationTokenSource());
                this.myResolverContext.setConnection(connection);
                DataNode<ProjectData> dataNode = GradleProjectResolver.this.doResolveProjectInfo(this.myResolverContext, this.myProjectResolverChain, this.myIsBuildSrcProject);
                return dataNode;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (RuntimeException e) {
                LOG.info("Gradle project resolve error", (Throwable)e);
                ExternalSystemException esException = (ExternalSystemException)((Object)ExceptionUtil.findCause((Throwable)e, ExternalSystemException.class));
                if (esException != null && esException != e) {
                    LOG.info("\nCaused by: " + esException.getOriginalReason());
                }
                ExternalSystemSyncActionsCollector.logError((com.intellij.openapi.project.Project)taskId.findProject(), (long)activityId, (Throwable)GradleProjectResolver.extractCause(e));
                ExternalSystemSyncActionsCollector.logSyncFinished((com.intellij.openapi.project.Project)taskId.findProject(), (long)activityId, (boolean)false);
                syncMetrics.endSpan("gradle.sync.duration", span -> span.setAttribute("project", ""));
                throw this.myProjectResolverChain.getUserFriendlyError(this.myResolverContext.getBuildEnvironment(), e, this.myResolverContext.getProjectPath(), null);
            }
            finally {
                GradleProjectResolver.this.myCancellationMap.remove((Object)taskId, (Object)this.myResolverContext.getCancellationTokenSource());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resolverContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "projectResolverChain";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver$ProjectConnectionDataNodeFunction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Counter {
        int count;

        private Counter() {
        }

        void increment() {
            ++this.count;
        }

        public String toString() {
            return String.valueOf(this.count);
        }
    }
}

