/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.ArtifactMappingService;
import org.jetbrains.plugins.gradle.service.project.MapBasedArtifactMappingService;
import org.jetbrains.plugins.gradle.service.project.ModuleMappingData;
import org.jetbrains.plugins.gradle.service.project.ModuleMappingInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0001H\u0016J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0016J \u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/MapBasedArtifactMappingService;", "Lorg/jetbrains/plugins/gradle/service/project/ArtifactMappingService;", "map", "", "", "(Ljava/util/Map;)V", "()V", "keys", "", "getKeys", "()Ljava/util/Collection;", "myMap", "", "", "myNonModulesContent", "myOwnersMap", "getModuleMapping", "Lorg/jetbrains/plugins/gradle/service/project/ModuleMappingInfo;", "artifactPath", "markArtifactPath", "", "canonicalPath", "hasNonModulesContent", "", "putAll", "artifactsMap", "storeModuleId", "moduleId", "ownerId", "intellij.gradle.common"})
@SourceDebugExtension(value={"SMAP\nArtifactMappingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArtifactMappingService.kt\norg/jetbrains/plugins/gradle/service/project/MapBasedArtifactMappingService\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n215#2,2:125\n1#3:127\n9#4:128\n1855#5,2:129\n*S KotlinDebug\n*F\n+ 1 ArtifactMappingService.kt\norg/jetbrains/plugins/gradle/service/project/MapBasedArtifactMappingService\n*L\n79#1:125,2\n97#1:128\n106#1:129,2\n*E\n"})
public final class MapBasedArtifactMappingService
implements ArtifactMappingService {
    @NotNull
    private final Map<String, Set<String>> myMap;
    @NotNull
    private final Map<String, String> myOwnersMap;
    @NotNull
    private final Set<String> myNonModulesContent;

    public MapBasedArtifactMappingService() {
        this.myMap = new LinkedHashMap();
        this.myOwnersMap = new LinkedHashMap();
        this.myNonModulesContent = new HashSet();
    }

    public MapBasedArtifactMappingService(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this();
        Map<String, String> $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String k = entry.getKey();
            String v = entry.getValue();
            this.storeModuleId(k, v);
        }
    }

    @Override
    @Nullable
    public ModuleMappingInfo getModuleMapping(@NotNull String artifactPath) {
        ModuleMappingData moduleMappingData;
        Intrinsics.checkNotNullParameter((Object)artifactPath, (String)"artifactPath");
        Set<String> set = this.myMap.get(artifactPath);
        if (set != null) {
            Set<String> it = set;
            boolean bl = false;
            List list2 = CollectionsKt.toList((Iterable)it);
            boolean bl2 = this.myNonModulesContent.contains(artifactPath);
            String string2 = this.myOwnersMap.get(artifactPath);
            if (string2 == null) {
                string2 = "base-gradle";
            }
            moduleMappingData = new ModuleMappingData(list2, bl2, string2);
        } else {
            moduleMappingData = null;
        }
        return moduleMappingData;
    }

    @Override
    public void storeModuleId(@NotNull String artifactPath, @NotNull String moduleId) {
        Intrinsics.checkNotNullParameter((Object)artifactPath, (String)"artifactPath");
        Intrinsics.checkNotNullParameter((Object)moduleId, (String)"moduleId");
        this.storeModuleId(artifactPath, moduleId, "base-gradle");
    }

    @Override
    public void storeModuleId(@NotNull String artifactPath, @NotNull String moduleId, @NotNull String ownerId) {
        Intrinsics.checkNotNullParameter((Object)artifactPath, (String)"artifactPath");
        Intrinsics.checkNotNullParameter((Object)moduleId, (String)"moduleId");
        Intrinsics.checkNotNullParameter((Object)ownerId, (String)"ownerId");
        String previousOwner = this.myOwnersMap.putIfAbsent(artifactPath, ownerId);
        if (previousOwner != null) {
            MapBasedArtifactMappingService $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(MapBasedArtifactMappingService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("[" + ownerId + "] adds new [" + moduleId + "] for [" + previousOwner + "] artifact [" + artifactPath + "]");
        }
        this.myMap.computeIfAbsent(artifactPath, arg_0 -> MapBasedArtifactMappingService.storeModuleId$lambda$2(storeModuleId.1.INSTANCE, arg_0)).add(moduleId);
    }

    @Override
    @NotNull
    public Collection<String> getKeys() {
        return this.myMap.keySet();
    }

    @Override
    public void putAll(@NotNull ArtifactMappingService artifactsMap) {
        Intrinsics.checkNotNullParameter((Object)artifactsMap, (String)"artifactsMap");
        Iterable $this$forEach$iv = artifactsMap.getKeys();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleMappingInfo mapping;
            LinkedHashSet linkedHashSet;
            String key = (String)element$iv;
            boolean bl = false;
            if (artifactsMap.getModuleMapping(key) == null) continue;
            boolean bl2 = false;
            Map<String, Set<String>> map = this.myMap;
            LinkedHashSet it = linkedHashSet = new LinkedHashSet();
            boolean bl3 = false;
            it.addAll(mapping.getModuleIds());
            map.put(key, linkedHashSet);
            this.myOwnersMap.put(key, mapping.getOwnerId());
            if (!mapping.getHasNonModulesContent()) continue;
            this.myNonModulesContent.add(key);
        }
    }

    @Override
    public void markArtifactPath(@NotNull String canonicalPath, boolean hasNonModulesContent) {
        Intrinsics.checkNotNullParameter((Object)canonicalPath, (String)"canonicalPath");
        if (hasNonModulesContent) {
            this.myNonModulesContent.add(canonicalPath);
        } else {
            this.myNonModulesContent.remove(canonicalPath);
        }
    }

    private static final Set storeModuleId$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }
}

