/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.open;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.project.open.GradleOpenProjectProvider;
import org.jetbrains.plugins.gradle.settings.GradleDefaultProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleEnvironment;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0001H\u0007\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a*\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u0001H\u0086@\u00a2\u0006\u0002\u0010\u0014\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\f\u0010\u0018\u001a\u00020\u000f*\u00020\u0019H\u0007\u00a8\u0006\u001a"}, d2={"canLinkAndRefreshGradleProject", "", "projectFilePath", "", "project", "Lcom/intellij/openapi/project/Project;", "showValidationDialog", "canOpenGradleProject", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createLinkSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "projectDirectory", "Ljava/nio/file/Path;", "linkAndRefreshGradleProject", "", "openGradleProject", "projectFile", "projectToClose", "forceOpenInNewFrame", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "suggestGradleHome", "validateGradleProject", "Lcom/intellij/openapi/ui/ValidationInfo;", "setupGradleSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleSettings;", "intellij.gradle.common"})
@JvmName(name="GradleProjectImportUtil")
public final class GradleProjectImportUtil {
    public static final boolean canOpenGradleProject(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new GradleOpenProjectProvider().canOpenProject(file);
    }

    @Nullable
    public static final Object openGradleProject(@NotNull VirtualFile projectFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame, @NotNull Continuation<? super Project> $completion) {
        return new GradleOpenProjectProvider().openProject(projectFile, projectToClose, forceOpenInNewFrame, $completion);
    }

    @ApiStatus.Experimental
    @JvmOverloads
    public static final boolean canLinkAndRefreshGradleProject(@NotNull String projectFilePath, @NotNull Project project, boolean showValidationDialog) {
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ValidationInfo validationInfo = GradleProjectImportUtil.validateGradleProject(projectFilePath, project);
        if (validationInfo == null) {
            return true;
        }
        ValidationInfo validationInfo2 = validationInfo;
        if (showValidationDialog) {
            String title = ExternalSystemBundle.message((String)"error.project.import.error.title", (Object[])new Object[0]);
            ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Unit>(validationInfo2, project, title){
                final /* synthetic */ ValidationInfo $validationInfo;
                final /* synthetic */ Project $project;
                final /* synthetic */ String $title;
                {
                    this.$validationInfo = $validationInfo;
                    this.$project = $project;
                    this.$title = $title;
                    super(0);
                }

                public final void invoke() {
                    if (this.$validationInfo.warning) {
                        Messages.showWarningDialog((Project)this.$project, (String)this.$validationInfo.message, (String)this.$title);
                    } else {
                        Messages.showErrorDialog((Project)this.$project, (String)this.$validationInfo.message, (String)this.$title);
                    }
                }
            }), (int)1, null);
        }
        return false;
    }

    public static /* synthetic */ boolean canLinkAndRefreshGradleProject$default(String string2, Project project, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return GradleProjectImportUtil.canLinkAndRefreshGradleProject(string2, project, bl);
    }

    public static final void linkAndRefreshGradleProject(@NotNull String projectFilePath, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        new GradleOpenProjectProvider().linkToExistingProject(projectFilePath, project);
    }

    @ApiStatus.Internal
    @NotNull
    public static final GradleProjectSettings createLinkSettings(@NotNull Path projectDirectory, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"getInstance(...)");
        GradleSettings gradleSettings2 = gradleSettings;
        GradleProjectImportUtil.setupGradleSettings(gradleSettings2);
        GradleProjectSettings gradleProjectSettings = GradleDefaultProjectSettings.Companion.createProjectSettings(NioPathUtil.toCanonicalPath((Path)projectDirectory));
        GradleVersion gradleVersion2 = gradleProjectSettings.resolveGradleVersion();
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion2, (String)"resolveGradleVersion(...)");
        GradleVersion gradleVersion3 = gradleVersion2;
        GradleJvmResolutionUtil.setupGradleJvm(project, gradleProjectSettings, gradleVersion3);
        return gradleProjectSettings;
    }

    @ApiStatus.Internal
    public static final void setupGradleSettings(@NotNull GradleSettings $this$setupGradleSettings) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$setupGradleSettings), (String)"<this>");
        String string2 = GradleEnvironment.Headless.GRADLE_VM_OPTIONS;
        if (string2 == null) {
            string2 = $this$setupGradleSettings.getGradleVmOptions();
        }
        $this$setupGradleSettings.setGradleVmOptions(string2);
        String string3 = GradleEnvironment.Headless.GRADLE_OFFLINE;
        $this$setupGradleSettings.setOfflineWork(string3 != null ? Boolean.parseBoolean(string3) : $this$setupGradleSettings.isOfflineWork());
        String string4 = GradleEnvironment.Headless.GRADLE_SERVICE_DIRECTORY;
        if (string4 == null) {
            string4 = $this$setupGradleSettings.getServiceDirectoryPath();
        }
        $this$setupGradleSettings.setServiceDirectoryPath(string4);
        $this$setupGradleSettings.setStoreProjectFilesExternally(true);
    }

    @Nullable
    public static final String suggestGradleHome(@Nullable Project project) {
        String defaultGradleHome = GradleDefaultProjectSettings.Companion.getInstance().getGradleHome();
        if (defaultGradleHome != null) {
            return defaultGradleHome;
        }
        String string2 = GradleUtil.getLastUsedGradleHome();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLastUsedGradleHome(...)");
        String lastUsedGradleHome = string2;
        if (((CharSequence)lastUsedGradleHome).length() > 0) {
            return lastUsedGradleHome;
        }
        File gradleHome2 = GradleInstallationManager.getInstance().getAutodetectedGradleHome(project);
        Comparable<File> comparable = gradleHome2;
        return comparable != null && (comparable = comparable.toPath()) != null ? NioPathUtil.toCanonicalPath((Path)comparable) : null;
    }

    private static final ValidationInfo validateGradleProject(String projectFilePath, Project project) {
        AbstractExternalSystemSettings abstractExternalSystemSettings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
        Intrinsics.checkNotNullExpressionValue((Object)abstractExternalSystemSettings, (String)"getSettings(...)");
        AbstractExternalSystemSettings systemSettings = abstractExternalSystemSettings;
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem localFileSystem2 = localFileSystem;
        VirtualFile projectFile = localFileSystem2.refreshAndFindFileByPath(projectFilePath);
        if (projectFile == null) {
            String shortPath = UiUtils.getPresentablePath((String)projectFilePath);
            Object[] objectArray = new Object[]{"Gradle", shortPath};
            return new ValidationInfo(ExternalSystemBundle.message((String)"error.project.does.not.exist", (Object[])objectArray));
        }
        VirtualFile projectDirectory = projectFile.isDirectory() ? projectFile : projectFile.getParent();
        ExternalProjectSettings projectSettings = systemSettings.getLinkedProjectSettings(projectDirectory.getPath());
        if (projectSettings != null) {
            return new ValidationInfo(ExternalSystemBundle.message((String)"error.project.already.registered", (Object[])new Object[0]));
        }
        return null;
    }

    @ApiStatus.Experimental
    @JvmOverloads
    public static final boolean canLinkAndRefreshGradleProject(@NotNull String projectFilePath, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return GradleProjectImportUtil.canLinkAndRefreshGradleProject$default(projectFilePath, project, false, 4, null);
    }
}

