/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.task;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="gradleExecuteTaskHistory", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class ExecuteGradleTaskHistoryService
implements PersistentStateComponent<String[]> {
    private static final int MAX_HISTORY_LENGTH = 20;
    private final LinkedList<String> myHistory = new LinkedList();
    private String myWorkDirectory = "";
    private String myCanceledCommand;

    public static ExecuteGradleTaskHistoryService getInstance(@NotNull Project project) {
        if (project == null) {
            ExecuteGradleTaskHistoryService.$$$reportNull$$$0(0);
        }
        return (ExecuteGradleTaskHistoryService)project.getService(ExecuteGradleTaskHistoryService.class);
    }

    @Nullable
    public String getCanceledCommand() {
        return this.myCanceledCommand;
    }

    public void setCanceledCommand(@Nullable String canceledCommand) {
        this.myCanceledCommand = canceledCommand;
    }

    public void addCommand(@NotNull String command, @NotNull String projectPath) {
        if (command == null) {
            ExecuteGradleTaskHistoryService.$$$reportNull$$$0(1);
        }
        if (projectPath == null) {
            ExecuteGradleTaskHistoryService.$$$reportNull$$$0(2);
        }
        this.myWorkDirectory = projectPath.trim();
        if ((command = command.trim()).length() == 0) {
            return;
        }
        this.myHistory.remove(command);
        this.myHistory.addFirst(command);
        while (this.myHistory.size() > 20) {
            this.myHistory.removeLast();
        }
    }

    public List<String> getHistory() {
        return new ArrayList<String>(this.myHistory);
    }

    @NotNull
    public String getWorkDirectory() {
        String string2 = this.myWorkDirectory;
        if (string2 == null) {
            ExecuteGradleTaskHistoryService.$$$reportNull$$$0(3);
        }
        return string2;
    }

    public String @Nullable [] getState() {
        String[] res = new String[this.myHistory.size() + 1];
        res[0] = this.myWorkDirectory;
        int i = 1;
        for (String goal : this.myHistory) {
            res[i++] = goal;
        }
        return res;
    }

    public void loadState(String @NotNull [] state) {
        if (state == null) {
            ExecuteGradleTaskHistoryService.$$$reportNull$$$0(4);
        }
        if (state.length == 0) {
            this.myWorkDirectory = "";
            this.myHistory.clear();
        } else {
            this.myWorkDirectory = state[0];
            this.myHistory.addAll(Arrays.asList(state).subList(1, state.length));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/task/ExecuteGradleTaskHistoryService";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/task/ExecuteGradleTaskHistoryService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addCommand";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3 -> new IllegalStateException(string2);
        };
    }
}

