/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.CompositeDefinitionSource;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.TestRunner;
import org.jetbrains.plugins.gradle.util.GradleEnvironment;

public class GradleProjectSettings
extends ExternalProjectSettings {
    @NotNull
    private static final Logger LOG = Logger.getInstance(GradleProjectSettings.class);
    public static final boolean DEFAULT_DELEGATE = true;
    @NotNull
    public static final TestRunner DEFAULT_TEST_RUNNER = TestRunner.GRADLE;
    @Nullable
    private String myGradleJvm;
    @Nullable
    private DistributionType myDistributionType;
    @Nullable
    private String myGradleHome;
    private boolean disableWrapperSourceDistributionNotification;
    private boolean resolveModulePerSourceSet;
    private boolean resolveExternalAnnotations;
    @Nullable
    private CompositeBuild myCompositeBuild;
    @NotNull
    private Boolean delegatedBuild;
    @NotNull
    private TestRunner testRunner;

    public GradleProjectSettings(@NotNull String externalProjectPath2) {
        if (externalProjectPath2 == null) {
            GradleProjectSettings.$$$reportNull$$$0(0);
        }
        this();
        this.setExternalProjectPath(externalProjectPath2);
    }

    public GradleProjectSettings() {
        this.myGradleJvm = "#USE_PROJECT_JDK";
        this.myDistributionType = DistributionType.DEFAULT_WRAPPED;
        this.myGradleHome = null;
        this.disableWrapperSourceDistributionNotification = false;
        this.resolveModulePerSourceSet = true;
        this.resolveExternalAnnotations = true;
        this.delegatedBuild = true;
        this.testRunner = DEFAULT_TEST_RUNNER;
        this.setupHeadlessProjectSettings();
    }

    private void setupHeadlessProjectSettings() {
        String gradleHome2;
        String distributionType = GradleEnvironment.Headless.GRADLE_DISTRIBUTION_TYPE;
        if (distributionType != null) {
            this.myDistributionType = DistributionType.valueOf(distributionType);
        }
        if ((gradleHome2 = GradleEnvironment.Headless.GRADLE_HOME) != null) {
            this.myGradleHome = gradleHome2;
        }
    }

    @Nullable
    @NlsSafe
    public String getGradleJvm() {
        return this.myGradleJvm;
    }

    public void setGradleJvm(@Nullable String gradleJvm) {
        this.myGradleJvm = gradleJvm;
    }

    @Nullable
    @NlsSafe
    public String getGradleHome() {
        return this.myGradleHome;
    }

    public void setGradleHome(@Nullable String gradleHome2) {
        this.myGradleHome = gradleHome2;
    }

    @Nullable
    public DistributionType getDistributionType() {
        return this.myDistributionType;
    }

    public void setDistributionType(@Nullable DistributionType distributionType) {
        this.myDistributionType = distributionType;
    }

    public boolean isDisableWrapperSourceDistributionNotification() {
        return this.disableWrapperSourceDistributionNotification;
    }

    public void setDisableWrapperSourceDistributionNotification(boolean disableWrapperSourceDistributionNotification) {
        this.disableWrapperSourceDistributionNotification = disableWrapperSourceDistributionNotification;
    }

    public boolean isResolveModulePerSourceSet() {
        return this.resolveModulePerSourceSet;
    }

    public void setResolveModulePerSourceSet(boolean useIdeModulePerSourceSet) {
        this.resolveModulePerSourceSet = useIdeModulePerSourceSet;
    }

    public boolean isResolveExternalAnnotations() {
        return this.resolveExternalAnnotations;
    }

    public void setResolveExternalAnnotations(boolean resolveExternalAnnotations) {
        this.resolveExternalAnnotations = resolveExternalAnnotations;
    }

    @OptionTag(tag="compositeConfiguration", nameAttribute="")
    @Nullable
    public CompositeBuild getCompositeBuild() {
        return this.myCompositeBuild;
    }

    public void setCompositeBuild(@Nullable CompositeBuild compositeBuild) {
        this.myCompositeBuild = compositeBuild;
    }

    @Transient
    public boolean getDelegatedBuild() {
        return (Boolean)ObjectUtils.notNull((Object)this.delegatedBuild, (Object)true);
    }

    public void setDelegatedBuild(@NotNull Boolean state) {
        if (state == null) {
            GradleProjectSettings.$$$reportNull$$$0(1);
        }
        this.delegatedBuild = state;
    }

    @OptionTag(value="delegatedBuild")
    @Nullable
    public Boolean getDirectDelegatedBuild() {
        return this.delegatedBuild;
    }

    public void setDirectDelegatedBuild(@Nullable Boolean state) {
        this.delegatedBuild = (Boolean)ObjectUtils.notNull((Object)state, (Object)true);
    }

    public static boolean isDelegatedBuildEnabled(@NotNull Project project, @Nullable String gradleProjectPath) {
        GradleProjectSettings projectSettings;
        if (project == null) {
            GradleProjectSettings.$$$reportNull$$$0(2);
        }
        GradleProjectSettings gradleProjectSettings = projectSettings = gradleProjectPath == null ? null : (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(gradleProjectPath);
        if (projectSettings == null) {
            return false;
        }
        return projectSettings.getDelegatedBuild();
    }

    public static boolean isDelegatedBuildEnabled(@NotNull Module module) {
        if (module == null) {
            GradleProjectSettings.$$$reportNull$$$0(3);
        }
        return GradleProjectSettings.isDelegatedBuildEnabled(module.getProject(), ExternalSystemApiUtil.getExternalRootProjectPath((Module)module));
    }

    @Transient
    @NotNull
    public TestRunner getTestRunner() {
        TestRunner testRunner = (TestRunner)((Object)ObjectUtils.notNull((Object)((Object)this.testRunner), (Object)((Object)DEFAULT_TEST_RUNNER)));
        if (testRunner == null) {
            GradleProjectSettings.$$$reportNull$$$0(4);
        }
        return testRunner;
    }

    public void setTestRunner(@NotNull TestRunner testRunner) {
        if (testRunner == null) {
            GradleProjectSettings.$$$reportNull$$$0(5);
        }
        if (LOG.isDebugEnabled() && testRunner != TestRunner.GRADLE) {
            LOG.debug(String.format("Gradle test runner sets to %s", new Object[]{testRunner}), new Throwable());
        }
        this.testRunner = testRunner;
    }

    @OptionTag(value="testRunner")
    @Nullable
    public TestRunner getDirectTestRunner() {
        return this.testRunner;
    }

    public void setDirectTestRunner(@Nullable TestRunner testRunner) {
        this.testRunner = (TestRunner)((Object)ObjectUtils.notNull((Object)((Object)testRunner), (Object)((Object)DEFAULT_TEST_RUNNER)));
    }

    @NotNull
    public static TestRunner getTestRunner(@NotNull Project project, @Nullable String gradleProjectPath) {
        TestRunner testRunner;
        if (project == null) {
            GradleProjectSettings.$$$reportNull$$$0(6);
        }
        GradleProjectSettings projectSettings = gradleProjectPath == null ? null : (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(gradleProjectPath);
        TestRunner testRunner2 = testRunner = projectSettings == null ? TestRunner.PLATFORM : projectSettings.getTestRunner();
        if (LOG.isDebugEnabled() && testRunner != TestRunner.GRADLE) {
            String settingsPresentation = projectSettings == null ? String.format("<null: %s>", gradleProjectPath) : gradleProjectPath;
            LOG.debug(String.format("Get non gradle test runner %s at '%s'", new Object[]{testRunner, settingsPresentation}), new Throwable());
        }
        TestRunner testRunner3 = testRunner;
        if (testRunner3 == null) {
            GradleProjectSettings.$$$reportNull$$$0(7);
        }
        return testRunner3;
    }

    @NotNull
    public static TestRunner getTestRunner(@NotNull Module module) {
        if (module == null) {
            GradleProjectSettings.$$$reportNull$$$0(8);
        }
        return GradleProjectSettings.getTestRunner(module.getProject(), ExternalSystemApiUtil.getExternalRootProjectPath((Module)module));
    }

    @NotNull
    public GradleVersion resolveGradleVersion() {
        GradleVersion version = GradleInstallationManager.guessGradleVersion(this);
        GradleVersion gradleVersion2 = Optional.ofNullable(version).orElseGet(GradleVersion::current);
        if (gradleVersion2 == null) {
            GradleProjectSettings.$$$reportNull$$$0(9);
        }
        return gradleVersion2;
    }

    @NotNull
    public GradleProjectSettings withQualifiedModuleNames() {
        this.setUseQualifiedModuleNames(true);
        GradleProjectSettings gradleProjectSettings = this;
        if (gradleProjectSettings == null) {
            GradleProjectSettings.$$$reportNull$$$0(10);
        }
        return gradleProjectSettings;
    }

    @NotNull
    public GradleProjectSettings clone() {
        GradleProjectSettings result = new GradleProjectSettings();
        this.copyTo(result);
        result.myGradleJvm = this.myGradleJvm;
        result.myDistributionType = this.myDistributionType;
        result.myGradleHome = this.myGradleHome;
        result.disableWrapperSourceDistributionNotification = this.disableWrapperSourceDistributionNotification;
        result.resolveModulePerSourceSet = this.resolveModulePerSourceSet;
        result.resolveExternalAnnotations = this.resolveExternalAnnotations;
        result.myCompositeBuild = this.myCompositeBuild != null ? this.myCompositeBuild.copy() : null;
        result.delegatedBuild = this.delegatedBuild;
        result.testRunner = this.testRunner;
        GradleProjectSettings gradleProjectSettings = result;
        if (gradleProjectSettings == null) {
            GradleProjectSettings.$$$reportNull$$$0(11);
        }
        return gradleProjectSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleProjectSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleProjectSettings";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRunner";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGradleVersion";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withQualifiedModuleNames";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setDelegatedBuild";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isDelegatedBuildEnabled";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setTestRunner";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTestRunner";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 7, 9, 10, 11 -> new IllegalStateException(string2);
        };
    }

    @Tag(value="compositeBuild")
    public static class CompositeBuild {
        @Nullable
        private CompositeDefinitionSource myCompositeDefinitionSource;
        private List<BuildParticipant> myCompositeParticipants = new SmartList();

        @Attribute
        @Nullable
        public CompositeDefinitionSource getCompositeDefinitionSource() {
            return this.myCompositeDefinitionSource;
        }

        public void setCompositeDefinitionSource(@Nullable CompositeDefinitionSource compositeDefinitionSource) {
            this.myCompositeDefinitionSource = compositeDefinitionSource;
        }

        @XCollection(propertyElementName="builds", elementName="build")
        @NotNull
        public List<BuildParticipant> getCompositeParticipants() {
            List<BuildParticipant> list2 = this.myCompositeParticipants;
            if (list2 == null) {
                CompositeBuild.$$$reportNull$$$0(0);
            }
            return list2;
        }

        public void setCompositeParticipants(@Nullable List<? extends BuildParticipant> compositeParticipants) {
            this.myCompositeParticipants = compositeParticipants == null ? new SmartList() : new ArrayList<BuildParticipant>(compositeParticipants);
        }

        @NotNull
        public CompositeBuild copy() {
            CompositeBuild result = new CompositeBuild();
            result.myCompositeParticipants = new ArrayList<BuildParticipant>();
            for (BuildParticipant participant : this.myCompositeParticipants) {
                result.myCompositeParticipants.add(participant.copy());
            }
            result.myCompositeDefinitionSource = this.myCompositeDefinitionSource;
            CompositeBuild compositeBuild = result;
            if (compositeBuild == null) {
                CompositeBuild.$$$reportNull$$$0(1);
            }
            return compositeBuild;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/plugins/gradle/settings/GradleProjectSettings$CompositeBuild";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompositeParticipants";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class GradleDistributionInfo {
        @NotNull
        private final DistributionType type;
        @NotNull
        private final GradleVersion gradleVersion;
        @Nullable
        private final String gradleHome;

        public GradleDistributionInfo(@NotNull DistributionType type, @NotNull GradleVersion gradleVersion2, @Nullable String gradleHome2) {
            if (type == null) {
                GradleDistributionInfo.$$$reportNull$$$0(0);
            }
            if (gradleVersion2 == null) {
                GradleDistributionInfo.$$$reportNull$$$0(1);
            }
            this.type = type;
            this.gradleVersion = gradleVersion2;
            this.gradleHome = gradleHome2;
        }

        @NotNull
        public DistributionType getType() {
            DistributionType distributionType = this.type;
            if (distributionType == null) {
                GradleDistributionInfo.$$$reportNull$$$0(2);
            }
            return distributionType;
        }

        @NotNull
        public GradleVersion getGradleVersion() {
            GradleVersion gradleVersion2 = this.gradleVersion;
            if (gradleVersion2 == null) {
                GradleDistributionInfo.$$$reportNull$$$0(3);
            }
            return gradleVersion2;
        }

        @Nullable
        public String getGradleHome() {
            return this.gradleHome;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradleVersion";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleProjectSettings$GradleDistributionInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleProjectSettings$GradleDistributionInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGradleVersion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3 -> new IllegalStateException(string2);
            };
        }
    }
}

