/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.externalSystem.model.ConfigurationDataImpl;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemUsageFields;
import com.intellij.openapi.externalSystem.statistics.JreType;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.properties.GradleProperties;
import org.jetbrains.plugins.gradle.properties.GradlePropertiesFile;
import org.jetbrains.plugins.gradle.properties.models.Property;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.TestRunner;
import org.jetbrains.plugins.gradle.statistics.GradleSettingsCollector;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#H\u0002J&\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J&\u0010-\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020*2\u0006\u0010.\u001a\u00020\u000eH\u0002J\u001e\u0010/\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u00100\u001a\u000201H\u0002J\b\u00102\u001a\u00020\u0013H\u0016J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020(042\u0006\u0010)\u001a\u00020*H\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/plugins/gradle/statistics/GradleSettingsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "CREATE_MODULE_PER_SOURCE_SET", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "DELEGATE_BUILD_RUN", "DISABLE_WRAPPER_SOURCE_DISTRIBUTION_NOTIFICATION", "DISTRIBUTION_TYPE", "Lorg/jetbrains/plugins/gradle/settings/DistributionType;", "GRADLE_DOWNLOAD_DEPENDENCY_SOURCES", "GRADLE_JVM_TYPE", "Lcom/intellij/openapi/externalSystem/statistics/JreType;", "GRADLE_JVM_VERSION", "", "GRADLE_PARALLEL_MODEL_FETCH", "GRADLE_PROPERTY_PARALLEL", "GRADLE_VERSION", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "HAS_CUSTOM_GRADLE_VM_OPTIONS", "HAS_CUSTOM_SERVICE_DIRECTORY_PATH", "HAS_GRADLE_PROJECT", "IDEA_SPECIFIC_CONFIGURATION_USED", "IS_COMPOSITE_BUILDS", "IS_USE_QUALIFIED_MODULE_NAMES", "OFFLINE_WORK", "PREFERRED_TEST_RUNNER", "Lorg/jetbrains/plugins/gradle/settings/TestRunner;", "SHOW_SELECTIVE_IMPORT_DIALOG_ON_INITIAL_IMPORT", "STORE_PROJECT_FILES_EXTERNALLY", "VERSION_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "anonymizeGradleVersion", "version", "Lorg/gradle/util/GradleVersion;", "collectGradleProjectSettingsMetrics", "", "usages", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "setting", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "collectGradlePropertiesMetrics", "externalProjectPath", "collectGradleSettingsMetrics", "gradleSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleSettings;", "getGroup", "getMetrics", "", "intellij.gradle.common"})
@SourceDebugExtension(value={"SMAP\nGradleSettingsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleSettingsCollector.kt\norg/jetbrains/plugins/gradle/statistics/GradleSettingsCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1#2:147\n*E\n"})
public final class GradleSettingsCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("build.gradle.state", 7, null, null, 12, null);
    @NotNull
    private final EventId1<Boolean> HAS_GRADLE_PROJECT = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"hasGradleProject", (EventField)((EventField)EventFields.Enabled), null, (int)4, null);
    @NotNull
    private final EventId1<Boolean> OFFLINE_WORK = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"offlineWork", (EventField)((EventField)EventFields.Enabled), null, (int)4, null);
    @NotNull
    private final EventId1<Boolean> HAS_CUSTOM_SERVICE_DIRECTORY_PATH = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"hasCustomServiceDirectoryPath", (EventField)((EventField)EventFields.Enabled), null, (int)4, null);
    @NotNull
    private final EventId1<Boolean> HAS_CUSTOM_GRADLE_VM_OPTIONS = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"hasCustomGradleVmOptions", (EventField)((EventField)EventFields.Enabled), null, (int)4, null);
    @NotNull
    private final EventId1<Boolean> SHOW_SELECTIVE_IMPORT_DIALOG_ON_INITIAL_IMPORT = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"showSelectiveImportDialogOnInitialImport", (EventField)((EventField)EventFields.Enabled), null, (int)4, null);
    @NotNull
    private final EventId1<Boolean> STORE_PROJECT_FILES_EXTERNALLY = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"storeProjectFilesExternally", (EventField)((EventField)EventFields.Enabled), null, (int)4, null);
    @NotNull
    private final EventId1<Boolean> IS_USE_QUALIFIED_MODULE_NAMES = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"isUseQualifiedModuleNames", (EventField)((EventField)EventFields.Enabled), null, (int)4, null);
    @NotNull
    private final EventId1<Boolean> CREATE_MODULE_PER_SOURCE_SET = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"createModulePerSourceSet", (EventField)((EventField)EventFields.Enabled), null, (int)4, null);
    @NotNull
    private final EventId1<Boolean> IS_COMPOSITE_BUILDS = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"isCompositeBuilds", (EventField)((EventField)EventFields.Enabled), null, (int)4, null);
    @NotNull
    private final EventId1<Boolean> DISABLE_WRAPPER_SOURCE_DISTRIBUTION_NOTIFICATION = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"disableWrapperSourceDistributionNotification", (EventField)((EventField)EventFields.Enabled), null, (int)4, null);
    @NotNull
    private final EventId1<Boolean> DELEGATE_BUILD_RUN = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"delegateBuildRun", (EventField)((EventField)EventFields.Enabled), null, (int)4, null);
    @NotNull
    private final EventId1<Boolean> IDEA_SPECIFIC_CONFIGURATION_USED = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"ideaSpecificConfigurationUsed", (EventField)((EventField)EventFields.Enabled), null, (int)4, null);
    @NotNull
    private final EventId1<DistributionType> DISTRIBUTION_TYPE = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"distributionType", (EventField)((EventField)EventFields.Enum((String)"value", DistributionType.class, (Function1)DISTRIBUTION_TYPE.1.INSTANCE)), null, (int)4, null);
    @NotNull
    private final StringEventField VERSION_FIELD = EventFields.StringValidatedByRegexpReference$default((String)"value", (String)"version", null, (int)4, null);
    @NotNull
    private final EventId1<String> GRADLE_VERSION = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"gradleVersion", (EventField)((EventField)this.VERSION_FIELD), null, (int)4, null);
    @NotNull
    private final EventId1<TestRunner> PREFERRED_TEST_RUNNER = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"preferredTestRunner", (EventField)((EventField)EventFields.Enum((String)"value", TestRunner.class, (Function1)PREFERRED_TEST_RUNNER.1.INSTANCE)), null, (int)4, null);
    @NotNull
    private final EventId1<JreType> GRADLE_JVM_TYPE = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"gradleJvmType", (EventField)((EventField)ExternalSystemUsageFields.INSTANCE.getJRE_TYPE_FIELD()), null, (int)4, null);
    @NotNull
    private final EventId1<String> GRADLE_JVM_VERSION = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"gradleJvmVersion", (EventField)((EventField)this.VERSION_FIELD), null, (int)4, null);
    @NotNull
    private final EventId1<Boolean> GRADLE_DOWNLOAD_DEPENDENCY_SOURCES = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"gradleDownloadDependencySources", (EventField)((EventField)EventFields.Enabled), null, (int)4, null);
    @NotNull
    private final EventId1<Boolean> GRADLE_PARALLEL_MODEL_FETCH = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"gradleParallelModelFetch", (EventField)((EventField)EventFields.Enabled), null, (int)4, null);
    @NotNull
    private final EventId1<Boolean> GRADLE_PROPERTY_PARALLEL = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"org.gradle.parallel", (EventField)((EventField)EventFields.Enabled), null, (int)4, null);

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"getInstance(...)");
        GradleSettings gradleSettings2 = gradleSettings;
        Collection collection = gradleSettings2.getLinkedProjectsSettings();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getLinkedProjectsSettings(...)");
        Collection projectsSettings = collection;
        if (projectsSettings.isEmpty()) {
            return SetsKt.emptySet();
        }
        Set usages = new LinkedHashSet();
        usages.add(this.HAS_GRADLE_PROJECT.metric((Object)true));
        this.collectGradleSettingsMetrics(usages, gradleSettings2);
        for (GradleProjectSettings projectSettings : gradleSettings2.getLinkedProjectsSettings()) {
            Intrinsics.checkNotNull((Object)((Object)projectSettings));
            this.collectGradleProjectSettingsMetrics(usages, project, projectSettings);
        }
        for (GradleProjectSettings projectSettings : gradleSettings2.getLinkedProjectsSettings()) {
            String string2 = projectSettings.getExternalProjectPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExternalProjectPath(...)");
            this.collectGradlePropertiesMetrics(usages, project, string2);
        }
        return usages;
    }

    private final void collectGradleSettingsMetrics(Set<MetricEvent> usages, GradleSettings gradleSettings) {
        usages.add(this.OFFLINE_WORK.metric((Object)gradleSettings.isOfflineWork()));
        CharSequence charSequence = gradleSettings.getServiceDirectoryPath();
        usages.add(this.HAS_CUSTOM_SERVICE_DIRECTORY_PATH.metric((Object)(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? 1 : 0)));
        charSequence = gradleSettings.getGradleVmOptions();
        usages.add(this.HAS_CUSTOM_GRADLE_VM_OPTIONS.metric((Object)(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? 1 : 0)));
        usages.add(this.SHOW_SELECTIVE_IMPORT_DIALOG_ON_INITIAL_IMPORT.metric((Object)gradleSettings.showSelectiveImportDialogOnInitialImport()));
        usages.add(this.STORE_PROJECT_FILES_EXTERNALLY.metric((Object)gradleSettings.getStoreProjectFilesExternally()));
        usages.add(this.GRADLE_DOWNLOAD_DEPENDENCY_SOURCES.metric((Object)gradleSettings.isDownloadSources()));
        usages.add(this.GRADLE_PARALLEL_MODEL_FETCH.metric((Object)gradleSettings.isParallelModelFetch()));
    }

    /*
     * Unable to fully structure code
     */
    private final void collectGradleProjectSettingsMetrics(Set<MetricEvent> usages, Project project, GradleProjectSettings setting) {
        projectPath = setting.getExternalProjectPath();
        usages.add(this.IS_USE_QUALIFIED_MODULE_NAMES.metric((Object)setting.isUseQualifiedModuleNames()));
        usages.add(this.CREATE_MODULE_PER_SOURCE_SET.metric((Object)setting.isResolveModulePerSourceSet()));
        distributionType = setting.getDistributionType();
        if (distributionType != null) {
            usages.add(this.DISTRIBUTION_TYPE.metric((Object)distributionType));
        }
        usages.add(this.IS_COMPOSITE_BUILDS.metric((Object)(setting.getCompositeBuild() != null)));
        usages.add(this.DISABLE_WRAPPER_SOURCE_DISTRIBUTION_NOTIFICATION.metric((Object)setting.isDisableWrapperSourceDistributionNotification()));
        usages.add(this.GRADLE_JVM_TYPE.metric((Object)ExternalSystemUsageFields.INSTANCE.getJreType(setting.getGradleJvm())));
        usages.add(this.GRADLE_JVM_VERSION.metric((Object)ExternalSystemUsageFields.INSTANCE.getJreVersion(project, setting.getGradleJvm())));
        v0 = setting.resolveGradleVersion();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"resolveGradleVersion(...)");
        gradleVersion = v0;
        if (gradleVersion.isSnapshot()) {
            v1 = gradleVersion.getBaseVersion();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getBaseVersion(...)");
            usages.add(this.GRADLE_VERSION.metric((Object)(this.anonymizeGradleVersion(v1) + ".SNAPSHOT")));
        } else {
            usages.add(this.GRADLE_VERSION.metric((Object)this.anonymizeGradleVersion(gradleVersion)));
        }
        usages.add(this.DELEGATE_BUILD_RUN.metric((Object)GradleProjectSettings.isDelegatedBuildEnabled(project, projectPath)));
        v2 = GradleProjectSettings.getTestRunner(project, projectPath);
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getTestRunner(...)");
        usages.add(this.PREFERRED_TEST_RUNNER.metric((Object)v2));
        var8_7 = ProjectDataManager.getInstance().getExternalProjectData(project, GradleConstants.SYSTEM_ID, projectPath);
        if (var8_7 == null || (var9_8 = var8_7.getExternalProjectStructure()) == null) ** GOTO lbl-1000
        dataNode = var9_8;
        $i$a$-let-GradleSettingsCollector$collectGradleProjectSettingsMetrics$hasNonEmptyIntellijConfig$1 = false;
        var10_12 = ExternalSystemApiUtil.findFirstRecursively((DataNode)dataNode, (Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, collectGradleProjectSettingsMetrics$lambda$1$lambda$0(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Z)((Function1)collectGradleProjectSettingsMetrics.hasNonEmptyIntellijConfig.1.1.INSTANCE));
        if (var10_12 == null) ** GOTO lbl-1000
        it = var10_12;
        $i$a$-let-GradleSettingsCollector$collectGradleProjectSettingsMetrics$hasNonEmptyIntellijConfig$2 = false;
        var15_15 = it.getData();
        var11_17 = var15_15 instanceof ConfigurationDataImpl ? (ConfigurationDataImpl)var15_15 : null;
        if (var11_17 != null) {
            it = var11_17;
            $i$a$-let-GradleSettingsCollector$collectGradleProjectSettingsMetrics$hasNonEmptyIntellijConfig$3 = false;
            v3 = it.getJsonString().length() > 2;
        } else lbl-1000:
        // 3 sources

        {
            v3 = false;
        }
        hasNonEmptyIntellijConfig = v3;
        usages.add(this.IDEA_SPECIFIC_CONFIGURATION_USED.metric((Object)hasNonEmptyIntellijConfig));
    }

    private final void collectGradlePropertiesMetrics(Set<MetricEvent> usages, Project project, String externalProjectPath2) {
        Path path = Paths.get(externalProjectPath2, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        GradleProperties gradleProperties = GradlePropertiesFile.INSTANCE.getProperties(project, path);
        Property<Boolean> parallel = gradleProperties.getParallel();
        if (parallel != null) {
            usages.add(this.GRADLE_PROPERTY_PARALLEL.metric((Object)parallel.getValue()));
        }
    }

    private final String anonymizeGradleVersion(GradleVersion version) {
        Version version2 = Version.parseVersion((String)version.getVersion());
        String string2 = version2 != null ? version2.toCompactString() : null;
        if (string2 == null) {
            string2 = "unknown";
        }
        return string2;
    }

    private static final boolean collectGradleProjectSettingsMetrics$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

