/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.gutterMarks;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.actions.GutterActionId;
import com.jetbrains.rd.actions.GutterActionKind;
import com.jetbrains.rd.ide.model.DndCopyArgs;
import com.jetbrains.rd.ide.model.GutterMarkActionModel;
import com.jetbrains.rd.ide.model.GutterMarkDnDModel;
import com.jetbrains.rd.ide.model.GutterMarkHoverModel;
import com.jetbrains.rd.ide.model.RdFileId;
import com.jetbrains.rd.ide.vfs.IProtocolVirtualFile;
import com.jetbrains.rdclient.actions.base.BackendAction;
import com.jetbrains.rdclient.daemon.highlighters.gutterMarks.FrontendGutterIconRenderer;
import com.jetbrains.rdclient.daemon.highlighters.gutterMarks.GutterMarkInfo;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendTooltipProvider;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\n\u0010 \u001a\u0004\u0018\u00010!H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010\u001fH\u0016J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016J\n\u0010%\u001a\u0004\u0018\u00010\u001fH\u0016R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0015\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0014\u001a\u0004\b\u0016\u0010\u0012R\u001b\u0010\u0018\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0014\u001a\u0004\b\u0019\u0010\u0012\u00a8\u0006&"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/gutterMarks/FrontendAsyncGutterIconRenderer;", "Lcom/jetbrains/rdclient/daemon/highlighters/gutterMarks/FrontendGutterIconRenderer;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "info", "Lcom/jetbrains/rdclient/daemon/highlighters/gutterMarks/GutterMarkInfo;", "gutterMarkActionModel", "Lcom/jetbrains/rd/ide/model/GutterMarkActionModel;", "gutterMarkHoverModel", "Lcom/jetbrains/rd/ide/model/GutterMarkHoverModel;", "tooltipProvider", "Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;", "dndModel", "Lcom/jetbrains/rd/ide/model/GutterMarkDnDModel;", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;Lcom/jetbrains/rdclient/daemon/highlighters/gutterMarks/GutterMarkInfo;Lcom/jetbrains/rd/ide/model/GutterMarkActionModel;Lcom/jetbrains/rd/ide/model/GutterMarkHoverModel;Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;Lcom/jetbrains/rd/ide/model/GutterMarkDnDModel;)V", "leftClickAction", "Lcom/jetbrains/rdclient/actions/base/BackendAction;", "getLeftClickAction", "()Lcom/jetbrains/rdclient/actions/base/BackendAction;", "leftClickAction$delegate", "Lkotlin/Lazy;", "middleClickAction", "getMiddleClickAction", "middleClickAction$delegate", "rightClickAction", "getRightClickAction", "rightClickAction$delegate", "createBackendAction", "kind", "Lcom/jetbrains/rd/actions/GutterActionKind;", "getClickAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getDraggableObject", "Lcom/intellij/openapi/editor/markup/GutterDraggableObject;", "getMiddleButtonClickAction", "getPopupMenuActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getRightButtonClickAction", "intellij.rd.client"})
public final class FrontendAsyncGutterIconRenderer
extends FrontendGutterIconRenderer {
    @NotNull
    private final Lazy leftClickAction$delegate;
    @NotNull
    private final Lazy middleClickAction$delegate;
    @NotNull
    private final Lazy rightClickAction$delegate;

    public FrontendAsyncGutterIconRenderer(@NotNull RangeHighlighter highlighter2, @NotNull GutterMarkInfo info2, @NotNull GutterMarkActionModel gutterMarkActionModel, @NotNull GutterMarkHoverModel gutterMarkHoverModel, @NotNull FrontendTooltipProvider tooltipProvider, @NotNull GutterMarkDnDModel dndModel) {
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        Intrinsics.checkNotNullParameter((Object)gutterMarkActionModel, (String)"gutterMarkActionModel");
        Intrinsics.checkNotNullParameter((Object)gutterMarkHoverModel, (String)"gutterMarkHoverModel");
        Intrinsics.checkNotNullParameter((Object)tooltipProvider, (String)"tooltipProvider");
        Intrinsics.checkNotNullParameter((Object)dndModel, (String)"dndModel");
        super(highlighter2, info2, gutterMarkActionModel, gutterMarkHoverModel, tooltipProvider, dndModel);
        this.leftClickAction$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BackendAction>(this){
            final /* synthetic */ FrontendAsyncGutterIconRenderer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final BackendAction invoke() {
                return FrontendAsyncGutterIconRenderer.access$createBackendAction(this.this$0, GutterActionKind.LEFT_CLICK);
            }
        }));
        this.middleClickAction$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BackendAction>(this){
            final /* synthetic */ FrontendAsyncGutterIconRenderer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final BackendAction invoke() {
                return FrontendAsyncGutterIconRenderer.access$createBackendAction(this.this$0, GutterActionKind.MIDDLE_CLICK);
            }
        }));
        this.rightClickAction$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BackendAction>(this){
            final /* synthetic */ FrontendAsyncGutterIconRenderer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final BackendAction invoke() {
                return FrontendAsyncGutterIconRenderer.access$createBackendAction(this.this$0, GutterActionKind.RIGHT_CLICK);
            }
        }));
    }

    private final BackendAction getLeftClickAction() {
        Lazy lazy = this.leftClickAction$delegate;
        return (BackendAction)lazy.getValue();
    }

    private final BackendAction getMiddleClickAction() {
        Lazy lazy = this.middleClickAction$delegate;
        return (BackendAction)lazy.getValue();
    }

    private final BackendAction getRightClickAction() {
        Lazy lazy = this.rightClickAction$delegate;
        return (BackendAction)lazy.getValue();
    }

    @Override
    @Nullable
    public ActionGroup getPopupMenuActions() {
        return null;
    }

    @Override
    @Nullable
    public AnAction getClickAction() {
        return this.getInfo().getHasLeftClick() || this.getInfo().getHasPopupActions() ? (AnAction)this.getLeftClickAction() : null;
    }

    @Nullable
    public AnAction getMiddleButtonClickAction() {
        return this.getInfo().getHasMiddleClick() || this.getInfo().getHasPopupActions() ? (AnAction)this.getMiddleClickAction() : null;
    }

    @Nullable
    public AnAction getRightButtonClickAction() {
        return this.getInfo().getHasRightClick() || this.getInfo().getHasPopupActions() ? (AnAction)this.getRightClickAction() : null;
    }

    private final BackendAction createBackendAction(GutterActionKind kind) {
        String actionId = new GutterActionId(kind, this.getInfo().getId()).toStringActionId();
        return new BackendAction(actionId, null, null, 6, null);
    }

    @Nullable
    public GutterDraggableObject getDraggableObject() {
        if (!this.getInfo().getSupportsDnD()) {
            return null;
        }
        return new GutterDraggableObject(this){
            final /* synthetic */ FrontendAsyncGutterIconRenderer this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean copy(int line, @NotNull VirtualFile file, int actionId) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                IProtocolVirtualFile iProtocolVirtualFile = file instanceof IProtocolVirtualFile ? (IProtocolVirtualFile)file : null;
                RdFileId fileId = iProtocolVirtualFile != null ? iProtocolVirtualFile.getFileId() : null;
                this.this$0.getDndModel().getCopy().fire((Object)new DndCopyArgs(this.this$0.getInfo().getId(), line, fileId, actionId));
                return false;
            }

            public void remove() {
                this.this$0.getDndModel().getRemove().fire((Object)this.this$0.getInfo().getId());
            }
        };
    }

    public static final /* synthetic */ BackendAction access$createBackendAction(FrontendAsyncGutterIconRenderer $this, GutterActionKind kind) {
        return $this.createBackendAction(kind);
    }
}

