/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.document;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.PatchEngineDocumentSynchronizer;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdDocumentChangeBase;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdPatchDocumentVersion;
import com.jetbrains.rd.ide.model.RdPatchItemId;
import com.jetbrains.rd.ide.model.RdResetDocumentChange;
import com.jetbrains.rd.ide.requests.PatchItemOperationType;
import com.jetbrains.rdclient.document.FrontendDocumentHost;
import com.jetbrains.rdclient.document.FrontendPatchDocumentItemHandlerKt;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchItemHandler;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rdclient/document/FrontendPatchDocumentItemHandler;", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchItemHandler;", "Lcom/jetbrains/rd/ide/model/RdPatchDocumentVersion;", "Lcom/jetbrains/rd/ide/model/RdDocumentChangeBase;", "()V", "apply", "", "item", "context", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext;", "(Lcom/jetbrains/rd/ide/model/RdDocumentChangeBase;Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDocumentSynchronizer", "Lcom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer;", "id", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "update", "version", "validate", "", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendPatchDocumentItemHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendPatchDocumentItemHandler.kt\ncom/jetbrains/rdclient/document/FrontendPatchDocumentItemHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,62:1\n53#2,4:63\n53#2,4:67\n53#2,4:71\n*S KotlinDebug\n*F\n+ 1 FrontendPatchDocumentItemHandler.kt\ncom/jetbrains/rdclient/document/FrontendPatchDocumentItemHandler\n*L\n28#1:63,4\n38#1:67,4\n56#1:71,4\n*E\n"})
public final class FrontendPatchDocumentItemHandler
implements FrontendRdPatchItemHandler<RdPatchDocumentVersion, RdDocumentChangeBase> {
    @Override
    public boolean validate(@NotNull RdPatchDocumentVersion version, @NotNull FrontendRdPatchHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RdPatchItemId rdPatchItemId = version.getId();
        Intrinsics.checkNotNull((Object)rdPatchItemId, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.RdDocumentId");
        PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer = this.getDocumentSynchronizer((RdDocumentId)rdPatchItemId, context.getSession());
        if (patchEngineDocumentSynchronizer == null) {
            return true;
        }
        PatchEngineDocumentSynchronizer synchronizer = patchEngineDocumentSynchronizer;
        if (!Intrinsics.areEqual((Object)synchronizer.getVersion(), (Object)version.getVersion())) {
            FrontendPatchDocumentItemHandlerKt.access$getLogger$p().error("Not matched versions for " + version.getId() + " documentId, actual: " + synchronizer.getVersion() + ", expected: " + version.getVersion());
            return false;
        }
        return true;
    }

    @Override
    public void update(@NotNull RdPatchDocumentVersion version, @NotNull FrontendRdPatchHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Logger $this$trace$iv = FrontendPatchDocumentItemHandlerKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Update document version: " + version.getId() + " to " + version.getVersion() + " with operation type " + context.getOperation());
        }
        RdPatchItemId rdPatchItemId = version.getId();
        Intrinsics.checkNotNull((Object)rdPatchItemId, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.RdDocumentId");
        PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer = this.getDocumentSynchronizer((RdDocumentId)rdPatchItemId, context.getSession());
        if (patchEngineDocumentSynchronizer == null) {
            return;
        }
        PatchEngineDocumentSynchronizer synchronizer = patchEngineDocumentSynchronizer;
        switch (WhenMappings.$EnumSwitchMapping$0[context.getOperation().ordinal()]) {
            case 1: {
                synchronizer.resetVersion((AbstractDocumentVersion)version.getVersion());
                break;
            }
            case 2: {
                synchronizer.updateLastKnownVersion(version.getVersion());
            }
        }
    }

    @Override
    @Nullable
    public Object apply(@NotNull RdDocumentChangeBase item, @NotNull FrontendRdPatchHandlerContext context, @NotNull Continuation<? super Unit> $completion) {
        block5: {
            RdDocumentChangeBase rdDocumentChangeBase;
            Logger $this$trace$iv = FrontendPatchDocumentItemHandlerKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Apply document step: " + item + " with operation type " + context.getOperation());
            }
            if (WhenMappings.$EnumSwitchMapping$0[context.getOperation().ordinal()] == 1) {
                RdDocumentChangeBase rdDocumentChangeBase2 = item;
                if (rdDocumentChangeBase2 instanceof RdResetDocumentChange) {
                    throw new IllegalStateException(("Can't revert initial change for " + DocumentExKt.toDebugString((RdDocumentId)item.getDocumentId())).toString());
                }
                if (!(rdDocumentChangeBase2 instanceof RdDocumentChange)) {
                    throw new IllegalStateException((item.getClass() + " is not supported for revert operation").toString());
                }
                rdDocumentChangeBase = (RdDocumentChangeBase)UtilKt.reverse((RdDocumentChange)((RdDocumentChange)item));
            } else {
                rdDocumentChangeBase = item;
            }
            RdDocumentChangeBase change = rdDocumentChangeBase;
            PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer = this.getDocumentSynchronizer(change.getDocumentId(), context.getSession());
            if (patchEngineDocumentSynchronizer == null) break block5;
            patchEngineDocumentSynchronizer.receiveDocumentChange(change, context.getOperation() == PatchItemOperationType.Redo);
        }
        return Unit.INSTANCE;
    }

    private final PatchEngineDocumentSynchronizer getDocumentSynchronizer(RdDocumentId id, ClientAppSession session) {
        FrontendDocumentHost documentHost = FrontendDocumentHost.Companion.getInstance(session);
        if (documentHost.isRecentlyClosed(id)) {
            Logger $this$trace$iv = FrontendPatchDocumentItemHandlerKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Do not promote document version for a recently closed document (it is an expected race case); document: " + id);
            }
            return null;
        }
        DocumentSynchronizer documentSynchronizer2 = documentHost.getSynchronizer(id);
        return documentSynchronizer2 instanceof PatchEngineDocumentSynchronizer ? (PatchEngineDocumentSynchronizer)documentSynchronizer2 : null;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PatchItemOperationType.values().length];
            try {
                nArray[PatchItemOperationType.Rollback.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PatchItemOperationType.Perform.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

