/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.gotoType;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.actions.SearchEverywhereAction;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.rd.ide.model.GotoKey;
import com.jetbrains.rd.ide.model.SearchItemData;
import com.jetbrains.rd.ide.model.SearchPopup;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rdclient.gotoType.GotoHost;
import com.jetbrains.rdclient.gotoType.GotoPopupSession;
import com.jetbrains.rdclient.gotoType.GotoResult;
import com.jetbrains.rdclient.gotoType.ProtocolNavigationItem;
import com.jetbrains.rdclient.gotoType.ProtocolNavigationItemRendererData;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J5\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J%\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rdclient/gotoType/ProtocolGotoContributorBase;", "Lcom/intellij/navigation/ChooseByNameContributor;", "key", "Lcom/jetbrains/rd/ide/model/GotoKey;", "(Lcom/jetbrains/rd/ide/model/GotoKey;)V", "getKey", "()Lcom/jetbrains/rd/ide/model/GotoKey;", "getItemsByName", "", "Lcom/intellij/navigation/NavigationItem;", "name", "", "pattern", "project", "Lcom/intellij/openapi/project/Project;", "includeNonProjectItems", "", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/project/Project;Z)[Lcom/intellij/navigation/NavigationItem;", "getNames", "(Lcom/intellij/openapi/project/Project;Z)[Ljava/lang/String;", "getPopup", "Lcom/intellij/openapi/Disposable;", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nProtocolGotoContributorBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolGotoContributorBase.kt\ncom/jetbrains/rdclient/gotoType/ProtocolGotoContributorBase\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,74:1\n26#2:75\n53#3,4:76\n11#3:87\n1#4:80\n1549#5:81\n1620#5,3:82\n37#6,2:85\n*S KotlinDebug\n*F\n+ 1 ProtocolGotoContributorBase.kt\ncom/jetbrains/rdclient/gotoType/ProtocolGotoContributorBase\n*L\n30#1:75\n35#1:76,4\n19#1:87\n67#1:81\n67#1:82,3\n71#1:85,2\n*E\n"})
public abstract class ProtocolGotoContributorBase
implements ChooseByNameContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GotoKey key;
    @NotNull
    private static final Logger logger;

    public ProtocolGotoContributorBase(@NotNull GotoKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.key = key;
    }

    @NotNull
    public final GotoKey getKey() {
        return this.key;
    }

    @Nullable
    protected Disposable getPopup(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)project.getUserData(SearchEverywhereAction.SEARCH_EVERYWHERE_POPUP);
        return concurrentHashMap != null && (concurrentHashMap = (JBPopup)concurrentHashMap.get(ClientId.Companion.getCurrent())) != null ? (Disposable)concurrentHashMap : (Disposable)project.getUserData(ChooseByNamePopup.CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY);
    }

    @NotNull
    public String[] getNames(@NotNull Project project, boolean includeNonProjectItems) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GotoHost gotoHost = GotoHost.Companion.getInstance(project);
        String string = (String)project.getUserData(ChooseByNamePopup.CURRENT_SEARCH_PATTERN);
        if (string == null) {
            boolean $i$f$emptyArray = false;
            return new String[0];
        }
        String text = string;
        Disposable disposable = this.getPopup(project);
        if (disposable == null) {
            return new String[0];
        }
        Disposable popup = disposable;
        if (logger.isTraceEnabled()) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("getting names for " + this.key + " contributor...");
            }
        }
        GotoPopupSession session = gotoHost.getSessionForPopup(popup, this.key);
        long started = System.currentTimeMillis();
        String[] items = session.getItemsSync(text, includeNonProjectItems, null);
        long delta = System.currentTimeMillis() - started;
        logger.debug("Done getting items from backend for " + this.key + ". Time = " + delta + ". Items count = " + items.length);
        return items;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public NavigationItem[] getItemsByName(@NotNull String name, @NotNull String pattern, @NotNull Project project, boolean includeNonProjectItems) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        GotoPopupSession gotoPopupSession;
        Object object;
        Ref.ObjectRef session;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GotoHost gotoTypeHost = GotoHost.Companion.getInstance(project);
        Ref.ObjectRef objectRef = session = new Ref.ObjectRef();
        Disposable disposable = this.getPopup(project);
        if (disposable != null) {
            void it;
            Disposable disposable2 = disposable;
            object = objectRef;
            boolean bl = false;
            gotoPopupSession = gotoTypeHost.getSessionForPopup((Disposable)it, this.key);
            objectRef = object;
        } else {
            gotoPopupSession = null;
        }
        objectRef.element = gotoPopupSession;
        Ref.ObjectRef items = new Ref.ObjectRef();
        items.element = CollectionsKt.emptyList();
        if (session.element == null) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                return new NavigationItem[0];
            }
            LifetimeDefinition lifetime = new LifetimeDefinition();
            session.element = new GotoPopupSession(project, (Lifetime)lifetime, this.key);
            Ref.BooleanRef itemsReceived = new Ref.BooleanRef();
            ((GotoPopupSession)session.element).getItemsAsync((Lifetime)lifetime, name, includeNonProjectItems, (Function1<? super String[], Unit>)((Function1)new Function1<String[], Unit>((Ref.ObjectRef<Collection<GotoResult>>)items, (Ref.ObjectRef<GotoPopupSession>)session, name, itemsReceived){
                final /* synthetic */ Ref.ObjectRef<Collection<GotoResult>> $items;
                final /* synthetic */ Ref.ObjectRef<GotoPopupSession> $session;
                final /* synthetic */ String $name;
                final /* synthetic */ Ref.BooleanRef $itemsReceived;
                {
                    this.$items = $items;
                    this.$session = $session;
                    this.$name = $name;
                    this.$itemsReceived = $itemsReceived;
                    super(1);
                }

                public final void invoke(@NotNull String[] it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$items.element = ((GotoPopupSession)this.$session.element).getItemByShortName(this.$name);
                    this.$itemsReceived.element = true;
                }
            }));
            ExtensionsKt.pumpMessages$default(null, (Function0)new Function0<Boolean>(itemsReceived){
                final /* synthetic */ Ref.BooleanRef $itemsReceived;
                {
                    this.$itemsReceived = $itemsReceived;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    return this.$itemsReceived.element;
                }
            }, 1, null);
            LifetimeDefinition.terminate$default((LifetimeDefinition)lifetime, (boolean)false, (int)1, null);
        } else {
            items.element = ((GotoPopupSession)session.element).getItemByShortName(name);
        }
        Iterable $this$map$iv = (Iterable)items.element;
        boolean $i$f$map = false;
        Iterable bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PsiFile psiFile;
            GotoResult gotoResult = (GotoResult)item$iv$iv;
            object = destination$iv$iv;
            boolean bl2 = false;
            SearchItemData searchItemData = gotoResult.component1();
            SearchPopup searchPopup = gotoResult.component2();
            PsiFile psiFile2 = psiFile = ProtocolNavigationItem.Companion.calculatePsiFile(searchItemData, true, project);
            ProtocolNavigationItemRendererData renderData = ProtocolNavigationItemRendererData.Companion.calculateRenderData((VirtualFile)(psiFile2 != null ? psiFile2.getVirtualFile() : null), true, project);
            object.add(new ProtocolNavigationItem(searchItemData, searchPopup, project, (GotoPopupSession)session.element, psiFile, renderData));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new ProtocolNavigationItem[0]);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProtocolGotoContributorBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ProtocolGotoContributorBase.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rdclient/gotoType/ProtocolGotoContributorBase$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

