/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationScript.providers;

import com.intellij.configurationScript.BeanConstructorKt;
import com.intellij.configurationScript.ConfigurationFileManager;
import com.intellij.configurationScript.providers.ConfigurationScriptProjectStoreFactory;
import com.intellij.configurationScript.providers.ReadOnlyStorage;
import com.intellij.configurationStore.ComponentInfo;
import com.intellij.configurationStore.ProjectWithModuleStoreImpl;
import com.intellij.configurationStore.SaveSessionProducer;
import com.intellij.configurationStore.SaveSessionProducerBase;
import com.intellij.configurationStore.StateGetter;
import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.configurationStore.XmlSerializerKt;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StoredProperty;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.snakeyaml.engine.v2.nodes.NodeTuple;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\u000eJ<\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0014J,\u0010\u001a\u001a\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u001c\u001a\u00020\u0018H\u0014J\u001e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140 H\u0016J*\u0010!\u001a\u00020\u000e2\b\u0010\"\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%H\u0014J\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u000bH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0007R \u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/configurationScript/providers/MyProjectStore;", "Lcom/intellij/configurationStore/ProjectWithModuleStoreImpl;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "isConfigurationFileListenerAdded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "storages", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/lang/Class;", "", "Lcom/intellij/configurationScript/providers/ReadOnlyStorage;", "configurationFileChanged", "", "doCreateStateGetter", "Lcom/intellij/configurationStore/StateGetter;", "reloadData", "", "storage", "Lcom/intellij/openapi/components/StateStorage;", "info", "Lcom/intellij/configurationStore/ComponentInfo;", "name", "", "stateClass", "getReadOnlyStorage", "componentClass", "configurationSchemaKey", "reload", "", "changedStorages", "", "setStateToSaveSessionProducer", "state", "effectiveComponentName", "sessionProducer", "Lcom/intellij/configurationStore/SaveSessionProducer;", "unloadComponent", "component", "intellij.configurationScript"})
@SourceDebugExtension(value={"SMAP\nConfigurationScriptProjectStoreFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationScriptProjectStoreFactory.kt\ncom/intellij/configurationScript/providers/MyProjectStore\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,132:1\n11#2:133\n*S KotlinDebug\n*F\n+ 1 ConfigurationScriptProjectStoreFactory.kt\ncom/intellij/configurationScript/providers/MyProjectStore\n*L\n95#1:133\n*E\n"})
final class MyProjectStore
extends ProjectWithModuleStoreImpl {
    @NotNull
    private final AtomicBoolean isConfigurationFileListenerAdded;
    @NotNull
    private final ConcurrentHashMap<Class<Object>, ReadOnlyStorage> storages;

    public MyProjectStore(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.isConfigurationFileListenerAdded = new AtomicBoolean();
        this.storages = new ConcurrentHashMap();
    }

    @NotNull
    public final AtomicBoolean isConfigurationFileListenerAdded() {
        return this.isConfigurationFileListenerAdded;
    }

    public final void configurationFileChanged() {
        if (!((Map)this.storages).isEmpty()) {
            StoreReloadManager storeReloadManager = StoreReloadManager.Companion.getInstance(this.getProject());
            IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)((ComponentManager)this.getProject()));
            Collection<ReadOnlyStorage> collection = this.storages.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            storeReloadManager.storageFilesChanged(iComponentStore, (Collection)CollectionsKt.toList((Iterable)collection));
        }
    }

    public void unloadComponent(@NotNull Object component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        super.unloadComponent(component);
        if (component instanceof PersistentStateComponent) {
            this.storages.remove(component.getClass());
        }
    }

    @NotNull
    protected StateStorage getReadOnlyStorage(@NotNull Class<Object> componentClass, @NotNull Class<Object> stateClass, @NotNull String configurationSchemaKey) {
        Intrinsics.checkNotNullParameter(componentClass, (String)"componentClass");
        Intrinsics.checkNotNullParameter(stateClass, (String)"stateClass");
        Intrinsics.checkNotNullParameter((Object)configurationSchemaKey, (String)"configurationSchemaKey");
        ReadOnlyStorage readOnlyStorage = this.storages.computeIfAbsent(componentClass, arg_0 -> MyProjectStore.getReadOnlyStorage$lambda$0((Function1)new Function1<Class<Object>, ReadOnlyStorage>(configurationSchemaKey, componentClass, this){
            final /* synthetic */ String $configurationSchemaKey;
            final /* synthetic */ Class<Object> $componentClass;
            final /* synthetic */ MyProjectStore this$0;
            {
                this.$configurationSchemaKey = $configurationSchemaKey;
                this.$componentClass = $componentClass;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ReadOnlyStorage invoke(@NotNull Class<Object> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return new ReadOnlyStorage(this.$configurationSchemaKey, this.$componentClass, this.this$0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)readOnlyStorage, (String)"computeIfAbsent(...)");
        return readOnlyStorage;
    }

    @NotNull
    protected StateGetter<Object> doCreateStateGetter(boolean reloadData, @NotNull StateStorage storage, @NotNull ComponentInfo info, @NotNull String name, @NotNull Class<Object> stateClass) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(stateClass, (String)"stateClass");
        StateGetter stateGetter = super.doCreateStateGetter(reloadData, storage, info, name, stateClass);
        String string = info.getConfigurationSchemaKey();
        if (string == null) {
            return stateGetter;
        }
        String configurationSchemaKey = string;
        ConfigurationFileManager configurationFileManager = ConfigurationFileManager.Companion.getInstance(this.getProject());
        List<NodeTuple> list = configurationFileManager.findValueNode(configurationSchemaKey);
        if (list == null) {
            return stateGetter;
        }
        List<NodeTuple> node = list;
        return (StateGetter)new StateGetter<Object>((StateGetter<Object>)stateGetter, stateClass, node, info){
            final /* synthetic */ StateGetter<Object> $stateGetter;
            final /* synthetic */ Class<Object> $stateClass;
            final /* synthetic */ List<NodeTuple> $node;
            final /* synthetic */ ComponentInfo $info;
            {
                this.$stateGetter = $stateGetter;
                this.$stateClass = $stateClass;
                this.$node = $node;
                this.$info = $info;
            }

            @NotNull
            public Object getState(@Nullable Object mergeInto) {
                Object object = this.$stateGetter.getState(mergeInto);
                if (object == null) {
                    Object object2 = ReflectionUtil.newInstance(this.$stateClass, (boolean)false);
                    object = object2;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"newInstance(...)");
                }
                Object state = object;
                List affectedProperties = new ArrayList<E>();
                BeanConstructorKt.readIntoObject((BaseState)state, this.$node, (Function1<? super StoredProperty<Object>, Unit>)((Function1)new Function1<StoredProperty<Object>, Unit>((List<String>)affectedProperties){
                    final /* synthetic */ List<String> $affectedProperties;
                    {
                        this.$affectedProperties = $affectedProperties;
                        super(1);
                    }

                    public final void invoke(@NotNull StoredProperty<Object> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        String string = it.getName();
                        Intrinsics.checkNotNull((Object)string);
                        this.$affectedProperties.add(string);
                    }
                }));
                this.$info.setAffectedPropertyNames(affectedProperties);
                return state;
            }

            @Nullable
            public Object archiveState() {
                return null;
            }
        };
    }

    protected void setStateToSaveSessionProducer(@Nullable Object state, @NotNull ComponentInfo info, @NotNull String effectiveComponentName, @NotNull SaveSessionProducer sessionProducer) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)effectiveComponentName, (String)"effectiveComponentName");
        Intrinsics.checkNotNullParameter((Object)sessionProducer, (String)"sessionProducer");
        String configurationSchemaKey = info.getConfigurationSchemaKey();
        if (state == null || configurationSchemaKey == null || info.getAffectedPropertyNames().isEmpty() || !(sessionProducer instanceof SaveSessionProducerBase)) {
            super.setStateToSaveSessionProducer(state, info, effectiveComponentName, sessionProducer);
        } else {
            Element serializedState = XmlSerializerKt.deserializeBaseStateWithCustomNameFilter((BaseState)((BaseState)state), (Collection)info.getAffectedPropertyNames());
            ((SaveSessionProducerBase)sessionProducer).setSerializedState(effectiveComponentName, serializedState);
        }
    }

    @Nullable
    public Collection<String> reload(@NotNull Set<? extends StateStorage> changedStorages) {
        Intrinsics.checkNotNullParameter(changedStorages, (String)"changedStorages");
        Collection result = super.reload(changedStorages);
        for (StateStorage stateStorage : changedStorages) {
            if (!(stateStorage instanceof ReadOnlyStorage)) continue;
            Object component = this.getProject().getServiceIfCreated(((ReadOnlyStorage)stateStorage).getComponentClass());
            if (component == null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(ConfigurationScriptProjectStoreFactory.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Cannot find component by " + ((ReadOnlyStorage)stateStorage).getComponentClass().getName());
                continue;
            }
            this.initComponentWithoutStateSpec((PersistentStateComponent)component, ((ReadOnlyStorage)stateStorage).getConfigurationSchemaKey());
        }
        return result;
    }

    private static final ReadOnlyStorage getReadOnlyStorage$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ReadOnlyStorage)$tmp0.invoke(p0);
    }
}

