/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.JBTerminalWidgetListener;
import com.intellij.terminal.actions.TerminalActionUtil;
import com.intellij.terminal.pty.PtyProcessTtyConnector;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalLineIntervalHighlighting;
import com.jediterm.terminal.model.TerminalModelListener;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.TerminalActionPresentation;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.JBTerminalSystemSettingsProvider;
import org.jetbrains.plugins.terminal.ProxyTtyConnector;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalShellCommandHandlerHelper;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.action.TerminalSplitAction;
import org.jetbrains.plugins.terminal.fus.TerminalUsageTriggerCollector;

public class ShellTerminalWidget
extends JBTerminalWidget {
    private static final Logger LOG = Logger.getInstance(ShellTerminalWidget.class);
    private static final long VFS_REFRESH_DELAY_MS = 500L;
    private String myCommandHistoryFilePath;
    private List<String> myShellCommand;
    private final Prompt myPrompt;
    private final TerminalShellCommandHandlerHelper myShellCommandHandlerHelper;
    private final Alarm myVfsRefreshAlarm;
    private final TerminalModelListener myVfsRefreshModelListener;
    private volatile String myPrevPromptWhenCommandStarted;

    @Deprecated(forRemoval=true)
    public ShellTerminalWidget(@NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settingsProvider, @NotNull Disposable parent) {
        JBTerminalSystemSettingsProvider p;
        if (project == null) {
            ShellTerminalWidget.$$$reportNull$$$0(0);
        }
        if (settingsProvider == null) {
            ShellTerminalWidget.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            ShellTerminalWidget.$$$reportNull$$$0(2);
        }
        this(project, settingsProvider instanceof JBTerminalSystemSettingsProvider ? (p = (JBTerminalSystemSettingsProvider)settingsProvider) : new JBTerminalSystemSettingsProvider(), parent);
    }

    public ShellTerminalWidget(@NotNull Project project, @NotNull JBTerminalSystemSettingsProvider settingsProvider, @NotNull Disposable parent) {
        if (project == null) {
            ShellTerminalWidget.$$$reportNull$$$0(3);
        }
        if (settingsProvider == null) {
            ShellTerminalWidget.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            ShellTerminalWidget.$$$reportNull$$$0(5);
        }
        super(project, (JBTerminalSystemSettingsProviderBase)settingsProvider, parent);
        this.myPrompt = new Prompt();
        this.myShellCommandHandlerHelper = new TerminalShellCommandHandlerHelper(this);
        this.myVfsRefreshAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myVfsRefreshModelListener = () -> {
            this.myVfsRefreshAlarm.cancelAllRequests();
            this.myVfsRefreshAlarm.addRequest(this::refreshVfsIfPromptIsShown, 500L);
        };
        this.getTerminalPanel().addPreKeyEventHandler(e -> {
            String prompt;
            if (e.getID() != 401) {
                return;
            }
            this.handleAnyKeyPressed();
            if (!(e.isConsumed() || e.getKeyCode() != 10 || (prompt = this.myPrompt.myPrompt).isEmpty() || this.getTypedShellCommand().isEmpty())) {
                this.myVfsRefreshAlarm.cancelAllRequests();
                this.getTerminalTextBuffer().removeModelListener(this.myVfsRefreshModelListener);
                this.myPrevPromptWhenCommandStarted = prompt;
                if (!this.getTerminalTextBuffer().isUsingAlternateBuffer()) {
                    this.getTerminalTextBuffer().addModelListener(this.myVfsRefreshModelListener);
                }
            }
            if (e.getKeyCode() == 10 || TerminalShellCommandHandlerHelper.matchedExecutor(e) != null) {
                TerminalUsageTriggerCollector.triggerCommandExecuted(project, this.getTypedShellCommand());
                if (this.myShellCommandHandlerHelper.processEnterKeyPressed((KeyEvent)e)) {
                    e.consume();
                }
                if (!e.isConsumed()) {
                    this.handleEnterPressed();
                }
            } else {
                this.myShellCommandHandlerHelper.processKeyPressed((KeyEvent)e);
            }
        });
        Disposer.register((Disposable)this, () -> this.getTerminalTextBuffer().removeModelListener(this.myVfsRefreshModelListener));
    }

    private void refreshVfsIfPromptIsShown() {
        String promptWhenCommandStarted = this.myPrevPromptWhenCommandStarted;
        if (promptWhenCommandStarted != null) {
            this.processTerminalBuffer(terminalTextBuffer -> {
                TerminalLine line = this.myPrompt.getLineAtCursor((TerminalTextBuffer)terminalTextBuffer);
                String lineStr = line.getText();
                if (lineStr.startsWith(promptWhenCommandStarted)) {
                    SaveAndSyncHandler.getInstance().scheduleRefresh();
                    this.myPrevPromptWhenCommandStarted = null;
                    this.myVfsRefreshAlarm.cancelAllRequests();
                    this.getTerminalTextBuffer().removeModelListener(this.myVfsRefreshModelListener);
                }
                return null;
            });
        }
    }

    public void handleEnterPressed() {
        this.myPrompt.reset();
    }

    public void handleAnyKeyPressed() {
        this.myPrompt.onKeyPressed();
    }

    public void setCommandHistoryFilePath(@Nullable String commandHistoryFilePath) {
        this.myCommandHistoryFilePath = commandHistoryFilePath;
    }

    @Nullable
    public String getCommandHistoryFilePath() {
        return this.myCommandHistoryFilePath;
    }

    public void setShellCommand(@Nullable List<String> shellCommand2) {
        this.myShellCommand = shellCommand2 != null ? List.copyOf(shellCommand2) : null;
    }

    @Nullable
    public List<String> getShellCommand() {
        return this.myShellCommand;
    }

    @NotNull
    public String getTypedShellCommand() {
        String string = this.myPrompt.getTypedShellCommand();
        if (string == null) {
            ShellTerminalWidget.$$$reportNull$$$0(6);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T processTerminalBuffer(@NotNull Function<TerminalTextBuffer, T> processor) {
        if (processor == null) {
            ShellTerminalWidget.$$$reportNull$$$0(7);
        }
        TerminalTextBuffer textBuffer = this.getTerminalPanel().getTerminalTextBuffer();
        textBuffer.lock();
        try {
            T t = processor.apply(textBuffer);
            return t;
        }
        finally {
            textBuffer.unlock();
        }
    }

    int getLineNumberAtCursor() {
        TerminalTextBuffer textBuffer = this.getTerminalPanel().getTerminalTextBuffer();
        Terminal terminal = this.getTerminal();
        return Math.max(0, Math.min(terminal.getCursorY() - 1, textBuffer.getHeight() - 1));
    }

    public void executeCommand(@NotNull String shellCommand2) throws IOException {
        String typedCommand;
        if (shellCommand2 == null) {
            ShellTerminalWidget.$$$reportNull$$$0(8);
        }
        if (!(typedCommand = this.getTypedShellCommand()).isEmpty()) {
            throw new IOException("Cannot execute command when another command is typed: " + typedCommand);
        }
        this.doWithTerminalStarter(terminalStarter -> TerminalUtil.sendCommandToExecute(shellCommand2, terminalStarter));
    }

    public void executeWithTtyConnector(@NotNull Consumer<TtyConnector> consumer2) {
        if (consumer2 == null) {
            ShellTerminalWidget.$$$reportNull$$$0(9);
        }
        this.asNewWidget().getTtyConnectorAccessor().executeWithTtyConnector(consumer2);
    }

    @Nls
    @Nullable
    public String getDefaultSessionName(@NotNull TtyConnector connector) {
        if (connector == null) {
            ShellTerminalWidget.$$$reportNull$$$0(10);
        }
        if (ShellTerminalWidget.getProcessTtyConnector(connector) instanceof PtyProcessTtyConnector) {
            return TerminalOptionsProvider.getInstance().getTabName();
        }
        return super.getDefaultSessionName(connector);
    }

    public boolean hasRunningCommands() throws IllegalStateException {
        TtyConnector connector = this.getTtyConnector();
        if (connector == null) {
            return false;
        }
        ProcessTtyConnector processTtyConnector = ShellTerminalWidget.getProcessTtyConnector(connector);
        if (processTtyConnector != null) {
            return TerminalUtil.hasRunningCommands(processTtyConnector);
        }
        throw new IllegalStateException("Cannot determine if there are running processes for " + connector.getClass());
    }

    @NotNull
    public JBTerminalSystemSettingsProvider getSettingsProvider() {
        JBTerminalSystemSettingsProvider jBTerminalSystemSettingsProvider = (JBTerminalSystemSettingsProvider)super.getSettingsProvider();
        if (jBTerminalSystemSettingsProvider == null) {
            ShellTerminalWidget.$$$reportNull$$$0(11);
        }
        return jBTerminalSystemSettingsProvider;
    }

    public List<TerminalAction> getActions() {
        ArrayList<TerminalAction> actions = new ArrayList<TerminalAction>(super.getActions());
        if (TerminalToolWindowManager.isInTerminalToolWindow(this)) {
            ContainerUtil.addIfNotNull(actions, (Object)TerminalActionUtil.createTerminalAction((JBTerminalWidget)this, (String)"Terminal.RenameSession", (boolean)true));
        }
        JBTerminalWidgetListener listener = this.getListener();
        JBTerminalSystemSettingsProvider settingsProvider = this.getSettingsProvider();
        actions.add(TerminalActionUtil.createTerminalAction((JBTerminalWidget)this, (TerminalActionPresentation)settingsProvider.getNewTabActionPresentation(), l -> {
            l.onNewSession();
            return true;
        }).withMnemonicKey(Integer.valueOf(84)));
        actions.add(TerminalActionUtil.createTerminalAction((JBTerminalWidget)this, (TerminalActionPresentation)settingsProvider.getCloseTabActionPresentation(), l -> {
            l.onSessionClosed();
            return true;
        }).withMnemonicKey(Integer.valueOf(84)));
        actions.add(TerminalSplitAction.create(true, this.getListener()).separatorBefore(true));
        actions.add(TerminalSplitAction.create(false, this.getListener()));
        if (listener != null && listener.isGotoNextSplitTerminalAvailable()) {
            actions.add(settingsProvider.getGotoNextSplitTerminalAction(listener, true));
            actions.add(settingsProvider.getGotoNextSplitTerminalAction(listener, false));
        }
        actions.add(TerminalActionUtil.createTerminalAction((JBTerminalWidget)this, (TerminalActionPresentation)settingsProvider.getPreviousTabActionPresentation(), l -> {
            l.onPreviousTabSelected();
            return true;
        }).withMnemonicKey(Integer.valueOf(84)));
        actions.add(TerminalActionUtil.createTerminalAction((JBTerminalWidget)this, (TerminalActionPresentation)settingsProvider.getNextTabActionPresentation(), l -> {
            l.onNextTabSelected();
            return true;
        }).withMnemonicKey(Integer.valueOf(84)));
        actions.add(TerminalActionUtil.createTerminalAction((JBTerminalWidget)this, (TerminalActionPresentation)settingsProvider.getMoveTabRightActionPresentation(), l -> {
            l.moveTabRight();
            return true;
        }).withMnemonicKey(Integer.valueOf(82)).withEnabledSupplier(() -> listener != null && listener.canMoveTabRight()));
        actions.add(TerminalActionUtil.createTerminalAction((JBTerminalWidget)this, (TerminalActionPresentation)settingsProvider.getMoveTabLeftActionPresentation(), l -> {
            l.moveTabLeft();
            return true;
        }).withMnemonicKey(Integer.valueOf(76)).withEnabledSupplier(() -> listener != null && listener.canMoveTabLeft()));
        actions.add(TerminalActionUtil.createTerminalAction((JBTerminalWidget)this, (TerminalActionPresentation)settingsProvider.getShowTabsActionPresentation(), l -> {
            l.showTabs();
            return true;
        }).withMnemonicKey(Integer.valueOf(84)));
        return actions;
    }

    @Nullable
    public TerminalLineIntervalHighlighting highlightLineInterval(int lineNumber, int intervalStartOffset, int intervalLength, @NotNull TextStyle style) {
        if (style == null) {
            ShellTerminalWidget.$$$reportNull$$$0(12);
        }
        TerminalLine line = this.getTerminalTextBuffer().getLine(lineNumber);
        TerminalLineIntervalHighlighting highlighting = line.addCustomHighlighting(intervalStartOffset, intervalLength, style);
        this.getTerminalPanel().repaint();
        return highlighting;
    }

    @Nullable
    public ProcessTtyConnector getProcessTtyConnector() {
        return ShellTerminalWidget.getProcessTtyConnector(this.getTtyConnector());
    }

    @Nullable
    public static ProcessTtyConnector getProcessTtyConnector(@Nullable TtyConnector connector) {
        if (connector instanceof ProcessTtyConnector) {
            return (ProcessTtyConnector)connector;
        }
        if (connector instanceof ProxyTtyConnector) {
            return ShellTerminalWidget.getProcessTtyConnector(((ProxyTtyConnector)connector).getConnector());
        }
        return null;
    }

    @Nullable
    public static ShellTerminalWidget asShellJediTermWidget(@NotNull TerminalWidget widget) {
        if (widget == null) {
            ShellTerminalWidget.$$$reportNull$$$0(13);
        }
        return (ShellTerminalWidget)((Object)ObjectUtils.tryCast((Object)JBTerminalWidget.asJediTermWidget((TerminalWidget)widget), ShellTerminalWidget.class));
    }

    @NotNull
    public static ShellTerminalWidget toShellJediTermWidgetOrThrow(@NotNull TerminalWidget widget) {
        if (widget == null) {
            ShellTerminalWidget.$$$reportNull$$$0(14);
        }
        ShellTerminalWidget shellTerminalWidget = (ShellTerminalWidget)Objects.requireNonNull(JBTerminalWidget.asJediTermWidget((TerminalWidget)widget));
        if (shellTerminalWidget == null) {
            ShellTerminalWidget.$$$reportNull$$$0(15);
        }
        return shellTerminalWidget;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 11, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/ShellTerminalWidget";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellCommand";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connector";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/ShellTerminalWidget";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedShellCommand";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsProvider";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "toShellJediTermWidgetOrThrow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 11: 
            case 15: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processTerminalBuffer";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeCommand";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeWithTtyConnector";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSessionName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "highlightLineInterval";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "asShellJediTermWidget";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "toShellJediTermWidgetOrThrow";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 11, 15 -> new IllegalStateException(string);
        };
    }

    private final class Prompt {
        @NotNull
        private volatile String myPrompt = "";
        private final AtomicInteger myTypings = new AtomicInteger(0);
        private TerminalLine myTerminalLine;
        private int myMaxCursorX = -1;

        private Prompt() {
        }

        private void reset() {
            this.myTypings.set(0);
            this.myTerminalLine = null;
            this.myMaxCursorX = -1;
        }

        private void onKeyPressed() {
            TerminalLine terminalLine = ShellTerminalWidget.this.processTerminalBuffer(this::getLineAtCursor);
            if (terminalLine != this.myTerminalLine) {
                this.myTypings.set(0);
                this.myTerminalLine = terminalLine;
                this.myMaxCursorX = -1;
            }
            String prompt = this.getLineTextUpToCursor(terminalLine);
            if (this.myTypings.get() == 0) {
                this.myPrompt = prompt;
                this.myTerminalLine = terminalLine;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Guessed shell prompt: " + this.myPrompt);
                }
            } else if (prompt.startsWith(this.myPrompt)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Guessed prompt confirmed by typing# " + (this.myTypings.get() + 1));
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Prompt rejected by typing#" + (this.myTypings.get() + 1) + ", new prompt: " + prompt);
                }
                this.myPrompt = prompt;
                this.myTypings.set(1);
            }
            this.myTypings.incrementAndGet();
        }

        @NotNull
        private String getTypedShellCommand() {
            if (this.myTypings.get() == 0) {
                return "";
            }
            TerminalLine terminalLine = ShellTerminalWidget.this.processTerminalBuffer(this::getLineAtCursor);
            if (terminalLine != this.myTerminalLine) {
                return "";
            }
            String lineTextUpToCursor = this.getLineTextUpToCursor(terminalLine);
            if (lineTextUpToCursor.startsWith(this.myPrompt)) {
                String string = lineTextUpToCursor.substring(this.myPrompt.length());
                if (string == null) {
                    Prompt.$$$reportNull$$$0(0);
                }
                return string;
            }
            return "";
        }

        @NotNull
        private TerminalLine getLineAtCursor(@NotNull TerminalTextBuffer textBuffer) {
            if (textBuffer == null) {
                Prompt.$$$reportNull$$$0(1);
            }
            TerminalLine terminalLine = textBuffer.getLine(ShellTerminalWidget.this.getLineNumberAtCursor());
            if (terminalLine == null) {
                Prompt.$$$reportNull$$$0(2);
            }
            return terminalLine;
        }

        @NotNull
        private String getLineTextUpToCursor(@Nullable TerminalLine line) {
            if (line == null) {
                return "";
            }
            String string = ShellTerminalWidget.this.processTerminalBuffer(textBuffer -> {
                int maxCursorX;
                int cursorX = ShellTerminalWidget.this.getTerminal().getCursorX() - 1;
                String lineStr = line.getText();
                for (maxCursorX = Math.max(this.myMaxCursorX, cursorX); maxCursorX < lineStr.length() && !Character.isWhitespace(lineStr.charAt(maxCursorX)); ++maxCursorX) {
                }
                this.myMaxCursorX = maxCursorX;
                return lineStr.substring(0, Math.min(maxCursorX, lineStr.length()));
            });
            if (string == null) {
                Prompt.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/terminal/ShellTerminalWidget$Prompt";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textBuffer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypedShellCommand";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/terminal/ShellTerminalWidget$Prompt";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLineAtCursor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLineTextUpToCursor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getLineAtCursor";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

