/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSshProcess;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.model.TerminalModelListener;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.pty4j.unix.UnixPtyProcess;
import com.pty4j.windows.WinPtyProcess;
import com.pty4j.windows.conpty.WinConPtyProcess;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TerminalUtil {
    private static final Logger LOG = Logger.getInstance(TerminalUtil.class);

    private TerminalUtil() {
    }

    public static boolean hasRunningCommands(@NotNull ProcessTtyConnector connector) throws IllegalStateException {
        Process process;
        if (connector == null) {
            TerminalUtil.$$$reportNull$$$0(0);
        }
        if (!(process = connector.getProcess()).isAlive()) {
            return false;
        }
        if (process instanceof RemoteSshProcess) {
            return true;
        }
        if (SystemInfo.isUnix && process instanceof UnixPtyProcess) {
            int shellPid = OSProcessUtil.getProcessID((Process)process);
            MultiMap pidToChildPidsMap = MultiMap.create();
            UnixProcessManager.processPSOutput((String[])UnixProcessManager.getPSCmd((boolean)false, (boolean)false), s -> {
                StringTokenizer st = new StringTokenizer((String)s, " ");
                int parentPid = Integer.parseInt(st.nextToken());
                int pid = Integer.parseInt(st.nextToken());
                pidToChildPidsMap.putValue((Object)parentPid, (Object)pid);
                return false;
            });
            return !pidToChildPidsMap.get((Object)shellPid).isEmpty();
        }
        if (SystemInfo.isWindows && process instanceof WinPtyProcess) {
            WinPtyProcess winPty = (WinPtyProcess)process;
            try {
                String executable = FileUtil.toSystemIndependentName((String)StringUtil.notNullize((String)TerminalUtil.getExecutable(winPty)));
                int consoleProcessCount = winPty.getConsoleProcessCount();
                if (executable.endsWith("/Git/bin/bash.exe")) {
                    return consoleProcessCount > 3;
                }
                return consoleProcessCount > 2;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        if (process instanceof WinConPtyProcess) {
            WinConPtyProcess conPtyProcess = (WinConPtyProcess)process;
            try {
                String executable = FileUtil.toSystemIndependentName((String)StringUtil.notNullize((String)((String)ContainerUtil.getFirstItem((List)conPtyProcess.getCommand()))));
                int consoleProcessCount = conPtyProcess.getConsoleProcessCount();
                if (executable.endsWith("/Git/bin/bash.exe")) {
                    return consoleProcessCount > 2;
                }
                return consoleProcessCount > 1;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        LOG.warn("Cannot determine if there are running processes: " + SystemInfo.OS_NAME + ", " + process.getClass().getName());
        return false;
    }

    @Nullable
    private static String getExecutable(@NotNull WinPtyProcess process) {
        if (process == null) {
            TerminalUtil.$$$reportNull$$$0(1);
        }
        return (String)ContainerUtil.getFirstItem((List)process.getCommand());
    }

    public static <T> void addItem(@NotNull List<T> items, @NotNull T item, @NotNull Disposable parentDisposable) {
        if (items == null) {
            TerminalUtil.$$$reportNull$$$0(2);
        }
        if (item == null) {
            TerminalUtil.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            TerminalUtil.$$$reportNull$$$0(4);
        }
        items.add(item);
        boolean registered = Disposer.tryRegister((Disposable)parentDisposable, () -> items.remove(item));
        if (!registered) {
            items.remove(item);
        }
    }

    public static void sendCommandToExecute(@NotNull String shellCommand2, @NotNull TerminalStarter terminalStarter) {
        if (shellCommand2 == null) {
            TerminalUtil.$$$reportNull$$$0(5);
        }
        if (terminalStarter == null) {
            TerminalUtil.$$$reportNull$$$0(6);
        }
        StringBuilder result2 = new StringBuilder();
        if (terminalStarter.isLastSentByteEscape()) {
            result2.append('\b');
        }
        String enterCode = new String(terminalStarter.getTerminal().getCodeForKey(10, 0), StandardCharsets.UTF_8);
        result2.append(shellCommand2).append(enterCode);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending " + shellCommand2);
        }
        terminalStarter.sendString(result2.toString(), false);
    }

    public static void addModelListener(@NotNull TerminalTextBuffer textBuffer, @NotNull Disposable parentDisposable, @NotNull TerminalModelListener listener) {
        if (textBuffer == null) {
            TerminalUtil.$$$reportNull$$$0(7);
        }
        if (parentDisposable == null) {
            TerminalUtil.$$$reportNull$$$0(8);
        }
        if (listener == null) {
            TerminalUtil.$$$reportNull$$$0(9);
        }
        textBuffer.addModelListener(listener);
        Disposer.register((Disposable)parentDisposable, () -> textBuffer.removeModelListener(listener));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellCommand";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalStarter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textBuffer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/terminal/TerminalUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasRunningCommands";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getExecutable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addItem";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "sendCommandToExecute";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addModelListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

