/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.exp.AllHighlightingsSnapshot;
import org.jetbrains.plugins.terminal.exp.HighlightingInfo;
import org.jetbrains.plugins.terminal.exp.TerminalOutputModelKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nJ\u0011\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\nH\u0086\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/terminal/exp/AllHighlightingsSnapshot;", "", "document", "Lcom/intellij/openapi/editor/Document;", "highlightings", "", "Lorg/jetbrains/plugins/terminal/exp/HighlightingInfo;", "(Lcom/intellij/openapi/editor/Document;Ljava/util/List;)V", "allSortedHighlightings", "size", "", "getSize", "()I", "findHighlightingIndex", "documentOffset", "get", "index", "intellij.terminal"})
public final class AllHighlightingsSnapshot {
    @NotNull
    private final Document document;
    @NotNull
    private final List<HighlightingInfo> allSortedHighlightings;

    public AllHighlightingsSnapshot(@NotNull Document document, @NotNull List<HighlightingInfo> highlightings) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(highlightings, (String)"highlightings");
        this.document = document;
        this.allSortedHighlightings = TerminalOutputModelKt.access$buildAndSortHighlightings(this.document, highlightings);
    }

    public final int getSize() {
        return this.allSortedHighlightings.size();
    }

    @NotNull
    public final HighlightingInfo get(int index) {
        return this.allSortedHighlightings.get(index);
    }

    public final int findHighlightingIndex(int documentOffset) {
        int insertionIndex;
        if (documentOffset <= 0) {
            return 0;
        }
        TextAttributes textAttributes = TextAttributes.ERASE_MARKER;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"ERASE_MARKER");
        HighlightingInfo searchKey = new HighlightingInfo(documentOffset, documentOffset, textAttributes);
        int binarySearchInd2 = Collections.binarySearch(this.allSortedHighlightings, searchKey, (arg_0, arg_1) -> AllHighlightingsSnapshot.findHighlightingIndex$lambda$0(findHighlightingIndex.binarySearchInd.1.INSTANCE, arg_0, arg_1));
        return binarySearchInd2 >= 0 ? binarySearchInd2 : ((insertionIndex = -binarySearchInd2 - 1) == 0 || insertionIndex == this.allSortedHighlightings.size() && documentOffset >= this.document.getTextLength() ? insertionIndex : insertionIndex - 1);
    }

    private static final int findHighlightingIndex$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

