/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.Key;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.TerminalColorPalette;
import com.intellij.terminal.TerminalExecutorServiceManagerImpl;
import com.jediterm.core.Color;
import com.jediterm.core.typeahead.Debouncer;
import com.jediterm.core.typeahead.TerminalTypeAheadManager;
import com.jediterm.core.typeahead.TypeAheadTerminalModel;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TerminalDataStream;
import com.jediterm.terminal.TerminalDisplay;
import com.jediterm.terminal.TerminalExecutorServiceManager;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.TtyBasedArrayDataStream;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.JediTermDebouncerImpl;
import com.jediterm.terminal.model.JediTermTypeAheadModel;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.exp.ModelUpdatingTerminalDisplay;
import org.jetbrains.plugins.terminal.exp.ShellCommandListener;
import org.jetbrains.plugins.terminal.exp.ShellCommandManager;
import org.jetbrains.plugins.terminal.exp.TerminalModel;
import org.jetbrains.plugins.terminal.shell_integration.CommandBlockIntegration;
import org.jetbrains.plugins.terminal.util.ShellIntegration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 :2\u00020\u0001:\u0001:B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u00020\u0001J\u0016\u00100\u001a\u00020,2\u0006\u00101\u001a\u00020&2\u0006\u0010/\u001a\u00020\u0001J\b\u00102\u001a\u00020,H\u0016J\u000e\u00103\u001a\u00020,2\u0006\u00104\u001a\u000205J\u000e\u00106\u001a\u00020,2\u0006\u00107\u001a\u000208J\f\u00109\u001a\u00020,*\u000208H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0 X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;", "Lcom/intellij/openapi/Disposable;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "colorPalette", "Lcom/intellij/terminal/TerminalColorPalette;", "shellIntegration", "Lorg/jetbrains/plugins/terminal/util/ShellIntegration;", "(Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lcom/intellij/terminal/TerminalColorPalette;Lorg/jetbrains/plugins/terminal/util/ShellIntegration;)V", "getColorPalette", "()Lcom/intellij/terminal/TerminalColorPalette;", "commandBlockIntegration", "Lorg/jetbrains/plugins/terminal/shell_integration/CommandBlockIntegration;", "getCommandBlockIntegration", "()Lorg/jetbrains/plugins/terminal/shell_integration/CommandBlockIntegration;", "commandManager", "Lorg/jetbrains/plugins/terminal/exp/ShellCommandManager;", "getCommandManager$intellij_terminal", "()Lorg/jetbrains/plugins/terminal/exp/ShellCommandManager;", "controller", "Lcom/jediterm/terminal/model/JediTerminal;", "getController$intellij_terminal", "()Lcom/jediterm/terminal/model/JediTerminal;", "executorServiceManager", "Lcom/jediterm/terminal/TerminalExecutorServiceManager;", "model", "Lorg/jetbrains/plugins/terminal/exp/TerminalModel;", "getModel", "()Lorg/jetbrains/plugins/terminal/exp/TerminalModel;", "getShellIntegration", "()Lorg/jetbrains/plugins/terminal/util/ShellIntegration;", "terminalStarterFuture", "Ljava/util/concurrent/CompletableFuture;", "Lcom/jediterm/terminal/TerminalStarter;", "getTerminalStarterFuture$intellij_terminal", "()Ljava/util/concurrent/CompletableFuture;", "terminationListeners", "", "Ljava/lang/Runnable;", "textBuffer", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "typeAheadManager", "Lcom/jediterm/core/typeahead/TerminalTypeAheadManager;", "addCommandListener", "", "listener", "Lorg/jetbrains/plugins/terminal/exp/ShellCommandListener;", "parentDisposable", "addTerminationCallback", "onTerminated", "dispose", "postResize", "newSize", "Lcom/jediterm/core/util/TermSize;", "start", "ttyConnector", "Lcom/jediterm/terminal/TtyConnector;", "closeSafely", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nBlockTerminalSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockTerminalSession.kt\norg/jetbrains/plugins/terminal/exp/BlockTerminalSession\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,125:1\n9#2:126\n9#2:127\n9#2:128\n*S KotlinDebug\n*F\n+ 1 BlockTerminalSession.kt\norg/jetbrains/plugins/terminal/exp/BlockTerminalSession\n*L\n102#1:126\n73#1:127\n64#1:128\n*E\n"})
public final class BlockTerminalSession
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalColorPalette colorPalette;
    @NotNull
    private final ShellIntegration shellIntegration;
    @NotNull
    private final TerminalModel model;
    @NotNull
    private final CompletableFuture<TerminalStarter> terminalStarterFuture;
    @NotNull
    private final TerminalExecutorServiceManager executorServiceManager;
    @NotNull
    private final TerminalTextBuffer textBuffer;
    @NotNull
    private final JediTerminal controller;
    @NotNull
    private final ShellCommandManager commandManager;
    @NotNull
    private final TerminalTypeAheadManager typeAheadManager;
    @NotNull
    private final List<Runnable> terminationListeners;
    @NotNull
    private final CommandBlockIntegration commandBlockIntegration;
    @NotNull
    private static final Key<BlockTerminalSession> KEY;
    @NotNull
    private static final DataKey<BlockTerminalSession> DATA_KEY;

    public BlockTerminalSession(@NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull TerminalColorPalette colorPalette, @NotNull ShellIntegration shellIntegration) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)colorPalette, (String)"colorPalette");
        Intrinsics.checkNotNullParameter((Object)shellIntegration, (String)"shellIntegration");
        this.colorPalette = colorPalette;
        this.shellIntegration = shellIntegration;
        this.terminalStarterFuture = new CompletableFuture();
        this.executorServiceManager = (TerminalExecutorServiceManager)new TerminalExecutorServiceManagerImpl();
        this.terminationListeners = new CopyOnWriteArrayList();
        CommandBlockIntegration commandBlockIntegration = this.shellIntegration.getCommandBlockIntegration();
        Intrinsics.checkNotNull((Object)commandBlockIntegration);
        this.commandBlockIntegration = commandBlockIntegration;
        StyleState styleState = new StyleState();
        TextStyle defaultStyle = new TextStyle(new TerminalColor(() -> BlockTerminalSession._init_$lambda$0(this)), new TerminalColor(() -> BlockTerminalSession._init_$lambda$1(this)));
        styleState.setDefaultStyle(defaultStyle);
        this.textBuffer = new TerminalTextBuffer(80, 24, styleState, AdvancedSettings.Companion.getInt("terminal.buffer.max.lines.count"), null);
        this.model = new TerminalModel(this.textBuffer);
        this.controller = new JediTerminal((TerminalDisplay)new ModelUpdatingTerminalDisplay(this.model, settings), this.textBuffer, styleState);
        this.commandManager = new ShellCommandManager(this);
        JediTermTypeAheadModel typeAheadTerminalModel = new JediTermTypeAheadModel((Terminal)this.controller, this.textBuffer, (SettingsProvider)settings);
        this.typeAheadManager = new TerminalTypeAheadManager((TypeAheadTerminalModel)typeAheadTerminalModel);
        JediTermDebouncerImpl typeAheadDebouncer = new JediTermDebouncerImpl(() -> ((TerminalTypeAheadManager)this.typeAheadManager).debounce(), TerminalTypeAheadManager.MAX_TERMINAL_DELAY, this.executorServiceManager);
        this.typeAheadManager.setClearPredictionsDebouncer((Debouncer)typeAheadDebouncer);
    }

    @NotNull
    public final TerminalColorPalette getColorPalette() {
        return this.colorPalette;
    }

    @NotNull
    public final ShellIntegration getShellIntegration() {
        return this.shellIntegration;
    }

    @NotNull
    public final TerminalModel getModel() {
        return this.model;
    }

    @NotNull
    public final CompletableFuture<TerminalStarter> getTerminalStarterFuture$intellij_terminal() {
        return this.terminalStarterFuture;
    }

    @NotNull
    public final JediTerminal getController$intellij_terminal() {
        return this.controller;
    }

    @NotNull
    public final ShellCommandManager getCommandManager$intellij_terminal() {
        return this.commandManager;
    }

    @NotNull
    public final CommandBlockIntegration getCommandBlockIntegration() {
        return this.commandBlockIntegration;
    }

    public final void start(@NotNull TtyConnector ttyConnector) {
        Intrinsics.checkNotNullParameter((Object)ttyConnector, (String)"ttyConnector");
        TerminalStarter terminalStarter = new TerminalStarter(this.controller, ttyConnector, (TerminalDataStream)new TtyBasedArrayDataStream(ttyConnector), this.typeAheadManager, this.executorServiceManager);
        this.terminalStarterFuture.complete(terminalStarter);
        this.executorServiceManager.getUnboundedExecutorService().submit(() -> BlockTerminalSession.start$lambda$2(terminalStarter, this, ttyConnector));
    }

    public final void addTerminationCallback(@NotNull Runnable onTerminated, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)onTerminated, (String)"onTerminated");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        TerminalUtil.addItem(this.terminationListeners, onTerminated, parentDisposable);
    }

    public final void postResize(@NotNull TermSize newSize) {
        Intrinsics.checkNotNullParameter((Object)newSize, (String)"newSize");
        this.terminalStarterFuture.thenAccept(arg_0 -> BlockTerminalSession.postResize$lambda$3((Function1)new Function1<TerminalStarter, Unit>(newSize, this){
            final /* synthetic */ TermSize $newSize;
            final /* synthetic */ BlockTerminalSession this$0;
            {
                this.$newSize = $newSize;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable TerminalStarter it) {
                if (it != null && (this.$newSize.getColumns() != this.this$0.getModel().getWidth() || this.$newSize.getRows() != this.this$0.getModel().getHeight())) {
                    BlockTerminalSession.access$getTypeAheadManager$p(this.this$0).onResize();
                    it.postResize(this.$newSize, RequestOrigin.User);
                }
            }
        }, arg_0));
    }

    public final void addCommandListener(@NotNull ShellCommandListener listener, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.commandManager.addListener(listener, parentDisposable);
    }

    public static /* synthetic */ void addCommandListener$default(BlockTerminalSession blockTerminalSession, ShellCommandListener shellCommandListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = blockTerminalSession;
        }
        blockTerminalSession.addCommandListener(shellCommandListener, disposable);
    }

    private final void closeSafely(TtyConnector $this$closeSafely) {
        try {
            $this$closeSafely.close();
        }
        catch (Throwable t) {
            TtyConnector $this$thisLogger$iv = $this$closeSafely;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(TtyConnector.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Error closing TtyConnector", t);
        }
    }

    public void dispose() {
        this.terminalStarterFuture.complete(null);
        TerminalStarter terminalStarter = this.terminalStarterFuture.getNow(null);
        if (terminalStarter != null) {
            TerminalStarter it = terminalStarter;
            boolean bl = false;
            it.requestEmulatorStop();
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                TtyConnector ttyConnector = it.getTtyConnector();
                Intrinsics.checkNotNullExpressionValue((Object)ttyConnector, (String)"getTtyConnector(...)");
                this.closeSafely(ttyConnector);
            } else {
                it.close();
            }
        }
        this.executorServiceManager.shutdownWhenAllExecuted();
    }

    private static final Color _init_$lambda$0(BlockTerminalSession this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.colorPalette.getDefaultForeground();
    }

    private static final Color _init_$lambda$1(BlockTerminalSession this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.colorPalette.getDefaultBackground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void start$lambda$2(TerminalStarter $terminalStarter, BlockTerminalSession this$0, TtyConnector $ttyConnector) {
        Intrinsics.checkNotNullParameter((Object)$terminalStarter, (String)"$terminalStarter");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$ttyConnector, (String)"$ttyConnector");
        try {
            $terminalStarter.start();
        }
        catch (Throwable t) {
            BlockTerminalSession $this$thisLogger$iv = this$0;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(BlockTerminalSession.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(t);
        }
        finally {
            this$0.closeSafely($ttyConnector);
            for (Runnable terminationListener : this$0.terminationListeners) {
                try {
                    terminationListener.run();
                }
                catch (Throwable t) {
                    BlockTerminalSession $this$thisLogger$iv = this$0;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(BlockTerminalSession.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("Unhandled exception in termination listener", t);
                }
            }
        }
    }

    private static final void postResize$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ TerminalTypeAheadManager access$getTypeAheadManager$p(BlockTerminalSession $this) {
        return $this.typeAheadManager;
    }

    static {
        Key key = Key.create((String)"TerminalSession");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY = key;
        DataKey dataKey = DataKey.create((String)"TerminalSession");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"create(...)");
        DATA_KEY = dataKey;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession$Companion;", "", "()V", "DATA_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;", "getDATA_KEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "KEY", "Lcom/intellij/openapi/util/Key;", "getKEY", "()Lcom/intellij/openapi/util/Key;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<BlockTerminalSession> getKEY() {
            return KEY;
        }

        @NotNull
        public final DataKey<BlockTerminalSession> getDATA_KEY() {
            return DATA_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

