/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.LinesBuffer;
import com.jediterm.terminal.model.TerminalLine;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.exp.StyleRange;
import org.jetbrains.plugins.terminal.exp.StyledCommandOutput;
import org.jetbrains.plugins.terminal.shell_integration.CommandBlockIntegration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0014H\u0002J\f\u0010\u001d\u001a\u00020\u0014*\u00020\u001eH\u0002R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/terminal/exp/OutputBuilder;", "", "()V", "output", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "pendingNewLines", "", "styles", "", "Lorg/jetbrains/plugins/terminal/exp/StyleRange;", "addLine", "", "line", "Lcom/jediterm/terminal/model/TerminalLine;", "addLines", "linesBuffer", "Lcom/jediterm/terminal/model/LinesBuffer;", "addTextChunk", "text", "", "style", "Lcom/jediterm/terminal/TextStyle;", "build", "Lorg/jetbrains/plugins/terminal/exp/StyledCommandOutput;", "commandBlockIntegration", "Lorg/jetbrains/plugins/terminal/shell_integration/CommandBlockIntegration;", "findSuffixStartIndIgnoringLF", "suffix", "normalize", "Lcom/jediterm/terminal/model/CharBuffer;", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nShellCommandOutputScraper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandOutputScraper.kt\norg/jetbrains/plugins/terminal/exp/OutputBuilder\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,158:1\n502#2,5:159\n*S KotlinDebug\n*F\n+ 1 ShellCommandOutputScraper.kt\norg/jetbrains/plugins/terminal/exp/OutputBuilder\n*L\n95#1:159,5\n*E\n"})
final class OutputBuilder {
    @NotNull
    private final StringBuilder output = new StringBuilder();
    @NotNull
    private final List<StyleRange> styles = new ArrayList();
    private int pendingNewLines;

    public final void addLines(@NotNull LinesBuffer linesBuffer) {
        Intrinsics.checkNotNullParameter((Object)linesBuffer, (String)"linesBuffer");
        int n = linesBuffer.getLineCount();
        for (int i = 0; i < n; ++i) {
            TerminalLine terminalLine = linesBuffer.getLine(i);
            Intrinsics.checkNotNullExpressionValue((Object)terminalLine, (String)"getLine(...)");
            this.addLine(terminalLine);
        }
    }

    private final void addLine(TerminalLine line) {
        line.forEachEntry(arg_0 -> OutputBuilder.addLine$lambda$0(this, arg_0));
        if (!line.isWrapped()) {
            int n = this.pendingNewLines;
            this.pendingNewLines = n + 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String normalize(CharBuffer $this$normalize) {
        String string;
        String string2 = $this$normalize.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String s = string2;
        if (StringsKt.contains$default((CharSequence)s, (char)'\ue000', (boolean)false, (int)2, null)) {
            void $this$filterTo$iv;
            CharSequence charSequence = s;
            Appendable destination$iv = new StringBuilder(s.length() - 1);
            boolean $i$f$filterTo = false;
            int n = $this$filterTo$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char element$iv;
                char it = element$iv = $this$filterTo$iv.charAt(index$iv);
                boolean bl = false;
                if (!(it != '\ue000')) continue;
                destination$iv.append(element$iv);
            }
            String string3 = ((StringBuilder)destination$iv).toString();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        } else {
            string = s;
        }
        return string;
    }

    private final void addTextChunk(String text, TextStyle style) {
        if (((CharSequence)text).length() > 0) {
            int n = this.pendingNewLines;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                this.output.append("\n");
            }
            this.pendingNewLines = 0;
            int startOffset = this.output.length();
            this.output.append(text);
            if (!Intrinsics.areEqual((Object)style, (Object)TextStyle.EMPTY)) {
                this.styles.add(new StyleRange(startOffset, startOffset + text.length(), style));
            }
        }
    }

    @NotNull
    public final StyledCommandOutput build(@NotNull CommandBlockIntegration commandBlockIntegration) {
        Intrinsics.checkNotNullParameter((Object)commandBlockIntegration, (String)"commandBlockIntegration");
        String string = this.output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String text = string;
        if (commandBlockIntegration.getCommandEndMarker() != null) {
            String trimmedText = ((Object)StringsKt.trimEnd((CharSequence)text)).toString();
            boolean commandEndMarkerFound = StringsKt.endsWith$default((String)trimmedText, (String)commandBlockIntegration.getCommandEndMarker(), (boolean)false, (int)2, null);
            if (commandEndMarkerFound) {
                String outputText = StringsKt.dropLast((String)trimmedText, (int)commandBlockIntegration.getCommandEndMarker().length());
                return new StyledCommandOutput(outputText, true, this.styles);
            }
            int suffixStartInd = this.findSuffixStartIndIgnoringLF(trimmedText, commandBlockIntegration.getCommandEndMarker());
            if (suffixStartInd >= 0) {
                String string2 = trimmedText.substring(0, suffixStartInd);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String commandText = string2;
                return new StyledCommandOutput(commandText, true, this.styles);
            }
        }
        return new StyledCommandOutput(text, false, this.styles);
    }

    private final int findSuffixStartIndIgnoringLF(String text, String suffix) {
        if (!(((CharSequence)suffix).length() > 0)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (text.length() < suffix.length()) {
            return -1;
        }
        int textInd = text.length();
        for (int suffixInd = suffix.length() - 1; -1 < suffixInd; --suffixInd) {
            --textInd;
            while (textInd >= 0 && text.charAt(textInd) == '\n') {
                --textInd;
            }
            if (textInd >= 0 && text.charAt(textInd) == suffix.charAt(suffixInd)) continue;
            return -1;
        }
        return textInd;
    }

    private static final void addLine$lambda$0(OutputBuilder this$0, TerminalLine.TextEntry entry) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        CharBuffer charBuffer = entry.getText();
        Intrinsics.checkNotNullExpressionValue((Object)charBuffer, (String)"getText(...)");
        if (((CharSequence)charBuffer).length() > 0 && !entry.isNul()) {
            CharBuffer charBuffer2 = entry.getText();
            Intrinsics.checkNotNullExpressionValue((Object)charBuffer2, (String)"getText(...)");
            String string = this$0.normalize(charBuffer2);
            TextStyle textStyle = entry.getStyle();
            Intrinsics.checkNotNullExpressionValue((Object)textStyle, (String)"getStyle(...)");
            this$0.addTextChunk(string, textStyle);
        }
    }
}

