/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import java.util.HexFormat;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CompletableDeferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.exp.BlockTerminalSession;
import org.jetbrains.plugins.terminal.exp.ShellCommandEndMarkerListener;
import org.jetbrains.plugins.terminal.exp.ShellCommandExecutionManager;
import org.jetbrains.plugins.terminal.exp.ShellCommandListener;
import org.jetbrains.plugins.terminal.exp.StartedCommand;
import org.jetbrains.plugins.terminal.exp.TerminalPromptState;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 12\u00020\u0001:\u000212B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u000fH\u0002J\u001a\u0010\u0014\u001a\u00020\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0019H\u0002J\b\u0010\u001e\u001a\u00020\u000fH\u0002J\b\u0010\u001f\u001a\u00020\u000fH\u0002J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0002J\u0016\u0010#\u001a\u00020\u000f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00190%H\u0002J\u0016\u0010&\u001a\u00020\u000f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00190%H\u0002J\u0016\u0010'\u001a\u00020\u000f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00190%H\u0002J\u0016\u0010(\u001a\u00020\u000f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00190%H\u0002J\b\u0010)\u001a\u00020\u000fH\u0002J\u0016\u0010*\u001a\u00020\u000f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00190%H\u0002J\"\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00190,2\u0006\u0010-\u001a\u00020\u00192\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00190%J\u000e\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u0019R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/plugins/terminal/exp/ShellCommandManager;", "", "session", "Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;", "(Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;)V", "commandExecutionManager", "Lorg/jetbrains/plugins/terminal/exp/ShellCommandExecutionManager;", "getCommandExecutionManager$intellij_terminal", "()Lorg/jetbrains/plugins/terminal/exp/ShellCommandExecutionManager;", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lorg/jetbrains/plugins/terminal/exp/ShellCommandListener;", "startedCommand", "Lorg/jetbrains/plugins/terminal/exp/StartedCommand;", "addListener", "", "listener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "fireClearInvoked", "fireCommandFinished", "exitCode", "", "fireCommandHistoryReceived", "history", "", "fireCommandStarted", "fireGeneratorFinished", "requestId", "result", "fireInitialized", "firePromptShown", "firePromptStateUpdated", "state", "Lorg/jetbrains/plugins/terminal/exp/TerminalPromptState;", "processCommandFinishedEvent", "event", "", "processCommandHistoryEvent", "processCommandStartedEvent", "processGeneratorFinishedEvent", "processInitialized", "processPromptStateUpdatedEvent", "runGeneratorAsync", "Lkotlinx/coroutines/CompletableDeferred;", "generatorName", "generatorParameters", "sendCommandToExecute", "shellCommand", "Companion", "Param", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nShellCommandManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandManager.kt\norg/jetbrains/plugins/terminal/exp/ShellCommandManager\n+ 2 ShellCommandManager.kt\norg/jetbrains/plugins/terminal/exp/ShellCommandManager$Companion\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n182#2,2:258\n184#2:264\n182#2,2:265\n184#2:271\n182#2,2:273\n184#2:279\n182#2,2:280\n184#2:286\n182#2,2:287\n184#2:293\n182#2,2:294\n184#2:300\n182#2,2:301\n184#2:307\n182#2,2:308\n184#2:314\n182#2,2:315\n184#2:321\n182#2,2:322\n184#2:328\n182#2,2:329\n184#2:335\n47#3,4:260\n47#3,4:267\n47#3,4:275\n47#3,4:282\n47#3,4:289\n47#3,4:296\n47#3,4:303\n47#3,4:310\n47#3,4:317\n47#3,4:324\n47#3,4:331\n11#3:336\n1#4:272\n*S KotlinDebug\n*F\n+ 1 ShellCommandManager.kt\norg/jetbrains/plugins/terminal/exp/ShellCommandManager\n*L\n45#1:258,2\n45#1:264\n67#1:265,2\n67#1:271\n97#1:273,2\n97#1:279\n108#1:280,2\n108#1:286\n115#1:287,2\n115#1:293\n122#1:294,2\n122#1:300\n133#1:301,2\n133#1:307\n145#1:308,2\n145#1:314\n149#1:315,2\n149#1:321\n156#1:322,2\n156#1:328\n163#1:329,2\n163#1:335\n45#1:260,4\n67#1:267,4\n97#1:275,4\n108#1:282,4\n115#1:289,4\n122#1:296,4\n133#1:303,4\n145#1:310,4\n149#1:317,4\n156#1:324,4\n163#1:331,4\n180#1:336\n*E\n"})
public final class ShellCommandManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final CopyOnWriteArrayList<ShellCommandListener> listeners;
    @Nullable
    private volatile StartedCommand startedCommand;
    @NotNull
    private final ShellCommandExecutionManager commandExecutionManager;
    @NotNull
    private static final Logger LOG;

    public ShellCommandManager(@NotNull BlockTerminalSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        this.listeners = new CopyOnWriteArrayList();
        this.commandExecutionManager = new ShellCommandExecutionManager(this.session, this);
        this.session.getController$intellij_terminal().addCustomCommandListener(arg_0 -> ShellCommandManager._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final ShellCommandExecutionManager getCommandExecutionManager$intellij_terminal() {
        return this.commandExecutionManager;
    }

    private final void processInitialized() {
        if (this.session.getCommandBlockIntegration().getCommandEndMarker() != null) {
            Companion $this$iv = Companion;
            Throwable e$iv = null;
            boolean $i$f$debug$intellij_terminal = false;
            Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
            boolean $i$f$debug = false;
            if ($this$debug$iv$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv$iv;
                boolean bl = false;
                logger.debug("Received initialized event, waiting for command end marker", e$iv);
            }
            new ShellCommandEndMarkerListener(this.session, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ ShellCommandManager this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ShellCommandManager.access$fireInitialized(this.this$0);
                }
            }));
        } else {
            this.fireInitialized();
        }
    }

    private final void processCommandStartedEvent(List<String> event) {
        StartedCommand startedCommand;
        String command = Param.COMMAND.getDecodedValue((String)CollectionsKt.getOrNull(event, (int)1));
        String currentDirectory = Param.CURRENT_DIRECTORY.getDecodedValue((String)CollectionsKt.getOrNull(event, (int)2));
        this.startedCommand = startedCommand = new StartedCommand(System.nanoTime(), currentDirectory, command);
        this.fireCommandStarted(startedCommand);
    }

    private final void processCommandFinishedEvent(List<String> event) {
        int exitCode = Param.EXIT_CODE.getIntValue((String)CollectionsKt.getOrNull(event, (int)1));
        StartedCommand startedCommand = this.startedCommand;
        if (this.session.getCommandBlockIntegration().getCommandEndMarker() != null) {
            Companion $this$iv = Companion;
            Throwable e$iv = null;
            boolean $i$f$debug$intellij_terminal = false;
            Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
            boolean $i$f$debug = false;
            if ($this$debug$iv$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv$iv;
                boolean bl = false;
                logger.debug("Received command_finished event, waiting for command end marker", e$iv);
            }
            new ShellCommandEndMarkerListener(this.session, (Function0<Unit>)((Function0)new Function0<Unit>(this, startedCommand, exitCode){
                final /* synthetic */ ShellCommandManager this$0;
                final /* synthetic */ StartedCommand $startedCommand;
                final /* synthetic */ int $exitCode;
                {
                    this.this$0 = $receiver;
                    this.$startedCommand = $startedCommand;
                    this.$exitCode = $exitCode;
                    super(0);
                }

                public final void invoke() {
                    ShellCommandManager.access$fireCommandFinished(this.this$0, this.$startedCommand, this.$exitCode);
                    ShellCommandManager.access$setStartedCommand$p(this.this$0, null);
                }
            }));
        } else {
            this.fireCommandFinished(startedCommand, exitCode);
            this.startedCommand = null;
        }
    }

    private final void processPromptStateUpdatedEvent(List<String> event) {
        String string;
        String string2;
        String string3;
        String it;
        String currentDirectory = Param.CURRENT_DIRECTORY.getDecodedValue((String)CollectionsKt.getOrNull(event, (int)1));
        String string4 = Param.GIT_BRANCH.getDecodedValueOrNull((String)CollectionsKt.getOrNull(event, (int)2));
        if (string4 != null) {
            String string5;
            it = string5 = string4;
            boolean bl = false;
            string3 = ((CharSequence)it).length() > 0 ? string5 : null;
        } else {
            string3 = null;
        }
        String gitBranch = string3;
        String string6 = Param.VIRTUAL_ENV.getDecodedValueOrNull((String)CollectionsKt.getOrNull(event, (int)3));
        if (string6 != null) {
            String it2 = it = string6;
            boolean bl = false;
            string2 = ((CharSequence)it2).length() > 0 ? it : null;
        } else {
            string2 = null;
        }
        String virtualEnv = string2;
        String string7 = Param.CONDA_ENV.getDecodedValueOrNull((String)CollectionsKt.getOrNull(event, (int)4));
        if (string7 != null) {
            String string8;
            String it3 = string8 = string7;
            boolean bl = false;
            string = ((CharSequence)it3).length() > 0 ? string8 : null;
        } else {
            string = null;
        }
        String condaEnv = string;
        TerminalPromptState state = new TerminalPromptState(currentDirectory, gitBranch, virtualEnv, condaEnv);
        this.firePromptStateUpdated(state);
    }

    private final void processCommandHistoryEvent(List<String> event) {
        String history = Param.HISTORY_STRING.getDecodedValue((String)CollectionsKt.getOrNull(event, (int)1));
        this.fireCommandHistoryReceived(history);
    }

    private final void processGeneratorFinishedEvent(List<String> event) {
        int requestId = Param.REQUEST_ID.getIntValue((String)CollectionsKt.getOrNull(event, (int)1));
        String result2 = Param.RESULT.getDecodedValue((String)CollectionsKt.getOrNull(event, (int)2));
        if (this.session.getCommandBlockIntegration().getCommandEndMarker() != null) {
            Companion $this$iv = Companion;
            Throwable e$iv = null;
            boolean $i$f$debug$intellij_terminal = false;
            Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
            boolean $i$f$debug = false;
            if ($this$debug$iv$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv$iv;
                boolean bl = false;
                logger.debug("Received generator_finished event, waiting for command end marker", e$iv);
            }
            new ShellCommandEndMarkerListener(this.session, (Function0<Unit>)((Function0)new Function0<Unit>(this, requestId, result2){
                final /* synthetic */ ShellCommandManager this$0;
                final /* synthetic */ int $requestId;
                final /* synthetic */ String $result;
                {
                    this.this$0 = $receiver;
                    this.$requestId = $requestId;
                    this.$result = $result;
                    super(0);
                }

                public final void invoke() {
                    ShellCommandManager.access$fireGeneratorFinished(this.this$0, this.$requestId, this.$result);
                }
            }));
        } else {
            this.fireGeneratorFinished(requestId, result2);
        }
    }

    private final void fireInitialized() {
        Companion $this$iv = Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv$iv;
            boolean bl = false;
            logger.debug("Shell event: initialized", e$iv);
        }
        for (ShellCommandListener listener : this.listeners) {
            listener.initialized();
        }
    }

    private final void firePromptShown() {
        Companion $this$iv = Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv$iv;
            boolean bl = false;
            logger.debug("Shell event: prompt_shown", e$iv);
        }
        for (ShellCommandListener listener : this.listeners) {
            listener.promptShown();
        }
    }

    private final void fireCommandStarted(StartedCommand startedCommand) {
        Companion $this$iv = Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv$iv;
            boolean bl = false;
            logger.debug("Shell event: command_started - " + startedCommand, e$iv);
        }
        for (ShellCommandListener listener : this.listeners) {
            listener.commandStarted(startedCommand.getCommand());
        }
    }

    private final void fireCommandFinished(StartedCommand startedCommand, int exitCode) {
        if (startedCommand == null) {
            LOG.info("Shell event: received command_finished without preceding command_started - skipping");
        } else {
            Companion $this$iv = Companion;
            Throwable e$iv = null;
            boolean $i$f$debug$intellij_terminal = false;
            Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
            boolean $i$f$debug = false;
            if ($this$debug$iv$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv$iv;
                boolean bl = false;
                logger.debug("Shell event: command_finished - " + startedCommand + ", exit code: " + exitCode, e$iv);
            }
            for (ShellCommandListener listener : this.listeners) {
                long it = startedCommand.getCommandStartedNano();
                boolean bl = false;
                long duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - it);
                listener.commandFinished(startedCommand.getCommand(), exitCode, duration);
            }
        }
    }

    private final void firePromptStateUpdated(TerminalPromptState state) {
        for (ShellCommandListener listener : this.listeners) {
            listener.promptStateUpdated(state);
        }
        Companion $this$iv = Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv$iv;
            boolean bl = false;
            logger.debug("Prompt state updated: " + state, e$iv);
        }
    }

    private final void fireCommandHistoryReceived(String history) {
        Companion $this$iv = Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv$iv;
            boolean bl = false;
            logger.debug("Shell event: command_history of " + history.length() + " size", e$iv);
        }
        for (ShellCommandListener listener : this.listeners) {
            listener.commandHistoryReceived(history);
        }
    }

    private final void fireGeneratorFinished(int requestId, String result2) {
        Companion $this$iv = Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv$iv;
            boolean bl = false;
            logger.debug("Shell event: generator_finished with requestId " + requestId + " and result of " + result2.length() + " size", e$iv);
        }
        for (ShellCommandListener listener : this.listeners) {
            listener.generatorFinished(requestId, result2);
        }
    }

    private final void fireClearInvoked() {
        Companion $this$iv = Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv$iv;
            boolean bl = false;
            logger.debug("Shell event: clear_invoked", e$iv);
        }
        for (ShellCommandListener listener : this.listeners) {
            listener.clearInvoked();
        }
    }

    public final void addListener(@NotNull ShellCommandListener listener, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        TerminalUtil.addItem((List)this.listeners, listener, parentDisposable);
    }

    public final void sendCommandToExecute(@NotNull String shellCommand2) {
        Intrinsics.checkNotNullParameter((Object)shellCommand2, (String)"shellCommand");
        this.commandExecutionManager.sendCommandToExecute(shellCommand2);
    }

    @NotNull
    public final CompletableDeferred<String> runGeneratorAsync(@NotNull String generatorName, @NotNull List<String> generatorParameters) {
        Intrinsics.checkNotNullParameter((Object)generatorName, (String)"generatorName");
        Intrinsics.checkNotNullParameter(generatorParameters, (String)"generatorParameters");
        return this.commandExecutionManager.runGeneratorAsync(generatorName, generatorParameters);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void _init_$lambda$0(ShellCommandManager this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            String string = (String)CollectionsKt.getOrNull((List)it, (int)0);
            if (string != null) {
                int n = -1;
                switch (string.hashCode()) {
                    case 424089318: {
                        if (!string.equals("command_finished")) break;
                        n = 1;
                        break;
                    }
                    case -779416838: {
                        if (!string.equals("clear_invoked")) break;
                        n = 2;
                        break;
                    }
                    case -1808601184: {
                        if (!string.equals("command_history")) break;
                        n = 3;
                        break;
                    }
                    case -337753203: {
                        if (!string.equals("command_started")) break;
                        n = 4;
                        break;
                    }
                    case -872176010: {
                        if (!string.equals("prompt_shown")) break;
                        n = 5;
                        break;
                    }
                    case -268905378: {
                        if (!string.equals("generator_finished")) break;
                        n = 6;
                        break;
                    }
                    case 1234020052: {
                        if (!string.equals("initialized")) break;
                        n = 7;
                        break;
                    }
                    case 1940723570: {
                        if (!string.equals("prompt_state_updated")) break;
                        n = 8;
                        break;
                    }
                }
                switch (n) {
                    case 7: {
                        this$0.processInitialized();
                        return;
                    }
                    case 5: {
                        this$0.firePromptShown();
                        return;
                    }
                    case 4: {
                        this$0.processCommandStartedEvent(it);
                        return;
                    }
                    case 1: {
                        this$0.processCommandFinishedEvent(it);
                        return;
                    }
                    case 8: {
                        this$0.processPromptStateUpdatedEvent(it);
                        return;
                    }
                    case 3: {
                        this$0.processCommandHistoryEvent(it);
                        return;
                    }
                    case 6: {
                        this$0.processGeneratorFinishedEvent(it);
                        return;
                    }
                    case 2: {
                        this$0.fireClearInvoked();
                        return;
                    }
                }
            }
            LOG.warn("Unknown custom command: " + it);
            return;
        }
        catch (Throwable t) {
            LOG.warn("Error while processing custom command: " + it, t);
        }
    }

    public static final /* synthetic */ void access$fireInitialized(ShellCommandManager $this) {
        $this.fireInitialized();
    }

    public static final /* synthetic */ void access$fireCommandFinished(ShellCommandManager $this, StartedCommand startedCommand, int exitCode) {
        $this.fireCommandFinished(startedCommand, exitCode);
    }

    public static final /* synthetic */ void access$setStartedCommand$p(ShellCommandManager $this, StartedCommand startedCommand) {
        $this.startedCommand = startedCommand;
    }

    public static final /* synthetic */ void access$fireGeneratorFinished(ShellCommandManager $this, int requestId, String result2) {
        $this.fireGeneratorFinished(requestId, result2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ShellCommandManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0007\u001a\u00020\b2\u0010\b\u0002\u0010\t\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b2\u0011\u0010\f\u001a\r\u0012\t\u0012\u00070\u000e\u00a2\u0006\u0002\b\u000f0\rH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b\u0010J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/terminal/exp/ShellCommandManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$intellij_terminal", "()Lcom/intellij/openapi/diagnostic/Logger;", "debug", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "lazyMessage", "Lkotlin/Function0;", "", "Lorg/jetbrains/annotations/NonNls;", "debug$intellij_terminal", "decodeHex", "hexStr", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nShellCommandManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandManager.kt\norg/jetbrains/plugins/terminal/exp/ShellCommandManager$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,257:1\n47#2,4:258\n*S KotlinDebug\n*F\n+ 1 ShellCommandManager.kt\norg/jetbrains/plugins/terminal/exp/ShellCommandManager$Companion\n*L\n183#1:258,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG$intellij_terminal() {
            return LOG;
        }

        public final void debug$intellij_terminal(@Nullable Exception e, @NotNull Function0<String> lazyMessage) {
            Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
            boolean $i$f$debug$intellij_terminal = false;
            Logger $this$debug$iv = this.getLOG$intellij_terminal();
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                $this$debug$iv.debug((String)lazyMessage.invoke(), (Throwable)e);
            }
        }

        public static /* synthetic */ void debug$intellij_terminal$default(Companion $this, Exception e, Function0 lazyMessage, int n, Object object) {
            if ((n & 1) != 0) {
                e = null;
            }
            Intrinsics.checkNotNullParameter((Object)lazyMessage, (String)"lazyMessage");
            boolean $i$f$debug$intellij_terminal = false;
            Logger $this$debug$iv = $this.getLOG$intellij_terminal();
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                $this$debug$iv.debug((String)lazyMessage.invoke(), (Throwable)e);
            }
        }

        private final String decodeHex(String hexStr) throws IllegalArgumentException {
            byte[] bytes = HexFormat.of().parseHex(hexStr);
            Intrinsics.checkNotNull((Object)bytes);
            return new String(bytes, Charsets.UTF_8);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\f\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u0006H\u0002\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\u0004J\u0014\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010\u000e\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/terminal/exp/ShellCommandManager$Param;", "", "(Ljava/lang/String;I)V", "paramNameWithSeparator", "", "fail", "T", "()Ljava/lang/Object;", "getDecodedValue", "nameAndValue", "getDecodedValueOrNull", "getIntValue", "", "getValueOrNull", "paramName", "EXIT_CODE", "COMMAND", "HISTORY_STRING", "REQUEST_ID", "RESULT", "CURRENT_DIRECTORY", "GIT_BRANCH", "VIRTUAL_ENV", "CONDA_ENV", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nShellCommandManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandManager.kt\norg/jetbrains/plugins/terminal/exp/ShellCommandManager$Param\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n1#2:258\n*E\n"})
    private static final class Param
    extends Enum<Param> {
        @NotNull
        private final String paramNameWithSeparator = this.paramName() + "=";
        public static final /* enum */ Param EXIT_CODE = new Param();
        public static final /* enum */ Param COMMAND = new Param();
        public static final /* enum */ Param HISTORY_STRING = new Param();
        public static final /* enum */ Param REQUEST_ID = new Param();
        public static final /* enum */ Param RESULT = new Param();
        public static final /* enum */ Param CURRENT_DIRECTORY = new Param();
        public static final /* enum */ Param GIT_BRANCH = new Param();
        public static final /* enum */ Param VIRTUAL_ENV = new Param();
        public static final /* enum */ Param CONDA_ENV = new Param();
        private static final /* synthetic */ Param[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private final String paramName() {
            String string = this.name();
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            return string2;
        }

        public final int getIntValue(@Nullable String nameAndValue) {
            Object object = this.getValueOrNull(nameAndValue);
            return object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? ((Integer)object).intValue() : ((Number)this.fail()).intValue();
        }

        @NotNull
        public final String getDecodedValue(@Nullable String nameAndValue) {
            String string = this.getDecodedValueOrNull(nameAndValue);
            if (string == null) {
                string = (String)this.fail();
            }
            return string;
        }

        @Nullable
        public final String getDecodedValueOrNull(@Nullable String nameAndValue) {
            String string = this.getValueOrNull(nameAndValue);
            if (string == null) {
                return null;
            }
            String encodedValue = string;
            return Companion.decodeHex(encodedValue);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String getValueOrNull(String nameAndValue) {
            String string;
            String string2 = nameAndValue;
            String string3 = string2;
            if (string2 == null) return null;
            String it = string = string3;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)this.paramNameWithSeparator, (boolean)false, (int)2, null)) return null;
            String string4 = string;
            string3 = string4;
            if (string4 == null) return null;
            String string5 = string3.substring(this.paramNameWithSeparator.length());
            String string6 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            return string6;
        }

        private final <T> T fail() {
            throw new IllegalStateException("Cannot parse " + this.paramName());
        }

        public static Param[] values() {
            return (Param[])$VALUES.clone();
        }

        public static Param valueOf(String value) {
            return Enum.valueOf(Param.class, value);
        }

        @NotNull
        public static EnumEntries<Param> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = paramArray = new Param[]{Param.EXIT_CODE, Param.COMMAND, Param.HISTORY_STRING, Param.REQUEST_ID, Param.RESULT, Param.CURRENT_DIRECTORY, Param.GIT_BRANCH, Param.VIRTUAL_ENV, Param.CONDA_ENV};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

