/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jediterm.terminal.StyledTextConsumer;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.AllHighlightingsSnapshot;
import org.jetbrains.plugins.terminal.exp.BlockTerminalSession;
import org.jetbrains.plugins.terminal.exp.HighlightingInfo;
import org.jetbrains.plugins.terminal.exp.SimpleTerminalEventsHandler;
import org.jetbrains.plugins.terminal.exp.TerminalCaretModel;
import org.jetbrains.plugins.terminal.exp.TerminalCaretPainter;
import org.jetbrains.plugins.terminal.exp.TerminalDataContextUtils;
import org.jetbrains.plugins.terminal.exp.TerminalEventDispatcherKt;
import org.jetbrains.plugins.terminal.exp.TerminalModel;
import org.jetbrains.plugins.terminal.exp.TerminalOutputModel;
import org.jetbrains.plugins.terminal.exp.TerminalSelectionModel;
import org.jetbrains.plugins.terminal.exp.TerminalTextHighlighter;
import org.jetbrains.plugins.terminal.exp.TerminalUiUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 *2\u00020\u0001:\u0002*+B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001e\u001a\u00020\u001fH\u0007J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u001fH\u0016J\b\u0010#\u001a\u00020\u001fH\u0002J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020!H\u0002J\b\u0010&\u001a\u00020\u001fH\u0002J\f\u0010'\u001a\u00020(*\u00020)H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006,"}, d2={"Lorg/jetbrains/plugins/terminal/exp/SimpleTerminalController;", "Lcom/intellij/openapi/Disposable;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "session", "Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "(Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;Lcom/intellij/openapi/editor/ex/EditorEx;)V", "caretModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalCaretModel;", "caretPainter", "Lorg/jetbrains/plugins/terminal/exp/TerminalCaretPainter;", "document", "Lcom/intellij/openapi/editor/Document;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "isFocused", "", "()Z", "setFocused", "(Z)V", "outputModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;", "selectionModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionModel;", "terminalModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalModel;", "getTerminalModel", "()Lorg/jetbrains/plugins/terminal/exp/TerminalModel;", "clearTextSelection", "", "computeTerminalContent", "Lorg/jetbrains/plugins/terminal/exp/SimpleTerminalController$TerminalContent;", "dispose", "setupContentListener", "updateEditor", "content", "updateEditorContent", "toTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "Lcom/jediterm/terminal/TextStyle;", "Companion", "TerminalContent", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nSimpleTerminalController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleTerminalController.kt\norg/jetbrains/plugins/terminal/exp/SimpleTerminalController\n+ 2 TerminalModel.kt\norg/jetbrains/plugins/terminal/exp/TerminalModel\n*L\n1#1,148:1\n156#2,7:149\n*S KotlinDebug\n*F\n+ 1 SimpleTerminalController.kt\norg/jetbrains/plugins/terminal/exp/SimpleTerminalController\n*L\n50#1:149,7\n*E\n"})
public final class SimpleTerminalController
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final TerminalSelectionModel selectionModel;
    @NotNull
    private final TerminalCaretModel caretModel;
    @NotNull
    private final TerminalCaretPainter caretPainter;
    private boolean isFocused;
    @NotNull
    private static final DataKey<SimpleTerminalController> KEY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleTerminalController(@NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull BlockTerminalSession session2, @NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.session = session2;
        this.editor = editor;
        this.outputModel = new TerminalOutputModel(this.editor);
        this.selectionModel = new TerminalSelectionModel(this.outputModel);
        this.caretModel = new TerminalCaretModel(this.session, this.outputModel, this.editor, this);
        this.caretPainter = new TerminalCaretPainter(this.caretModel, this.outputModel, this.selectionModel, this.editor);
        this.editor.putUserData(TerminalDataContextUtils.INSTANCE.getIS_ALTERNATE_BUFFER_EDITOR_KEY(), (Object)true);
        Disposer.register((Disposable)this, (Disposable)this.caretPainter);
        this.outputModel.createBlock(null, null);
        this.getTerminalModel().setCommandRunning(true);
        this.setupContentListener();
        SimpleTerminalEventsHandler eventsHandler = new SimpleTerminalEventsHandler(this.session, settings, this.outputModel);
        TerminalEventDispatcherKt.setupKeyEventDispatcher(this.editor, settings, eventsHandler, this.outputModel, this.selectionModel, this);
        TerminalEventDispatcherKt.setupMouseListener(this.editor, settings, this.getTerminalModel(), eventsHandler, this);
        TerminalModel this_$iv = this.getTerminalModel();
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            this.updateEditorContent();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.unlockContent();
        }
    }

    @NotNull
    public final Document getDocument() {
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        return (Document)documentEx;
    }

    private final TerminalModel getTerminalModel() {
        return this.session.getModel();
    }

    public final boolean isFocused() {
        return this.isFocused;
    }

    public final void setFocused(boolean bl) {
        this.isFocused = bl;
    }

    @RequiresEdt
    public final void clearTextSelection() {
        this.editor.getSelectionModel().removeSelection();
    }

    private final void setupContentListener() {
        this.getTerminalModel().addContentListener(new TerminalModel.ContentListener(this){
            final /* synthetic */ SimpleTerminalController this$0;
            {
                this.this$0 = $receiver;
            }

            public void onContentChanged() {
                SimpleTerminalController.access$updateEditorContent(this.this$0);
            }
        }, this);
    }

    private final void updateEditorContent() {
        TerminalContent content = this.computeTerminalContent();
        ActionsKt.invokeLater((ModalityState)ModalityState.any(), (Function0)((Function0)new Function0<Unit>(this, content){
            final /* synthetic */ SimpleTerminalController this$0;
            final /* synthetic */ TerminalContent $content;
            {
                this.this$0 = $receiver;
                this.$content = $content;
                super(0);
            }

            public final void invoke() {
                if (!SimpleTerminalController.access$getEditor$p(this.this$0).isDisposed()) {
                    SimpleTerminalController.access$updateEditor(this.this$0, this.$content);
                }
            }
        }));
    }

    private final TerminalContent computeTerminalContent() {
        StringBuilder builder = new StringBuilder();
        List highlightings = new ArrayList();
        StyledTextConsumer consumer2 = new StyledTextConsumer(builder, this, highlightings){
            final /* synthetic */ StringBuilder $builder;
            final /* synthetic */ SimpleTerminalController this$0;
            final /* synthetic */ List<HighlightingInfo> $highlightings;
            {
                this.$builder = $builder;
                this.this$0 = $receiver;
                this.$highlightings = $highlightings;
            }

            public void consume(int x, int y, @NotNull TextStyle style, @NotNull CharBuffer characters, int startRow) {
                Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                Intrinsics.checkNotNullParameter((Object)characters, (String)"characters");
                int startOffset = this.$builder.length();
                this.$builder.append(characters.toString());
                TextAttributes attributes = SimpleTerminalController.access$toTextAttributes(this.this$0, style);
                this.$highlightings.add(new HighlightingInfo(startOffset, this.$builder.length(), attributes));
            }

            public void consumeNul(int x, int y, int nulIndex, @NotNull TextStyle style, @NotNull CharBuffer characters, int startRow) {
                Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                Intrinsics.checkNotNullParameter((Object)characters, (String)"characters");
                int startOffset = this.$builder.length();
                int n = characters.getBuf().length;
                StringBuilder stringBuilder = this.$builder;
                int n2 = 0;
                while (n2 < n) {
                    int it = n2++;
                    boolean bl = false;
                    stringBuilder.append(' ');
                }
                int n3 = this.$builder.length();
                TextStyle textStyle = TextStyle.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)textStyle, (String)"EMPTY");
                this.$highlightings.add(new HighlightingInfo(startOffset, n3, SimpleTerminalController.access$toTextAttributes(this.this$0, textStyle)));
            }

            public void consumeQueue(int x, int y, int nulIndex, int startRow) {
                this.$builder.append("\n");
                int n = this.$builder.length() - 1;
                int n2 = this.$builder.length();
                TextStyle textStyle = TextStyle.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)textStyle, (String)"EMPTY");
                this.$highlightings.add(new HighlightingInfo(n, n2, SimpleTerminalController.access$toTextAttributes(this.this$0, textStyle)));
            }
        };
        if (this.getTerminalModel().getUseAlternateBuffer()) {
            this.getTerminalModel().processScreenLines(0, this.getTerminalModel().getScreenLinesCount(), consumer2);
        } else {
            this.getTerminalModel().processHistoryAndScreenLines(-this.getTerminalModel().getHistoryLinesCount(), this.getTerminalModel().getHistoryLinesCount() + this.getTerminalModel().getCursorY(), consumer2);
        }
        while (true) {
            Character c = StringsKt.lastOrNull((CharSequence)builder);
            char c2 = '\n';
            if (c == null || c.charValue() != c2) break;
            builder.deleteCharAt(StringsKt.getLastIndex((CharSequence)builder));
            CollectionsKt.removeLast((List)highlightings);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new TerminalContent(string, highlightings);
    }

    private final void updateEditor(TerminalContent content) {
        this.getDocument().setText((CharSequence)content.getText());
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        this.editor.setHighlighter((EditorHighlighter)new TerminalTextHighlighter(new AllHighlightingsSnapshot((Document)documentEx, content.getHighlightings())));
        int line = this.getTerminalModel().getHistoryLinesCount() + this.getTerminalModel().getCursorY() - 1;
        this.editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(line, this.getTerminalModel().getCursorX()));
        this.editor.getScrollingModel().scrollToCaret(ScrollType.CENTER_DOWN);
        this.caretPainter.repaint();
    }

    private final TextAttributes toTextAttributes(TextStyle $this$toTextAttributes) {
        return TerminalUiUtils.INSTANCE.toTextAttributes$intellij_terminal($this$toTextAttributes, this.session.getColorPalette());
    }

    public void dispose() {
    }

    public static final /* synthetic */ void access$updateEditorContent(SimpleTerminalController $this) {
        $this.updateEditorContent();
    }

    public static final /* synthetic */ EditorEx access$getEditor$p(SimpleTerminalController $this) {
        return $this.editor;
    }

    public static final /* synthetic */ void access$updateEditor(SimpleTerminalController $this, TerminalContent content) {
        $this.updateEditor(content);
    }

    public static final /* synthetic */ TextAttributes access$toTextAttributes(SimpleTerminalController $this, TextStyle $receiver) {
        return $this.toTextAttributes($receiver);
    }

    static {
        DataKey dataKey = DataKey.create((String)"SimpleTerminalController");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"create(...)");
        KEY = dataKey;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/terminal/exp/SimpleTerminalController$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lorg/jetbrains/plugins/terminal/exp/SimpleTerminalController;", "getKEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<SimpleTerminalController> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/terminal/exp/SimpleTerminalController$TerminalContent;", "", "text", "", "highlightings", "", "Lorg/jetbrains/plugins/terminal/exp/HighlightingInfo;", "(Ljava/lang/String;Ljava/util/List;)V", "getHighlightings", "()Ljava/util/List;", "getText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.terminal"})
    private static final class TerminalContent {
        @NotNull
        private final String text;
        @NotNull
        private final List<HighlightingInfo> highlightings;

        public TerminalContent(@NotNull String text, @NotNull List<HighlightingInfo> highlightings) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(highlightings, (String)"highlightings");
            this.text = text;
            this.highlightings = highlightings;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final List<HighlightingInfo> getHighlightings() {
            return this.highlightings;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final List<HighlightingInfo> component2() {
            return this.highlightings;
        }

        @NotNull
        public final TerminalContent copy(@NotNull String text, @NotNull List<HighlightingInfo> highlightings) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(highlightings, (String)"highlightings");
            return new TerminalContent(text, highlightings);
        }

        public static /* synthetic */ TerminalContent copy$default(TerminalContent terminalContent, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = terminalContent.text;
            }
            if ((n & 2) != 0) {
                list = terminalContent.highlightings;
            }
            return terminalContent.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "TerminalContent(text=" + this.text + ", highlightings=" + this.highlightings + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + ((Object)this.highlightings).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TerminalContent)) {
                return false;
            }
            TerminalContent terminalContent = (TerminalContent)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)terminalContent.text)) {
                return false;
            }
            return Intrinsics.areEqual(this.highlightings, terminalContent.highlightings);
        }
    }
}

