/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.BlockTerminalSession;
import org.jetbrains.plugins.terminal.exp.CommandBlock;
import org.jetbrains.plugins.terminal.exp.TerminalModel;
import org.jetbrains.plugins.terminal.exp.TerminalOutputModel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002:\u0002/0B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\nJ\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002J\b\u0010$\u001a\u00020\u0010H\u0002J\b\u0010%\u001a\u00020\u001cH\u0003J\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020(H\u0016J\u0018\u0010+\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0016J\u0010\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020(H\u0016J\b\u0010.\u001a\u00020\u001cH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalCaretModel;", "Lorg/jetbrains/plugins/terminal/exp/TerminalModel$CursorListener;", "Lorg/jetbrains/plugins/terminal/exp/TerminalModel$TerminalListener;", "session", "Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;", "outputModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/openapi/Disposable;)V", "listeners", "", "Lorg/jetbrains/plugins/terminal/exp/TerminalCaretModel$CaretListener;", "state", "Lorg/jetbrains/plugins/terminal/exp/TerminalCaretModel$CaretState;", "getState", "()Lorg/jetbrains/plugins/terminal/exp/TerminalCaretModel$CaretState;", "terminalModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalModel;", "getTerminalModel", "()Lorg/jetbrains/plugins/terminal/exp/TerminalModel;", "updateAlarm", "Lcom/intellij/util/Alarm;", "updateScheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "addListener", "", "listener", "disposable", "calculateCaretPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "cursorX", "", "cursorY", "calculateState", "doUpdate", "onBlinkingChanged", "blinking", "", "onCommandRunningChanged", "isRunning", "onPositionChanged", "onVisibilityChanged", "visible", "scheduleUpdate", "CaretListener", "CaretState", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalCaretModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCaretModel.kt\norg/jetbrains/plugins/terminal/exp/TerminalCaretModel\n+ 2 TerminalModel.kt\norg/jetbrains/plugins/terminal/exp/TerminalModel\n*L\n1#1,105:1\n156#2,7:106\n*S KotlinDebug\n*F\n+ 1 TerminalCaretModel.kt\norg/jetbrains/plugins/terminal/exp/TerminalCaretModel\n*L\n78#1:106,7\n*E\n"})
public final class TerminalCaretModel
implements TerminalModel.CursorListener,
TerminalModel.TerminalListener {
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final List<CaretListener> listeners;
    @NotNull
    private final AtomicBoolean updateScheduled;
    @NotNull
    private final Alarm updateAlarm;

    public TerminalCaretModel(@NotNull BlockTerminalSession session2, @NotNull TerminalOutputModel outputModel, @NotNull EditorEx editor, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.session = session2;
        this.outputModel = outputModel;
        this.editor = editor;
        this.listeners = new CopyOnWriteArrayList();
        this.updateScheduled = new AtomicBoolean(false);
        this.updateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, parentDisposable);
        this.getTerminalModel().addTerminalListener(this, parentDisposable);
        this.getTerminalModel().addCursorListener(this, parentDisposable);
    }

    private final TerminalModel getTerminalModel() {
        return this.session.getModel();
    }

    @NotNull
    public final CaretState getState() {
        return this.calculateState();
    }

    public final void addListener(@NotNull CaretListener listener, @Nullable Disposable disposable) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            this.listeners.add(listener);
            Disposable disposable2 = disposable;
            if (disposable2 == null) break block0;
            Disposable it = disposable2;
            boolean bl = false;
            Disposer.register((Disposable)it, () -> TerminalCaretModel.addListener$lambda$1$lambda$0(this, listener));
        }
    }

    public static /* synthetic */ void addListener$default(TerminalCaretModel terminalCaretModel, CaretListener caretListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalCaretModel.addListener(caretListener, disposable);
    }

    @Override
    public void onPositionChanged(int cursorX, int cursorY) {
        this.scheduleUpdate();
    }

    @Override
    public void onVisibilityChanged(boolean visible) {
        this.scheduleUpdate();
    }

    @Override
    public void onBlinkingChanged(boolean blinking) {
        this.scheduleUpdate();
    }

    @Override
    public void onCommandRunningChanged(boolean isRunning) {
        this.scheduleUpdate();
    }

    private final void scheduleUpdate() {
        if (this.updateScheduled.compareAndSet(false, true)) {
            this.updateAlarm.addRequest(this::doUpdate, 50);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    private final void doUpdate() {
        try {
            CaretState state = this.calculateState();
            for (CaretListener listener : this.listeners) {
                listener.caretStateChanged(state);
            }
        }
        finally {
            this.updateScheduled.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CaretState calculateState() {
        CaretState caretState;
        TerminalModel this_$iv = this.session.getModel();
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            LogicalPosition position = this.getTerminalModel().isCursorVisible() ? this.calculateCaretPosition(this.getTerminalModel().getCursorX(), this.getTerminalModel().getCursorY()) : null;
            caretState = new CaretState(position, this.getTerminalModel().isCursorBlinking());
        }
        finally {
            this_$iv.unlockContent();
        }
        return caretState;
    }

    private final LogicalPosition calculateCaretPosition(int cursorX, int cursorY) {
        CommandBlock commandBlock = this.outputModel.getLastBlock();
        Intrinsics.checkNotNull((Object)commandBlock);
        int outputStartOffset = commandBlock.getOutputStartOffset();
        int blockStartLine = this.editor.getDocument().getLineNumber(outputStartOffset);
        int historyLines = this.getTerminalModel().getUseAlternateBuffer() ? 0 : this.getTerminalModel().getHistoryLinesCount();
        int blockLine = historyLines + cursorY - 1;
        return new LogicalPosition(blockStartLine + blockLine, cursorX);
    }

    private static final void addListener$lambda$1$lambda$0(TerminalCaretModel this$0, CaretListener $listener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        this$0.listeners.remove($listener);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalCaretModel$CaretListener;", "", "caretStateChanged", "", "state", "Lorg/jetbrains/plugins/terminal/exp/TerminalCaretModel$CaretState;", "intellij.terminal"})
    public static interface CaretListener {
        @RequiresEdt
        default public void caretStateChanged(@NotNull CaretState state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalCaretModel$CaretState;", "", "position", "Lcom/intellij/openapi/editor/LogicalPosition;", "isBlinking", "", "(Lcom/intellij/openapi/editor/LogicalPosition;Z)V", "()Z", "getPosition", "()Lcom/intellij/openapi/editor/LogicalPosition;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.terminal"})
    public static final class CaretState {
        @Nullable
        private final LogicalPosition position;
        private final boolean isBlinking;

        public CaretState(@Nullable LogicalPosition position, boolean isBlinking) {
            this.position = position;
            this.isBlinking = isBlinking;
        }

        public /* synthetic */ CaretState(LogicalPosition logicalPosition, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            this(logicalPosition, bl);
        }

        @Nullable
        public final LogicalPosition getPosition() {
            return this.position;
        }

        public final boolean isBlinking() {
            return this.isBlinking;
        }

        @Nullable
        public final LogicalPosition component1() {
            return this.position;
        }

        public final boolean component2() {
            return this.isBlinking;
        }

        @NotNull
        public final CaretState copy(@Nullable LogicalPosition position, boolean isBlinking) {
            return new CaretState(position, isBlinking);
        }

        public static /* synthetic */ CaretState copy$default(CaretState caretState, LogicalPosition logicalPosition, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                logicalPosition = caretState.position;
            }
            if ((n & 2) != 0) {
                bl = caretState.isBlinking;
            }
            return caretState.copy(logicalPosition, bl);
        }

        @NotNull
        public String toString() {
            return "CaretState(position=" + this.position + ", isBlinking=" + this.isBlinking + ")";
        }

        public int hashCode() {
            int result2 = this.position == null ? 0 : this.position.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isBlinking);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CaretState)) {
                return false;
            }
            CaretState caretState = (CaretState)other;
            if (!Intrinsics.areEqual((Object)this.position, (Object)caretState.position)) {
                return false;
            }
            return this.isBlinking == caretState.isBlinking;
        }
    }
}

