/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.BlockTerminalView;
import org.jetbrains.plugins.terminal.exp.TerminalOutputView;
import org.jetbrains.plugins.terminal.exp.TerminalPromptView;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\b\u0010\u0019\u001a\u00020\u0015H\u0007J\b\u0010\u001a\u001a\u00020\u0015H\u0007J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalFocusModel;", "", "project", "Lcom/intellij/openapi/project/Project;", "blockTerminalView", "Lorg/jetbrains/plugins/terminal/exp/BlockTerminalView;", "outputView", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputView;", "promptView", "Lorg/jetbrains/plugins/terminal/exp/TerminalPromptView;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/exp/BlockTerminalView;Lorg/jetbrains/plugins/terminal/exp/TerminalOutputView;Lorg/jetbrains/plugins/terminal/exp/TerminalPromptView;)V", "value", "", "isActive", "()Z", "setActive", "(Z)V", "listeners", "", "Lorg/jetbrains/plugins/terminal/exp/TerminalFocusModel$TerminalFocusListener;", "addListener", "", "listener", "disposable", "Lcom/intellij/openapi/Disposable;", "focusOutput", "focusPrompt", "requestFocus", "target", "Ljavax/swing/JComponent;", "Companion", "TerminalFocusListener", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalFocusModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalFocusModel.kt\norg/jetbrains/plugins/terminal/exp/TerminalFocusModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1855#2,2:94\n*S KotlinDebug\n*F\n+ 1 TerminalFocusModel.kt\norg/jetbrains/plugins/terminal/exp/TerminalFocusModel\n*L\n30#1:94,2\n*E\n"})
public final class TerminalFocusModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final BlockTerminalView blockTerminalView;
    @NotNull
    private final TerminalOutputView outputView;
    @NotNull
    private final TerminalPromptView promptView;
    private boolean isActive;
    @NotNull
    private final List<TerminalFocusListener> listeners;
    @NotNull
    private static final DataKey<TerminalFocusModel> KEY;

    public TerminalFocusModel(@NotNull Project project, @NotNull BlockTerminalView blockTerminalView, @NotNull TerminalOutputView outputView, @NotNull TerminalPromptView promptView) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)blockTerminalView, (String)"blockTerminalView");
        Intrinsics.checkNotNullParameter((Object)outputView, (String)"outputView");
        Intrinsics.checkNotNullParameter((Object)promptView, (String)"promptView");
        this.project = project;
        this.blockTerminalView = blockTerminalView;
        this.outputView = outputView;
        this.promptView = promptView;
        this.isActive = true;
        this.listeners = new CopyOnWriteArrayList();
        AWTEventListener listener = arg_0 -> TerminalFocusModel._init_$lambda$1(this, arg_0);
        Toolkit.getDefaultToolkit().addAWTEventListener(listener, 4L);
        Disposer.register((Disposable)this.blockTerminalView, () -> TerminalFocusModel._init_$lambda$2(listener));
        this.promptView.getPreferredFocusableComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@Nullable FocusEvent e) {
                Iterable $this$forEach$iv = listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TerminalFocusListener it = (TerminalFocusListener)element$iv;
                    boolean bl = false;
                    it.promptFocused();
                }
            }
        });
    }

    public final boolean isActive() {
        return this.isActive;
    }

    private final void setActive(boolean value) {
        if (value != this.isActive) {
            this.isActive = value;
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TerminalFocusListener it = (TerminalFocusListener)element$iv;
                boolean bl = false;
                it.activeStateChanged(value);
            }
        }
    }

    @RequiresEdt
    public final void focusOutput() {
        this.requestFocus(this.outputView.getPreferredFocusableComponent());
    }

    @RequiresEdt
    public final void focusPrompt() {
        this.requestFocus(this.promptView.getPreferredFocusableComponent());
    }

    public final void addListener(@NotNull TerminalFocusListener listener, @Nullable Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add(listener);
        if (disposable != null) {
            Disposer.register((Disposable)disposable, () -> TerminalFocusModel.addListener$lambda$3(this, listener));
        }
    }

    public static /* synthetic */ void addListener$default(TerminalFocusModel terminalFocusModel, TerminalFocusListener terminalFocusListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalFocusModel.addListener(terminalFocusListener, disposable);
    }

    private final void requestFocus(JComponent target) {
        if (!target.hasFocus()) {
            IdeFocusManager.getInstance((Project)this.project).requestFocus((Component)target, true);
        }
    }

    private static final void _init_$lambda$1(TerminalFocusModel this$0, AWTEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (UIUtil.isFocusAncestor((Component)this$0.blockTerminalView.getComponent())) {
            this$0.setActive(true);
        } else {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            Intrinsics.checkNotNullExpressionValue((Object)menuElementArray, (String)"getSelectedPath(...)");
            Object object = ArraysKt.firstOrNull((Object[])menuElementArray);
            JPopupMenu menu = object instanceof JPopupMenu ? (JPopupMenu)object : null;
            this$0.setActive(UIUtil.isDescendingFrom((Component)menu, (Component)this$0.blockTerminalView.getComponent()));
        }
    }

    private static final void _init_$lambda$2(AWTEventListener $listener) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        Toolkit.getDefaultToolkit().removeAWTEventListener($listener);
    }

    private static final void addListener$lambda$3(TerminalFocusModel this$0, TerminalFocusListener $listener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        this$0.listeners.remove($listener);
    }

    static {
        DataKey dataKey = DataKey.create((String)"TerminalFocusModel");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"create(...)");
        KEY = dataKey;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalFocusModel$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lorg/jetbrains/plugins/terminal/exp/TerminalFocusModel;", "getKEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<TerminalFocusModel> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalFocusModel$TerminalFocusListener;", "", "activeStateChanged", "", "isActive", "", "promptFocused", "intellij.terminal"})
    public static interface TerminalFocusListener {
        default public void promptFocused() {
        }

        default public void activeStateChanged(boolean isActive) {
        }
    }
}

